/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import com.google.api.core.ApiFutures;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.TransportChannel;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.gax.rpc.testing.FakeCallContext;
import com.google.api.gax.rpc.testing.FakeCallableFactory;
import com.google.api.gax.rpc.testing.FakeChannel;
import com.google.api.gax.rpc.testing.FakePagedApi;
import com.google.api.gax.rpc.testing.FakeTransportChannel;
import com.google.api.pathtemplate.ValidationException;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class PagingTest {
    private ClientContext clientContext;
    UnaryCallable<Integer, List<Integer>> callIntList = (UnaryCallable)Mockito.mock(UnaryCallable.class);

    @Before
    public void setUp() {
        this.clientContext = ClientContext.newBuilder().setDefaultCallContext((ApiCallContext)FakeCallContext.createDefault()).setTransportChannel((TransportChannel)FakeTransportChannel.create(new FakeChannel())).build();
    }

    @Test
    public void nonPaged() {
        ArgumentCaptor requestCapture = ArgumentCaptor.forClass(Integer.class);
        Mockito.when((Object)this.callIntList.futureCall(requestCapture.capture(), (ApiCallContext)Mockito.any())).thenReturn((Object)ApiFutures.immediateFuture(Arrays.asList(0, 1, 2))).thenReturn((Object)ApiFutures.immediateFuture(Arrays.asList(3, 4))).thenReturn((Object)ApiFutures.immediateFuture(Collections.emptyList()));
        UnaryCallable<Integer, List<Integer>> callable = FakeCallableFactory.createUnpagedCallable(this.callIntList, PagedCallSettings.newBuilder((PagedListResponseFactory)new FakePagedApi.ListIntegersPagedResponseFactory()).build(), this.clientContext);
        Truth.assertThat((Iterable)ImmutableList.copyOf((Collection)((Collection)callable.call((Object)0)))).containsExactly(new Object[]{0, 1, 2}).inOrder();
        Truth.assertThat((Iterable)ImmutableList.copyOf((Collection)((Collection)callable.call((Object)2)))).containsExactly(new Object[]{3, 4}).inOrder();
        Truth.assertThat((Iterable)ImmutableList.copyOf((Collection)((Collection)callable.call((Object)4)))).isEmpty();
        Truth.assertThat((Iterable)requestCapture.getAllValues()).containsExactly(new Object[]{0, 2, 4}).inOrder();
    }

    @Test
    public void paged() {
        ArgumentCaptor requestCapture = ArgumentCaptor.forClass(Integer.class);
        Mockito.when((Object)this.callIntList.futureCall(requestCapture.capture(), (ApiCallContext)Mockito.any())).thenReturn((Object)ApiFutures.immediateFuture(Arrays.asList(0, 1, 2))).thenReturn((Object)ApiFutures.immediateFuture(Arrays.asList(3, 4))).thenReturn((Object)ApiFutures.immediateFuture(Collections.emptyList()));
        UnaryCallable callable = FakeCallableFactory.createPagedCallable(this.callIntList, PagedCallSettings.newBuilder((PagedListResponseFactory)new FakePagedApi.ListIntegersPagedResponseFactory()).build(), this.clientContext);
        Truth.assertThat((Iterable)ImmutableList.copyOf((Iterable)((FakePagedApi.ListIntegersPagedResponse)((Object)callable.call((Object)0))).iterateAll())).containsExactly(new Object[]{0, 1, 2, 3, 4}).inOrder();
        Truth.assertThat((Iterable)requestCapture.getAllValues()).containsExactly(new Object[]{0, 2, 4}).inOrder();
    }

    @Test
    public void pagedByPage() {
        ArgumentCaptor requestCapture = ArgumentCaptor.forClass(Integer.class);
        Mockito.when((Object)this.callIntList.futureCall(requestCapture.capture(), (ApiCallContext)Mockito.any())).thenReturn((Object)ApiFutures.immediateFuture(Arrays.asList(0, 1, 2))).thenReturn((Object)ApiFutures.immediateFuture(Arrays.asList(3, 4))).thenReturn((Object)ApiFutures.immediateFuture(Collections.emptyList()));
        AbstractPage page = ((FakePagedApi.ListIntegersPagedResponse)((Object)FakeCallableFactory.createPagedCallable(this.callIntList, PagedCallSettings.newBuilder((PagedListResponseFactory)new FakePagedApi.ListIntegersPagedResponseFactory()).build(), this.clientContext).call((Object)0))).getPage();
        Truth.assertThat((Iterable)page.getValues()).containsExactly(new Object[]{0, 1, 2}).inOrder();
        Truth.assertThat((Boolean)page.hasNextPage()).isTrue();
        page = page.getNextPage();
        Truth.assertThat((Iterable)page.getValues()).containsExactly(new Object[]{3, 4}).inOrder();
        Truth.assertThat((Boolean)page.hasNextPage()).isTrue();
        page = page.getNextPage();
        Truth.assertThat((Iterable)page.getValues()).isEmpty();
        Truth.assertThat((Boolean)page.hasNextPage()).isFalse();
        Truth.assertThat((Object)page.getNextPage()).isNull();
        Truth.assertThat((Iterable)requestCapture.getAllValues()).containsExactly(new Object[]{0, 2, 4}).inOrder();
    }

    @Test
    public void pagedByFixedSizeCollection() {
        ArgumentCaptor requestCapture = ArgumentCaptor.forClass(Integer.class);
        Mockito.when((Object)this.callIntList.futureCall(requestCapture.capture(), (ApiCallContext)Mockito.any())).thenReturn((Object)ApiFutures.immediateFuture(Arrays.asList(0, 1, 2))).thenReturn((Object)ApiFutures.immediateFuture(Arrays.asList(3, 4))).thenReturn((Object)ApiFutures.immediateFuture(Arrays.asList(5, 6, 7))).thenReturn((Object)ApiFutures.immediateFuture(Collections.emptyList()));
        AbstractFixedSizeCollection fixedSizeCollection = ((FakePagedApi.ListIntegersPagedResponse)((Object)FakeCallableFactory.createPagedCallable(this.callIntList, PagedCallSettings.newBuilder((PagedListResponseFactory)new FakePagedApi.ListIntegersPagedResponseFactory()).build(), this.clientContext).call((Object)0))).expandToFixedSizeCollection(5);
        Truth.assertThat((Iterable)fixedSizeCollection.getValues()).containsExactly(new Object[]{0, 1, 2, 3, 4}).inOrder();
        Truth.assertThat((Iterable)fixedSizeCollection.getNextCollection().getValues()).containsExactly(new Object[]{5, 6, 7}).inOrder();
        Truth.assertThat((Iterable)requestCapture.getAllValues()).containsExactly(new Object[]{0, 2, 4, 7}).inOrder();
    }

    @Test(expected=ValidationException.class)
    public void pagedFixedSizeCollectionTooManyElements() {
        Mockito.when((Object)this.callIntList.futureCall((Object)((Integer)Mockito.any()), (ApiCallContext)Mockito.any())).thenReturn((Object)ApiFutures.immediateFuture(Arrays.asList(0, 1, 2))).thenReturn((Object)ApiFutures.immediateFuture(Arrays.asList(3, 4))).thenReturn((Object)ApiFutures.immediateFuture(Collections.emptyList()));
        ((FakePagedApi.ListIntegersPagedResponse)((Object)FakeCallableFactory.createPagedCallable(this.callIntList, PagedCallSettings.newBuilder((PagedListResponseFactory)new FakePagedApi.ListIntegersPagedResponseFactory()).build(), this.clientContext).call((Object)0))).expandToFixedSizeCollection(4);
    }

    @Test(expected=ValidationException.class)
    public void pagedFixedSizeCollectionTooSmallCollectionSize() {
        Mockito.when((Object)this.callIntList.futureCall((Object)((Integer)Mockito.any()), (ApiCallContext)Mockito.any())).thenReturn((Object)ApiFutures.immediateFuture(Arrays.asList(0, 1))).thenReturn((Object)ApiFutures.immediateFuture(Collections.emptyList()));
        ((FakePagedApi.ListIntegersPagedResponse)((Object)FakeCallableFactory.createPagedCallable(this.callIntList, PagedCallSettings.newBuilder((PagedListResponseFactory)new FakePagedApi.ListIntegersPagedResponseFactory()).build(), this.clientContext).call((Object)0))).expandToFixedSizeCollection(2);
    }
}

