/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import com.google.api.gax.rpc.BatchedFuture;
import com.google.api.gax.rpc.BatchedRequestIssuer;
import com.google.common.truth.Truth;
import java.util.concurrent.ExecutionException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class BatchedRequestIssuerTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void test() throws Exception {
        BatchedFuture batchedFuture = BatchedFuture.create();
        BatchedRequestIssuer issuer = new BatchedRequestIssuer(batchedFuture, 2L);
        issuer.setResponse((Object)1);
        Truth.assertThat((Boolean)batchedFuture.isDone()).isFalse();
        issuer.sendResult();
        Truth.assertThat((Boolean)batchedFuture.isDone()).isTrue();
        Truth.assertThat((Integer)((Integer)batchedFuture.get())).isEqualTo((Object)1);
    }

    @Test
    public void testNullResult() throws Exception {
        BatchedFuture batchedFuture = BatchedFuture.create();
        BatchedRequestIssuer issuer = new BatchedRequestIssuer(batchedFuture, 2L);
        issuer.setResponse(null);
        Truth.assertThat((Boolean)batchedFuture.isDone()).isFalse();
        issuer.sendResult();
        Truth.assertThat((Boolean)batchedFuture.isDone()).isTrue();
        Truth.assertThat((Integer)((Integer)batchedFuture.get())).isNull();
    }

    @Test
    public void testException() throws Exception {
        IllegalArgumentException thrownException = new IllegalArgumentException("bad!");
        BatchedFuture batchedFuture = BatchedFuture.create();
        BatchedRequestIssuer issuer = new BatchedRequestIssuer(batchedFuture, 2L);
        issuer.setException((Throwable)thrownException);
        Truth.assertThat((Boolean)batchedFuture.isDone()).isFalse();
        issuer.sendResult();
        Truth.assertThat((Boolean)batchedFuture.isDone()).isTrue();
        try {
            batchedFuture.get();
            Assert.fail((String)"BatchedFuture should have thrown an exception");
        }
        catch (ExecutionException e) {
            Truth.assertThat((Throwable)e.getCause()).isInstanceOf(IllegalArgumentException.class);
        }
    }

    @Test
    public void testNoResult() {
        this.thrown.expect(IllegalStateException.class);
        BatchedFuture batchedFuture = BatchedFuture.create();
        BatchedRequestIssuer issuer = new BatchedRequestIssuer(batchedFuture, 2L);
        issuer.sendResult();
    }

    @Test
    public void testResponseAndException() {
        this.thrown.expect(IllegalStateException.class);
        IllegalArgumentException thrownException = new IllegalArgumentException("bad!");
        BatchedFuture batchedFuture = BatchedFuture.create();
        BatchedRequestIssuer issuer = new BatchedRequestIssuer(batchedFuture, 2L);
        issuer.setResponse((Object)1);
        issuer.setException((Throwable)thrownException);
    }

    @Test
    public void testExceptionAndResponse() {
        this.thrown.expect(IllegalStateException.class);
        IllegalArgumentException thrownException = new IllegalArgumentException("bad!");
        BatchedFuture batchedFuture = BatchedFuture.create();
        BatchedRequestIssuer issuer = new BatchedRequestIssuer(batchedFuture, 2L);
        issuer.setException((Throwable)thrownException);
        issuer.setResponse((Object)1);
    }
}

