/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.ListenableFutureToApiFuture;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptions;
import com.google.api.gax.rpc.AsyncTaskException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.UnavailableException;
import com.google.api.gax.rpc.testing.FakeStatusCode;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ApiExceptionsTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void noException() {
        Integer result = (Integer)ApiExceptions.callAndTranslateApiException((ApiFuture)ApiFutures.immediateFuture((Object)2));
        Truth.assertThat((Integer)result).isEqualTo((Object)2);
    }

    @Test
    public void throwsApiException() {
        this.thrown.expect(ApiException.class);
        ApiExceptions.callAndTranslateApiException((ApiFuture)ApiFutures.immediateFailedFuture((Throwable)new UnavailableException(null, (StatusCode)FakeStatusCode.of(StatusCode.Code.UNAVAILABLE), false)));
    }

    @Test
    public void throwsIOException() {
        this.thrown.expect(UncheckedExecutionException.class);
        ApiExceptions.callAndTranslateApiException((ApiFuture)ApiFutures.immediateFailedFuture((Throwable)new IOException()));
    }

    @Test
    public void throwsRuntimeException() {
        this.thrown.expect(IllegalArgumentException.class);
        ApiExceptions.callAndTranslateApiException((ApiFuture)ApiFutures.immediateFailedFuture((Throwable)new IllegalArgumentException()));
    }

    @Test
    public void containsCurrentStacktrace() {
        String currentMethod = "containsCurrentStacktrace";
        ListeningExecutorService executor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newSingleThreadExecutor());
        ListenableFuture futureError = executor.submit(new Runnable(){

            @Override
            public void run() {
                throw new IllegalArgumentException();
            }
        });
        ListenableFutureToApiFuture futureErrorWrapper = new ListenableFutureToApiFuture(futureError);
        executor.shutdown();
        Exception actualError = null;
        try {
            ApiExceptions.callAndTranslateApiException((ApiFuture)futureErrorWrapper);
        }
        catch (Exception e) {
            actualError = e;
        }
        Truth.assertThat((Throwable)actualError).isNotNull();
        Truth.assertThat((Boolean)ApiExceptionsTest.isMethodInStacktrace("containsCurrentStacktrace", actualError)).isFalse();
        Truth.assertThat((Throwable)actualError.getSuppressed()[0]).isInstanceOf(AsyncTaskException.class);
        Truth.assertThat((Boolean)ApiExceptionsTest.isMethodInStacktrace("containsCurrentStacktrace", actualError.getSuppressed()[0])).isTrue();
    }

    private static boolean isMethodInStacktrace(String method, Throwable t) {
        for (StackTraceElement e : t.getStackTrace()) {
            if (!method.equals(e.getMethodName())) continue;
            return true;
        }
        return false;
    }
}

