/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.retrying;

import com.google.api.core.ApiFuture;
import com.google.api.core.NanoClock;
import com.google.api.gax.retrying.AbstractRetryingExecutorTest;
import com.google.api.gax.retrying.ExponentialRetryAlgorithm;
import com.google.api.gax.retrying.FailingCallable;
import com.google.api.gax.retrying.RetryAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.RetryingExecutorWithContext;
import com.google.api.gax.retrying.RetryingFuture;
import com.google.api.gax.retrying.ScheduledRetryingExecutor;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.tracing.ApiTracer;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import junit.framework.TestCase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.threeten.bp.Duration;

@RunWith(value=MockitoJUnitRunner.class)
public class ScheduledRetryingExecutorTest
extends AbstractRetryingExecutorTest {
    private ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private static final int EXECUTIONS_COUNT = 5;

    @Override
    protected RetryingExecutorWithContext<String> getExecutor(RetryAlgorithm<String> retryAlgorithm) {
        return this.getRetryingExecutor(retryAlgorithm, this.scheduler);
    }

    @Override
    protected RetryAlgorithm<String> getAlgorithm(RetrySettings retrySettings, int apocalypseCountDown, RuntimeException apocalypseException) {
        return new RetryAlgorithm(new AbstractRetryingExecutorTest.TestResultRetryAlgorithm(apocalypseCountDown, apocalypseException), (TimedRetryAlgorithm)new ExponentialRetryAlgorithm(retrySettings, NanoClock.getDefaultClock()));
    }

    private RetryingExecutorWithContext<String> getRetryingExecutor(RetryAlgorithm<String> retryAlgorithm, ScheduledExecutorService scheduler) {
        return new ScheduledRetryingExecutor(retryAlgorithm, scheduler);
    }

    @After
    public void after() {
        this.scheduler.shutdownNow();
    }

    @Test
    public void testSuccessWithFailuresPeekAttempt() throws Exception {
        for (int executionsCount = 0; executionsCount < 5; ++executionsCount) {
            int maxRetries = 100;
            ScheduledExecutorService localExecutor = Executors.newSingleThreadScheduledExecutor();
            FailingCallable callable = new FailingCallable(15, "SUCCESS", this.tracer);
            RetrySettings retrySettings = FailingCallable.FAST_RETRY_SETTINGS.toBuilder().setTotalTimeout(Duration.ofMillis((long)1000L)).setMaxAttempts(100).build();
            RetryingExecutorWithContext<String> executor = this.getRetryingExecutor(this.getAlgorithm(retrySettings, 0, null), localExecutor);
            RetryingFuture future = executor.createFuture((Callable)callable, this.retryingContext);
            Assert.assertNull((Object)future.peekAttemptResult());
            Assert.assertSame((Object)future.peekAttemptResult(), (Object)future.peekAttemptResult());
            TestCase.assertFalse((boolean)future.getAttemptResult().isDone());
            TestCase.assertFalse((boolean)future.getAttemptResult().isCancelled());
            future.setAttemptFuture(executor.submit(future));
            int failedAttempts = 0;
            while (!future.isDone()) {
                block5: {
                    ApiFuture attemptResult = future.peekAttemptResult();
                    if (attemptResult != null) {
                        Assert.assertTrue((boolean)attemptResult.isDone());
                        TestCase.assertFalse((boolean)attemptResult.isCancelled());
                        try {
                            attemptResult.get();
                        }
                        catch (ExecutionException e) {
                            if (!(e.getCause() instanceof FailingCallable.CustomException)) break block5;
                            ++failedAttempts;
                        }
                    }
                }
                Thread.sleep(0L, 100);
            }
            this.assertFutureSuccess((RetryingFuture<String>)future);
            Assert.assertEquals((long)15L, (long)future.getAttemptSettings().getAttemptCount());
            Assert.assertTrue((failedAttempts > 0 ? 1 : 0) != 0);
            localExecutor.shutdownNow();
        }
    }

    @Test
    public void testSuccessWithFailuresGetAttempt() throws Exception {
        for (int executionsCount = 0; executionsCount < 5; ++executionsCount) {
            FailingCallable.CustomException exception;
            int maxRetries = 100;
            ScheduledExecutorService localExecutor = Executors.newSingleThreadScheduledExecutor();
            FailingCallable callable = new FailingCallable(15, "SUCCESS", this.tracer);
            RetrySettings retrySettings = FailingCallable.FAST_RETRY_SETTINGS.toBuilder().setTotalTimeout(Duration.ofMillis((long)1000L)).setMaxAttempts(100).build();
            RetryingExecutorWithContext<String> executor = this.getRetryingExecutor(this.getAlgorithm(retrySettings, 0, null), localExecutor);
            RetryingFuture future = executor.createFuture((Callable)callable, this.retryingContext);
            Assert.assertNull((Object)future.peekAttemptResult());
            Assert.assertSame((Object)future.getAttemptResult(), (Object)future.getAttemptResult());
            TestCase.assertFalse((boolean)future.getAttemptResult().isDone());
            TestCase.assertFalse((boolean)future.getAttemptResult().isCancelled());
            future.setAttemptFuture(executor.submit(future));
            int checks = 0;
            do {
                exception = null;
                ++checks;
                ApiFuture attemptResult = future.getAttemptResult();
                try {
                    TestCase.assertFalse((boolean)attemptResult.cancel(false));
                    TestCase.assertFalse((boolean)attemptResult.cancel(true));
                    attemptResult.get();
                    Assert.assertNotNull((Object)future.peekAttemptResult());
                }
                catch (ExecutionException e) {
                    exception = (FailingCallable.CustomException)e.getCause();
                }
                Assert.assertTrue((boolean)attemptResult.isDone());
                TestCase.assertFalse((boolean)attemptResult.isCancelled());
            } while (exception != null && checks < 101);
            Assert.assertTrue((boolean)future.isDone());
            this.assertFutureSuccess((RetryingFuture<String>)future);
            Assert.assertEquals((long)15L, (long)future.getAttemptSettings().getAttemptCount());
            Assert.assertTrue((String)("checks is equal to " + checks), (checks > 1 && checks <= 100 ? 1 : 0) != 0);
            localExecutor.shutdownNow();
        }
    }

    @Test
    public void testCancelGetAttempt() throws Exception {
        for (int executionsCount = 0; executionsCount < 5; ++executionsCount) {
            FailingCallable.CustomException exception;
            ScheduledExecutorService localExecutor = Executors.newSingleThreadScheduledExecutor();
            int maxRetries = 100;
            FailingCallable callable = new FailingCallable(99, "SUCCESS", this.tracer);
            RetrySettings retrySettings = FailingCallable.FAST_RETRY_SETTINGS.toBuilder().setTotalTimeout(Duration.ofMillis((long)1000L)).setMaxAttempts(100).build();
            RetryingExecutorWithContext<String> executor = this.getRetryingExecutor(this.getAlgorithm(retrySettings, 0, null), localExecutor);
            RetryingFuture future = executor.createFuture((Callable)callable, this.retryingContext);
            Assert.assertNull((Object)future.peekAttemptResult());
            Assert.assertSame((Object)future.getAttemptResult(), (Object)future.getAttemptResult());
            TestCase.assertFalse((boolean)future.getAttemptResult().isDone());
            TestCase.assertFalse((boolean)future.getAttemptResult().isCancelled());
            future.setAttemptFuture(executor.submit(future));
            CancellationException cancellationException = null;
            int checks = 0;
            int failedCancelations = 0;
            do {
                exception = null;
                ++checks;
                ApiFuture attemptResult = future.getAttemptResult();
                try {
                    attemptResult.get();
                    Assert.assertNotNull((Object)future.peekAttemptResult());
                }
                catch (CancellationException e) {
                    cancellationException = e;
                }
                catch (ExecutionException e) {
                    exception = (FailingCallable.CustomException)e.getCause();
                }
                Assert.assertTrue((boolean)attemptResult.isDone());
                if (future.cancel(true)) continue;
                ++failedCancelations;
            } while (exception != null && checks < 100);
            Assert.assertTrue((boolean)future.isDone());
            Assert.assertNotNull((Object)cancellationException);
            Assert.assertEquals((long)2L, (long)(checks - (failedCancelations - 1)));
            Assert.assertTrue((future.getAttemptSettings().getAttemptCount() > 0 ? 1 : 0) != 0);
            this.assertFutureCancel(future);
            localExecutor.shutdownNow();
        }
    }

    @Test
    public void testCancelOuterFutureAfterStart() throws Exception {
        for (int executionsCount = 0; executionsCount < 5; ++executionsCount) {
            ScheduledExecutorService localExecutor = Executors.newSingleThreadScheduledExecutor();
            FailingCallable callable = new FailingCallable(4, "SUCCESS", this.tracer);
            RetrySettings retrySettings = FailingCallable.FAST_RETRY_SETTINGS.toBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setMaxRetryDelay(Duration.ofMillis((long)1000L)).setTotalTimeout(Duration.ofMillis((long)100000L)).build();
            RetryingExecutorWithContext<String> executor = this.getRetryingExecutor(this.getAlgorithm(retrySettings, 0, null), localExecutor);
            RetryingFuture future = executor.createFuture((Callable)callable, this.retryingContext);
            future.setAttemptFuture(executor.submit(future));
            Thread.sleep(30L);
            boolean res = future.cancel(false);
            Assert.assertTrue((boolean)res);
            this.assertFutureCancel(future);
            Assert.assertTrue((future.getAttemptSettings().getAttemptCount() < 4 ? 1 : 0) != 0);
            localExecutor.shutdownNow();
        }
    }

    @Test
    public void testCancelIsTraced() throws Exception {
        ScheduledExecutorService localExecutor = Executors.newSingleThreadScheduledExecutor();
        FailingCallable callable = new FailingCallable(4, "SUCCESS", this.tracer);
        RetrySettings retrySettings = FailingCallable.FAST_RETRY_SETTINGS.toBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setMaxRetryDelay(Duration.ofMillis((long)1000L)).setTotalTimeout(Duration.ofMillis((long)100000L)).build();
        RetryingExecutorWithContext<String> executor = this.getRetryingExecutor(this.getAlgorithm(retrySettings, 0, null), localExecutor);
        RetryingFuture future = executor.createFuture((Callable)callable, this.retryingContext);
        future.setAttemptFuture(executor.submit(future));
        Thread.sleep(30L);
        boolean res = future.cancel(false);
        Assert.assertTrue((boolean)res);
        this.assertFutureCancel(future);
        ((ApiTracer)Mockito.verify((Object)this.tracer)).attemptCancelled();
        localExecutor.shutdownNow();
    }

    @Test
    public void testCancelProxiedFutureAfterStart() throws Exception {
        for (int executionsCount = 0; executionsCount < 2; ++executionsCount) {
            ScheduledExecutorService localExecutor = Executors.newSingleThreadScheduledExecutor();
            FailingCallable callable = new FailingCallable(5, "SUCCESS", this.tracer);
            RetrySettings retrySettings = FailingCallable.FAST_RETRY_SETTINGS.toBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setMaxRetryDelay(Duration.ofMillis((long)1000L)).setTotalTimeout(Duration.ofMillis((long)100000L)).build();
            RetryingExecutorWithContext<String> executor = this.getRetryingExecutor(this.getAlgorithm(retrySettings, 0, null), localExecutor);
            RetryingFuture future = executor.createFuture((Callable)callable, this.retryingContext);
            future.setAttemptFuture(executor.submit(future));
            Thread.sleep(50L);
            localExecutor.shutdown();
            this.assertFutureFail(future, RejectedExecutionException.class);
            localExecutor.shutdownNow();
        }
    }
}

