/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.longrunning;

import com.google.api.core.AbstractApiFuture;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.longrunning.OperationFutureImpl;
import com.google.api.gax.longrunning.OperationFutures;
import com.google.api.gax.longrunning.OperationSnapshot;
import com.google.api.gax.retrying.RetryingFuture;
import com.google.api.gax.retrying.TimedAttemptSettings;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.testing.FakeOperationSnapshot;
import com.google.api.gax.rpc.testing.FakeStatusCode;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;

public class OperationFuturesTest {
    @Test(expected=IllegalArgumentException.class)
    public void testNotDone() {
        OperationFutures.immediateOperationFuture((OperationSnapshot)FakeOperationSnapshot.newBuilder().setName("required").setDone(false).setErrorCode(FakeStatusCode.of(StatusCode.Code.OK)).build());
    }

    @Test
    public void testCompleted() throws Exception {
        OperationFuture future = OperationFutures.immediateOperationFuture((OperationSnapshot)FakeOperationSnapshot.newBuilder().setName("myName").setDone(true).setResponse("theResponse").setMetadata(42).setErrorCode(FakeStatusCode.of(StatusCode.Code.OK)).build());
        Truth.assertThat((String)future.getName()).isEqualTo((Object)"myName");
        Truth.assertThat((String)((String)future.get())).isEqualTo((Object)"theResponse");
        Truth.assertThat((Integer)((Integer)future.getMetadata().get())).isEqualTo((Object)42);
    }

    @Test
    public void testFailed() throws Exception {
        OperationFuture future = OperationFutures.immediateOperationFuture((OperationSnapshot)FakeOperationSnapshot.newBuilder().setName("myName").setDone(true).setMetadata(42).setErrorCode(FakeStatusCode.of(StatusCode.Code.INVALID_ARGUMENT)).build());
        Truth.assertThat((String)future.getName()).isEqualTo((Object)"myName");
        Truth.assertThat((Integer)((Integer)future.getMetadata().get())).isEqualTo((Object)42);
        try {
            future.get();
            Assert.fail();
        }
        catch (ExecutionException e) {
            Truth.assertThat((Throwable)e.getCause()).isInstanceOf(ApiException.class);
        }
    }

    @Test
    public void testTransform() throws Exception {
        MockRetryingFuture<FakeOperationSnapshot> pollingFuture = new MockRetryingFuture<FakeOperationSnapshot>();
        SettableApiFuture initialFuture = SettableApiFuture.create();
        ApiFunction<OperationSnapshot, String> responseTransform = new ApiFunction<OperationSnapshot, String>(){

            public String apply(OperationSnapshot operationSnapshot) {
                return (String)operationSnapshot.getResponse();
            }
        };
        ApiFunction<OperationSnapshot, Integer> metadataTransform = new ApiFunction<OperationSnapshot, Integer>(){

            public Integer apply(OperationSnapshot operationSnapshot) {
                return (int)((Integer)operationSnapshot.getMetadata());
            }
        };
        pollingFuture.set(FakeOperationSnapshot.newBuilder().setName("my-name").setDone(true).setErrorCode(FakeStatusCode.of(StatusCode.Code.OK)).setResponse("response").build());
        OperationFutureImpl future = new OperationFutureImpl(pollingFuture, (ApiFuture)initialFuture, (ApiFunction)responseTransform, (ApiFunction)metadataTransform);
        ApiFuture transformedFuture = ApiFutures.transform((ApiFuture)future, (ApiFunction)new ApiFunction<String, String>(){

            public String apply(String s) {
                return "transformed: " + s;
            }
        }, (Executor)MoreExecutors.directExecutor());
        Truth.assertThat((String)((String)transformedFuture.get(1L, TimeUnit.SECONDS))).isEqualTo((Object)"transformed: response");
    }

    private static class MockRetryingFuture<ResponseT>
    extends AbstractApiFuture<ResponseT>
    implements RetryingFuture<ResponseT> {
        private MockRetryingFuture() {
        }

        public boolean set(ResponseT value) {
            return super.set(value);
        }

        public void setAttemptFuture(ApiFuture<ResponseT> attemptFuture) {
            throw new UnsupportedOperationException();
        }

        public Callable<ResponseT> getCallable() {
            throw new UnsupportedOperationException();
        }

        public TimedAttemptSettings getAttemptSettings() {
            throw new UnsupportedOperationException();
        }

        public ApiFuture<ResponseT> peekAttemptResult() {
            throw new UnsupportedOperationException();
        }

        public ApiFuture<ResponseT> getAttemptResult() {
            throw new UnsupportedOperationException();
        }
    }
}

