/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc.internal;

import com.google.api.gax.rpc.internal.Headers;
import com.google.common.collect.ImmutableMap;
import com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class HeadersTest {
    @Test
    public void testMergeHeaders() {
        Map<String, List<String>> headers1 = HeadersTest.createHeaders("key1", "value1", "key1", "value2");
        Map<String, List<String>> headers2 = HeadersTest.createHeaders("key1", "value2", "key2", "value2");
        ImmutableMap mergedHeaders = Headers.mergeHeaders(headers1, headers2);
        Map<String, List<String>> expectedHeaders = HeadersTest.createHeaders("key1", "value1", "key1", "value2", "key1", "value2", "key2", "value2");
        Truth.assertThat((Map)mergedHeaders).containsExactlyEntriesIn(expectedHeaders);
    }

    @Test
    public void testMergeHeadersEmpty() {
        Map<String, List<String>> headers1 = HeadersTest.createHeaders(new String[0]);
        Map<String, List<String>> headers2 = HeadersTest.createHeaders("key1", "value1", "key2", "value2");
        ImmutableMap mergedHeaders = Headers.mergeHeaders(headers1, headers2);
        Map<String, List<String>> expectedHeaders = HeadersTest.createHeaders("key1", "value1", "key2", "value2");
        Truth.assertThat((Map)mergedHeaders).containsExactlyEntriesIn(expectedHeaders);
    }

    private static Map<String, List<String>> createHeaders(String ... keyValues) {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        for (int i = 0; i < keyValues.length; i += 2) {
            String key = keyValues[i];
            String value = keyValues[i + 1];
            if (!headers.containsKey(key)) {
                headers.put(key, new ArrayList());
            }
            ((List)headers.get(key)).add(value);
        }
        return headers;
    }
}

