/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import com.google.api.core.ApiFuture;
import com.google.api.gax.rpc.SpoolingCallable;
import com.google.api.gax.rpc.testing.MockStreamingApi;
import com.google.common.truth.Truth;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SpoolingCallableTest {
    private MockStreamingApi.MockServerStreamingCallable<String, String> upstream;
    private SpoolingCallable<String, String> callable;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setup() {
        this.upstream = new MockStreamingApi.MockServerStreamingCallable();
        this.callable = new SpoolingCallable(this.upstream);
    }

    @Test
    public void testHappyPath() throws InterruptedException, ExecutionException {
        ApiFuture result = this.callable.futureCall((Object)"request");
        MockStreamingApi.MockServerStreamingCall<String, String> call = this.upstream.popLastCall();
        Truth.assertThat((Boolean)call.getController().isAutoFlowControlEnabled()).isTrue();
        call.getController().getObserver().onResponse((Object)"response1");
        call.getController().getObserver().onResponse((Object)"response2");
        call.getController().getObserver().onComplete();
        Truth.assertThat((Iterable)((Iterable)result.get())).containsAllOf((Object)"response1", (Object)"response2", new Object[0]).inOrder();
    }

    @Test
    public void testEarlyTermination() throws Exception {
        ApiFuture result = this.callable.futureCall((Object)"request");
        MockStreamingApi.MockServerStreamingCall<String, String> call = this.upstream.popLastCall();
        call.getController().getObserver().onResponse((Object)"response1");
        result.cancel(true);
        call.getController().getObserver().onResponse((Object)"response2");
        Truth.assertThat((Boolean)call.getController().isCancelled()).isTrue();
        call.getController().getObserver().onError((Throwable)new RuntimeException("Some other upstream cancellation indicator"));
        this.expectedException.expect(CancellationException.class);
        result.get();
    }

    @Test
    public void testNoResults() throws Exception {
        ApiFuture result = this.callable.futureCall((Object)"request");
        MockStreamingApi.MockServerStreamingCall<String, String> call = this.upstream.popLastCall();
        call.getController().getObserver().onComplete();
        Truth.assertThat((Iterable)((Iterable)result.get())).isEmpty();
    }
}

