/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public abstract class LatchCountDownScheduler
implements ScheduledExecutorService {
    public static LatchCountDownScheduler get(final CountDownLatch latch, final long delayBeforeCountDown, final long extraDelayAfterCountDown) {
        LatchCountDownScheduler mock = (LatchCountDownScheduler)Mockito.mock(LatchCountDownScheduler.class);
        final ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);
        Mockito.when(mock.schedule((Runnable)ArgumentMatchers.any(Runnable.class), ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any(TimeUnit.class)))).then(new Answer<ScheduledFuture<?>>(){

            public ScheduledFuture<?> answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                Long delay = (Long)args[1];
                TimeUnit timeUnit = (TimeUnit)((Object)args[2]);
                delay = delay + timeUnit.convert(extraDelayAfterCountDown, TimeUnit.MILLISECONDS);
                latch.countDown();
                if (delayBeforeCountDown > 0L) {
                    Thread.sleep(delayBeforeCountDown);
                }
                return executor.schedule((Runnable)args[0], (long)delay, timeUnit);
            }
        });
        Mockito.when(mock.shutdownNow()).then((Answer)new Answer<List<Runnable>>(){

            public List<Runnable> answer(InvocationOnMock invocation) throws Throwable {
                return executor.shutdownNow();
            }
        });
        return mock;
    }
}

