/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.retrying;

import com.google.api.gax.retrying.RetrySettings;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import org.threeten.bp.Duration;

class FailingCallable
implements Callable<String> {
    static final RetrySettings FAST_RETRY_SETTINGS = RetrySettings.newBuilder().setMaxAttempts(6).setInitialRetryDelay(Duration.ofMillis((long)8L)).setRetryDelayMultiplier(1.0).setMaxRetryDelay(Duration.ofMillis((long)8L)).setInitialRpcTimeout(Duration.ofMillis((long)8L)).setJittered(false).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)8L)).setTotalTimeout(Duration.ofMillis((long)200L)).build();
    private AtomicInteger attemptsCount = new AtomicInteger(0);
    private final int expectedFailuresCount;
    private final String result;

    FailingCallable(int expectedFailuresCount, String result) {
        this.expectedFailuresCount = expectedFailuresCount;
        this.result = result;
    }

    @Override
    public String call() throws Exception {
        if (this.attemptsCount.getAndIncrement() < this.expectedFailuresCount) {
            throw new CustomException();
        }
        return this.result;
    }

    static class CustomException
    extends RuntimeException {
        private static final long serialVersionUID = -1543459008653697004L;

        CustomException() {
        }
    }
}

