/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.retrying;

import com.google.api.core.ApiFuture;
import com.google.api.core.NanoClock;
import com.google.api.gax.retrying.BasicResultRetryAlgorithm;
import com.google.api.gax.retrying.ExponentialPollAlgorithm;
import com.google.api.gax.retrying.FailingCallable;
import com.google.api.gax.retrying.PollException;
import com.google.api.gax.retrying.RetryAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.RetryingContext;
import com.google.api.gax.retrying.RetryingExecutorWithContext;
import com.google.api.gax.retrying.RetryingFuture;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;
import org.threeten.bp.Duration;

@RunWith(value=MockitoJUnitRunner.class)
public abstract class AbstractRetryingExecutorTest {
    @Mock
    protected RetryingContext retryingContext;

    protected abstract RetryingExecutorWithContext<String> getExecutor(RetryAlgorithm<String> var1);

    protected abstract RetryAlgorithm<String> getAlgorithm(RetrySettings var1, int var2, RuntimeException var3);

    @Test
    public void testSuccess() throws Exception {
        FailingCallable callable = new FailingCallable(0, "SUCCESS");
        RetryingExecutorWithContext<String> executor = this.getExecutor(this.getAlgorithm(FailingCallable.FAST_RETRY_SETTINGS, 0, null));
        RetryingFuture future = executor.createFuture((Callable)callable, this.retryingContext);
        future.setAttemptFuture(executor.submit(future));
        this.assertFutureSuccess((RetryingFuture<String>)future);
        Assert.assertEquals((long)0L, (long)future.getAttemptSettings().getAttemptCount());
    }

    @Test
    public void testSuccessWithFailures() throws Exception {
        FailingCallable callable = new FailingCallable(5, "SUCCESS");
        RetryingExecutorWithContext<String> executor = this.getExecutor(this.getAlgorithm(FailingCallable.FAST_RETRY_SETTINGS, 0, null));
        RetryingFuture future = executor.createFuture((Callable)callable, this.retryingContext);
        future.setAttemptFuture(executor.submit(future));
        this.assertFutureSuccess((RetryingFuture<String>)future);
        Assert.assertEquals((long)5L, (long)future.getAttemptSettings().getAttemptCount());
    }

    @Test
    public void testSuccessWithFailuresPeekGetAttempt() throws Exception {
        FailingCallable callable = new FailingCallable(5, "SUCCESS");
        RetryingExecutorWithContext<String> executor = this.getExecutor(this.getAlgorithm(FailingCallable.FAST_RETRY_SETTINGS, 0, null));
        RetryingFuture future = executor.createFuture((Callable)callable, this.retryingContext);
        Assert.assertNull((Object)future.peekAttemptResult());
        Assert.assertSame((Object)future.peekAttemptResult(), (Object)future.peekAttemptResult());
        TestCase.assertFalse((boolean)future.getAttemptResult().isDone());
        TestCase.assertFalse((boolean)future.getAttemptResult().isCancelled());
        TimeoutException exception = null;
        try {
            future.get(1L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            exception = e;
        }
        Assert.assertNotNull((Object)exception);
        future.setAttemptFuture(executor.submit(future));
        this.assertFutureSuccess((RetryingFuture<String>)future);
        Assert.assertEquals((long)5L, (long)future.getAttemptSettings().getAttemptCount());
    }

    @Test
    public void testMaxRetriesExceeded() throws Exception {
        FailingCallable callable = new FailingCallable(6, "FAILURE");
        RetryingExecutorWithContext<String> executor = this.getExecutor(this.getAlgorithm(FailingCallable.FAST_RETRY_SETTINGS, 0, null));
        RetryingFuture future = executor.createFuture((Callable)callable, this.retryingContext);
        future.setAttemptFuture(executor.submit(future));
        this.assertFutureFail(future, FailingCallable.CustomException.class);
        Assert.assertEquals((long)5L, (long)future.getAttemptSettings().getAttemptCount());
    }

    @Test
    public void testTotalTimeoutExceeded() throws Exception {
        RetrySettings retrySettings = FailingCallable.FAST_RETRY_SETTINGS.toBuilder().setInitialRetryDelay(Duration.ofMillis((long)Integer.MAX_VALUE)).setMaxRetryDelay(Duration.ofMillis((long)Integer.MAX_VALUE)).build();
        RetryingExecutorWithContext<String> executor = this.getExecutor(this.getAlgorithm(retrySettings, 0, null));
        FailingCallable callable = new FailingCallable(6, "FAILURE");
        RetryingFuture future = executor.createFuture((Callable)callable, this.retryingContext);
        future.setAttemptFuture(executor.submit(future));
        this.assertFutureFail(future, FailingCallable.CustomException.class);
        Assert.assertTrue((future.getAttemptSettings().getAttemptCount() < 4 ? 1 : 0) != 0);
    }

    @Test
    public void testCancelOuterFutureBeforeStart() throws Exception {
        FailingCallable callable = new FailingCallable(4, "SUCCESS");
        RetrySettings retrySettings = FailingCallable.FAST_RETRY_SETTINGS.toBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setMaxRetryDelay(Duration.ofMillis((long)1000L)).setTotalTimeout(Duration.ofMillis((long)100000L)).build();
        RetryingExecutorWithContext<String> executor = this.getExecutor(this.getAlgorithm(retrySettings, 0, null));
        RetryingFuture future = executor.createFuture((Callable)callable, this.retryingContext);
        boolean res = future.cancel(false);
        Assert.assertTrue((boolean)res);
        future.setAttemptFuture(executor.submit(future));
        this.assertFutureCancel(future);
        Assert.assertEquals((long)0L, (long)future.getAttemptSettings().getAttemptCount());
    }

    @Test
    public void testCancelByRetryingAlgorithm() throws Exception {
        FailingCallable callable = new FailingCallable(6, "FAILURE");
        RetryingExecutorWithContext<String> executor = this.getExecutor(this.getAlgorithm(FailingCallable.FAST_RETRY_SETTINGS, 5, new CancellationException()));
        RetryingFuture future = executor.createFuture((Callable)callable, this.retryingContext);
        future.setAttemptFuture(executor.submit(future));
        this.assertFutureCancel(future);
        Assert.assertEquals((long)4L, (long)future.getAttemptSettings().getAttemptCount());
    }

    @Test
    public void testUnexpectedExceptionFromRetryAlgorithm() throws Exception {
        FailingCallable callable = new FailingCallable(6, "FAILURE");
        RetryingExecutorWithContext<String> executor = this.getExecutor(this.getAlgorithm(FailingCallable.FAST_RETRY_SETTINGS, 5, new RuntimeException()));
        RetryingFuture future = executor.createFuture((Callable)callable, this.retryingContext);
        future.setAttemptFuture(executor.submit(future));
        this.assertFutureFail(future, RuntimeException.class);
        Assert.assertEquals((long)4L, (long)future.getAttemptSettings().getAttemptCount());
    }

    @Test
    public void testPollExceptionByPollAlgorithm() throws Exception {
        RetrySettings retrySettings = FailingCallable.FAST_RETRY_SETTINGS.toBuilder().setInitialRetryDelay(Duration.ofMillis((long)Integer.MAX_VALUE)).setMaxRetryDelay(Duration.ofMillis((long)Integer.MAX_VALUE)).build();
        RetryAlgorithm retryAlgorithm = new RetryAlgorithm(new TestResultRetryAlgorithm(0, null), (TimedRetryAlgorithm)new ExponentialPollAlgorithm(retrySettings, NanoClock.getDefaultClock()));
        RetryingExecutorWithContext<String> executor = this.getExecutor((RetryAlgorithm<String>)retryAlgorithm);
        FailingCallable callable = new FailingCallable(6, "FAILURE");
        RetryingFuture future = executor.createFuture((Callable)callable, this.retryingContext);
        future.setAttemptFuture(executor.submit(future));
        this.assertFutureFail(future, PollException.class);
        Assert.assertTrue((future.getAttemptSettings().getAttemptCount() < 4 ? 1 : 0) != 0);
    }

    void assertFutureSuccess(RetryingFuture<String> future) throws ExecutionException, InterruptedException, TimeoutException {
        Assert.assertEquals((Object)"SUCCESS", (Object)future.get(3L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)future.isDone());
        TestCase.assertFalse((boolean)future.isCancelled());
        Assert.assertEquals((Object)"SUCCESS", (Object)future.peekAttemptResult().get(3L, TimeUnit.SECONDS));
        Assert.assertSame((Object)future.peekAttemptResult(), (Object)future.peekAttemptResult());
        Assert.assertTrue((boolean)future.peekAttemptResult().isDone());
        TestCase.assertFalse((boolean)future.peekAttemptResult().isCancelled());
        Assert.assertEquals((Object)"SUCCESS", (Object)future.getAttemptResult().get(3L, TimeUnit.SECONDS));
        Assert.assertSame((Object)future.getAttemptResult(), (Object)future.getAttemptResult());
        Assert.assertTrue((boolean)future.getAttemptResult().isDone());
        TestCase.assertFalse((boolean)future.getAttemptResult().isCancelled());
        String res = (String)future.get();
        ApiFuture gottentAttempt = future.getAttemptResult();
        ApiFuture peekedAttempt = future.peekAttemptResult();
        TestCase.assertFalse((boolean)future.cancel(true));
        TestCase.assertFalse((boolean)future.cancel(false));
        Assert.assertSame((Object)gottentAttempt, (Object)future.getAttemptResult());
        Assert.assertSame((Object)peekedAttempt, (Object)future.peekAttemptResult());
        Assert.assertSame((Object)res, (Object)future.get());
        Assert.assertTrue((boolean)future.isDone());
        TestCase.assertFalse((boolean)future.isCancelled());
    }

    void assertFutureFail(RetryingFuture<?> future, Class<? extends Throwable> exceptionClass) throws TimeoutException, InterruptedException {
        Throwable exception = null;
        try {
            future.get(3L, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            exception = e.getCause();
        }
        Assert.assertNotNull((Object)exception);
        Assert.assertEquals(exception.getClass(), exceptionClass);
        Assert.assertTrue((boolean)future.isDone());
        TestCase.assertFalse((boolean)future.isCancelled());
        try {
            future.peekAttemptResult().get(3L, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            exception = e.getCause();
        }
        Assert.assertNotNull((Object)exception);
        Assert.assertEquals(exception.getClass(), exceptionClass);
        Assert.assertSame((Object)future.peekAttemptResult(), (Object)future.peekAttemptResult());
        Assert.assertTrue((boolean)future.peekAttemptResult().isDone());
        TestCase.assertFalse((boolean)future.peekAttemptResult().isCancelled());
        try {
            future.getAttemptResult().get(3L, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            exception = e.getCause();
        }
        Assert.assertNotNull((Object)exception);
        Assert.assertEquals(exception.getClass(), exceptionClass);
        Assert.assertSame((Object)future.getAttemptResult(), (Object)future.getAttemptResult());
        Assert.assertTrue((boolean)future.getAttemptResult().isDone());
        TestCase.assertFalse((boolean)future.getAttemptResult().isCancelled());
        ApiFuture gottentAttempt = future.getAttemptResult();
        ApiFuture peekedAttempt = future.peekAttemptResult();
        TestCase.assertFalse((boolean)future.cancel(true));
        TestCase.assertFalse((boolean)future.cancel(false));
        Assert.assertSame((Object)gottentAttempt, (Object)future.getAttemptResult());
        Assert.assertSame((Object)peekedAttempt, (Object)future.peekAttemptResult());
        try {
            future.get(3L, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            exception = e.getCause();
        }
        Assert.assertNotNull((Object)exception);
        Assert.assertEquals(exception.getClass(), exceptionClass);
        Assert.assertTrue((boolean)future.isDone());
        TestCase.assertFalse((boolean)future.isCancelled());
    }

    void assertFutureCancel(RetryingFuture<?> future) throws ExecutionException, InterruptedException, TimeoutException {
        CancellationException exception = null;
        try {
            future.get(3L, TimeUnit.SECONDS);
        }
        catch (CancellationException e) {
            exception = e;
        }
        Assert.assertNotNull((Object)exception);
        Assert.assertTrue((boolean)future.isDone());
        Assert.assertTrue((boolean)future.isCancelled());
        try {
            future.getAttemptResult().get(3L, TimeUnit.SECONDS);
        }
        catch (CancellationException e) {
            exception = e;
        }
        Assert.assertNotNull((Object)exception);
        Assert.assertSame((Object)future.getAttemptResult(), (Object)future.getAttemptResult());
        Assert.assertTrue((boolean)future.getAttemptResult().isDone());
        Assert.assertTrue((boolean)future.getAttemptResult().isCancelled());
        try {
            future.peekAttemptResult().get(3L, TimeUnit.SECONDS);
        }
        catch (CancellationException e) {
            exception = e;
        }
        Assert.assertNotNull((Object)exception);
        Assert.assertSame((Object)future.peekAttemptResult(), (Object)future.peekAttemptResult());
        Assert.assertTrue((boolean)future.peekAttemptResult().isDone());
        Assert.assertTrue((boolean)future.peekAttemptResult().isCancelled());
        ApiFuture gottentAttempt = future.getAttemptResult();
        ApiFuture peekedAttempt = future.peekAttemptResult();
        TestCase.assertFalse((boolean)future.cancel(true));
        TestCase.assertFalse((boolean)future.cancel(false));
        Assert.assertSame((Object)gottentAttempt, (Object)future.getAttemptResult());
        Assert.assertSame((Object)peekedAttempt, (Object)future.peekAttemptResult());
        try {
            future.get(3L, TimeUnit.SECONDS);
        }
        catch (CancellationException e) {
            exception = e;
        }
        Assert.assertNotNull((Object)exception);
        Assert.assertTrue((boolean)future.isDone());
        Assert.assertTrue((boolean)future.isCancelled());
    }

    protected static class TestResultRetryAlgorithm<ResponseT>
    extends BasicResultRetryAlgorithm<ResponseT> {
        private AtomicInteger apocalypseCountDown;
        private RuntimeException apocalypseException;

        TestResultRetryAlgorithm(int apocalypseCountDown, RuntimeException apocalypseException) {
            this.apocalypseCountDown = apocalypseCountDown > 0 ? new AtomicInteger(apocalypseCountDown * 2) : new AtomicInteger(Integer.MAX_VALUE);
            this.apocalypseException = apocalypseException;
        }

        public boolean shouldRetry(Throwable prevThrowable, ResponseT prevResponse) {
            if (this.apocalypseCountDown.decrementAndGet() == 0) {
                throw this.apocalypseException;
            }
            return super.shouldRetry(prevThrowable, prevResponse);
        }
    }
}

