/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.batching;

import com.google.api.gax.batching.FlowControlSettings;
import com.google.api.gax.batching.FlowController;
import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class FlowControllerTest {
    @Test
    public void testReserveRelease_ok() throws Exception {
        FlowController flowController = new FlowController(FlowControlSettings.newBuilder().setMaxOutstandingElementCount(Long.valueOf(10L)).setMaxOutstandingRequestBytes(Long.valueOf(10L)).setLimitExceededBehavior(FlowController.LimitExceededBehavior.Block).build());
        flowController.reserve(1L, 1L);
        flowController.release(1L, 1L);
    }

    @Test
    public void testInvalidArguments() throws Exception {
        FlowController flowController = new FlowController(FlowControlSettings.newBuilder().setMaxOutstandingElementCount(Long.valueOf(10L)).setMaxOutstandingRequestBytes(Long.valueOf(10L)).setLimitExceededBehavior(FlowController.LimitExceededBehavior.Block).build());
        flowController.reserve(0L, 0L);
        try {
            flowController.reserve(-1L, 1L);
            Assert.fail((String)"Must have thrown an illegal argument error");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            flowController.reserve(1L, -1L);
            Assert.fail((String)"Must have thrown an illegal argument error");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testReserveRelease_noLimits_ok() throws Exception {
        FlowController flowController = new FlowController(FlowControlSettings.newBuilder().setLimitExceededBehavior(FlowController.LimitExceededBehavior.Block).build());
        flowController.reserve(1L, 1L);
        flowController.release(1L, 1L);
    }

    @Test
    public void testReserveRelease_ignore_ok() throws Exception {
        FlowController flowController = new FlowController(FlowControlSettings.newBuilder().setMaxOutstandingElementCount(Long.valueOf(1L)).setMaxOutstandingRequestBytes(Long.valueOf(1L)).setLimitExceededBehavior(FlowController.LimitExceededBehavior.Ignore).build());
        flowController.reserve(1L, 1L);
        flowController.release(1L, 1L);
    }

    @Test
    public void testReserveRelease_blockedByElementCount() throws Exception {
        FlowController flowController = new FlowController(FlowControlSettings.newBuilder().setMaxOutstandingElementCount(Long.valueOf(10L)).setMaxOutstandingRequestBytes(Long.valueOf(100L)).setLimitExceededBehavior(FlowController.LimitExceededBehavior.Block).build());
        FlowControllerTest.testBlockingReserveRelease(flowController, 10, 10);
    }

    @Test
    public void testReserveRelease_blockedByElementCount_noBytesLimit() throws Exception {
        FlowController flowController = new FlowController(FlowControlSettings.newBuilder().setMaxOutstandingElementCount(Long.valueOf(10L)).setLimitExceededBehavior(FlowController.LimitExceededBehavior.Block).build());
        FlowControllerTest.testBlockingReserveRelease(flowController, 10, 10);
    }

    @Test
    public void testReserveRelease_blockedByNumberOfBytes() throws Exception {
        FlowController flowController = new FlowController(FlowControlSettings.newBuilder().setMaxOutstandingElementCount(Long.valueOf(100L)).setMaxOutstandingRequestBytes(Long.valueOf(10L)).setLimitExceededBehavior(FlowController.LimitExceededBehavior.Block).build());
        FlowControllerTest.testBlockingReserveRelease(flowController, 10, 10);
    }

    @Test
    public void testReserveRelease_blockedByNumberOfBytes_noElementCountLimit() throws Exception {
        FlowController flowController = new FlowController(FlowControlSettings.newBuilder().setMaxOutstandingRequestBytes(Long.valueOf(10L)).setLimitExceededBehavior(FlowController.LimitExceededBehavior.Block).build());
        FlowControllerTest.testBlockingReserveRelease(flowController, 10, 10);
    }

    private static void testBlockingReserveRelease(final FlowController flowController, final int maxElementCount, final int maxNumBytes) throws Exception {
        flowController.reserve(1L, 1L);
        final SettableFuture permitsReserved = SettableFuture.create();
        Future<?> finished = Executors.newCachedThreadPool().submit(new Runnable(){

            @Override
            public void run() {
                try {
                    permitsReserved.set(null);
                    flowController.reserve((long)maxElementCount, (long)maxNumBytes);
                }
                catch (FlowController.FlowControlException e) {
                    throw new AssertionError((Object)e);
                }
            }
        });
        permitsReserved.get();
        flowController.release(1L, 1L);
        finished.get();
    }

    @Test
    public void testReserveRelease_rejectedByElementCount() throws Exception {
        FlowController flowController = new FlowController(FlowControlSettings.newBuilder().setMaxOutstandingElementCount(Long.valueOf(10L)).setMaxOutstandingRequestBytes(Long.valueOf(100L)).setLimitExceededBehavior(FlowController.LimitExceededBehavior.ThrowException).build());
        this.testRejectedReserveRelease(flowController, 10, 10, FlowController.MaxOutstandingElementCountReachedException.class);
    }

    @Test
    public void testReserveRelease_rejectedByElementCount_noBytesLimit() throws Exception {
        FlowController flowController = new FlowController(FlowControlSettings.newBuilder().setMaxOutstandingElementCount(Long.valueOf(10L)).setLimitExceededBehavior(FlowController.LimitExceededBehavior.ThrowException).build());
        this.testRejectedReserveRelease(flowController, 10, 10, FlowController.MaxOutstandingElementCountReachedException.class);
    }

    @Test
    public void testReserveRelease_rejectedByNumberOfBytes() throws Exception {
        FlowController flowController = new FlowController(FlowControlSettings.newBuilder().setMaxOutstandingElementCount(Long.valueOf(100L)).setMaxOutstandingRequestBytes(Long.valueOf(10L)).setLimitExceededBehavior(FlowController.LimitExceededBehavior.ThrowException).build());
        this.testRejectedReserveRelease(flowController, 10, 10, FlowController.MaxOutstandingRequestBytesReachedException.class);
    }

    @Test
    public void testReserveRelease_rejectedByNumberOfBytes_noElementCountLimit() throws Exception {
        FlowController flowController = new FlowController(FlowControlSettings.newBuilder().setMaxOutstandingRequestBytes(Long.valueOf(10L)).setLimitExceededBehavior(FlowController.LimitExceededBehavior.ThrowException).build());
        this.testRejectedReserveRelease(flowController, 10, 10, FlowController.MaxOutstandingRequestBytesReachedException.class);
    }

    @Test
    public void testRestoreAfterFail() throws FlowController.FlowControlException {
        FlowController flowController = new FlowController(FlowControlSettings.newBuilder().setMaxOutstandingElementCount(Long.valueOf(2L)).setMaxOutstandingRequestBytes(Long.valueOf(1L)).setLimitExceededBehavior(FlowController.LimitExceededBehavior.ThrowException).build());
        flowController.reserve(1L, 1L);
        try {
            flowController.reserve(1L, 1L);
            throw new IllegalStateException("flowController should not have any bytes left");
        }
        catch (FlowController.MaxOutstandingRequestBytesReachedException maxOutstandingRequestBytesReachedException) {
            flowController.reserve(1L, 0L);
            return;
        }
    }

    private void testRejectedReserveRelease(FlowController flowController, int maxElementCount, int maxNumBytes, Class<? extends FlowController.FlowControlException> expectedException) throws FlowController.FlowControlException {
        flowController.reserve(1L, 1L);
        try {
            flowController.reserve((long)maxElementCount, (long)maxNumBytes);
            Assert.fail((String)"Should thrown a FlowController.FlowControlException");
        }
        catch (FlowController.FlowControlException e) {
            Assert.assertTrue((boolean)expectedException.isInstance((Object)e));
        }
        flowController.release(1L, 1L);
        flowController.reserve((long)maxElementCount, (long)maxNumBytes);
    }
}

