/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.retrying;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.api.gax.retrying.RetryAlgorithm;
import com.google.api.gax.retrying.RetryingExecutor;
import com.google.api.gax.retrying.RetryingFuture;
import com.google.api.gax.retrying.TimedAttemptSettings;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.FutureCallback;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

class RetryingFutureImpl<ResponseT>
extends AbstractFuture<ResponseT>
implements RetryingFuture<ResponseT> {
    private final Object lock = new Object();
    private final Callable<ResponseT> callable;
    private final RetryAlgorithm retryAlgorithm;
    private final RetryingExecutor<ResponseT> retryingExecutor;
    private volatile TimedAttemptSettings attemptSettings;
    private volatile AttemptFutureCallback attemptFutureCallback;

    RetryingFutureImpl(Callable<ResponseT> callable, RetryAlgorithm retryAlgorithm, RetryingExecutor<ResponseT> retryingExecutor) {
        this.callable = (Callable)Preconditions.checkNotNull(callable);
        this.retryAlgorithm = (RetryAlgorithm)Preconditions.checkNotNull((Object)retryAlgorithm);
        this.retryingExecutor = (RetryingExecutor)Preconditions.checkNotNull(retryingExecutor);
        this.attemptSettings = retryAlgorithm.createFirstAttempt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel(boolean mayInterruptIfRunning) {
        Object object = this.lock;
        synchronized (object) {
            if (this.attemptFutureCallback != null) {
                if (this.attemptFutureCallback.attemptFuture.cancel(mayInterruptIfRunning)) {
                    super.cancel(mayInterruptIfRunning);
                }
                return this.isCancelled();
            }
            return super.cancel(mayInterruptIfRunning);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttemptFuture(ApiFuture<ResponseT> attemptFuture) {
        if (this.isDone()) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.isDone()) {
                return;
            }
            if (attemptFuture != null) {
                this.attemptFutureCallback = new AttemptFutureCallback((Future)attemptFuture);
                ApiFutures.addCallback(attemptFuture, (ApiFutureCallback)this.attemptFutureCallback);
                if (this.isCancelled()) {
                    attemptFuture.cancel(false);
                }
            } else {
                this.attemptFutureCallback = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TimedAttemptSettings getAttemptSettings() {
        Object object = this.lock;
        synchronized (object) {
            return this.attemptSettings;
        }
    }

    @Override
    public Callable<ResponseT> getCallable() {
        return this.callable;
    }

    private void executeAttempt(Throwable delegateThrowable, Future<ResponseT> prevAttemptFuture) {
        try {
            if (prevAttemptFuture.isCancelled()) {
                this.cancel(false);
            }
            if (this.isDone()) {
                return;
            }
            TimedAttemptSettings nextAttemptSettings = this.retryAlgorithm.createNextAttempt(delegateThrowable, this.attemptSettings);
            if (this.retryAlgorithm.accept(delegateThrowable, nextAttemptSettings)) {
                this.attemptSettings = nextAttemptSettings;
                this.retryingExecutor.submit(this);
            } else {
                this.setException(delegateThrowable);
            }
        }
        catch (Throwable e) {
            this.setException(delegateThrowable);
        }
    }

    private class AttemptFutureCallback
    implements FutureCallback<ResponseT>,
    ApiFutureCallback<ResponseT> {
        private Future<ResponseT> attemptFuture;

        private AttemptFutureCallback(Future<ResponseT> attemptFuture) {
            this.attemptFuture = attemptFuture;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSuccess(ResponseT result) {
            if (this == RetryingFutureImpl.this.attemptFutureCallback && !RetryingFutureImpl.this.isDone()) {
                Object object = RetryingFutureImpl.this.lock;
                synchronized (object) {
                    if (this == RetryingFutureImpl.this.attemptFutureCallback && !RetryingFutureImpl.this.isDone()) {
                        RetryingFutureImpl.this.setAttemptFuture(null);
                        RetryingFutureImpl.this.set(result);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onFailure(Throwable t) {
            if (this == RetryingFutureImpl.this.attemptFutureCallback && !RetryingFutureImpl.this.isDone()) {
                Object object = RetryingFutureImpl.this.lock;
                synchronized (object) {
                    if (this == RetryingFutureImpl.this.attemptFutureCallback && !RetryingFutureImpl.this.isDone()) {
                        RetryingFutureImpl.this.setAttemptFuture(null);
                        RetryingFutureImpl.this.executeAttempt(t, this.attemptFuture);
                    }
                }
            }
        }
    }
}

