/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.retrying;

import com.google.api.core.BetaApi;
import com.google.api.gax.retrying.ExceptionRetryAlgorithm;
import com.google.api.gax.retrying.TimedAttemptSettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.common.base.Preconditions;

@BetaApi
public class RetryAlgorithm {
    private final TimedRetryAlgorithm timedAlgorithm;
    private final ExceptionRetryAlgorithm exceptionAlgorithm;

    public RetryAlgorithm(ExceptionRetryAlgorithm exceptionAlgorithm, TimedRetryAlgorithm timedAlgorithm) {
        this.timedAlgorithm = (TimedRetryAlgorithm)Preconditions.checkNotNull((Object)timedAlgorithm);
        this.exceptionAlgorithm = (ExceptionRetryAlgorithm)Preconditions.checkNotNull((Object)exceptionAlgorithm);
    }

    public TimedAttemptSettings createFirstAttempt() {
        return this.timedAlgorithm.createFirstAttempt();
    }

    public TimedAttemptSettings createNextAttempt(Throwable prevThrowable, TimedAttemptSettings prevSettings) {
        TimedAttemptSettings newSettings = this.exceptionAlgorithm.createNextAttempt(prevThrowable, prevSettings);
        if (newSettings == null) {
            newSettings = this.timedAlgorithm.createNextAttempt(prevSettings);
        }
        return newSettings;
    }

    boolean accept(Throwable prevThrowable, TimedAttemptSettings nextAttemptSettings) {
        return this.exceptionAlgorithm.accept(prevThrowable) && this.timedAlgorithm.accept(nextAttemptSettings);
    }
}

