/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.httpjson;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonStatusCode;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.testing.FakeApiMessage;
import com.google.api.gax.httpjson.testing.MockHttpService;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.pathtemplate.PathTemplate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.junit.Before;
import org.junit.Test;

public class MockHttpServiceTest {
    private static PetMessage gerbilMessage = new PetMessage((Map<String, Object>)ImmutableMap.of((Object)"type", (Object)Lists.newArrayList((Object[])new String[]{"rodent"})), null, null);
    private static PetMessage ospreyMessage = new PetMessage((Map<String, Object>)ImmutableMap.of((Object)"type", (Object)Lists.newArrayList((Object[])new String[]{"raptor"})), null, null);
    private static HumanMessage humanMessage = new HumanMessage((Map<String, Object>)ImmutableMap.of((Object)"type", (Object)Lists.newArrayList((Object[])new String[]{"toddler"})), null, null);
    private static final String RESPONSE_EXCEPTION_STRING = "[Expected exception]";
    private static final ApiException PARSE_EXCEPTION = new ApiException("Unknown object type.", null, (StatusCode)HttpJsonStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), false);
    private static final HttpResponseParser<PetMessage> PET_RESPONSE_PARSER = new HttpResponseParser<PetMessage>(){

        public PetMessage parse(InputStream httpContent) {
            return null;
        }

        public String serialize(PetMessage response) {
            return (String)((List)response.getFieldValue("type")).get(0);
        }
    };
    private static final String BASE_ENDPOINT = "http://google.com/";
    private static final HttpRequestFormatter<PetMessage> PET_REQUEST_FORMATTER = new HttpRequestFormatter<PetMessage>(){

        public Map<String, List<String>> getQueryParamNames(PetMessage apiMessage) {
            return null;
        }

        public String getRequestBody(PetMessage apiMessage) {
            return null;
        }

        public String getPath(PetMessage apiMessage) {
            return null;
        }

        public PathTemplate getPathTemplate() {
            return PathTemplate.create((String)"pet/{name}");
        }
    };
    private static final ApiMethodDescriptor methodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("getPetName").setHttpMethod("GET").setRequestFormatter(PET_REQUEST_FORMATTER).setResponseParser(PET_RESPONSE_PARSER).build();
    private static final List<ApiMethodDescriptor> SERVER_METHOD_DESCRIPTORS = Lists.newArrayList((Object[])new ApiMethodDescriptor[]{methodDescriptor});
    private static MockHttpService testService = new MockHttpService(SERVER_METHOD_DESCRIPTORS, "http://google.com/");
    private static final HttpRequestFactory HTTP_REQUEST_FACTORY = testService.createRequestFactory();

    @Before
    public void cleanUp() {
        testService.reset();
    }

    @Test
    public void testMessageResponse() throws IOException {
        testService.addResponse(gerbilMessage);
        testService.addResponse(ospreyMessage);
        HttpResponse httpResponse = HTTP_REQUEST_FACTORY.buildGetRequest(new GenericUrl("http://google.com/pet/rodent")).execute();
        TestCase.assertEquals((String)"rodent", (String)this.getHttpResponseString(httpResponse));
        httpResponse = HTTP_REQUEST_FACTORY.buildGetRequest(new GenericUrl("http://google.com/pet/raptor?species=birb&name=G%C3%BCnter")).execute();
        TestCase.assertEquals((String)"raptor", (String)this.getHttpResponseString(httpResponse));
    }

    @Test
    public void testNullResponse() throws IOException {
        testService.addNullResponse();
        HttpResponse httpResponse = HTTP_REQUEST_FACTORY.buildGetRequest(new GenericUrl("http://google.com/pet/raptor?species=birb")).execute();
        TestCase.assertNull((Object)httpResponse.getContent());
    }

    @Test
    public void testBadFormatter() throws IOException {
        testService.addResponse(humanMessage);
        try {
            HTTP_REQUEST_FACTORY.buildGetRequest(new GenericUrl("http://google.com/pet/raptor?species=birb")).execute();
            TestCase.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    @Test
    public void testUnknownMethodPath() throws IOException {
        testService.addResponse(gerbilMessage);
        try {
            GenericUrl url = new GenericUrl("http://google.com/car/");
            HttpResponse httpResponse = HTTP_REQUEST_FACTORY.buildGetRequest(url).execute();
            TestCase.fail();
        }
        catch (HttpResponseException e) {
            TestCase.assertFalse((boolean)e.isSuccessStatusCode());
        }
    }

    @Test
    public void testReturnException() throws IOException {
        testService.addException(new Exception(RESPONSE_EXCEPTION_STRING));
        try {
            HTTP_REQUEST_FACTORY.buildGetRequest(new GenericUrl("http://google.com/pet/rodent")).execute();
            TestCase.fail();
        }
        catch (HttpResponseException e) {
            TestCase.assertFalse((boolean)e.isSuccessStatusCode());
            TestCase.assertTrue((boolean)e.getContent().contains(RESPONSE_EXCEPTION_STRING));
        }
    }

    @Test
    public void testHeaderSent() throws IOException {
        testService.addNullResponse();
        String headerValue1 = "3005";
        String headerValue2 = "d.?g";
        HttpRequestInitializer httpRequestInitializer = new HttpRequestInitializer(){

            public void initialize(HttpRequest request) throws IOException {
                request.setHeaders(new HttpHeaders().set("headerkey1", (Object)"3005").set("headerkey2", (Object)"d.?g"));
            }
        };
        HttpRequestFactory requestFactory = testService.createRequestFactory(httpRequestInitializer);
        requestFactory.buildGetRequest(new GenericUrl(BASE_ENDPOINT)).execute();
        TestCase.assertEquals((String)"3005", (String)((String)testService.getRequestHeaders().get((Object)"headerkey1").iterator().next()));
        TestCase.assertEquals((String)"d.?g", (String)((String)testService.getRequestHeaders().get((Object)"headerkey2").iterator().next()));
    }

    private String getHttpResponseString(HttpResponse httpResponse) throws IOException {
        return CharStreams.toString((Readable)new InputStreamReader(httpResponse.getContent()));
    }

    private static class HumanMessage
    extends FakeApiMessage {
        public HumanMessage(Map<String, Object> fieldValues, ApiMessage requestBodyMessage, List<String> fieldMask) {
            super(fieldValues, requestBodyMessage, fieldMask);
        }
    }

    private static class PetMessage
    extends FakeApiMessage {
        public PetMessage(Map<String, Object> fieldValues, ApiMessage requestBodyMessage, List<String> fieldMask) {
            super(fieldValues, requestBodyMessage, fieldMask);
        }
    }
}

