/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.httpjson;

import com.google.api.gax.httpjson.ApiMessage;
import com.google.api.gax.httpjson.FieldMaskedSerializer;
import com.google.api.gax.httpjson.testing.FakeApiMessage;
import com.google.common.collect.Lists;
import com.google.common.truth.Truth;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.junit.Test;

public class FieldMaskTest {
    private static final TreeMessage treeMessage = new TreeMessage("Cedrus", Lists.newArrayList((Object[])new Integer[]{2, 0, 6}));

    @Test
    public void testFieldMaskGenus() {
        ArrayList fieldMask = Lists.newArrayList((Object[])new String[]{"genus"});
        FieldMaskedSerializer jsonSerializer = new FieldMaskedSerializer((List)fieldMask);
        Gson gson = new GsonBuilder().registerTypeAdapter(TreeMessage.class, (Object)jsonSerializer).create();
        Truth.assertThat((String)gson.toJson((Object)treeMessage)).isEqualTo((Object)"{\"genus\":\"Cedrus\"}");
    }

    @Test
    public void testFieldMaskBranches() {
        ArrayList fieldMask = Lists.newArrayList((Object[])new String[]{"branchLengths"});
        FieldMaskedSerializer jsonSerializer = new FieldMaskedSerializer((List)fieldMask);
        Gson gson = new GsonBuilder().registerTypeAdapter(TreeMessage.class, (Object)jsonSerializer).create();
        Truth.assertThat((String)gson.toJson((Object)treeMessage)).isEqualTo((Object)"{\"branchLengths\":[2,0,6]}");
    }

    @Test
    public void testEmptyFieldMask() {
        FieldMaskedSerializer jsonSerializer = new FieldMaskedSerializer(null);
        Gson gson = new GsonBuilder().registerTypeAdapter(FakeApiMessage.class, (Object)jsonSerializer).create();
        Truth.assertThat((String)gson.toJson((Object)treeMessage)).isEqualTo((Object)"{\"genus\":\"Cedrus\",\"branchLengths\":[2,0,6]}");
    }

    private static class TreeMessage
    implements ApiMessage {
        private String genus;
        private List<Integer> branchLengths;

        TreeMessage(String genus, List<Integer> branchLengths) {
            this.genus = genus;
            this.branchLengths = branchLengths;
        }

        @Nullable
        public Object getFieldValue(String fieldName) {
            if (fieldName.equals("genus")) {
                return this.genus;
            }
            if (fieldName.equals("branchLengths")) {
                return this.branchLengths;
            }
            return null;
        }

        @Nullable
        public List<String> getFieldMask() {
            return null;
        }

        @Nullable
        public ApiMessage getApiMessageRequestBody() {
            return null;
        }
    }
}

