/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.httpjson;

import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpResponseException;
import com.google.api.core.ApiClock;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.FakeApiClock;
import com.google.api.gax.core.RecordingScheduler;
import com.google.api.gax.httpjson.HttpJsonCallContext;
import com.google.api.gax.httpjson.HttpJsonCallableFactory;
import com.google.api.gax.httpjson.HttpJsonStatusCode;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.FailedPreconditionException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.gax.rpc.UnknownException;
import com.google.common.collect.ImmutableSet;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class RetryingTest {
    private UnaryCallable<Integer, Integer> callInt = (UnaryCallable)Mockito.mock(UnaryCallable.class);
    private RecordingScheduler executor;
    private FakeApiClock fakeClock;
    private ClientContext clientContext;
    private static int STATUS_SERVER_ERROR = 500;
    private static int STATUS_DEADLINE_EXCEEDED = 504;
    private static int STATUS_FAILED_PRECONDITION = 400;
    private static String DEADLINE_EXCEEDED = "DEADLINE_EXCEEDED";
    private HttpResponseException HTTP_SERVICE_UNAVAILABLE_EXCEPTION = new HttpResponseException.Builder(503, "server unavailable", new HttpHeaders()).build();
    private static final RetrySettings FAST_RETRY_SETTINGS = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)2L)).setRetryDelayMultiplier(1.0).setMaxRetryDelay(Duration.ofMillis((long)2L)).setInitialRpcTimeout(Duration.ofMillis((long)2L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)2L)).setTotalTimeout(Duration.ofMillis((long)10L)).build();
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Before
    public void resetClock() {
        this.fakeClock = new FakeApiClock(System.nanoTime());
        this.executor = RecordingScheduler.create((FakeApiClock)this.fakeClock);
        this.clientContext = ClientContext.newBuilder().setExecutor((ScheduledExecutorService)this.executor).setClock((ApiClock)this.fakeClock).setDefaultCallContext((ApiCallContext)HttpJsonCallContext.createDefault()).build();
    }

    @After
    public void teardown() {
        this.executor.shutdownNow();
    }

    static <V> ApiFuture<V> immediateFailedFuture(Throwable t) {
        return ApiFutures.immediateFailedFuture((Throwable)t);
    }

    @Test
    public void retry() {
        ImmutableSet retryable = ImmutableSet.of((Object)StatusCode.Code.UNAVAILABLE);
        Mockito.when((Object)this.callInt.futureCall((Object)((Integer)Mockito.any()), (ApiCallContext)Mockito.any())).thenReturn(RetryingTest.immediateFailedFuture(this.HTTP_SERVICE_UNAVAILABLE_EXCEPTION)).thenReturn(RetryingTest.immediateFailedFuture(this.HTTP_SERVICE_UNAVAILABLE_EXCEPTION)).thenReturn(RetryingTest.immediateFailedFuture(this.HTTP_SERVICE_UNAVAILABLE_EXCEPTION)).thenReturn((Object)ApiFutures.immediateFuture((Object)2));
        UnaryCallSettings<Integer, Integer> callSettings = RetryingTest.createSettings((Set<StatusCode.Code>)retryable, FAST_RETRY_SETTINGS);
        UnaryCallable callable = HttpJsonCallableFactory.createUnaryCallable(this.callInt, callSettings, (ClientContext)this.clientContext);
        Truth.assertThat((Integer)((Integer)callable.call((Object)1))).isEqualTo((Object)2);
    }

    @Test(expected=ApiException.class)
    public void retryTotalTimeoutExceeded() {
        ImmutableSet retryable = ImmutableSet.of((Object)StatusCode.Code.UNAVAILABLE);
        HttpResponseException httpResponseException = new HttpResponseException.Builder(503, "server unavailable", new HttpHeaders()).build();
        ApiException apiException = ApiExceptionFactory.createException((String)"foobar", (Throwable)httpResponseException, (StatusCode)HttpJsonStatusCode.of((StatusCode.Code)StatusCode.Code.FAILED_PRECONDITION), (boolean)false);
        Mockito.when((Object)this.callInt.futureCall((Object)((Integer)Mockito.any()), (ApiCallContext)Mockito.any())).thenReturn(RetryingTest.immediateFailedFuture((Throwable)apiException)).thenReturn((Object)ApiFutures.immediateFuture((Object)2));
        RetrySettings retrySettings = FAST_RETRY_SETTINGS.toBuilder().setInitialRetryDelay(Duration.ofMillis((long)Integer.MAX_VALUE)).setMaxRetryDelay(Duration.ofMillis((long)Integer.MAX_VALUE)).build();
        UnaryCallSettings<Integer, Integer> callSettings = RetryingTest.createSettings((Set<StatusCode.Code>)retryable, retrySettings);
        UnaryCallable callable = HttpJsonCallableFactory.createUnaryCallable(this.callInt, callSettings, (ClientContext)this.clientContext);
        callable.call((Object)1);
    }

    @Test(expected=ApiException.class)
    public void retryMaxAttemptsExceeded() {
        ImmutableSet retryable = ImmutableSet.of((Object)StatusCode.Code.UNAVAILABLE);
        Mockito.when((Object)this.callInt.futureCall((Object)((Integer)Mockito.any()), (ApiCallContext)Mockito.any())).thenReturn(RetryingTest.immediateFailedFuture(this.HTTP_SERVICE_UNAVAILABLE_EXCEPTION)).thenReturn(RetryingTest.immediateFailedFuture(this.HTTP_SERVICE_UNAVAILABLE_EXCEPTION)).thenReturn((Object)ApiFutures.immediateFuture((Object)2));
        RetrySettings retrySettings = FAST_RETRY_SETTINGS.toBuilder().setMaxAttempts(2).build();
        UnaryCallSettings<Integer, Integer> callSettings = RetryingTest.createSettings((Set<StatusCode.Code>)retryable, retrySettings);
        UnaryCallable callable = HttpJsonCallableFactory.createUnaryCallable(this.callInt, callSettings, (ClientContext)this.clientContext);
        callable.call((Object)1);
    }

    @Test
    public void retryWithinMaxAttempts() {
        ImmutableSet retryable = ImmutableSet.of((Object)StatusCode.Code.UNAVAILABLE);
        Mockito.when((Object)this.callInt.futureCall((Object)((Integer)Mockito.any()), (ApiCallContext)Mockito.any())).thenReturn(RetryingTest.immediateFailedFuture(this.HTTP_SERVICE_UNAVAILABLE_EXCEPTION)).thenReturn(RetryingTest.immediateFailedFuture(this.HTTP_SERVICE_UNAVAILABLE_EXCEPTION)).thenReturn((Object)ApiFutures.immediateFuture((Object)2));
        RetrySettings retrySettings = FAST_RETRY_SETTINGS.toBuilder().setMaxAttempts(3).build();
        UnaryCallSettings<Integer, Integer> callSettings = RetryingTest.createSettings((Set<StatusCode.Code>)retryable, retrySettings);
        UnaryCallable callable = HttpJsonCallableFactory.createUnaryCallable(this.callInt, callSettings, (ClientContext)this.clientContext);
        callable.call((Object)1);
        Truth.assertThat((Integer)((Integer)callable.call((Object)1))).isEqualTo((Object)2);
    }

    @Test
    public void retryOnStatusUnknown() {
        ImmutableSet retryable = ImmutableSet.of((Object)StatusCode.Code.UNKNOWN);
        HttpResponseException throwable = new HttpResponseException.Builder(STATUS_SERVER_ERROR, "server unavailable", new HttpHeaders()).setMessage("UNKNOWN").build();
        Mockito.when((Object)this.callInt.futureCall((Object)((Integer)Mockito.any()), (ApiCallContext)Mockito.any())).thenReturn(RetryingTest.immediateFailedFuture(throwable)).thenReturn(RetryingTest.immediateFailedFuture(throwable)).thenReturn(RetryingTest.immediateFailedFuture(throwable)).thenReturn((Object)ApiFutures.immediateFuture((Object)2));
        UnaryCallSettings<Integer, Integer> callSettings = RetryingTest.createSettings((Set<StatusCode.Code>)retryable, FAST_RETRY_SETTINGS);
        UnaryCallable callable = HttpJsonCallableFactory.createUnaryCallable(this.callInt, callSettings, (ClientContext)this.clientContext);
        Truth.assertThat((Integer)((Integer)callable.call((Object)1))).isEqualTo((Object)2);
    }

    @Test
    public void retryOnUnexpectedException() {
        this.thrown.expect(ApiException.class);
        this.thrown.expectMessage("foobar");
        ImmutableSet retryable = ImmutableSet.of((Object)StatusCode.Code.UNKNOWN);
        RuntimeException throwable = new RuntimeException("foobar");
        Mockito.when((Object)this.callInt.futureCall((Object)((Integer)Mockito.any()), (ApiCallContext)Mockito.any())).thenReturn(RetryingTest.immediateFailedFuture(throwable));
        UnaryCallSettings<Integer, Integer> callSettings = RetryingTest.createSettings((Set<StatusCode.Code>)retryable, FAST_RETRY_SETTINGS);
        UnaryCallable callable = HttpJsonCallableFactory.createUnaryCallable(this.callInt, callSettings, (ClientContext)this.clientContext);
        callable.call((Object)1);
    }

    @Test
    public void retryNoRecover() {
        this.thrown.expect(ApiException.class);
        this.thrown.expectMessage("foobar");
        ImmutableSet retryable = ImmutableSet.of((Object)StatusCode.Code.UNAVAILABLE);
        HttpResponseException httpResponseException = new HttpResponseException.Builder(STATUS_FAILED_PRECONDITION, "foobar", new HttpHeaders()).build();
        ApiException apiException = ApiExceptionFactory.createException((String)"foobar", (Throwable)httpResponseException, (StatusCode)HttpJsonStatusCode.of((StatusCode.Code)StatusCode.Code.FAILED_PRECONDITION), (boolean)false);
        Mockito.when((Object)this.callInt.futureCall((Object)((Integer)Mockito.any()), (ApiCallContext)Mockito.any())).thenReturn(RetryingTest.immediateFailedFuture((Throwable)apiException)).thenReturn((Object)ApiFutures.immediateFuture((Object)2));
        UnaryCallSettings<Integer, Integer> callSettings = RetryingTest.createSettings((Set<StatusCode.Code>)retryable, FAST_RETRY_SETTINGS);
        UnaryCallable callable = HttpJsonCallableFactory.createUnaryCallable(this.callInt, callSettings, (ClientContext)this.clientContext);
        callable.call((Object)1);
    }

    @Test
    public void retryKeepFailing() {
        this.thrown.expect(UncheckedExecutionException.class);
        this.thrown.expectMessage("foobar");
        ImmutableSet retryable = ImmutableSet.of((Object)StatusCode.Code.UNAVAILABLE);
        Mockito.when((Object)this.callInt.futureCall((Object)((Integer)Mockito.any()), (ApiCallContext)Mockito.any())).thenReturn(RetryingTest.immediateFailedFuture(new HttpResponseException.Builder(503, "foobar", new HttpHeaders()).build()));
        UnaryCallSettings<Integer, Integer> callSettings = RetryingTest.createSettings((Set<StatusCode.Code>)retryable, FAST_RETRY_SETTINGS);
        UnaryCallable callable = HttpJsonCallableFactory.createUnaryCallable(this.callInt, callSettings, (ClientContext)this.clientContext);
        ApiFuture future = callable.futureCall((Object)1);
        Futures.getUnchecked((Future)future);
    }

    @Test
    public void testKnownStatusCode() {
        ImmutableSet retryable = ImmutableSet.of((Object)StatusCode.Code.UNAVAILABLE);
        String throwableMessage = "{\n \"error\": {\n  \"errors\": [\n   {\n    \"domain\": \"global\",\n    \"reason\": \"FAILED_PRECONDITION\",\n   }\n  ],\n  \"code\": 400,\n  \"message\": \"Failed precondition.\"\n }\n}";
        HttpResponseException throwable = new HttpResponseException.Builder(STATUS_FAILED_PRECONDITION, "FAILED_PRECONDITION", new HttpHeaders()).setMessage(throwableMessage).build();
        Mockito.when((Object)this.callInt.futureCall((Object)((Integer)Mockito.any()), (ApiCallContext)Mockito.any())).thenReturn(RetryingTest.immediateFailedFuture(throwable));
        UnaryCallSettings callSettings = UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)retryable).build();
        UnaryCallable callable = HttpJsonCallableFactory.createUnaryCallable(this.callInt, (UnaryCallSettings)callSettings, (ClientContext)this.clientContext);
        try {
            callable.call((Object)1);
        }
        catch (FailedPreconditionException exception) {
            Truth.assertThat((Integer)((HttpJsonStatusCode)exception.getStatusCode()).getTransportCode()).isEqualTo((Object)STATUS_FAILED_PRECONDITION);
            Truth.assertThat((String)exception.getMessage()).contains((CharSequence)"FAILED_PRECONDITION");
        }
    }

    @Test
    public void testUnknownStatusCode() {
        ImmutableSet retryable = ImmutableSet.of();
        Mockito.when((Object)this.callInt.futureCall((Object)((Integer)Mockito.any()), (ApiCallContext)Mockito.any())).thenReturn(RetryingTest.immediateFailedFuture(new RuntimeException("unknown")));
        UnaryCallSettings callSettings = UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)retryable).build();
        UnaryCallable callable = HttpJsonCallableFactory.createUnaryCallable(this.callInt, (UnaryCallSettings)callSettings, (ClientContext)this.clientContext);
        try {
            callable.call((Object)1);
        }
        catch (UnknownException exception) {
            Truth.assertThat((String)exception.getMessage()).isEqualTo((Object)"java.lang.RuntimeException: unknown");
        }
    }

    public static UnaryCallSettings<Integer, Integer> createSettings(Set<StatusCode.Code> retryableCodes, RetrySettings retrySettings) {
        return UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes(retryableCodes).setRetrySettings(retrySettings).build();
    }
}

