/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.httpjson;

import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.testing.http.MockHttpTransport;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallOptions;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpRequestRunnable;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.testing.FakeApiMessage;
import com.google.api.pathtemplate.PathTemplate;
import com.google.auth.Credentials;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.truth.Truth;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.junit.BeforeClass;
import org.junit.Test;
import org.threeten.bp.Instant;

public class HttpRequestRunnableTest {
    private static HttpJsonCallOptions fakeCallOptions;
    private static CatMessage catMessage;
    private static final String ENDPOINT = "https://www.googleapis.com/animals/v1/projects/";
    private static HttpRequestRunnable httpRequestRunnable;
    private static HttpRequestFormatter<CatMessage> catFormatter;
    private static HttpResponseParser<Void> catParser;
    private static ApiMethodDescriptor<CatMessage, Void> methodDescriptor;
    private static PathTemplate nameTemplate;
    private static Set<String> queryParams;

    @BeforeClass
    public static void setUp() {
        fakeCallOptions = new HttpJsonCallOptions(){

            public Instant getDeadline() {
                return null;
            }

            public Credentials getCredentials() {
                return null;
            }
        };
        catMessage = new CatMessage((Map<String, Object>)ImmutableMap.of((Object)"name", (Object)"feline", (Object)"size", Arrays.asList("small"), (Object)"food", Arrays.asList("bird", "mouse")), null, null);
        catFormatter = new HttpRequestFormatter<CatMessage>(){
            private PathTemplate namePattern = PathTemplate.create((String)"name/{name}");

            public Map<String, List<String>> getQueryParamNames(CatMessage apiMessage) {
                TreeMap<String, List<String>> values = new TreeMap<String, List<String>>();
                for (String queryParam : queryParams) {
                    Object fieldValue = apiMessage.getFieldValue(queryParam);
                    if (fieldValue == null) continue;
                    if (fieldValue instanceof List) {
                        values.put(queryParam, (List)fieldValue);
                        continue;
                    }
                    values.put(queryParam, Lists.newArrayList((Object[])new String[]{fieldValue.toString()}));
                }
                return values;
            }

            public String getRequestBody(CatMessage apiMessage) {
                return null;
            }

            public String getPath(CatMessage apiMessage) {
                String name = apiMessage.getFieldValue("name").toString();
                return nameTemplate.instantiate(new String[]{"name", name});
            }

            public PathTemplate getPathTemplate() {
                return this.namePattern;
            }
        };
        catParser = new HttpResponseParser<Void>(){

            public Void parse(InputStream httpContent) {
                return null;
            }

            public String serialize(Void response) {
                return null;
            }
        };
        methodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("house.cat.get").setHttpMethod(null).setRequestFormatter(catFormatter).setResponseParser(catParser).build();
        httpRequestRunnable = HttpRequestRunnable.newBuilder().setHttpJsonCallOptions(fakeCallOptions).setEndpoint(ENDPOINT).setRequest((Object)catMessage).setApiMethodDescriptor(methodDescriptor).setHttpTransport((HttpTransport)new MockHttpTransport()).setJsonFactory((JsonFactory)new JacksonFactory()).build();
    }

    @Test
    public void testRequestUrl() throws IOException {
        HttpRequest httpRequest = httpRequestRunnable.createHttpRequest();
        String expectedUrl = "https://www.googleapis.com/animals/v1/projects/name/feline?food=bird&food=mouse&size=small";
        Truth.assertThat((String)httpRequest.getUrl().toString()).isEqualTo((Object)expectedUrl);
    }

    static {
        nameTemplate = PathTemplate.create((String)"name/{name}");
        queryParams = Sets.newTreeSet((Iterable)Lists.newArrayList((Object[])new String[]{"food", "size", "gibberish"}));
    }

    private static class CatMessage
    extends FakeApiMessage {
        CatMessage(Map<String, Object> fieldValues, ApiMessage messageBody, List<String> fieldMask) {
            super(fieldValues, messageBody, fieldMask);
        }
    }
}

