/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.httpjson;

import com.google.api.gax.httpjson.HttpJsonCallContext;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.ManagedHttpJsonChannel;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.TransportChannel;
import com.google.api.gax.rpc.testing.FakeCallContext;
import com.google.api.gax.rpc.testing.FakeChannel;
import com.google.api.gax.rpc.testing.FakeTransportChannel;
import com.google.auth.Credentials;
import com.google.common.truth.Truth;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class HttpJsonCallContextTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testNullToSelfWrongType() {
        this.thrown.expect(IllegalArgumentException.class);
        HttpJsonCallContext.createDefault().nullToSelf((ApiCallContext)FakeCallContext.createDefault());
    }

    @Test
    public void testWithCredentials() {
        Credentials credentials = (Credentials)Mockito.mock(Credentials.class);
        HttpJsonCallContext emptyContext = HttpJsonCallContext.createDefault();
        Truth.assertThat((Object)emptyContext.getCredentials()).isNull();
        HttpJsonCallContext context = emptyContext.withCredentials(credentials);
        Truth.assertThat((Object)context.getCredentials()).isNotNull();
    }

    @Test
    public void testWithTransportChannel() {
        ManagedHttpJsonChannel channel = (ManagedHttpJsonChannel)Mockito.mock(ManagedHttpJsonChannel.class);
        HttpJsonCallContext context = HttpJsonCallContext.createDefault().withTransportChannel((TransportChannel)HttpJsonTransportChannel.newBuilder().setManagedChannel(channel).build());
        Truth.assertThat((Object)context.getChannel()).isSameAs((Object)channel);
    }

    @Test
    public void testWithTransportChannelWrongType() {
        this.thrown.expect(IllegalArgumentException.class);
        FakeChannel channel = new FakeChannel();
        HttpJsonCallContext.createDefault().withTransportChannel((TransportChannel)FakeTransportChannel.create((FakeChannel)channel));
    }

    @Test
    public void testMergeWrongType() {
        this.thrown.expect(IllegalArgumentException.class);
        HttpJsonCallContext.createDefault().merge((ApiCallContext)FakeCallContext.createDefault());
    }

    @Test
    public void testWithTimeout() {
        Truth.assertThat((Comparable)HttpJsonCallContext.createDefault().withTimeout(null).getTimeout()).isNull();
    }

    @Test
    public void testWithNegativeTimeout() {
        Truth.assertThat((Comparable)HttpJsonCallContext.createDefault().withTimeout(Duration.ofSeconds((long)-1L)).getTimeout()).isNull();
    }

    @Test
    public void testWithZeroTimeout() {
        Truth.assertThat((Comparable)HttpJsonCallContext.createDefault().withTimeout(Duration.ofSeconds((long)0L)).getTimeout()).isNull();
    }

    @Test
    public void testWithShorterTimeout() {
        HttpJsonCallContext ctxWithLongTimeout = HttpJsonCallContext.createDefault().withTimeout(Duration.ofSeconds((long)10L));
        Truth.assertThat((Comparable)ctxWithLongTimeout.getTimeout()).isEqualTo((Object)Duration.ofSeconds((long)10L));
        HttpJsonCallContext ctxWithShorterTimeout = ctxWithLongTimeout.withTimeout(Duration.ofSeconds((long)5L));
        Truth.assertThat((Comparable)ctxWithShorterTimeout.getTimeout()).isEqualTo((Object)Duration.ofSeconds((long)5L));
    }

    @Test
    public void testWithLongerTimeout() {
        HttpJsonCallContext ctxWithShortTimeout = HttpJsonCallContext.createDefault().withTimeout(Duration.ofSeconds((long)5L));
        Truth.assertThat((Comparable)ctxWithShortTimeout.getTimeout()).isEqualTo((Object)Duration.ofSeconds((long)5L));
        HttpJsonCallContext ctxWithUnchangedTimeout = ctxWithShortTimeout.withTimeout(Duration.ofSeconds((long)10L));
        Truth.assertThat((Comparable)ctxWithUnchangedTimeout.getTimeout()).isEqualTo((Object)Duration.ofSeconds((long)5L));
    }

    @Test
    public void testMergeWithNullTimeout() {
        Duration timeout = Duration.ofSeconds((long)10L);
        HttpJsonCallContext baseContext = HttpJsonCallContext.createDefault().withTimeout(timeout);
        HttpJsonCallContext defaultOverlay = HttpJsonCallContext.createDefault();
        Truth.assertThat((Comparable)baseContext.merge((ApiCallContext)defaultOverlay).getTimeout()).isEqualTo((Object)timeout);
        HttpJsonCallContext explicitNullOverlay = HttpJsonCallContext.createDefault().withTimeout(null);
        Truth.assertThat((Comparable)baseContext.merge((ApiCallContext)explicitNullOverlay).getTimeout()).isEqualTo((Object)timeout);
    }

    @Test
    public void testMergeWithTimeout() {
        Duration timeout = Duration.ofSeconds((long)19L);
        HttpJsonCallContext ctx1 = HttpJsonCallContext.createDefault();
        HttpJsonCallContext ctx2 = HttpJsonCallContext.createDefault().withTimeout(timeout);
        Truth.assertThat((Comparable)ctx1.merge((ApiCallContext)ctx2).getTimeout()).isEqualTo((Object)timeout);
    }
}

