/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.services;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClient;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.testing.services.MockGoogleClient;
import com.google.api.client.googleapis.testing.services.MockGoogleClientRequest;
import com.google.api.client.http.EmptyContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.testing.http.MockHttpTransport;
import com.google.api.client.testing.http.MockLowLevelHttpRequest;
import com.google.api.client.testing.http.MockLowLevelHttpResponse;
import com.google.api.client.util.ObjectParser;
import com.google.common.io.BaseEncoding;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import junit.framework.TestCase;

public class AbstractGoogleClientRequestTest
extends TestCase {
    private static final String ROOT_URL = "https://www.googleapis.com/test/";
    private static final String SERVICE_PATH = "path/v1/";
    private static final String URI_TEMPLATE = "tests/{testId}";
    private static final JsonFactory JSON_FACTORY = new GsonFactory();
    private static final JsonObjectParser JSON_OBJECT_PARSER = new JsonObjectParser(JSON_FACTORY);
    private static final String ERROR_CONTENT = "{\"error\":{\"code\":401,\"errors\":[{\"domain\":\"global\",\"location\":\"Authorization\",\"locationType\":\"header\",\"message\":\"me\",\"reason\":\"authError\"}],\"message\":\"me\"}}";
    private String originalOsName;
    private String originalOsVersion;

    protected void setUp() throws Exception {
        super.setUp();
        this.originalOsName = System.getProperty("os.name");
        this.originalOsVersion = System.getProperty("os.version");
    }

    protected void tearDown() throws Exception {
        System.setProperty("os.name", this.originalOsName);
        System.setProperty("os.version", this.originalOsVersion);
        super.tearDown();
    }

    public void testExecuteUnparsed_error() throws Exception {
        MockHttpTransport transport = new MockHttpTransport(){

            public LowLevelHttpRequest buildRequest(final String method, final String url) {
                return new MockLowLevelHttpRequest(){

                    public LowLevelHttpResponse execute() {
                        TestCase.assertEquals((String)"GET", (String)method);
                        TestCase.assertEquals((String)"https://www.googleapis.com/test/path/v1/tests/foo", (String)url);
                        MockLowLevelHttpResponse result = new MockLowLevelHttpResponse();
                        result.setStatusCode(401);
                        result.setContentType("application/json; charset=UTF-8");
                        result.setContent(AbstractGoogleClientRequestTest.ERROR_CONTENT);
                        return result;
                    }
                };
            }
        };
        MockGoogleClient client = new MockGoogleClient.Builder((HttpTransport)transport, ROOT_URL, SERVICE_PATH, (ObjectParser)JSON_OBJECT_PARSER, null).setApplicationName("Test Application").build();
        MockGoogleClientRequest request = new MockGoogleClientRequest((AbstractGoogleClient)client, "GET", URI_TEMPLATE, null, String.class);
        try {
            request.put("testId", (Object)"foo");
            request.executeUnparsed();
            AbstractGoogleClientRequestTest.fail((String)("expected " + HttpResponseException.class));
        }
        catch (HttpResponseException e) {
            AbstractGoogleClientRequestTest.assertTrue((boolean)e.getMessage().startsWith("401"));
        }
    }

    public void testExecuteUsingHead() throws Exception {
        MockHttpTransport transport = new MockHttpTransport(){

            public LowLevelHttpRequest buildRequest(final String method, final String url) {
                return new MockLowLevelHttpRequest(){

                    public LowLevelHttpResponse execute() {
                        TestCase.assertEquals((String)"HEAD", (String)method);
                        TestCase.assertEquals((String)"https://www.googleapis.com/test/path/v1/tests/foo", (String)url);
                        return new MockLowLevelHttpResponse();
                    }
                };
            }
        };
        MockGoogleClient client = new MockGoogleClient.Builder((HttpTransport)transport, ROOT_URL, SERVICE_PATH, (ObjectParser)JSON_OBJECT_PARSER, null).setApplicationName("Test Application").build();
        MockGoogleClientRequest request = new MockGoogleClientRequest((AbstractGoogleClient)client, "GET", URI_TEMPLATE, null, String.class);
        request.put("testId", (Object)"foo");
        request.executeUsingHead();
    }

    public void testBuildHttpRequest_emptyContent() throws Exception {
        for (String method : Arrays.asList("GET", "HEAD", "DELETE", "FOO")) {
            this.subtestBuildHttpRequest_emptyContent(method, false);
        }
        for (String method : Arrays.asList("POST", "PUT", "PATCH")) {
            this.subtestBuildHttpRequest_emptyContent(method, true);
        }
    }

    private void subtestBuildHttpRequest_emptyContent(String method, boolean expectEmptyContent) throws Exception {
        MockHttpTransport transport = new MockHttpTransport();
        MockGoogleClient client = new MockGoogleClient.Builder((HttpTransport)transport, ROOT_URL, SERVICE_PATH, (ObjectParser)JSON_OBJECT_PARSER, null).setApplicationName("Test Application").build();
        MockGoogleClientRequest request = new MockGoogleClientRequest((AbstractGoogleClient)client, method, URI_TEMPLATE, null, String.class);
        HttpRequest httpRequest = request.buildHttpRequest();
        if (expectEmptyContent) {
            AbstractGoogleClientRequestTest.assertTrue((boolean)(httpRequest.getContent() instanceof EmptyContent));
        } else {
            AbstractGoogleClientRequestTest.assertNull((Object)httpRequest.getContent());
        }
    }

    public void testCheckRequiredParameter() throws Exception {
        MockHttpTransport transport = new MockHttpTransport();
        MockGoogleClient client = new MockGoogleClient.Builder((HttpTransport)transport, ROOT_URL, SERVICE_PATH, (ObjectParser)JSON_OBJECT_PARSER, null).setApplicationName("Test Application").build();
        MockGoogleClientRequest request = new MockGoogleClientRequest((AbstractGoogleClient)client, "GET", URI_TEMPLATE, null, String.class);
        request.checkRequiredParameter((Object)"Not Null", "notNull()");
        try {
            request.checkRequiredParameter(null, "content.getTest().getAnotherTest()");
            AbstractGoogleClientRequestTest.fail((String)("Expected " + IllegalArgumentException.class));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testExecute_void() throws Exception {
        MockHttpTransport transport = new MockHttpTransport(){

            public LowLevelHttpRequest buildRequest(String method, String url) {
                return new MockLowLevelHttpRequest(){

                    public LowLevelHttpResponse execute() {
                        return new MockLowLevelHttpResponse().setContent("{\"a\":\"ignored\"}").setContentType("application/json; charset=UTF-8");
                    }
                };
            }
        };
        MockGoogleClient client = new MockGoogleClient.Builder((HttpTransport)transport, ROOT_URL, SERVICE_PATH, (ObjectParser)JSON_OBJECT_PARSER, null).setApplicationName("Test Application").build();
        MockGoogleClientRequest request = new MockGoogleClientRequest((AbstractGoogleClient)client, "GET", URI_TEMPLATE, null, Void.class);
        Void v = (Void)request.execute();
        AbstractGoogleClientRequestTest.assertNull((Object)v);
    }

    public void testUserAgentSuffix() throws Exception {
        AssertUserAgentTransport transport = new AssertUserAgentTransport();
        String applicationName = "Test Application";
        transport.expectedUserAgent = applicationName + " Google-API-Java-Client/" + GoogleUtils.VERSION + " " + HttpRequest.USER_AGENT_SUFFIX;
        MockGoogleClient client = new MockGoogleClient.Builder((HttpTransport)transport, ROOT_URL, SERVICE_PATH, (ObjectParser)JSON_OBJECT_PARSER, null).setApplicationName(applicationName).build();
        MockGoogleClientRequest request = new MockGoogleClientRequest((AbstractGoogleClient)client, "GET", URI_TEMPLATE, null, Void.class);
        request.executeUnparsed();
    }

    public void testUserAgent() throws IOException {
        AssertUserAgentTransport transport = new AssertUserAgentTransport();
        transport.expectedUserAgent = "Google-API-Java-Client/" + GoogleUtils.VERSION + " " + HttpRequest.USER_AGENT_SUFFIX;
        MockGoogleClient client = new MockGoogleClient.Builder((HttpTransport)transport, ROOT_URL, SERVICE_PATH, (ObjectParser)JSON_OBJECT_PARSER, null).build();
        MockGoogleClientRequest request = new MockGoogleClientRequest((AbstractGoogleClient)client, "GET", URI_TEMPLATE, null, Void.class);
        request.executeUnparsed();
    }

    public void testSetsApiClientHeader() throws IOException {
        AssertHeaderTransport transport = new AssertHeaderTransport("X-Goog-Api-Client", "gl-java/\\d+\\.\\d+\\.\\d+.*");
        MockGoogleClient client = new MockGoogleClient.Builder((HttpTransport)transport, ROOT_URL, SERVICE_PATH, (ObjectParser)JSON_OBJECT_PARSER, null).build();
        MockGoogleClientRequest request = new MockGoogleClientRequest((AbstractGoogleClient)client, "GET", URI_TEMPLATE, null, Void.class);
        request.executeUnparsed();
    }

    public void testSetsApiClientHeaderWithOsVersion() {
        System.setProperty("os.name", "My OS");
        System.setProperty("os.version", "1.2.3");
        String version = new AbstractGoogleClientRequest.ApiClientVersion().toString();
        AbstractGoogleClientRequestTest.assertTrue((String)"Api version should contain the os version", (boolean)version.matches(".* my-os/1.2.3"));
    }

    public void testSetsApiClientHeader_NativeImage() throws IOException {
        System.setProperty("org.graalvm.nativeimage.imagecode", "runtime");
        System.setProperty("java.version", "11.0.0");
        String version = new AbstractGoogleClientRequest.ApiClientVersion().toString();
        AbstractGoogleClientRequestTest.assertTrue((String)"Api version should contain -graalvm suffix", (boolean)version.matches("gl-java/11.0.0-graalvm.*"));
    }

    public void testSetsApiClientHeaderWithoutOsVersion() {
        System.setProperty("os.name", "My OS");
        System.clearProperty("os.version");
        AbstractGoogleClientRequestTest.assertNull((Object)System.getProperty("os.version"));
        String version = new AbstractGoogleClientRequest.ApiClientVersion().toString();
        AbstractGoogleClientRequestTest.assertFalse((String)"Api version should not contain the os version", (boolean)version.matches(".*my-os.*"));
    }

    public void testSetsApiClientHeaderDiscoveryVersion() throws IOException {
        AssertHeaderTransport transport = new AssertHeaderTransport("X-Goog-Api-Client", ".*gdcl/\\d+\\.\\d+\\.\\d+.*");
        MockGoogleClient client = new MockGoogleClient.Builder((HttpTransport)transport, ROOT_URL, SERVICE_PATH, (ObjectParser)JSON_OBJECT_PARSER, null).build();
        MockGoogleClientRequest request = new MockGoogleClientRequest((AbstractGoogleClient)client, "GET", URI_TEMPLATE, null, Void.class);
        request.executeUnparsed();
    }

    public void testReturnRawInputStream_defaultFalse() throws Exception {
        MockHttpTransport transport = new MockHttpTransport(){

            public LowLevelHttpRequest buildRequest(String method, String url) {
                return new MockLowLevelHttpRequest(){

                    public LowLevelHttpResponse execute() {
                        return new MockLowLevelHttpResponse().setContentEncoding("gzip").setContent((InputStream)new ByteArrayInputStream(BaseEncoding.base64().decode((CharSequence)"H4sIAAAAAAAAAPNIzcnJV3DPz0/PSVVwzskvTVEILskvSkxPVQQA/LySchsAAAA=")));
                    }
                };
            }
        };
        MockGoogleClient client = new MockGoogleClient.Builder((HttpTransport)transport, ROOT_URL, SERVICE_PATH, (ObjectParser)JSON_OBJECT_PARSER, null).setApplicationName("Test Application").build();
        MockGoogleClientRequest request = new MockGoogleClientRequest((AbstractGoogleClient)client, "GET", URI_TEMPLATE, null, String.class);
        InputStream inputStream = request.executeAsInputStream();
        AbstractGoogleClientRequestTest.assertFalse((boolean)(inputStream instanceof ByteArrayInputStream));
    }

    public void testReturnRawInputStream_True() throws Exception {
        MockHttpTransport transport = new MockHttpTransport(){

            public LowLevelHttpRequest buildRequest(String method, String url) {
                return new MockLowLevelHttpRequest(){

                    public LowLevelHttpResponse execute() {
                        return new MockLowLevelHttpResponse().setContentEncoding("gzip").setContent((InputStream)new ByteArrayInputStream(BaseEncoding.base64().decode((CharSequence)"H4sIAAAAAAAAAPNIzcnJV3DPz0/PSVVwzskvTVEILskvSkxPVQQA/LySchsAAAA=")));
                    }
                };
            }
        };
        MockGoogleClient client = new MockGoogleClient.Builder((HttpTransport)transport, ROOT_URL, SERVICE_PATH, (ObjectParser)JSON_OBJECT_PARSER, null).setApplicationName("Test Application").build();
        MockGoogleClientRequest request = new MockGoogleClientRequest((AbstractGoogleClient)client, "GET", URI_TEMPLATE, null, String.class);
        request.setReturnRawInputStream(true);
        InputStream inputStream = request.executeAsInputStream();
        AbstractGoogleClientRequestTest.assertTrue((boolean)(inputStream instanceof ByteArrayInputStream));
    }

    private class AssertUserAgentTransport
    extends MockHttpTransport {
        String expectedUserAgent;

        private AssertUserAgentTransport() {
        }

        public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
            return new MockLowLevelHttpRequest(){

                public LowLevelHttpResponse execute() throws IOException {
                    TestCase.assertEquals((String)AssertUserAgentTransport.this.expectedUserAgent, (String)this.getFirstHeaderValue("User-Agent"));
                    return new MockLowLevelHttpResponse();
                }
            };
        }
    }

    private class AssertHeaderTransport
    extends MockHttpTransport {
        String expectedHeader;
        String expectedHeaderValue;

        AssertHeaderTransport(String header, String value) {
            this.expectedHeader = header;
            this.expectedHeaderValue = value;
        }

        public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
            return new MockLowLevelHttpRequest(){

                public LowLevelHttpResponse execute() throws IOException {
                    String firstHeader = this.getFirstHeaderValue(AssertHeaderTransport.this.expectedHeader);
                    TestCase.assertTrue((String)String.format("Expected header value to match %s, instead got %s.", AssertHeaderTransport.this.expectedHeaderValue, firstHeader), (boolean)firstHeader.matches(AssertHeaderTransport.this.expectedHeaderValue));
                    return new MockLowLevelHttpResponse();
                }
            };
        }
    }
}

