/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.mtls;

import com.google.api.client.googleapis.mtls.MtlsUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class MtlsUtilsTest {
    @Test
    public void testUseMtlsClientCertificateEmpty() {
        MtlsUtils.DefaultMtlsProvider mtlsProvider = new MtlsUtils.DefaultMtlsProvider((MtlsUtils.DefaultMtlsProvider.EnvironmentProvider)new TestEnvironmentProvider(""), "/path/to/missing/file");
        Assert.assertFalse((boolean)mtlsProvider.useMtlsClientCertificate());
    }

    @Test
    public void testUseMtlsClientCertificateNull() {
        MtlsUtils.DefaultMtlsProvider mtlsProvider = new MtlsUtils.DefaultMtlsProvider((MtlsUtils.DefaultMtlsProvider.EnvironmentProvider)new TestEnvironmentProvider(null), "/path/to/missing/file");
        Assert.assertFalse((boolean)mtlsProvider.useMtlsClientCertificate());
    }

    @Test
    public void testUseMtlsClientCertificateTrue() {
        MtlsUtils.DefaultMtlsProvider mtlsProvider = new MtlsUtils.DefaultMtlsProvider((MtlsUtils.DefaultMtlsProvider.EnvironmentProvider)new TestEnvironmentProvider("true"), "/path/to/missing/file");
        Assert.assertTrue((boolean)mtlsProvider.useMtlsClientCertificate());
    }

    @Test
    public void testLoadDefaultKeyStoreMissingFile() throws InterruptedException, GeneralSecurityException, IOException {
        MtlsUtils.DefaultMtlsProvider mtlsProvider = new MtlsUtils.DefaultMtlsProvider((MtlsUtils.DefaultMtlsProvider.EnvironmentProvider)new TestEnvironmentProvider("true"), "/path/to/missing/file");
        KeyStore keyStore = mtlsProvider.getKeyStore();
        Assert.assertNull((Object)keyStore);
    }

    @Test
    public void testLoadDefaultKeyStore() throws InterruptedException, GeneralSecurityException, IOException {
        MtlsUtils.DefaultMtlsProvider mtlsProvider = new MtlsUtils.DefaultMtlsProvider((MtlsUtils.DefaultMtlsProvider.EnvironmentProvider)new TestEnvironmentProvider("true"), "src/test/resources/com/google/api/client/googleapis/util/mtls_context_aware_metadata.json");
        KeyStore keyStore = mtlsProvider.getKeyStore();
        Assert.assertNotNull((Object)keyStore);
    }

    @Test
    public void testLoadDefaultKeyStoreBadCertificate() throws InterruptedException, GeneralSecurityException, IOException {
        MtlsUtils.DefaultMtlsProvider mtlsProvider = new MtlsUtils.DefaultMtlsProvider((MtlsUtils.DefaultMtlsProvider.EnvironmentProvider)new TestEnvironmentProvider("true"), "src/test/resources/com/google/api/client/googleapis/util/mtls_context_aware_metadata_bad_command.json");
        try {
            mtlsProvider.getKeyStore();
            Assert.fail((String)"should throw and exception");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((String)"expected to fail with certificate is missing", (boolean)e.getMessage().contains("certificate is missing"));
        }
    }

    @Test
    public void testExtractCertificateProviderCommand() throws IOException {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("com/google/api/client/googleapis/util/mtls_context_aware_metadata.json");
        List command = MtlsUtils.DefaultMtlsProvider.extractCertificateProviderCommand((InputStream)inputStream);
        Assert.assertEquals((long)2L, (long)command.size());
        Assert.assertEquals((Object)"cat", command.get(0));
        Assert.assertEquals((Object)"src/test/resources/com/google/api/client/googleapis/util/mtlsCertAndKey.pem", command.get(1));
    }

    @Test
    public void testRunCertificateProviderCommandSuccess() throws IOException, InterruptedException {
        TestCertProviderCommandProcess certCommandProcess = new TestCertProviderCommandProcess(0, false);
        int exitValue = MtlsUtils.DefaultMtlsProvider.runCertificateProviderCommand((Process)certCommandProcess, (long)100L);
        Assert.assertEquals((long)0L, (long)exitValue);
    }

    @Test
    public void testRunCertificateProviderCommandTimeout() throws InterruptedException {
        TestCertProviderCommandProcess certCommandProcess = new TestCertProviderCommandProcess(0, true);
        try {
            MtlsUtils.DefaultMtlsProvider.runCertificateProviderCommand((Process)certCommandProcess, (long)100L);
            Assert.fail((String)"should throw and exception");
        }
        catch (IOException e) {
            Assert.assertTrue((String)"expected to fail with timeout", (boolean)e.getMessage().contains("cert provider command timed out"));
        }
    }

    static class TestCertProviderCommandProcess
    extends Process {
        private boolean runForever;
        private int exitValue;

        public TestCertProviderCommandProcess(int exitValue, boolean runForever) {
            this.runForever = runForever;
            this.exitValue = exitValue;
        }

        @Override
        public OutputStream getOutputStream() {
            return null;
        }

        @Override
        public InputStream getInputStream() {
            return null;
        }

        @Override
        public InputStream getErrorStream() {
            return null;
        }

        @Override
        public int waitFor() throws InterruptedException {
            return 0;
        }

        @Override
        public int exitValue() {
            if (this.runForever) {
                throw new IllegalThreadStateException();
            }
            return this.exitValue;
        }

        @Override
        public void destroy() {
        }
    }

    static class TestEnvironmentProvider
    implements MtlsUtils.DefaultMtlsProvider.EnvironmentProvider {
        private final String value;

        TestEnvironmentProvider(String value) {
            this.value = value;
        }

        public String getenv(String name) {
            return this.value;
        }
    }
}

