/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.media;

import com.google.api.client.googleapis.media.MediaHttpUploader;
import com.google.api.client.googleapis.media.MediaHttpUploaderProgressListener;
import com.google.api.client.http.AbstractHttpContent;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.EmptyContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpBackOffIOExceptionHandler;
import com.google.api.client.http.HttpBackOffUnsuccessfulResponseHandler;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpIOExceptionHandler;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.HttpUnsuccessfulResponseHandler;
import com.google.api.client.http.InputStreamContent;
import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.testing.http.MockHttpTransport;
import com.google.api.client.testing.http.MockLowLevelHttpRequest;
import com.google.api.client.testing.http.MockLowLevelHttpResponse;
import com.google.api.client.testing.util.TestableByteArrayInputStream;
import com.google.api.client.util.BackOff;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Arrays;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.TestCase;

public class MediaHttpUploaderTest
extends TestCase {
    private static final String TEST_RESUMABLE_REQUEST_URL = "http://www.test.com/request/url?uploadType=resumable";
    private static final String TEST_DIRECT_REQUEST_URL = "http://www.test.com/request/url?uploadType=media";
    private static final String TEST_MULTIPART_REQUEST_URL = "http://www.test.com/request/url?uploadType=multipart";
    private static final String TEST_UPLOAD_URL = "http://www.test.com/media/upload/location";
    private static final String TEST_CONTENT_TYPE = "image/jpeg";
    private static Logger LOGGER = Logger.getLogger(HttpTransport.class.getName());
    private Level oldLevel;

    public void setUp() {
        this.oldLevel = LOGGER.getLevel();
        LOGGER.setLevel(Level.SEVERE);
    }

    public void tearDown() {
        LOGGER.setLevel(this.oldLevel);
    }

    public void testUploadOneCall() throws Exception {
        int contentLength = 0xA00000;
        MediaTransport fakeTransport = new MediaTransport(contentLength);
        ByteArrayInputStream is = new ByteArrayInputStream(new byte[contentLength]);
        InputStreamContent mediaContent = new InputStreamContent(TEST_CONTENT_TYPE, (InputStream)is);
        mediaContent.setLength((long)contentLength);
        MediaHttpUploader uploader = new MediaHttpUploader((AbstractInputStreamContent)mediaContent, (HttpTransport)fakeTransport, null);
        uploader.upload(new GenericUrl(TEST_RESUMABLE_REQUEST_URL));
        MediaHttpUploaderTest.assertEquals((int)2, (int)fakeTransport.lowLevelExecCalls);
    }

    public void testUploadOneCall_WithPatch() throws Exception {
        int contentLength = 0xA00000;
        MediaTransport fakeTransport = new MediaTransport(contentLength);
        fakeTransport.testMethodOverride = true;
        ByteArrayInputStream is = new ByteArrayInputStream(new byte[contentLength]);
        InputStreamContent mediaContent = new InputStreamContent(TEST_CONTENT_TYPE, (InputStream)is);
        mediaContent.setLength((long)contentLength);
        MediaHttpUploader uploader = new MediaHttpUploader((AbstractInputStreamContent)mediaContent, (HttpTransport)fakeTransport, null);
        uploader.setInitiationRequestMethod("PATCH");
        uploader.upload(new GenericUrl(TEST_RESUMABLE_REQUEST_URL));
        MediaHttpUploaderTest.assertEquals((int)2, (int)fakeTransport.lowLevelExecCalls);
    }

    public void testUploadOneCall_WithGZipDisabled() throws Exception {
        int contentLength = 0xA00000;
        MediaTransport fakeTransport = new MediaTransport(contentLength);
        ByteArrayInputStream is = new ByteArrayInputStream(new byte[contentLength]);
        InputStreamContent mediaContent = new InputStreamContent(TEST_CONTENT_TYPE, (InputStream)is);
        fakeTransport.contentLengthNotSpecified = true;
        MediaHttpUploader uploader = new MediaHttpUploader((AbstractInputStreamContent)mediaContent, (HttpTransport)fakeTransport, (HttpRequestInitializer)new GZipCheckerInitializer(true));
        uploader.setDisableGZipContent(true);
        uploader.upload(new GenericUrl(TEST_RESUMABLE_REQUEST_URL));
        MediaHttpUploaderTest.assertEquals((int)2, (int)fakeTransport.lowLevelExecCalls);
    }

    public void testUploadOneCall_WithGZipEnabled() throws Exception {
        int contentLength = 0xA00000;
        MediaTransport fakeTransport = new MediaTransport(contentLength);
        ByteArrayInputStream is = new ByteArrayInputStream(new byte[contentLength]);
        InputStreamContent mediaContent = new InputStreamContent(TEST_CONTENT_TYPE, (InputStream)is);
        fakeTransport.contentLengthNotSpecified = true;
        MediaHttpUploader uploader = new MediaHttpUploader((AbstractInputStreamContent)mediaContent, (HttpTransport)fakeTransport, (HttpRequestInitializer)new GZipCheckerInitializer(false));
        uploader.setDisableGZipContent(false);
        uploader.upload(new GenericUrl(TEST_RESUMABLE_REQUEST_URL));
        MediaHttpUploaderTest.assertEquals((int)2, (int)fakeTransport.lowLevelExecCalls);
    }

    public void testUploadOneCall_WithDefaultGzip() throws Exception {
        int contentLength = 0xA00000;
        MediaTransport fakeTransport = new MediaTransport(contentLength);
        ByteArrayInputStream is = new ByteArrayInputStream(new byte[contentLength]);
        InputStreamContent mediaContent = new InputStreamContent(TEST_CONTENT_TYPE, (InputStream)is);
        fakeTransport.contentLengthNotSpecified = true;
        MediaHttpUploader uploader = new MediaHttpUploader((AbstractInputStreamContent)mediaContent, (HttpTransport)fakeTransport, (HttpRequestInitializer)new GZipCheckerInitializer(false));
        uploader.upload(new GenericUrl(TEST_RESUMABLE_REQUEST_URL));
        MediaHttpUploaderTest.assertEquals((int)2, (int)fakeTransport.lowLevelExecCalls);
    }

    public void testUploadOneCall_WithNoContentSizeProvided() throws Exception {
        int contentLength = 0xA00000;
        MediaTransport fakeTransport = new MediaTransport(contentLength);
        fakeTransport.contentLengthNotSpecified = true;
        ByteArrayInputStream is = new ByteArrayInputStream(new byte[contentLength]);
        InputStreamContent mediaContent = new InputStreamContent(TEST_CONTENT_TYPE, (InputStream)is);
        MediaHttpUploader uploader = new MediaHttpUploader((AbstractInputStreamContent)mediaContent, (HttpTransport)fakeTransport, null);
        uploader.upload(new GenericUrl(TEST_RESUMABLE_REQUEST_URL));
        MediaHttpUploaderTest.assertEquals((int)2, (int)fakeTransport.lowLevelExecCalls);
    }

    public void testUploadOneCall_WithContentSizeProvided() throws Exception {
        int contentLength = 0xA00000;
        MediaTransport fakeTransport = new MediaTransport(contentLength);
        ByteArrayInputStream is = new ByteArrayInputStream(new byte[contentLength]);
        InputStreamContent mediaContent = new InputStreamContent(TEST_CONTENT_TYPE, (InputStream)is);
        mediaContent.setLength((long)contentLength);
        MediaHttpUploader uploader = new MediaHttpUploader((AbstractInputStreamContent)mediaContent, (HttpTransport)fakeTransport, (HttpRequestInitializer)new GZipCheckerInitializer(true));
        uploader.upload(new GenericUrl(TEST_RESUMABLE_REQUEST_URL));
        MediaHttpUploaderTest.assertEquals((int)2, (int)fakeTransport.lowLevelExecCalls);
    }

    public void testUploadMultipleCalls() throws Exception {
        int contentLength = 0x3200000;
        MediaTransport fakeTransport = new MediaTransport(contentLength);
        ByteArrayInputStream is = new ByteArrayInputStream(new byte[contentLength]);
        InputStreamContent mediaContent = new InputStreamContent(TEST_CONTENT_TYPE, (InputStream)is);
        mediaContent.setLength((long)contentLength);
        MediaHttpUploader uploader = new MediaHttpUploader((AbstractInputStreamContent)mediaContent, (HttpTransport)fakeTransport, null);
        uploader.upload(new GenericUrl(TEST_RESUMABLE_REQUEST_URL));
        MediaHttpUploaderTest.assertEquals((int)6, (int)fakeTransport.lowLevelExecCalls);
    }

    public void testUploadMultipleCalls_WithPatch() throws Exception {
        int contentLength = 0x3200000;
        MediaTransport fakeTransport = new MediaTransport(contentLength);
        fakeTransport.testMethodOverride = true;
        ByteArrayInputStream is = new ByteArrayInputStream(new byte[contentLength]);
        InputStreamContent mediaContent = new InputStreamContent(TEST_CONTENT_TYPE, (InputStream)is);
        mediaContent.setLength((long)contentLength);
        MediaHttpUploader uploader = new MediaHttpUploader((AbstractInputStreamContent)mediaContent, (HttpTransport)fakeTransport, null);
        uploader.setInitiationRequestMethod("PATCH");
        uploader.upload(new GenericUrl(TEST_RESUMABLE_REQUEST_URL));
        MediaHttpUploaderTest.assertEquals((int)6, (int)fakeTransport.lowLevelExecCalls);
    }

    public void testUploadMultipleCalls_WithSpecifiedHeader() throws Exception {
        int contentLength = 0x3200000;
        MediaTransport fakeTransport = new MediaTransport(contentLength);
        fakeTransport.assertTestHeaders = true;
        ByteArrayInputStream is = new ByteArrayInputStream(new byte[contentLength]);
        InputStreamContent mediaContent = new InputStreamContent(TEST_CONTENT_TYPE, (InputStream)is);
        mediaContent.setLength((long)contentLength);
        MediaHttpUploader uploader = new MediaHttpUploader((AbstractInputStreamContent)mediaContent, (HttpTransport)fakeTransport, null);
        uploader.getInitiationHeaders().set("test-header-name", (Object)"test-header-value");
        uploader.upload(new GenericUrl(TEST_RESUMABLE_REQUEST_URL));
        MediaHttpUploaderTest.assertEquals((int)6, (int)fakeTransport.lowLevelExecCalls);
    }

    public void testUploadMultipleCalls_WithNoContentSizeProvided() throws Exception {
        int contentLength = 0x3200000;
        MediaTransport fakeTransport = new MediaTransport(contentLength);
        fakeTransport.contentLengthNotSpecified = true;
        ByteArrayInputStream is = new ByteArrayInputStream(new byte[contentLength]);
        InputStreamContent mediaContent = new InputStreamContent(TEST_CONTENT_TYPE, (InputStream)is);
        MediaHttpUploader uploader = new MediaHttpUploader((AbstractInputStreamContent)mediaContent, (HttpTransport)fakeTransport, null);
        uploader.upload(new GenericUrl(TEST_RESUMABLE_REQUEST_URL));
        MediaHttpUploaderTest.assertEquals((int)6, (int)fakeTransport.lowLevelExecCalls);
    }

    public void testUploadMultipleCalls_WithNoContentSizeProvidedChunkedInput() throws Exception {
        int contentLength = 0x3200000;
        MediaTransport fakeTransport = new MediaTransport(contentLength);
        fakeTransport.contentLengthNotSpecified = true;
        ByteArrayInputStream is = new ByteArrayInputStream(new byte[contentLength]){

            @Override
            public synchronized int read(byte[] b, int off, int len) {
                return super.read(b, off, Math.min(len, 0x100000));
            }
        };
        InputStreamContent mediaContent = new InputStreamContent(TEST_CONTENT_TYPE, (InputStream)is);
        MediaHttpUploader uploader = new MediaHttpUploader((AbstractInputStreamContent)mediaContent, (HttpTransport)fakeTransport, null);
        uploader.upload(new GenericUrl(TEST_RESUMABLE_REQUEST_URL));
        MediaHttpUploaderTest.assertEquals((int)6, (int)fakeTransport.lowLevelExecCalls);
    }

    public void testUploadMultipleCalls_WithNoContentSizeProvided_WithExtraByte() throws Exception {
        int contentLength = 52428801;
        MediaTransport fakeTransport = new MediaTransport(contentLength);
        fakeTransport.contentLengthNotSpecified = true;
        ByteArrayInputStream is = new ByteArrayInputStream(new byte[contentLength]);
        InputStreamContent mediaContent = new InputStreamContent(TEST_CONTENT_TYPE, (InputStream)is);
        MediaHttpUploader uploader = new MediaHttpUploader((AbstractInputStreamContent)mediaContent, (HttpTransport)fakeTransport, null);
        uploader.upload(new GenericUrl(TEST_RESUMABLE_REQUEST_URL));
        MediaHttpUploaderTest.assertEquals((int)7, (int)fakeTransport.lowLevelExecCalls);
    }

    public void testUploadProgressListener() throws Exception {
        int contentLength = 0x1400000;
        MediaTransport fakeTransport = new MediaTransport(contentLength);
        ByteArrayInputStream is = new ByteArrayInputStream(new byte[contentLength]);
        InputStreamContent mediaContent = new InputStreamContent(TEST_CONTENT_TYPE, (InputStream)is);
        mediaContent.setLength((long)contentLength);
        MediaHttpUploader uploader = new MediaHttpUploader((AbstractInputStreamContent)mediaContent, (HttpTransport)fakeTransport, null);
        uploader.setProgressListener((MediaHttpUploaderProgressListener)new ResumableProgressListenerWithTwoUploadCalls());
        uploader.upload(new GenericUrl(TEST_RESUMABLE_REQUEST_URL));
    }

    public void testUploadProgressListener_WithNoContentSizeProvided() throws Exception {
        int contentLength = 0x1400000;
        MediaTransport fakeTransport = new MediaTransport(contentLength);
        fakeTransport.contentLengthNotSpecified = true;
        ByteArrayInputStream is = new ByteArrayInputStream(new byte[contentLength]);
        InputStreamContent mediaContent = new InputStreamContent(TEST_CONTENT_TYPE, (InputStream)is);
        MediaHttpUploader uploader = new MediaHttpUploader((AbstractInputStreamContent)mediaContent, (HttpTransport)fakeTransport, null);
        ResumableProgressListenerWithTwoUploadCalls listener = new ResumableProgressListenerWithTwoUploadCalls();
        listener.contentLengthNotSpecified = true;
        uploader.setProgressListener((MediaHttpUploaderProgressListener)listener);
        uploader.upload(new GenericUrl(TEST_RESUMABLE_REQUEST_URL));
    }

    public void testUploadServerError_WithoutUnsuccessfulHandler() throws Exception {
        int contentLength = 0x1400000;
        MediaTransport fakeTransport = new MediaTransport(contentLength);
        fakeTransport.testServerError = true;
        ByteArrayInputStream is = new ByteArrayInputStream(new byte[contentLength]);
        InputStreamContent mediaContent = new InputStreamContent(TEST_CONTENT_TYPE, (InputStream)is);
        mediaContent.setLength((long)contentLength);
        MediaHttpUploader uploader = new MediaHttpUploader((AbstractInputStreamContent)mediaContent, (HttpTransport)fakeTransport, null);
        HttpResponse response = uploader.upload(new GenericUrl(TEST_RESUMABLE_REQUEST_URL));
        MediaHttpUploaderTest.assertEquals((int)500, (int)response.getStatusCode());
        MediaHttpUploaderTest.assertEquals((int)3, (int)fakeTransport.lowLevelExecCalls);
    }

    public void testUpload_ResumableIOException_WithIOExceptionHandler() throws Exception {
        this.subtestUpload_ResumableWithError(ErrorType.IO_EXCEPTION);
    }

    public void testUpload_ResumableServerError_WithoutUnsuccessfulHandler() throws Exception {
        this.subtestUpload_ResumableWithError(ErrorType.SERVER_UNAVAILABLE);
    }

    private void subtestUpload_ResumableWithError(ErrorType error) throws Exception {
        this.subtestUpload_ResumableWithError(error, 0x1400000, false, 0x9FFFFF, 3, false);
        this.subtestUpload_ResumableWithError(error, 0x1400000, true, 0x9FFFFF, 3, false);
        this.subtestUpload_ResumableWithError(error, 0x1E00000, false, 0x9FFFFF, 4, false);
        this.subtestUpload_ResumableWithError(error, 0x1E00000, true, 0x9FFFFF, 4, false);
        this.subtestUpload_ResumableWithError(error, 0x1400000, false, 0x13FFFFF, 2, false);
        this.subtestUpload_ResumableWithError(error, 0x1400000, true, 0x13FFFFF, 2, false);
        this.subtestUpload_ResumableWithError(error, 0x1400000, false, 0x13FFFFF, 3, true);
        this.subtestUpload_ResumableWithError(error, 0x1400000, true, 0x13FFFFF, 3, true);
        this.subtestUpload_ResumableWithError(error, 0x1E00000, false, 0x13FFFFF, 3, false);
        this.subtestUpload_ResumableWithError(error, 0x1E00000, true, 0x13FFFFF, 3, false);
        this.subtestUpload_ResumableWithError(error, 0x1400000, false, 0xD55555, 3, false);
        this.subtestUpload_ResumableWithError(error, 0x1400000, true, 0xD55555, 3, false);
        this.subtestUpload_ResumableWithError(error, 20971523, false, 0xA00004, 3, false);
        this.subtestUpload_ResumableWithError(error, 20971523, true, 0xA00004, 3, false);
        this.subtestUpload_ResumableWithError(error, 0x1400000, false, 0xA00000, 3, false);
        this.subtestUpload_ResumableWithError(error, 0x1400000, true, 0xA00000, 3, false);
        this.subtestUpload_ResumableWithError(error, 31457282, false, 0xA00000, 5, false);
        this.subtestUpload_ResumableWithError(error, 31457282, true, 0xA00000, 5, false);
    }

    public void subtestUpload_ResumableWithError(ErrorType error, int contentLength, boolean contentLengthKnown, int maxByteIndexUploadedOnError, int chunks, boolean force308OnRangeQueryResponse) throws Exception {
        MediaTransport fakeTransport = new MediaTransport(contentLength, true);
        if (error == ErrorType.IO_EXCEPTION) {
            fakeTransport.testIOException = true;
        } else if (error == ErrorType.SERVER_UNAVAILABLE) {
            fakeTransport.testServerError = true;
        }
        fakeTransport.contentLengthNotSpecified = !contentLengthKnown;
        fakeTransport.maxByteIndexUploadedOnError = maxByteIndexUploadedOnError;
        fakeTransport.force308OnRangeQueryResponse = force308OnRangeQueryResponse;
        byte[] testedData = new byte[contentLength];
        new Random().nextBytes(testedData);
        TestingInputStream is = new TestingInputStream(testedData);
        InputStreamContent mediaContent = new InputStreamContent(TEST_CONTENT_TYPE, (InputStream)is);
        if (contentLengthKnown) {
            mediaContent.setLength((long)contentLength);
        }
        MediaHttpUploader uploader = new MediaHttpUploader((AbstractInputStreamContent)mediaContent, (HttpTransport)fakeTransport, (HttpRequestInitializer)new ZeroBackOffRequestInitializer());
        uploader.setDisableGZipContent(true);
        HttpResponse response = uploader.upload(new GenericUrl(TEST_RESUMABLE_REQUEST_URL));
        MediaHttpUploaderTest.assertEquals((int)200, (int)response.getStatusCode());
        int calls = 2 + chunks;
        MediaHttpUploaderTest.assertEquals((int)calls, (int)fakeTransport.lowLevelExecCalls);
        MediaHttpUploaderTest.assertTrue((boolean)Arrays.equals(testedData, fakeTransport.bytesReceived));
        MediaHttpUploaderTest.assertTrue((boolean)is.isClosed);
    }

    public void testUploadIOException_WithoutIOExceptionHandler() throws Exception {
        int contentLength = 0x1400000;
        MediaTransport fakeTransport = new MediaTransport(contentLength);
        fakeTransport.testIOException = true;
        ByteArrayInputStream is = new ByteArrayInputStream(new byte[contentLength]);
        InputStreamContent mediaContent = new InputStreamContent(TEST_CONTENT_TYPE, (InputStream)is);
        mediaContent.setLength((long)contentLength);
        MediaHttpUploader uploader = new MediaHttpUploader((AbstractInputStreamContent)mediaContent, (HttpTransport)fakeTransport, null);
        try {
            uploader.upload(new GenericUrl(TEST_RESUMABLE_REQUEST_URL));
            MediaHttpUploaderTest.fail((String)("expected " + IOException.class));
        }
        catch (IOException e) {
            MediaHttpUploaderTest.assertEquals((int)3, (int)fakeTransport.lowLevelExecCalls);
        }
    }

    public void testUploadServerErrorWithBackOffDisabled_WithNoContentSizeProvided() throws Exception {
        int contentLength = 0x1400000;
        MediaTransport fakeTransport = new MediaTransport(contentLength);
        fakeTransport.testServerError = true;
        fakeTransport.contentLengthNotSpecified = true;
        ByteArrayInputStream is = new ByteArrayInputStream(new byte[contentLength]);
        InputStreamContent mediaContent = new InputStreamContent(TEST_CONTENT_TYPE, (InputStream)is);
        MediaHttpUploader uploader = new MediaHttpUploader((AbstractInputStreamContent)mediaContent, (HttpTransport)fakeTransport, null);
        HttpResponse response = uploader.upload(new GenericUrl(TEST_RESUMABLE_REQUEST_URL));
        MediaHttpUploaderTest.assertEquals((int)500, (int)response.getStatusCode());
        MediaHttpUploaderTest.assertEquals((int)3, (int)fakeTransport.lowLevelExecCalls);
    }

    public void testUploadAuthenticationError() throws Exception {
        int contentLength = 0x1400000;
        MediaTransport fakeTransport = new MediaTransport(contentLength);
        fakeTransport.testAuthenticationError = true;
        ByteArrayInputStream is = new ByteArrayInputStream(new byte[contentLength]);
        InputStreamContent mediaContent = new InputStreamContent(TEST_CONTENT_TYPE, (InputStream)is);
        mediaContent.setLength((long)contentLength);
        MediaHttpUploader uploader = new MediaHttpUploader((AbstractInputStreamContent)mediaContent, (HttpTransport)fakeTransport, null);
        HttpResponse response = uploader.upload(new GenericUrl(TEST_RESUMABLE_REQUEST_URL));
        MediaHttpUploaderTest.assertEquals((int)404, (int)response.getStatusCode());
        MediaHttpUploaderTest.assertEquals((int)1, (int)fakeTransport.lowLevelExecCalls);
    }

    public void testUploadClientErrorInUploadCalls() throws Exception {
        int contentLength = 0x1400000;
        MediaTransport fakeTransport = new MediaTransport(contentLength);
        fakeTransport.testClientError = true;
        ByteArrayInputStream is = new ByteArrayInputStream(new byte[contentLength]);
        InputStreamContent mediaContent = new InputStreamContent(TEST_CONTENT_TYPE, (InputStream)is);
        mediaContent.setLength((long)contentLength);
        MediaHttpUploader uploader = new MediaHttpUploader((AbstractInputStreamContent)mediaContent, (HttpTransport)fakeTransport, null);
        HttpResponse response = uploader.upload(new GenericUrl(TEST_RESUMABLE_REQUEST_URL));
        MediaHttpUploaderTest.assertEquals((int)411, (int)response.getStatusCode());
        MediaHttpUploaderTest.assertEquals((int)2, (int)fakeTransport.lowLevelExecCalls);
    }

    public void testUploadClientErrorInUploadCalls_WithNoContentSizeProvided() throws Exception {
        int contentLength = 0x1400000;
        MediaTransport fakeTransport = new MediaTransport(contentLength);
        fakeTransport.testClientError = true;
        fakeTransport.contentLengthNotSpecified = true;
        ByteArrayInputStream is = new ByteArrayInputStream(new byte[contentLength]);
        InputStreamContent mediaContent = new InputStreamContent(TEST_CONTENT_TYPE, (InputStream)is);
        MediaHttpUploader uploader = new MediaHttpUploader((AbstractInputStreamContent)mediaContent, (HttpTransport)fakeTransport, null);
        HttpResponse response = uploader.upload(new GenericUrl(TEST_RESUMABLE_REQUEST_URL));
        MediaHttpUploaderTest.assertEquals((int)411, (int)response.getStatusCode());
        MediaHttpUploaderTest.assertEquals((int)2, (int)fakeTransport.lowLevelExecCalls);
    }

    public void testDirectMediaUpload() throws Exception {
        int contentLength = 0x1400000;
        MediaTransport fakeTransport = new MediaTransport(contentLength);
        fakeTransport.directUploadEnabled = true;
        ByteArrayInputStream is = new ByteArrayInputStream(new byte[contentLength]);
        InputStreamContent mediaContent = new InputStreamContent(TEST_CONTENT_TYPE, (InputStream)is);
        mediaContent.setLength((long)contentLength);
        MediaHttpUploader uploader = new MediaHttpUploader((AbstractInputStreamContent)mediaContent, (HttpTransport)fakeTransport, null);
        uploader.setProgressListener((MediaHttpUploaderProgressListener)new DirectProgressListener());
        uploader.setDirectUploadEnabled(true);
        HttpResponse response = uploader.upload(new GenericUrl(TEST_DIRECT_REQUEST_URL));
        MediaHttpUploaderTest.assertEquals((int)200, (int)response.getStatusCode());
        MediaHttpUploaderTest.assertEquals((int)1, (int)fakeTransport.lowLevelExecCalls);
    }

    public void testDirectMediaUpload_WithSpecifiedHeader() throws Exception {
        int contentLength = 0x1400000;
        MediaTransport fakeTransport = new MediaTransport(contentLength);
        fakeTransport.directUploadEnabled = true;
        fakeTransport.assertTestHeaders = true;
        ByteArrayInputStream is = new ByteArrayInputStream(new byte[contentLength]);
        InputStreamContent mediaContent = new InputStreamContent(TEST_CONTENT_TYPE, (InputStream)is);
        mediaContent.setLength((long)contentLength);
        MediaHttpUploader uploader = new MediaHttpUploader((AbstractInputStreamContent)mediaContent, (HttpTransport)fakeTransport, null);
        uploader.getInitiationHeaders().set("test-header-name", (Object)"test-header-value");
        uploader.setProgressListener((MediaHttpUploaderProgressListener)new DirectProgressListener());
        uploader.setDirectUploadEnabled(true);
        HttpResponse response = uploader.upload(new GenericUrl(TEST_DIRECT_REQUEST_URL));
        MediaHttpUploaderTest.assertEquals((int)200, (int)response.getStatusCode());
        MediaHttpUploaderTest.assertEquals((int)1, (int)fakeTransport.lowLevelExecCalls);
    }

    public void testDirectMediaUpload_WithNoContentSizeProvided() throws Exception {
        int contentLength = 0x1400000;
        MediaTransport fakeTransport = new MediaTransport(contentLength);
        fakeTransport.directUploadEnabled = true;
        fakeTransport.contentLengthNotSpecified = true;
        ByteArrayInputStream is = new ByteArrayInputStream(new byte[contentLength]);
        InputStreamContent mediaContent = new InputStreamContent(TEST_CONTENT_TYPE, (InputStream)is);
        MediaHttpUploader uploader = new MediaHttpUploader((AbstractInputStreamContent)mediaContent, (HttpTransport)fakeTransport, null);
        DirectProgressListener listener = new DirectProgressListener();
        listener.contentLengthNotSpecified = true;
        uploader.setProgressListener((MediaHttpUploaderProgressListener)listener);
        uploader.setDirectUploadEnabled(true);
        HttpResponse response = uploader.upload(new GenericUrl(TEST_DIRECT_REQUEST_URL));
        MediaHttpUploaderTest.assertEquals((int)200, (int)response.getStatusCode());
        MediaHttpUploaderTest.assertEquals((int)1, (int)fakeTransport.lowLevelExecCalls);
    }

    public void testDirectMediaUploadWithMetadata() throws Exception {
        int contentLength = 0x1400000;
        MediaTransport fakeTransport = new MediaTransport(contentLength);
        fakeTransport.directUploadEnabled = true;
        fakeTransport.directUploadWithMetadata = true;
        ByteArrayInputStream is = new ByteArrayInputStream(new byte[contentLength]);
        InputStreamContent mediaContent = new InputStreamContent(TEST_CONTENT_TYPE, (InputStream)is);
        mediaContent.setLength((long)contentLength);
        MediaHttpUploader uploader = new MediaHttpUploader((AbstractInputStreamContent)mediaContent, (HttpTransport)fakeTransport, null);
        uploader.setProgressListener((MediaHttpUploaderProgressListener)new DirectProgressListener());
        uploader.setDirectUploadEnabled(true);
        uploader.setMetadata((HttpContent)new MockHttpContent());
        HttpResponse response = uploader.upload(new GenericUrl(TEST_MULTIPART_REQUEST_URL));
        MediaHttpUploaderTest.assertEquals((int)200, (int)response.getStatusCode());
        MediaHttpUploaderTest.assertEquals((int)1, (int)fakeTransport.lowLevelExecCalls);
    }

    public void testDirectMediaUploadWithMetadata_WithNoContentSizeProvided() throws Exception {
        int contentLength = 0x1400000;
        MediaTransport fakeTransport = new MediaTransport(contentLength);
        fakeTransport.directUploadEnabled = true;
        fakeTransport.contentLengthNotSpecified = true;
        fakeTransport.directUploadWithMetadata = true;
        ByteArrayInputStream is = new ByteArrayInputStream(new byte[contentLength]);
        InputStreamContent mediaContent = new InputStreamContent(TEST_CONTENT_TYPE, (InputStream)is);
        MediaHttpUploader uploader = new MediaHttpUploader((AbstractInputStreamContent)mediaContent, (HttpTransport)fakeTransport, null);
        DirectProgressListener listener = new DirectProgressListener();
        listener.contentLengthNotSpecified = true;
        uploader.setProgressListener((MediaHttpUploaderProgressListener)listener);
        uploader.setDirectUploadEnabled(true);
        uploader.setMetadata((HttpContent)new MockHttpContent());
        HttpResponse response = uploader.upload(new GenericUrl(TEST_MULTIPART_REQUEST_URL));
        MediaHttpUploaderTest.assertEquals((int)200, (int)response.getStatusCode());
        MediaHttpUploaderTest.assertEquals((int)1, (int)fakeTransport.lowLevelExecCalls);
    }

    public void testSetChunkSize() throws Exception {
        int contentLength = 0x1400000;
        MediaTransport fakeTransport = new MediaTransport(contentLength);
        fakeTransport.directUploadEnabled = true;
        ByteArrayInputStream is = new ByteArrayInputStream(new byte[contentLength]);
        InputStreamContent mediaContent = new InputStreamContent(TEST_CONTENT_TYPE, (InputStream)is);
        MediaHttpUploader uploader = new MediaHttpUploader((AbstractInputStreamContent)mediaContent, (HttpTransport)fakeTransport, null);
        uploader.setChunkSize(0xA00000);
        uploader.setChunkSize(262144);
        uploader.setChunkSize(524288);
        uploader.setChunkSize(786432);
        uploader.setChunkSize(0x1900000);
        try {
            uploader.setChunkSize(262143);
            MediaHttpUploaderTest.fail((String)("Expected " + IllegalArgumentException.class));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            uploader.setChunkSize(262145);
            MediaHttpUploaderTest.fail((String)("Expected " + IllegalArgumentException.class));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            uploader.setChunkSize(655360);
            MediaHttpUploaderTest.fail((String)("Expected " + IllegalArgumentException.class));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testDirectUploadServerErrorWithBackOffEnabled() throws Exception {
        int contentLength = 0x1400000;
        MediaTransport fakeTransport = new MediaTransport(contentLength);
        fakeTransport.testServerError = true;
        fakeTransport.directUploadEnabled = true;
        ByteArrayContent mediaContent = new ByteArrayContent(TEST_CONTENT_TYPE, new byte[contentLength]);
        MediaHttpUploader uploader = new MediaHttpUploader((AbstractInputStreamContent)mediaContent, (HttpTransport)fakeTransport, (HttpRequestInitializer)new ZeroBackOffRequestInitializer());
        uploader.setDirectUploadEnabled(true);
        uploader.upload(new GenericUrl(TEST_DIRECT_REQUEST_URL));
        MediaHttpUploaderTest.assertEquals((int)2, (int)fakeTransport.lowLevelExecCalls);
    }

    public void testDirectUploadServerErrorWithBackOffDisabled() throws Exception {
        int contentLength = 0x1400000;
        MediaTransport fakeTransport = new MediaTransport(contentLength);
        fakeTransport.testServerError = true;
        fakeTransport.directUploadEnabled = true;
        ByteArrayContent mediaContent = new ByteArrayContent(TEST_CONTENT_TYPE, new byte[contentLength]);
        MediaHttpUploader uploader = new MediaHttpUploader((AbstractInputStreamContent)mediaContent, (HttpTransport)fakeTransport, null);
        uploader.setDirectUploadEnabled(true);
        uploader.upload(new GenericUrl(TEST_DIRECT_REQUEST_URL));
        MediaHttpUploaderTest.assertEquals((int)1, (int)fakeTransport.lowLevelExecCalls);
    }

    public void testDirectMediaUploadWithZeroContent() throws Exception {
        int contentLength = 0;
        MediaTransport fakeTransport = new MediaTransport(contentLength);
        fakeTransport.directUploadEnabled = true;
        ByteArrayContent mediaContent = new ByteArrayContent(TEST_CONTENT_TYPE, new byte[contentLength]);
        MediaHttpUploader uploader = new MediaHttpUploader((AbstractInputStreamContent)mediaContent, (HttpTransport)fakeTransport, null);
        uploader.setDirectUploadEnabled(true);
        uploader.upload(new GenericUrl(TEST_DIRECT_REQUEST_URL));
        MediaHttpUploaderTest.assertEquals((int)1, (int)fakeTransport.lowLevelExecCalls);
    }

    public void testResumableMediaUploadWithZeroContent() throws Exception {
        int contentLength = 0;
        MediaTransport fakeTransport = new MediaTransport(contentLength);
        ByteArrayContent mediaContent = new ByteArrayContent(TEST_CONTENT_TYPE, new byte[contentLength]);
        MediaHttpUploader uploader = new MediaHttpUploader((AbstractInputStreamContent)mediaContent, (HttpTransport)fakeTransport, null);
        uploader.upload(new GenericUrl(TEST_RESUMABLE_REQUEST_URL));
        MediaHttpUploaderTest.assertEquals((int)2, (int)fakeTransport.lowLevelExecCalls);
    }

    public void testResumableMediaUploadWithZeroContentOfUnknownLength() throws Exception {
        int contentLength = 0;
        MediaTransport fakeTransport = new MediaTransport(contentLength);
        fakeTransport.contentLengthNotSpecified = true;
        ByteArrayInputStream is = new ByteArrayInputStream(new byte[contentLength]);
        InputStreamContent mediaContent = new InputStreamContent(TEST_CONTENT_TYPE, (InputStream)is);
        MediaHttpUploader uploader = new MediaHttpUploader((AbstractInputStreamContent)mediaContent, (HttpTransport)fakeTransport, null);
        uploader.upload(new GenericUrl(TEST_RESUMABLE_REQUEST_URL));
        MediaHttpUploaderTest.assertEquals((int)2, (int)fakeTransport.lowLevelExecCalls);
    }

    public void testResumableMediaUploadWithContentClose() throws Exception {
        int contentLength = 0;
        MediaTransport fakeTransport = new MediaTransport(contentLength);
        TestableByteArrayInputStream inputStream = new TestableByteArrayInputStream(new byte[contentLength]);
        InputStreamContent mediaContent = new InputStreamContent(TEST_CONTENT_TYPE, (InputStream)inputStream).setLength((long)contentLength);
        MediaHttpUploader uploader = new MediaHttpUploader((AbstractInputStreamContent)mediaContent, (HttpTransport)fakeTransport, null);
        uploader.upload(new GenericUrl(TEST_RESUMABLE_REQUEST_URL));
        MediaHttpUploaderTest.assertTrue((boolean)inputStream.isClosed());
    }

    public void testResumableMediaUploadWithoutContentClose() throws Exception {
        int contentLength = 0;
        MediaTransport fakeTransport = new MediaTransport(contentLength);
        TestableByteArrayInputStream inputStream = new TestableByteArrayInputStream(new byte[contentLength]);
        InputStreamContent mediaContent = new InputStreamContent(TEST_CONTENT_TYPE, (InputStream)inputStream).setLength((long)contentLength).setCloseInputStream(false);
        MediaHttpUploader uploader = new MediaHttpUploader((AbstractInputStreamContent)mediaContent, (HttpTransport)fakeTransport, null);
        uploader.upload(new GenericUrl(TEST_RESUMABLE_REQUEST_URL));
        MediaHttpUploaderTest.assertFalse((boolean)inputStream.isClosed());
    }

    public void testResumableSlowUpload() throws Exception {
        int contentLength = 3;
        MediaTransport fakeTransport = new MediaTransport(contentLength);
        fakeTransport.contentLengthNotSpecified = true;
        PipedOutputStream outputStream = new PipedOutputStream();
        PipedInputStream inputStream = new PipedInputStream(outputStream);
        Thread thread = new Thread(new SlowWriter(outputStream, contentLength));
        thread.start();
        InputStreamContent mediaContent = new InputStreamContent(TEST_CONTENT_TYPE, (InputStream)inputStream);
        MediaHttpUploader uploader = new MediaHttpUploader((AbstractInputStreamContent)mediaContent, (HttpTransport)fakeTransport, (HttpRequestInitializer)new TimeoutRequestInitializer());
        uploader.setDirectUploadEnabled(false);
        uploader.upload(new GenericUrl(TEST_RESUMABLE_REQUEST_URL));
    }

    public void testResumable_BadResponse() throws IOException {
        int contentLength = 3;
        ResumableErrorMediaTransport fakeTransport = new ResumableErrorMediaTransport();
        byte[] testedData = new byte[contentLength];
        new Random().nextBytes(testedData);
        TestingInputStream is = new TestingInputStream(testedData);
        InputStreamContent mediaContent = new InputStreamContent(TEST_CONTENT_TYPE, (InputStream)is);
        mediaContent.setLength((long)contentLength);
        MediaHttpUploader uploader = new MediaHttpUploader((AbstractInputStreamContent)mediaContent, (HttpTransport)fakeTransport, (HttpRequestInitializer)new ZeroBackOffRequestInitializer());
        uploader.setDisableGZipContent(true);
        HttpResponse response = uploader.upload(new GenericUrl(TEST_RESUMABLE_REQUEST_URL));
        MediaHttpUploaderTest.assertEquals((int)500, (int)response.getStatusCode());
        MediaHttpUploaderTest.assertTrue((String)"input stream should be closed", (boolean)is.isClosed);
    }

    class TestingInputStream
    extends ByteArrayInputStream {
        boolean isClosed;

        TestingInputStream(byte[] testData) {
            super(testData);
        }

        @Override
        public void close() throws IOException {
            this.isClosed = true;
            super.close();
        }
    }

    static class ResumableErrorMediaTransport
    extends MockHttpTransport {
        ResumableErrorMediaTransport() {
        }

        public boolean supportsMethod(String method) throws IOException {
            return true;
        }

        public LowLevelHttpRequest buildRequest(String method, String url) {
            if (method.equals("POST")) {
                TestCase.assertEquals((String)MediaHttpUploaderTest.TEST_RESUMABLE_REQUEST_URL, (String)url);
                return new MockLowLevelHttpRequest(){

                    public LowLevelHttpResponse execute() {
                        TestCase.assertEquals((String)MediaHttpUploaderTest.TEST_CONTENT_TYPE, (String)this.getFirstHeaderValue("x-upload-content-type"));
                        MockLowLevelHttpResponse response = new MockLowLevelHttpResponse();
                        response.setStatusCode(200);
                        response.addHeader("Location", MediaHttpUploaderTest.TEST_UPLOAD_URL);
                        return response;
                    }
                };
            }
            return new MockLowLevelHttpRequest(){

                public LowLevelHttpResponse execute() throws IOException {
                    MockLowLevelHttpResponse response = new MockLowLevelHttpResponse();
                    response.setStatusCode(500);
                    return response;
                }
            };
        }
    }

    class TimeoutRequestInitializer
    implements HttpRequestInitializer {
        TimeoutRequestInitializer() {
        }

        public void initialize(HttpRequest request) {
            request.setInterceptor((HttpExecuteInterceptor)new TimingInterceptor());
        }

        class TimingInterceptor
        implements HttpExecuteInterceptor {
            private long initTime = System.currentTimeMillis();

            TimingInterceptor() {
            }

            public void intercept(HttpRequest request) {
                TestCase.assertTrue((String)"Request initialization to execute should be fast", (System.currentTimeMillis() - this.initTime < 100L ? 1 : 0) != 0);
            }
        }
    }

    class SlowWriter
    implements Runnable {
        private final OutputStream outputStream;
        private final int contentLength;

        SlowWriter(OutputStream outputStream, int contentLength) {
            this.outputStream = outputStream;
            this.contentLength = contentLength;
        }

        @Override
        public void run() {
            try {
                for (int i = 0; i < this.contentLength; ++i) {
                    this.outputStream.write(i);
                    Thread.sleep(1000L);
                }
                this.outputStream.close();
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    static enum ErrorType {
        IO_EXCEPTION,
        SERVER_UNAVAILABLE;

    }

    static class ZeroBackOffRequestInitializer
    implements HttpRequestInitializer {
        ZeroBackOffRequestInitializer() {
        }

        public void initialize(HttpRequest request) {
            request.setIOExceptionHandler((HttpIOExceptionHandler)new HttpBackOffIOExceptionHandler(BackOff.ZERO_BACKOFF));
            request.setUnsuccessfulResponseHandler((HttpUnsuccessfulResponseHandler)new HttpBackOffUnsuccessfulResponseHandler(BackOff.ZERO_BACKOFF));
        }
    }

    private static class GZipCheckerInterceptor
    implements HttpExecuteInterceptor {
        private boolean gzipDisabled;

        public GZipCheckerInterceptor(boolean gzipDisabled) {
            this.gzipDisabled = gzipDisabled;
        }

        public void intercept(HttpRequest request) {
            TestCase.assertEquals((!this.gzipDisabled && !(request.getContent() instanceof EmptyContent) ? 1 : 0) != 0, (request.getEncoding() != null ? 1 : 0) != 0);
        }
    }

    private static class GZipCheckerInitializer
    implements HttpRequestInitializer {
        private boolean gzipDisabled;

        public GZipCheckerInitializer(boolean gzipDisabled) {
            this.gzipDisabled = gzipDisabled;
        }

        public void initialize(HttpRequest request) {
            request.setInterceptor((HttpExecuteInterceptor)new GZipCheckerInterceptor(this.gzipDisabled));
        }
    }

    private static class DirectProgressListener
    implements MediaHttpUploaderProgressListener {
        int progressListenerCalls;
        boolean contentLengthNotSpecified;

        public void progressChanged(MediaHttpUploader uploader) throws IOException {
            ++this.progressListenerCalls;
            switch (uploader.getUploadState()) {
                case MEDIA_IN_PROGRESS: {
                    TestCase.assertEquals((int)1, (int)this.progressListenerCalls);
                    if (this.contentLengthNotSpecified) {
                        try {
                            uploader.getProgress();
                            TestCase.fail((String)("Expected " + IllegalArgumentException.class));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {}
                        break;
                    }
                    TestCase.assertEquals((double)0.0, (double)uploader.getProgress(), (double)0.0);
                    break;
                }
                case MEDIA_COMPLETE: {
                    TestCase.assertEquals((int)2, (int)this.progressListenerCalls);
                    if (this.contentLengthNotSpecified) {
                        try {
                            uploader.getProgress();
                            TestCase.fail((String)("Expected " + IllegalArgumentException.class));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {}
                        break;
                    }
                    TestCase.assertEquals((double)1.0, (double)uploader.getProgress(), (double)0.0);
                    break;
                }
            }
        }
    }

    private static class ResumableProgressListenerWithTwoUploadCalls
    implements MediaHttpUploaderProgressListener {
        int progressListenerCalls;
        boolean contentLengthNotSpecified;

        public void progressChanged(MediaHttpUploader uploader) throws IOException {
            ++this.progressListenerCalls;
            switch (uploader.getUploadState()) {
                case INITIATION_STARTED: {
                    TestCase.assertEquals((int)1, (int)this.progressListenerCalls);
                    break;
                }
                case INITIATION_COMPLETE: {
                    TestCase.assertEquals((int)2, (int)this.progressListenerCalls);
                    break;
                }
                case MEDIA_IN_PROGRESS: {
                    TestCase.assertTrue((this.progressListenerCalls == 3 ? 1 : 0) != 0);
                    if (this.contentLengthNotSpecified) {
                        try {
                            uploader.getProgress();
                            TestCase.fail((String)("Expected " + IllegalArgumentException.class));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {}
                        break;
                    }
                    TestCase.assertEquals((double)0.5, (double)uploader.getProgress(), (double)0.0);
                    break;
                }
                case MEDIA_COMPLETE: {
                    TestCase.assertEquals((int)4, (int)this.progressListenerCalls);
                    if (this.contentLengthNotSpecified) {
                        try {
                            uploader.getProgress();
                            TestCase.fail((String)("Expected " + IllegalArgumentException.class));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {}
                        break;
                    }
                    TestCase.assertEquals((double)1.0, (double)uploader.getProgress(), (double)0.0);
                    break;
                }
            }
        }
    }

    static class MediaTransport
    extends MockHttpTransport {
        int lowLevelExecCalls;
        int bytesUploaded;
        final int contentLength;
        boolean testServerError;
        boolean testClientError;
        boolean testAuthenticationError;
        boolean directUploadEnabled;
        boolean directUploadWithMetadata;
        boolean contentLengthNotSpecified;
        boolean assertTestHeaders;
        boolean testIOException;
        boolean testMethodOverride;
        boolean force308OnRangeQueryResponse;
        int maxByteIndexUploadedOnError = 0x9FFFFF;
        byte[] bytesReceived;

        MediaTransport(int contentLength) {
            this.contentLength = contentLength;
        }

        MediaTransport(int contentLength, boolean testContent) {
            this(contentLength);
            if (testContent) {
                this.bytesReceived = new byte[contentLength];
            }
        }

        public boolean supportsMethod(String method) throws IOException {
            return method.equals("POST") || method.equals("PUT") || method.equals("GET");
        }

        public LowLevelHttpRequest buildRequest(String name, String url) {
            if (name.equals("POST")) {
                if (this.directUploadEnabled) {
                    if (this.directUploadWithMetadata) {
                        TestCase.assertEquals((String)MediaHttpUploaderTest.TEST_MULTIPART_REQUEST_URL, (String)url);
                    } else {
                        TestCase.assertEquals((String)MediaHttpUploaderTest.TEST_DIRECT_REQUEST_URL, (String)url);
                    }
                } else {
                    TestCase.assertEquals((String)MediaHttpUploaderTest.TEST_RESUMABLE_REQUEST_URL, (String)url);
                }
                return new MockLowLevelHttpRequest(){

                    public LowLevelHttpResponse execute() {
                        ++MediaTransport.this.lowLevelExecCalls;
                        if (!MediaTransport.this.directUploadEnabled) {
                            if (!MediaTransport.this.contentLengthNotSpecified) {
                                TestCase.assertEquals((String)Integer.toString(MediaTransport.this.contentLength), (String)this.getFirstHeaderValue("x-upload-content-length"));
                            }
                            TestCase.assertEquals((String)MediaHttpUploaderTest.TEST_CONTENT_TYPE, (String)this.getFirstHeaderValue("x-upload-content-type"));
                        }
                        if (MediaTransport.this.assertTestHeaders) {
                            TestCase.assertEquals((String)"test-header-value", (String)this.getFirstHeaderValue("test-header-name"));
                        }
                        if (MediaTransport.this.testMethodOverride) {
                            TestCase.assertEquals((String)"PATCH", (String)this.getFirstHeaderValue("X-HTTP-Method-Override"));
                        }
                        MockLowLevelHttpResponse response = new MockLowLevelHttpResponse();
                        TestCase.assertFalse((MediaTransport.this.directUploadEnabled && MediaTransport.this.testIOException ? 1 : 0) != 0);
                        if (MediaTransport.this.directUploadEnabled && MediaTransport.this.testServerError && MediaTransport.this.lowLevelExecCalls == 1) {
                            response.setStatusCode(500);
                        } else if (MediaTransport.this.testAuthenticationError) {
                            response.setStatusCode(404);
                        } else {
                            response.setStatusCode(200);
                            if (!MediaTransport.this.directUploadEnabled) {
                                response.addHeader("Location", MediaHttpUploaderTest.TEST_UPLOAD_URL);
                            }
                        }
                        return response;
                    }
                };
            }
            TestCase.assertEquals((String)MediaHttpUploaderTest.TEST_UPLOAD_URL, (String)url);
            TestCase.assertEquals((String)"PUT", (String)name);
            return new MockLowLevelHttpRequest(){

                public LowLevelHttpResponse execute() throws IOException {
                    String contentRangeHeader;
                    MockLowLevelHttpResponse response;
                    block14: {
                        block13: {
                            ++MediaTransport.this.lowLevelExecCalls;
                            response = new MockLowLevelHttpResponse();
                            contentRangeHeader = this.getFirstHeaderValue("Content-Range");
                            if (!MediaTransport.this.testServerError && !MediaTransport.this.testIOException) break block13;
                            switch (MediaTransport.this.lowLevelExecCalls) {
                                case 3: {
                                    int bytesToRead = MediaTransport.this.maxByteIndexUploadedOnError + 1 - MediaTransport.this.bytesUploaded;
                                    this.copyBytesToBytesReceivedArray(bytesToRead);
                                    MediaTransport.this.bytesUploaded += bytesToRead;
                                    if (MediaTransport.this.testIOException) {
                                        throw new IOException();
                                    }
                                    response.setStatusCode(500);
                                    return response;
                                }
                                case 4: {
                                    if (!MediaTransport.this.contentLengthNotSpecified || 0x1400000 >= MediaTransport.this.contentLength) {
                                        TestCase.assertEquals((String)("bytes */" + MediaTransport.this.contentLength), (String)contentRangeHeader);
                                    } else {
                                        TestCase.assertEquals((String)"bytes */*", (String)contentRangeHeader);
                                    }
                                    int statusCode = 200;
                                    if (MediaTransport.this.contentLength != MediaTransport.this.maxByteIndexUploadedOnError + 1 || MediaTransport.this.force308OnRangeQueryResponse) {
                                        statusCode = 308;
                                    }
                                    response.setStatusCode(statusCode);
                                    response.addHeader("Range", "bytes=0-" + MediaTransport.this.maxByteIndexUploadedOnError);
                                    return response;
                                }
                                case 5: {
                                    if (MediaTransport.this.force308OnRangeQueryResponse && MediaTransport.this.contentLength == MediaTransport.this.maxByteIndexUploadedOnError + 1) {
                                        TestCase.assertEquals((String)("bytes */" + MediaTransport.this.contentLength), (String)contentRangeHeader);
                                        response.setStatusCode(200);
                                        response.addHeader("Range", "bytes=0-" + MediaTransport.this.contentLength);
                                        return response;
                                    } else {
                                        break;
                                    }
                                }
                            }
                            break block14;
                        }
                        if (MediaTransport.this.testClientError) {
                            response.setStatusCode(411);
                            return response;
                        }
                    }
                    String bytesRange = MediaTransport.this.bytesUploaded + 0xA00000 > MediaTransport.this.contentLength ? MediaTransport.this.bytesUploaded + "-" + (MediaTransport.this.contentLength - 1) : MediaTransport.this.bytesUploaded + "-" + (MediaTransport.this.bytesUploaded + 0xA00000 - 1);
                    String expectedContentRange = MediaTransport.this.contentLength == 0 ? "bytes */0" : (MediaTransport.this.contentLengthNotSpecified && MediaTransport.this.bytesUploaded + 0xA00000 < MediaTransport.this.contentLength ? "bytes " + bytesRange + "/*" : "bytes " + bytesRange + "/" + MediaTransport.this.contentLength);
                    TestCase.assertEquals((String)expectedContentRange, (String)contentRangeHeader);
                    this.copyBytesToBytesReceivedArray(-1);
                    MediaTransport.this.bytesUploaded += 0xA00000;
                    if (MediaTransport.this.bytesUploaded >= MediaTransport.this.contentLength) {
                        response.setStatusCode(200);
                    } else {
                        response.setStatusCode(308);
                        response.addHeader("Range", "bytes=" + bytesRange);
                    }
                    return response;
                }

                void copyBytesToBytesReceivedArray(int length) throws IOException {
                    if (MediaTransport.this.bytesReceived == null || length == 0) {
                        return;
                    }
                    ByteArrayOutputStream stream = new ByteArrayOutputStream();
                    this.getStreamingContent().writeTo((OutputStream)stream);
                    byte[] currentRequest = stream.toByteArray();
                    System.arraycopy(currentRequest, 0, MediaTransport.this.bytesReceived, MediaTransport.this.bytesUploaded, length == -1 ? currentRequest.length : length);
                }
            };
        }
    }

    private static class MockHttpContent
    extends AbstractHttpContent {
        public MockHttpContent() {
            super("mock/type");
        }

        public void writeTo(OutputStream out) {
        }
    }
}

