/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.json;

import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonParser;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.testing.http.HttpTesting;
import com.google.api.client.testing.http.MockHttpTransport;
import com.google.api.client.testing.http.MockLowLevelHttpRequest;
import com.google.api.client.testing.http.MockLowLevelHttpResponse;
import java.io.InputStream;
import junit.framework.TestCase;

public class GoogleJsonErrorTest
extends TestCase {
    static final JsonFactory FACTORY = new GsonFactory();
    static final String ERROR = "{\"code\":403,\"errors\":[{\"domain\":\"usageLimits\",\"message\":\"Access Not Configured\",\"reason\":\"accessNotConfigured\"}],\"message\":\"Access Not Configured\"}";
    static final String ERROR_RESPONSE = "{\"error\":{\"code\":403,\"errors\":[{\"domain\":\"usageLimits\",\"message\":\"Access Not Configured\",\"reason\":\"accessNotConfigured\"}],\"message\":\"Access Not Configured\"}}";

    public void test_json() throws Exception {
        JsonParser parser = FACTORY.createJsonParser(ERROR);
        parser.nextToken();
        GoogleJsonError e = (GoogleJsonError)parser.parse(GoogleJsonError.class);
        GoogleJsonErrorTest.assertEquals((String)ERROR, (String)FACTORY.toString((Object)e));
    }

    public void testParse() throws Exception {
        ErrorTransport transport = new ErrorTransport();
        HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        request.setThrowExceptionOnExecuteError(false);
        HttpResponse response = request.execute();
        GoogleJsonError errorResponse = GoogleJsonError.parse((JsonFactory)FACTORY, (HttpResponse)response);
        GoogleJsonErrorTest.assertEquals((String)ERROR, (String)FACTORY.toString((Object)errorResponse));
    }

    public void testParse_withDetails() throws Exception {
        String DETAILS_ERROR = "{\"code\":400,\"details\":[{\"@type\":\"type.googleapis.com/google.dataflow.v1beta3.InvalidTemplateParameters\",\"parameterViolations\":[{\"description\":\"Parameter didn't match regex '^[0-9a-zA-Z_]+$'\",\"parameter\":\"safeBrowsingApiKey\"}]},{\"@type\":\"type.googleapis.com/google.rpc.DebugInfo\",\"detail\":\"test detail\"}],\"message\":\"The template parameters are invalid.\",\"status\":\"INVALID_ARGUMENT\"}";
        InputStream errorContent = GoogleJsonErrorTest.class.getResourceAsStream("error.json");
        ErrorTransport transport = new ErrorTransport(new MockLowLevelHttpResponse().setContent(errorContent).setContentType("application/json; charset=UTF-8").setStatusCode(403));
        HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        request.setThrowExceptionOnExecuteError(false);
        HttpResponse response = request.execute();
        GoogleJsonError errorResponse = GoogleJsonError.parse((JsonFactory)FACTORY, (HttpResponse)response);
        GoogleJsonErrorTest.assertEquals((String)DETAILS_ERROR, (String)FACTORY.toString((Object)errorResponse));
        GoogleJsonErrorTest.assertNotNull((Object)errorResponse.getDetails());
    }

    public void testParse_withReasonInDetails() throws Exception {
        String DETAILS_ERROR = "{\"code\":400,\"details\":[{\"@type\":\"type.googleapis.com/google.dataflow.v1beta3.InvalidTemplateParameters\",\"parameterViolations\":[{\"description\":\"Parameter didn't match regex '^[0-9a-zA-Z_]+$'\",\"parameter\":\"safeBrowsingApiKey\"}],\"reason\":\"TEST REASON 1\"},{\"@type\":\"type.googleapis.com/google.rpc.DebugInfo\",\"detail\":\"test detail\"},{\"@type\":\"type.googleapis.com/google.rpc.DebugInfo\",\"reason\":\"test reason 2\"},{\"@type\":\"type.googleapis.com/google.rpc.DebugInfo\"}],\"message\":\"The template parameters are invalid.\",\"status\":\"INVALID_ARGUMENT\"}";
        InputStream errorContent = GoogleJsonErrorTest.class.getResourceAsStream("errorWithReasonInDetails.json");
        ErrorTransport transport = new ErrorTransport(new MockLowLevelHttpResponse().setContent(errorContent).setContentType("application/json; charset=UTF-8").setStatusCode(403));
        HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        request.setThrowExceptionOnExecuteError(false);
        HttpResponse response = request.execute();
        GoogleJsonError errorResponse = GoogleJsonError.parse((JsonFactory)FACTORY, (HttpResponse)response);
        GoogleJsonErrorTest.assertEquals((String)DETAILS_ERROR, (String)FACTORY.toString((Object)errorResponse));
        GoogleJsonErrorTest.assertNotNull((Object)((GoogleJsonError.Details)errorResponse.getDetails().get(2)).getReason());
    }

    static class ErrorTransport
    extends MockHttpTransport {
        final MockLowLevelHttpResponse response;

        ErrorTransport() {
            this(GoogleJsonErrorTest.ERROR_RESPONSE, "application/json; charset=UTF-8");
        }

        ErrorTransport(String content, String contentType) {
            this.response = new MockLowLevelHttpResponse().setContent(content).setContentType(contentType).setStatusCode(403);
        }

        ErrorTransport(MockLowLevelHttpResponse mockLowLevelHttpResponse) {
            this.response = mockLowLevelHttpResponse;
        }

        public LowLevelHttpRequest buildRequest(String name, String url) {
            return new MockLowLevelHttpRequest(url).setResponse(this.response);
        }
    }
}

