/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.auth.oauth2;

import com.google.api.client.googleapis.auth.oauth2.GoogleIdToken;
import com.google.api.client.googleapis.auth.oauth2.GoogleIdTokenVerifier;
import com.google.api.client.googleapis.auth.oauth2.GooglePublicKeysManagerTest;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.json.webtoken.JsonWebSignature;
import com.google.api.client.testing.http.FixedClock;
import com.google.api.client.util.Clock;
import com.google.api.client.util.Lists;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;

public class GoogleIdTokenVerifierTest
extends TestCase {
    private static final String ISSUER = "issuer.example.com";
    private static final String CLIENT_ID = "myclientid";
    private static final List<String> TRUSTED_CLIENT_IDS = Arrays.asList("myclientid");

    private static GoogleIdToken.Payload newPayload(String clientId) {
        GoogleIdToken.Payload payload = new GoogleIdToken.Payload();
        payload.setIssuer("accounts.google.com");
        payload.setAudience((Object)clientId);
        payload.setAuthorizedParty(clientId);
        payload.setExpirationTimeSeconds(Long.valueOf(100L));
        payload.setIssuedAtTimeSeconds(Long.valueOf(0L));
        return payload;
    }

    public void testBuilder() throws Exception {
        GoogleIdTokenVerifier.Builder builder = new GoogleIdTokenVerifier.Builder((HttpTransport)new GooglePublicKeysManagerTest.PublicCertsMockHttpTransport(), (JsonFactory)new GsonFactory()).setIssuer(ISSUER).setAudience(TRUSTED_CLIENT_IDS);
        GoogleIdTokenVerifierTest.assertEquals((Object)Clock.SYSTEM, (Object)builder.getClock());
        GoogleIdTokenVerifierTest.assertEquals((String)ISSUER, (String)builder.getIssuer());
        GoogleIdTokenVerifierTest.assertTrue((boolean)TRUSTED_CLIENT_IDS.equals(builder.getAudience()));
        FixedClock clock = new FixedClock(4L);
        builder.setClock((Clock)clock);
        GoogleIdTokenVerifierTest.assertEquals((Object)clock, (Object)builder.getClock());
        GoogleIdTokenVerifier verifier = builder.build();
        GoogleIdTokenVerifierTest.assertEquals((Object)clock, (Object)verifier.getClock());
        GoogleIdTokenVerifierTest.assertEquals((String)ISSUER, (String)verifier.getIssuer());
        GoogleIdTokenVerifierTest.assertEquals(TRUSTED_CLIENT_IDS, (Object)Lists.newArrayList((Iterable)verifier.getAudience()));
    }

    public void testVerify() throws Exception {
        GoogleIdTokenVerifier verifier = new GoogleIdTokenVerifier.Builder((HttpTransport)new GooglePublicKeysManagerTest.PublicCertsMockHttpTransport(), (JsonFactory)new GsonFactory()).build();
        JsonWebSignature.Header header = new JsonWebSignature.Header();
        header.setAlgorithm("RS25");
        GoogleIdToken.Payload payload = GoogleIdTokenVerifierTest.newPayload(CLIENT_ID);
        GoogleIdToken.Payload payload2 = GoogleIdTokenVerifierTest.newPayload("myclientid2");
        GoogleIdToken idToken = new GoogleIdToken(header, payload, new byte[0], new byte[0]);
        GoogleIdToken idToken2 = new GoogleIdToken(header, payload2, new byte[0], new byte[0]);
        GoogleIdTokenVerifierTest.assertFalse((boolean)verifier.verify(idToken));
        GoogleIdTokenVerifierTest.assertFalse((boolean)verifier.verify(idToken2));
        verifier = new GoogleIdTokenVerifier((HttpTransport)new GooglePublicKeysManagerTest.PublicCertsMockHttpTransport(), (JsonFactory)new GsonFactory());
        GoogleIdTokenVerifierTest.assertFalse((boolean)verifier.verify(idToken));
        GoogleIdTokenVerifierTest.assertFalse((boolean)verifier.verify(idToken2));
    }
}

