/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis;

import com.google.api.client.googleapis.GoogleUtils;
import java.security.KeyStore;
import java.util.Enumeration;
import java.util.regex.Matcher;
import junit.framework.TestCase;

public class GoogleUtilsTest
extends TestCase {
    public void testGetCertificateTrustStore() throws Exception {
        KeyStore trustStore = GoogleUtils.getCertificateTrustStore();
        Enumeration<String> aliases = trustStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            GoogleUtilsTest.assertTrue((boolean)trustStore.isCertificateEntry(alias));
        }
        GoogleUtilsTest.assertEquals((int)70, (int)trustStore.size());
    }

    public void testVersionMatcher() {
        String version = "1.30.3";
        Matcher matcher = GoogleUtils.VERSION_PATTERN.matcher(version);
        GoogleUtilsTest.assertTrue((boolean)matcher.find());
        GoogleUtilsTest.assertEquals((int)1, (int)Integer.parseInt(matcher.group(1)));
        GoogleUtilsTest.assertEquals((int)30, (int)Integer.parseInt(matcher.group(2)));
        GoogleUtilsTest.assertEquals((int)3, (int)Integer.parseInt(matcher.group(3)));
    }

    public void testVersionMatcherSnapshot() {
        String version = "1.30.3-SNAPSHOT";
        Matcher matcher = GoogleUtils.VERSION_PATTERN.matcher(version);
        GoogleUtilsTest.assertTrue((boolean)matcher.find());
        GoogleUtilsTest.assertEquals((int)1, (int)Integer.parseInt(matcher.group(1)));
        GoogleUtilsTest.assertEquals((int)30, (int)Integer.parseInt(matcher.group(2)));
        GoogleUtilsTest.assertEquals((int)3, (int)Integer.parseInt(matcher.group(3)));
    }

    public void testVersion() {
        Matcher matcher = GoogleUtils.VERSION_PATTERN.matcher(GoogleUtils.VERSION);
        GoogleUtilsTest.assertTrue((boolean)matcher.find());
        GoogleUtilsTest.assertNotNull((Object)GoogleUtils.MAJOR_VERSION);
        GoogleUtilsTest.assertNotNull((Object)GoogleUtils.MINOR_VERSION);
        GoogleUtilsTest.assertNotNull((Object)GoogleUtils.BUGFIX_VERSION);
    }
}

