/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.server.response;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.server.converter.ConverterWrapper;
import com.google.android.gms.common.server.response.FastParser;
import com.google.android.gms.common.server.response.FieldCreator;
import com.google.android.gms.common.server.response.FieldMappingDictionary;
import com.google.android.gms.common.server.response.PostProcessor;
import com.google.android.gms.common.server.response.SafeParcelResponse;
import com.google.android.gms.common.util.Base64Utils;
import com.google.android.gms.common.util.IOUtils;
import com.google.android.gms.common.util.JsonUtils;
import com.google.android.gms.common.util.MapUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;

public abstract class FastJsonResponse {
    private int zzwk;
    private byte[] zzwl;
    private boolean zzwm;
    protected static final String QUOTE = "\"";

    public FastJsonResponse() {
    }

    public <T extends FastJsonResponse> void parseNetworkResponse(int n, byte[] byArray) throws FastParser.ParseException {
        this.zzwk = n;
        this.zzwl = byArray;
        this.zzwm = true;
        InputStream inputStream = FastJsonResponse.getUnzippedStream(byArray);
        try {
            new FastParser<FastJsonResponse>().parse(inputStream, this);
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            inputStream.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public static InputStream getUnzippedStream(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        if (IOUtils.isGzipByteBuffer((byte[])byArray)) {
            try {
                return new GZIPInputStream(byteArrayInputStream);
            }
            catch (IOException iOException) {}
        }
        return byteArrayInputStream;
    }

    public int getResponseCode() {
        Preconditions.checkState((boolean)this.zzwm);
        return this.zzwk;
    }

    /*
     * Loose catch block
     */
    public byte[] getResponseBody() {
        int n;
        Preconditions.checkState((boolean)this.zzwm);
        InputStream inputStream = null;
        inputStream = new GZIPInputStream(new ByteArrayInputStream(this.zzwl));
        byte[] byArray = new byte[4096];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = inputStream.read(byArray, 0, 4096)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byteArrayOutputStream.flush();
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        try {
            inputStream.close();
        }
        catch (IOException iOException) {}
        return byArray2;
        catch (IOException iOException) {
            byte[] byArray3;
            block12: {
                try {
                    byArray3 = this.zzwl;
                    if (inputStream == null) break block12;
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    throw throwable;
                }
                try {
                    inputStream.close();
                }
                catch (IOException iOException3) {}
            }
            return byArray3;
        }
    }

    public abstract Map<String, Field<?, ?>> getFieldMappings();

    protected abstract Object getValueObject(String var1);

    protected boolean isFieldSet(Field field) {
        if (field.getTypeOut() == 11) {
            if (field.isTypeOutArray()) {
                return this.isConcreteTypeArrayFieldSet(field.getOutputFieldName());
            }
            return this.isConcreteTypeFieldSet(field.getOutputFieldName());
        }
        return this.isPrimitiveFieldSet(field.getOutputFieldName());
    }

    protected abstract boolean isPrimitiveFieldSet(String var1);

    protected boolean isConcreteTypeFieldSet(String string2) {
        throw new UnsupportedOperationException("Concrete types not supported");
    }

    protected boolean isConcreteTypeArrayFieldSet(String string2) {
        throw new UnsupportedOperationException("Concrete type arrays not supported");
    }

    private final <I, O> void zza(Field<I, O> field, I i) {
        String string2 = field.getOutputFieldName();
        O o = field.convert(i);
        switch (field.getTypeOut()) {
            case 0: {
                if (!FastJsonResponse.zzb(string2, o)) break;
                this.setIntegerInternal(field, string2, (Integer)o);
                return;
            }
            case 1: {
                this.setBigIntegerInternal(field, string2, (BigInteger)o);
                return;
            }
            case 2: {
                if (!FastJsonResponse.zzb(string2, o)) break;
                this.setLongInternal(field, string2, (Long)o);
                return;
            }
            case 4: {
                if (!FastJsonResponse.zzb(string2, o)) break;
                this.setDoubleInternal(field, string2, (Double)o);
                return;
            }
            case 5: {
                this.setBigDecimalInternal(field, string2, (BigDecimal)o);
                return;
            }
            case 6: {
                if (!FastJsonResponse.zzb(string2, o)) break;
                this.setBooleanInternal(field, string2, (Boolean)o);
                return;
            }
            case 7: {
                this.setStringInternal(field, string2, (String)o);
                return;
            }
            case 8: 
            case 9: {
                if (!FastJsonResponse.zzb(string2, o)) break;
                this.setDecodedBytesInternal(field, string2, (byte[])o);
                return;
            }
            default: {
                int n = field.getTypeOut();
                throw new IllegalStateException(new StringBuilder(44).append("Unsupported type for conversion: ").append(n).toString());
            }
        }
    }

    protected <O, I> I getOriginalValue(Field<I, O> field, Object object) {
        if (((Field)field).zzwo != null) {
            return field.convertBack(object);
        }
        return (I)object;
    }

    public final <O> void setInteger(Field<Integer, O> field, int n) {
        if (((Field)field).zzwo != null) {
            this.zza(field, n);
            return;
        }
        this.setIntegerInternal(field, field.getOutputFieldName(), n);
    }

    public final <O> void setIntegers(Field<ArrayList<Integer>, O> field, ArrayList<Integer> arrayList) {
        if (((Field)field).zzwo != null) {
            this.zza(field, arrayList);
            return;
        }
        this.setIntegersInternal(field, field.getOutputFieldName(), arrayList);
    }

    public final <O> void setBigInteger(Field<BigInteger, O> field, BigInteger bigInteger) {
        if (((Field)field).zzwo != null) {
            this.zza(field, bigInteger);
            return;
        }
        this.setBigIntegerInternal(field, field.getOutputFieldName(), bigInteger);
    }

    public final <O> void setBigIntegers(Field<ArrayList<BigInteger>, O> field, ArrayList<BigInteger> arrayList) {
        if (((Field)field).zzwo != null) {
            this.zza(field, arrayList);
            return;
        }
        this.setBigIntegersInternal(field, field.getOutputFieldName(), arrayList);
    }

    public final <O> void setLong(Field<Long, O> field, long l) {
        if (((Field)field).zzwo != null) {
            this.zza(field, l);
            return;
        }
        this.setLongInternal(field, field.getOutputFieldName(), l);
    }

    public final <O> void setLongs(Field<ArrayList<Long>, O> field, ArrayList<Long> arrayList) {
        if (((Field)field).zzwo != null) {
            this.zza(field, arrayList);
            return;
        }
        this.setLongsInternal(field, field.getOutputFieldName(), arrayList);
    }

    public final <O> void setFloat(Field<Float, O> field, float f) {
        if (((Field)field).zzwo != null) {
            this.zza(field, Float.valueOf(f));
            return;
        }
        this.setFloatInternal(field, field.getOutputFieldName(), f);
    }

    public final <O> void setFloats(Field<ArrayList<Float>, O> field, ArrayList<Float> arrayList) {
        if (((Field)field).zzwo != null) {
            this.zza(field, arrayList);
            return;
        }
        this.setFloatsInternal(field, field.getOutputFieldName(), arrayList);
    }

    public final <O> void setDouble(Field<Double, O> field, double d) {
        if (((Field)field).zzwo != null) {
            this.zza(field, d);
            return;
        }
        this.setDoubleInternal(field, field.getOutputFieldName(), d);
    }

    public final <O> void setDoubles(Field<ArrayList<Double>, O> field, ArrayList<Double> arrayList) {
        if (((Field)field).zzwo != null) {
            this.zza(field, arrayList);
            return;
        }
        this.setDoublesInternal(field, field.getOutputFieldName(), arrayList);
    }

    public final <O> void setBigDecimal(Field<BigDecimal, O> field, BigDecimal bigDecimal) {
        if (((Field)field).zzwo != null) {
            this.zza(field, bigDecimal);
            return;
        }
        this.setBigDecimalInternal(field, field.getOutputFieldName(), bigDecimal);
    }

    public final <O> void setBigDecimals(Field<ArrayList<BigDecimal>, O> field, ArrayList<BigDecimal> arrayList) {
        if (((Field)field).zzwo != null) {
            this.zza(field, arrayList);
            return;
        }
        this.setBigDecimalsInternal(field, field.getOutputFieldName(), arrayList);
    }

    public final <O> void setBoolean(Field<Boolean, O> field, boolean bl) {
        if (((Field)field).zzwo != null) {
            this.zza(field, bl);
            return;
        }
        this.setBooleanInternal(field, field.getOutputFieldName(), bl);
    }

    public final <O> void setBooleans(Field<ArrayList<Boolean>, O> field, ArrayList<Boolean> arrayList) {
        if (((Field)field).zzwo != null) {
            this.zza(field, arrayList);
            return;
        }
        this.setBooleansInternal(field, field.getOutputFieldName(), arrayList);
    }

    public final <O> void setString(Field<String, O> field, String string2) {
        if (((Field)field).zzwo != null) {
            this.zza(field, string2);
            return;
        }
        this.setStringInternal(field, field.getOutputFieldName(), string2);
    }

    public final <O> void setStrings(Field<ArrayList<String>, O> field, ArrayList<String> arrayList) {
        if (((Field)field).zzwo != null) {
            this.zza(field, arrayList);
            return;
        }
        this.setStringsInternal(field, field.getOutputFieldName(), arrayList);
    }

    public final <O> void setDecodedBytes(Field<byte[], O> field, byte[] byArray) {
        if (((Field)field).zzwo != null) {
            this.zza(field, byArray);
            return;
        }
        this.setDecodedBytesInternal(field, field.getOutputFieldName(), byArray);
    }

    public final <O> void setStringMap(Field<Map<String, String>, O> field, Map<String, String> map) {
        if (((Field)field).zzwo != null) {
            this.zza(field, map);
            return;
        }
        this.setStringMapInternal(field, field.getOutputFieldName(), map);
    }

    protected void setIntegerInternal(Field<?, ?> field, String string2, int n) {
        this.setInteger(string2, n);
    }

    protected void setIntegersInternal(Field<?, ?> field, String string2, ArrayList<Integer> arrayList) {
        this.setIntegers(string2, arrayList);
    }

    protected void setBigIntegerInternal(Field<?, ?> field, String string2, BigInteger bigInteger) {
        this.setBigInteger(string2, bigInteger);
    }

    protected void setBigIntegersInternal(Field<?, ?> field, String string2, ArrayList<BigInteger> arrayList) {
        this.setBigIntegers(string2, arrayList);
    }

    protected void setLongInternal(Field<?, ?> field, String string2, long l) {
        this.setLong(string2, l);
    }

    protected void setLongsInternal(Field<?, ?> field, String string2, ArrayList<Long> arrayList) {
        this.setLongs(string2, arrayList);
    }

    protected void setFloatInternal(Field<?, ?> field, String string2, float f) {
        this.setFloat(string2, f);
    }

    protected void setFloatsInternal(Field<?, ?> field, String string2, ArrayList<Float> arrayList) {
        this.setFloats(string2, arrayList);
    }

    protected void setDoubleInternal(Field<?, ?> field, String string2, double d) {
        this.setDouble(string2, d);
    }

    protected void setDoublesInternal(Field<?, ?> field, String string2, ArrayList<Double> arrayList) {
        this.setDoubles(string2, arrayList);
    }

    protected void setBigDecimalInternal(Field<?, ?> field, String string2, BigDecimal bigDecimal) {
        this.setBigDecimal(string2, bigDecimal);
    }

    protected void setBigDecimalsInternal(Field<?, ?> field, String string2, ArrayList<BigDecimal> arrayList) {
        this.setBigDecimals(string2, arrayList);
    }

    protected void setBooleanInternal(Field<?, ?> field, String string2, boolean bl) {
        this.setBoolean(string2, bl);
    }

    protected void setBooleansInternal(Field<?, ?> field, String string2, ArrayList<Boolean> arrayList) {
        this.setBooleans(string2, arrayList);
    }

    protected void setStringInternal(Field<?, ?> field, String string2, String string3) {
        this.setString(string2, string3);
    }

    protected void setStringsInternal(Field<?, ?> field, String string2, ArrayList<String> arrayList) {
        this.setStrings(string2, arrayList);
    }

    protected void setDecodedBytesInternal(Field<?, ?> field, String string2, byte[] byArray) {
        this.setDecodedBytes(string2, byArray);
    }

    protected void setStringMapInternal(Field<?, ?> field, String string2, Map<String, String> map) {
        this.setStringMap(string2, map);
    }

    private static <O> boolean zzb(String string2, O o) {
        if (o == null) {
            if (Log.isLoggable((String)"FastJsonResponse", (int)6)) {
                Log.e((String)"FastJsonResponse", (String)new StringBuilder(58 + String.valueOf(string2).length()).append("Output field (").append(string2).append(") has a null value, but expected a primitive").toString());
            }
            return false;
        }
        return true;
    }

    public <T extends FastJsonResponse> void addConcreteTypeInternal(Field<?, ?> field, String string2, T t) {
        this.addConcreteType(string2, t);
    }

    public <T extends FastJsonResponse> void addConcreteTypeArrayInternal(Field<?, ?> field, String string2, ArrayList<T> arrayList) {
        this.addConcreteTypeArray(string2, arrayList);
    }

    protected void setInteger(String string2, int n) {
        throw new UnsupportedOperationException("Integer not supported");
    }

    protected void setIntegers(String string2, ArrayList<Integer> arrayList) {
        throw new UnsupportedOperationException("Integer list not supported");
    }

    protected void setBigInteger(String string2, BigInteger bigInteger) {
        throw new UnsupportedOperationException("BigInteger not supported");
    }

    protected void setBigIntegers(String string2, ArrayList<BigInteger> arrayList) {
        throw new UnsupportedOperationException("BigInteger list not supported");
    }

    protected void setLong(String string2, long l) {
        throw new UnsupportedOperationException("Long not supported");
    }

    protected void setLongs(String string2, ArrayList<Long> arrayList) {
        throw new UnsupportedOperationException("Long list not supported");
    }

    protected void setFloat(String string2, float f) {
        throw new UnsupportedOperationException("Float not supported");
    }

    protected void setFloats(String string2, ArrayList<Float> arrayList) {
        throw new UnsupportedOperationException("Float list not supported");
    }

    protected void setDouble(String string2, double d) {
        throw new UnsupportedOperationException("Double not supported");
    }

    protected void setDoubles(String string2, ArrayList<Double> arrayList) {
        throw new UnsupportedOperationException("Double list not supported");
    }

    protected void setBigDecimal(String string2, BigDecimal bigDecimal) {
        throw new UnsupportedOperationException("BigDecimal not supported");
    }

    protected void setBigDecimals(String string2, ArrayList<BigDecimal> arrayList) {
        throw new UnsupportedOperationException("BigDecimal list not supported");
    }

    protected void setBoolean(String string2, boolean bl) {
        throw new UnsupportedOperationException("Boolean not supported");
    }

    protected void setBooleans(String string2, ArrayList<Boolean> arrayList) {
        throw new UnsupportedOperationException("Boolean list not supported");
    }

    protected void setString(String string2, String string3) {
        throw new UnsupportedOperationException("String not supported");
    }

    protected void setStrings(String string2, ArrayList<String> arrayList) {
        throw new UnsupportedOperationException("String list not supported");
    }

    protected void setDecodedBytes(String string2, byte[] byArray) {
        throw new UnsupportedOperationException("byte[] not supported");
    }

    protected void setStringMap(String string2, Map<String, String> map) {
        throw new UnsupportedOperationException("String map not supported");
    }

    public <T extends FastJsonResponse> void addConcreteType(String string2, T t) {
        throw new UnsupportedOperationException("Concrete type not supported");
    }

    public <T extends FastJsonResponse> void addConcreteTypeArray(String string2, ArrayList<T> arrayList) {
        throw new UnsupportedOperationException("Concrete type array not supported");
    }

    public HashMap<String, Object> getConcreteTypes() {
        return null;
    }

    public HashMap<String, Object> getConcreteTypeArrays() {
        return null;
    }

    public String toString() {
        Map<String, Field<?, ?>> map = this.getFieldMappings();
        StringBuilder stringBuilder = new StringBuilder(100);
        block5: for (String string2 : map.keySet()) {
            Field<?, ?> field = map.get(string2);
            if (!this.isFieldSet(field)) continue;
            Object object = this.getFieldValue(field);
            Object obj = this.getOriginalValue(field, object);
            if (stringBuilder.length() == 0) {
                stringBuilder.append("{");
            } else {
                stringBuilder.append(",");
            }
            stringBuilder.append(QUOTE).append(string2).append("\":");
            if (obj == null) {
                stringBuilder.append("null");
                continue;
            }
            switch (field.getTypeOut()) {
                case 8: {
                    stringBuilder.append(QUOTE).append(Base64Utils.encode((byte[])((byte[])obj))).append(QUOTE);
                    continue block5;
                }
                case 9: {
                    stringBuilder.append(QUOTE).append(Base64Utils.encodeUrlSafe((byte[])((byte[])obj))).append(QUOTE);
                    continue block5;
                }
                case 10: {
                    HashMap hashMap = (HashMap)obj;
                    MapUtils.writeStringMapToJson((StringBuilder)stringBuilder, (HashMap)hashMap);
                    continue block5;
                }
            }
            if (field.isTypeInArray()) {
                ArrayList arrayList = (ArrayList)obj;
                Field<?, ?> field2 = field;
                StringBuilder stringBuilder2 = stringBuilder;
                stringBuilder2.append("[");
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    Object e;
                    if (i > 0) {
                        stringBuilder2.append(",");
                    }
                    if ((e = arrayList.get(i)) == null) continue;
                    FastJsonResponse.zza(stringBuilder2, field2, e);
                }
                stringBuilder2.append("]");
                continue;
            }
            FastJsonResponse.zza(stringBuilder, field, obj);
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append("}");
        } else {
            stringBuilder.append("{}");
        }
        return stringBuilder.toString();
    }

    protected Object getFieldValue(Field field) {
        String string2 = field.getOutputFieldName();
        if (field.getConcreteType() != null) {
            Preconditions.checkState((this.getValueObject(field.getOutputFieldName()) == null ? 1 : 0) != 0, (String)"Concrete field shouldn't be value object: %s", (Object[])new Object[]{field.getOutputFieldName()});
            HashMap<String, Object> hashMap = field.isTypeOutArray() ? this.getConcreteTypeArrays() : this.getConcreteTypes();
            if (hashMap != null) {
                return hashMap.get(string2);
            }
            try {
                char c = Character.toUpperCase(string2.charAt(0));
                String string3 = string2.substring(1);
                String string4 = new StringBuilder(4 + String.valueOf(string3).length()).append("get").append(c).append(string3).toString();
                return this.getClass().getMethod(string4, new Class[0]).invoke((Object)this, new Object[0]);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return this.getValueObject(field.getOutputFieldName());
    }

    private static void zza(StringBuilder stringBuilder, Field field, Object object) {
        if (field.getTypeIn() == 11) {
            Class<FastJsonResponse> clazz = field.getConcreteType();
            stringBuilder.append(clazz.cast(object).toString());
            return;
        }
        if (field.getTypeIn() == 7) {
            stringBuilder.append(QUOTE);
            stringBuilder.append(JsonUtils.escapeString((String)((String)object)));
            stringBuilder.append(QUOTE);
            return;
        }
        stringBuilder.append(object);
    }

    public PostProcessor<? extends FastJsonResponse> getPostProcessor() {
        return null;
    }

    public static interface FieldConverter<I, O> {
        public int getTypeIn();

        public int getTypeOut();

        public O convert(I var1);

        public I convertBack(O var1);
    }

    @VisibleForTesting
    @SafeParcelable.Class(creator="FieldCreator")
    public static class Field<I, O>
    extends AbstractSafeParcelable {
        @SafeParcelable.VersionField(id=1, getter="getVersionCode")
        private final int zzal;
        @SafeParcelable.Field(id=2, getter="getTypeIn")
        protected final int mTypeIn;
        @SafeParcelable.Field(id=3, getter="isTypeInArray")
        protected final boolean mTypeInArray;
        @SafeParcelable.Field(id=4, getter="getTypeOut")
        protected final int mTypeOut;
        @SafeParcelable.Field(id=5, getter="isTypeOutArray")
        protected final boolean mTypeOutArray;
        @SafeParcelable.Field(id=6, getter="getOutputFieldName")
        protected final String mOutputFieldName;
        @SafeParcelable.Field(id=7, getter="getSafeParcelableFieldId")
        protected final int mSafeParcelableFieldId;
        protected final Class<? extends FastJsonResponse> mConcreteType;
        @SafeParcelable.Field(id=8, getter="getConcreteTypeName")
        protected final String mConcreteTypeName;
        private FieldMappingDictionary zzwn;
        @SafeParcelable.Field(id=9, getter="getWrappedConverter", type="com.google.android.gms.common.server.converter.ConverterWrapper")
        private FieldConverter<I, O> zzwo;
        public static final FieldCreator CREATOR = new FieldCreator();

        @SafeParcelable.Constructor
        Field(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) int n2, @SafeParcelable.Param(id=3) boolean bl, @SafeParcelable.Param(id=4) int n3, @SafeParcelable.Param(id=5) boolean bl2, @SafeParcelable.Param(id=6) String string2, @SafeParcelable.Param(id=7) int n4, @SafeParcelable.Param(id=8) String string3, @SafeParcelable.Param(id=9) ConverterWrapper converterWrapper) {
            this.zzal = n;
            this.mTypeIn = n2;
            this.mTypeInArray = bl;
            this.mTypeOut = n3;
            this.mTypeOutArray = bl2;
            this.mOutputFieldName = string2;
            this.mSafeParcelableFieldId = n4;
            if (string3 == null) {
                this.mConcreteType = null;
                this.mConcreteTypeName = null;
            } else {
                this.mConcreteType = SafeParcelResponse.class;
                this.mConcreteTypeName = string3;
            }
            if (converterWrapper == null) {
                this.zzwo = null;
                return;
            }
            this.zzwo = converterWrapper.unwrap();
        }

        protected Field(int n, boolean bl, int n2, boolean bl2, String string2, int n3, Class<? extends FastJsonResponse> clazz, FieldConverter<I, O> fieldConverter) {
            this.zzal = 1;
            this.mTypeIn = n;
            this.mTypeInArray = bl;
            this.mTypeOut = n2;
            this.mTypeOutArray = bl2;
            this.mOutputFieldName = string2;
            this.mSafeParcelableFieldId = n3;
            this.mConcreteType = clazz;
            this.mConcreteTypeName = clazz == null ? null : clazz.getCanonicalName();
            this.zzwo = fieldConverter;
        }

        public Field<I, O> copyForDictionary() {
            return new Field<I, O>(this.zzal, this.mTypeIn, this.mTypeInArray, this.mTypeOut, this.mTypeOutArray, this.mOutputFieldName, this.mSafeParcelableFieldId, this.mConcreteTypeName, this.zzda());
        }

        public int getVersionCode() {
            return this.zzal;
        }

        public int getTypeIn() {
            return this.mTypeIn;
        }

        public boolean isTypeInArray() {
            return this.mTypeInArray;
        }

        public int getTypeOut() {
            return this.mTypeOut;
        }

        public boolean isTypeOutArray() {
            return this.mTypeOutArray;
        }

        public String getOutputFieldName() {
            return this.mOutputFieldName;
        }

        public int getSafeParcelableFieldId() {
            return this.mSafeParcelableFieldId;
        }

        public boolean isValidSafeParcelableFieldId() {
            return this.mSafeParcelableFieldId != -1;
        }

        public Class<? extends FastJsonResponse> getConcreteType() {
            return this.mConcreteType;
        }

        private final String zzcz() {
            if (this.mConcreteTypeName == null) {
                return null;
            }
            return this.mConcreteTypeName;
        }

        public boolean hasConverter() {
            return this.zzwo != null;
        }

        public void setFieldMappingDictionary(FieldMappingDictionary fieldMappingDictionary) {
            this.zzwn = fieldMappingDictionary;
        }

        private final ConverterWrapper zzda() {
            if (this.zzwo == null) {
                return null;
            }
            return ConverterWrapper.wrap(this.zzwo);
        }

        public FastJsonResponse newConcreteTypeInstance() throws InstantiationException, IllegalAccessException {
            if (this.mConcreteType == SafeParcelResponse.class) {
                Preconditions.checkNotNull((Object)((Object)this.zzwn), (Object)"The field mapping dictionary must be set if the concrete type is a SafeParcelResponse object.");
                return new SafeParcelResponse(this.zzwn, this.mConcreteTypeName);
            }
            return this.mConcreteType.newInstance();
        }

        public Map<String, Field<?, ?>> getConcreteTypeFieldMappingFromDictionary() {
            Preconditions.checkNotNull((Object)this.mConcreteTypeName);
            Preconditions.checkNotNull((Object)((Object)this.zzwn));
            return this.zzwn.getFieldMapping(this.mConcreteTypeName);
        }

        public O convert(I i) {
            return this.zzwo.convert(i);
        }

        public I convertBack(O o) {
            return this.zzwo.convertBack(o);
        }

        @VisibleForTesting
        public static Field<Integer, Integer> forInteger(String string2, int n) {
            return new Field<Integer, Integer>(0, false, 0, false, string2, n, null, null);
        }

        @VisibleForTesting
        public static Field<ArrayList<Integer>, ArrayList<Integer>> forIntegers(String string2, int n) {
            return new Field<ArrayList<Integer>, ArrayList<Integer>>(0, true, 0, true, string2, n, null, null);
        }

        public static Field<BigInteger, BigInteger> forBigInteger(String string2, int n) {
            return new Field<BigInteger, BigInteger>(1, false, 1, false, string2, n, null, null);
        }

        public static Field<ArrayList<BigInteger>, ArrayList<BigInteger>> forBigIntegers(String string2, int n) {
            return new Field<ArrayList<BigInteger>, ArrayList<BigInteger>>(0, true, 1, true, string2, n, null, null);
        }

        public static Field<Long, Long> forLong(String string2, int n) {
            return new Field<Long, Long>(2, false, 2, false, string2, n, null, null);
        }

        public static Field<ArrayList<Long>, ArrayList<Long>> forLongs(String string2, int n) {
            return new Field<ArrayList<Long>, ArrayList<Long>>(2, true, 2, true, string2, n, null, null);
        }

        public static Field<Float, Float> forFloat(String string2, int n) {
            return new Field<Float, Float>(3, false, 3, false, string2, n, null, null);
        }

        public static Field<ArrayList<Float>, ArrayList<Float>> forFloats(String string2, int n) {
            return new Field<ArrayList<Float>, ArrayList<Float>>(3, true, 3, true, string2, n, null, null);
        }

        public static Field<Double, Double> forDouble(String string2, int n) {
            return new Field<Double, Double>(4, false, 4, false, string2, n, null, null);
        }

        public static Field<ArrayList<Double>, ArrayList<Double>> forDoubles(String string2, int n) {
            return new Field<ArrayList<Double>, ArrayList<Double>>(4, true, 4, true, string2, n, null, null);
        }

        @VisibleForTesting
        public static Field<BigDecimal, BigDecimal> forBigDecimal(String string2, int n) {
            return new Field<BigDecimal, BigDecimal>(5, false, 5, false, string2, n, null, null);
        }

        public static Field<ArrayList<BigDecimal>, ArrayList<BigDecimal>> forBigDecimals(String string2, int n) {
            return new Field<ArrayList<BigDecimal>, ArrayList<BigDecimal>>(5, true, 5, true, string2, n, null, null);
        }

        public static Field<Boolean, Boolean> forBoolean(String string2, int n) {
            return new Field<Boolean, Boolean>(6, false, 6, false, string2, n, null, null);
        }

        public static Field<ArrayList<Boolean>, ArrayList<Boolean>> forBooleans(String string2, int n) {
            return new Field<ArrayList<Boolean>, ArrayList<Boolean>>(6, true, 6, true, string2, n, null, null);
        }

        public static Field<String, String> forString(String string2, int n) {
            return new Field<String, String>(7, false, 7, false, string2, n, null, null);
        }

        public static Field<ArrayList<String>, ArrayList<String>> forStrings(String string2, int n) {
            return new Field<ArrayList<String>, ArrayList<String>>(7, true, 7, true, string2, n, null, null);
        }

        @VisibleForTesting
        public static Field<byte[], byte[]> forBase64(String string2, int n) {
            return new Field<byte[], byte[]>(8, false, 8, false, string2, n, null, null);
        }

        @VisibleForTesting
        public static Field<byte[], byte[]> forBase64UrlSafe(String string2, int n) {
            return new Field<byte[], byte[]>(9, false, 9, false, string2, n, null, null);
        }

        public static Field<HashMap<String, String>, HashMap<String, String>> forStringMap(String string2, int n) {
            return new Field<HashMap<String, String>, HashMap<String, String>>(10, false, 10, false, string2, n, null, null);
        }

        public static <T extends FastJsonResponse> Field<T, T> forConcreteType(String string2, int n, Class<T> clazz) {
            return new Field(11, false, 11, false, string2, n, clazz, null);
        }

        public static <T extends FastJsonResponse> Field<ArrayList<T>, ArrayList<T>> forConcreteTypeArray(String string2, int n, Class<T> clazz) {
            return new Field<ArrayList<T>, ArrayList<T>>(11, true, 11, true, string2, n, clazz, null);
        }

        public static <T extends FieldConverter> Field withConverter(String string2, int n, Class<T> clazz, boolean bl) {
            try {
                FieldConverter fieldConverter = (FieldConverter)clazz.newInstance();
                return Field.withConverter(string2, n, fieldConverter, bl);
            }
            catch (InstantiationException instantiationException) {
                throw new RuntimeException(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
        }

        public static Field withConverter(String string2, FieldConverter<?, ?> fieldConverter, boolean bl) {
            return Field.withConverter(string2, -1, fieldConverter, bl);
        }

        public static Field withConverter(String string2, int n, FieldConverter<?, ?> fieldConverter, boolean bl) {
            return new Field(fieldConverter.getTypeIn(), bl, fieldConverter.getTypeOut(), false, string2, n, null, fieldConverter);
        }

        public static Field<Integer, Integer> forInteger(String string2) {
            return new Field<Integer, Integer>(0, false, 0, false, string2, -1, null, null);
        }

        public static Field<ArrayList<Integer>, ArrayList<Integer>> forIntegers(String string2) {
            return new Field<ArrayList<Integer>, ArrayList<Integer>>(0, true, 0, true, string2, -1, null, null);
        }

        public static Field<BigInteger, BigInteger> forBigInteger(String string2) {
            return new Field<BigInteger, BigInteger>(1, false, 1, false, string2, -1, null, null);
        }

        public static Field<ArrayList<BigInteger>, ArrayList<BigInteger>> forBigIntegers(String string2) {
            return new Field<ArrayList<BigInteger>, ArrayList<BigInteger>>(0, true, 1, true, string2, -1, null, null);
        }

        @VisibleForTesting
        public static Field<Long, Long> forLong(String string2) {
            return new Field<Long, Long>(2, false, 2, false, string2, -1, null, null);
        }

        @VisibleForTesting
        public static Field<ArrayList<Long>, ArrayList<Long>> forLongs(String string2) {
            return new Field<ArrayList<Long>, ArrayList<Long>>(2, true, 2, true, string2, -1, null, null);
        }

        public static Field<Float, Float> forFloat(String string2) {
            return new Field<Float, Float>(3, false, 3, false, string2, -1, null, null);
        }

        public static Field<ArrayList<Float>, ArrayList<Float>> forFloats(String string2) {
            return new Field<ArrayList<Float>, ArrayList<Float>>(3, true, 3, true, string2, -1, null, null);
        }

        public static Field<Double, Double> forDouble(String string2) {
            return new Field<Double, Double>(4, false, 4, false, string2, -1, null, null);
        }

        public static Field<ArrayList<Double>, ArrayList<Double>> forDoubles(String string2) {
            return new Field<ArrayList<Double>, ArrayList<Double>>(4, true, 4, true, string2, -1, null, null);
        }

        public static Field<BigDecimal, BigDecimal> forBigDecimal(String string2) {
            return new Field<BigDecimal, BigDecimal>(5, false, 5, false, string2, -1, null, null);
        }

        public static Field<ArrayList<BigDecimal>, ArrayList<BigDecimal>> forBigDecimals(String string2) {
            return new Field<ArrayList<BigDecimal>, ArrayList<BigDecimal>>(5, true, 5, true, string2, -1, null, null);
        }

        public static Field<Boolean, Boolean> forBoolean(String string2) {
            return new Field<Boolean, Boolean>(6, false, 6, false, string2, -1, null, null);
        }

        public static Field<ArrayList<Boolean>, ArrayList<Boolean>> forBooleans(String string2) {
            return new Field<ArrayList<Boolean>, ArrayList<Boolean>>(6, true, 6, true, string2, -1, null, null);
        }

        public static Field<String, String> forString(String string2) {
            return new Field<String, String>(7, false, 7, false, string2, -1, null, null);
        }

        public static Field<ArrayList<String>, ArrayList<String>> forStrings(String string2) {
            return new Field<ArrayList<String>, ArrayList<String>>(7, true, 7, true, string2, -1, null, null);
        }

        public static Field<byte[], byte[]> forBase64(String string2) {
            return new Field<byte[], byte[]>(8, false, 8, false, string2, -1, null, null);
        }

        @VisibleForTesting
        public static Field<byte[], byte[]> forBase64UrlSafe(String string2) {
            return new Field<byte[], byte[]>(9, false, 9, false, string2, -1, null, null);
        }

        public static Field<HashMap<String, String>, HashMap<String, String>> forStringMap(String string2) {
            return new Field<HashMap<String, String>, HashMap<String, String>>(10, false, 10, false, string2, -1, null, null);
        }

        public static <T extends FastJsonResponse> Field<T, T> forConcreteType(String string2, Class<T> clazz) {
            return new Field(11, false, 11, false, string2, -1, clazz, null);
        }

        public static <T extends FastJsonResponse> Field<ArrayList<T>, ArrayList<T>> forConcreteTypeArray(String string2, Class<T> clazz) {
            return new Field<ArrayList<T>, ArrayList<T>>(11, true, 11, true, string2, -1, clazz, null);
        }

        public static <T extends FieldConverter> Field withConverter(String string2, Class<T> clazz, boolean bl) {
            return Field.withConverter(string2, -1, clazz, bl);
        }

        public void writeToParcel(Parcel parcel, int n) {
            Parcel parcel2 = parcel;
            Field field = this;
            int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
            SafeParcelWriter.writeInt((Parcel)parcel2, (int)1, (int)field.getVersionCode());
            SafeParcelWriter.writeInt((Parcel)parcel2, (int)2, (int)field.getTypeIn());
            SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)3, (boolean)field.isTypeInArray());
            SafeParcelWriter.writeInt((Parcel)parcel2, (int)4, (int)field.getTypeOut());
            SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)5, (boolean)field.isTypeOutArray());
            SafeParcelWriter.writeString((Parcel)parcel2, (int)6, (String)field.getOutputFieldName(), (boolean)false);
            SafeParcelWriter.writeInt((Parcel)parcel2, (int)7, (int)field.getSafeParcelableFieldId());
            SafeParcelWriter.writeString((Parcel)parcel2, (int)8, (String)field.zzcz(), (boolean)false);
            SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)9, (Parcelable)field.zzda(), (int)n, (boolean)false);
            SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
        }

        public String toString() {
            Objects.ToStringHelper toStringHelper = Objects.toStringHelper((Object)((Object)this)).add("versionCode", (Object)this.zzal).add("typeIn", (Object)this.mTypeIn).add("typeInArray", (Object)this.mTypeInArray).add("typeOut", (Object)this.mTypeOut).add("typeOutArray", (Object)this.mTypeOutArray).add("outputFieldName", (Object)this.mOutputFieldName).add("safeParcelFieldId", (Object)this.mSafeParcelableFieldId).add("concreteTypeName", (Object)this.zzcz());
            Class<FastJsonResponse> clazz = this.getConcreteType();
            if (clazz != null) {
                toStringHelper.add("concreteType.class", (Object)clazz.getCanonicalName());
            }
            if (this.zzwo != null) {
                toStringHelper.add("converterName", (Object)this.zzwo.getClass().getCanonicalName());
            }
            return toStringHelper.toString();
        }
    }

    public static interface FieldType {
        public static final int INT = 0;
        public static final int BIG_INTEGER = 1;
        public static final int LONG = 2;
        public static final int FLOAT = 3;
        public static final int DOUBLE = 4;
        public static final int BIG_DECIMAL = 5;
        public static final int BOOLEAN = 6;
        public static final int STRING = 7;
        public static final int BASE64 = 8;
        public static final int BASE64_URL_SAFE = 9;
        public static final int STRING_MAP = 10;
        public static final int CONCRETE_TYPE = 11;
    }
}

