/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images.internal;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Path;
import android.net.Uri;
import android.util.AttributeSet;
import android.widget.ImageView;
import com.google.android.gms.base.R;
import com.google.android.gms.common.images.ImageManager;
import com.google.android.gms.common.images.ImageRequest;
import com.google.android.gms.common.images.internal.ColorFilters;
import com.google.android.gms.common.internal.Asserts;
import com.google.android.gms.common.util.PlatformVersion;

public final class LoadingImageView
extends ImageView {
    public static final int ASPECT_RATIO_ADJUST_NONE = 0;
    public static final int ASPECT_RATIO_ADJUST_WIDTH = 1;
    public static final int ASPECT_RATIO_ADJUST_HEIGHT = 2;
    private static ImageManager zzqm;
    private Uri zzqn;
    private int zzqo = 0;
    private boolean zzpl = true;
    private boolean zzpm = false;
    private boolean zzqp = false;
    private int zzqq = 0;
    private int mPostProcessingFlags = 0;
    private ClipPathProvider zzqr;
    private ImageManager.OnImageLoadedListener mOnImageLoadedListener;
    private int zzqs = 0;
    private float zzqt = 1.0f;

    public LoadingImageView(Context context) {
        this(context, null, 0);
    }

    public LoadingImageView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public LoadingImageView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.LoadingImageView);
        this.zzqs = typedArray.getInt(R.styleable.LoadingImageView_imageAspectRatioAdjust, 0);
        this.zzqt = typedArray.getFloat(R.styleable.LoadingImageView_imageAspectRatio, 1.0f);
        boolean bl = typedArray.getBoolean(R.styleable.LoadingImageView_circleCrop, false);
        this.setCircleCropEnabled(bl);
        typedArray.recycle();
    }

    public final void clearImage() {
        this.loadUri(null);
        this.zzqp = true;
    }

    public final void loadUri(Uri uri) {
        this.loadUri(uri, 0, true, false);
    }

    public final void loadUri(Uri uri, int n) {
        this.loadUri(uri, n, true, false);
    }

    public final void loadUri(Uri uri, int n, boolean bl) {
        this.loadUri(uri, n, bl, false);
    }

    public final void loadUri(Uri uri, int n, boolean bl, boolean bl2) {
        if (uri != null ? uri.equals((Object)this.zzqn) : this.zzqn == null) {
            if (this.zzqn != null) {
                this.zzc(true);
                return;
            }
            if (this.zzqo == n) {
                this.zzc(false);
                return;
            }
        }
        if (zzqm == null) {
            boolean bl3 = this.getContext().getApplicationContext().getPackageName().equals("com.google.android.play.games");
            zzqm = ImageManager.create(this.getContext(), bl3);
        }
        boolean bl4 = this.zzpm || this.zzqp;
        this.zzqp = false;
        ImageRequest.ImageViewImageRequest imageViewImageRequest = new ImageRequest.ImageViewImageRequest((ImageView)this, uri);
        imageViewImageRequest.setNoDataPlaceholder(n);
        imageViewImageRequest.setCrossFadeEnabled(this.zzpl);
        imageViewImageRequest.setCrossFadeAlwaysEnabled(bl4);
        imageViewImageRequest.setLoadingPlaceholderEnabled(bl);
        imageViewImageRequest.setPostProcessingFlags(this.mPostProcessingFlags);
        imageViewImageRequest.setOnImageLoadedListener(this.mOnImageLoadedListener);
        imageViewImageRequest.setUseNewDrawable(bl2);
        zzqm.loadImage(imageViewImageRequest);
    }

    public final Uri getLoadedUri() {
        return this.zzqn;
    }

    public final void setLoadedUri(Uri uri) {
        this.zzqn = uri;
    }

    public final void setOnImageLoadedListener(ImageManager.OnImageLoadedListener onImageLoadedListener) {
        this.mOnImageLoadedListener = onImageLoadedListener;
    }

    public final int getLoadedNoDataPlaceholderResId() {
        return this.zzqo;
    }

    public final void setLoadedNoDataPlaceholderResId(int n) {
        this.zzqo = n;
    }

    public final void setCrossFadeEnabled(boolean bl) {
        this.zzpl = bl;
    }

    public final void setCrossFadeAlwaysEnabled(boolean bl) {
        this.zzpm = bl;
    }

    public final void setCircleCropEnabled(boolean bl) {
        if (bl) {
            this.mPostProcessingFlags |= 1;
            return;
        }
        this.mPostProcessingFlags &= 0xFFFFFFFE;
    }

    public final void setTintColorId(int n) {
        Resources resources;
        int n2 = 0;
        if (n > 0 && (resources = this.getResources()) != null) {
            n2 = resources.getColor(n);
        }
        this.setTintColor(n2);
    }

    public final void setTintColor(int n) {
        this.zzqq = n;
        if (this.zzqq != 0) {
            this.setColorFilter(ColorFilters.COLOR_FILTER_BW);
        } else {
            this.setColorFilter(null);
        }
        this.invalidate();
    }

    public final void setClipPathProvider(ClipPathProvider clipPathProvider) {
        this.zzqr = clipPathProvider;
        if (!PlatformVersion.isAtLeastJellyBean()) {
            this.setLayerType(1, null);
        }
    }

    public final void setImageAspectRatioAdjust(int n, float f) {
        Asserts.checkState((n == 0 || n == 1 || n == 2 ? 1 : 0) != 0);
        Asserts.checkState((f > 0.0f ? 1 : 0) != 0);
        this.zzqs = n;
        this.zzqt = f;
        this.requestLayout();
    }

    public final void clearAspectRatioAdjust() {
        if (this.zzqs != 0) {
            this.zzqs = 0;
            this.requestLayout();
        }
    }

    protected final void onMeasure(int n, int n2) {
        int n3;
        int n4;
        super.onMeasure(n, n2);
        switch (this.zzqs) {
            case 1: {
                n4 = this.getMeasuredHeight();
                n3 = (int)((float)n4 * this.zzqt);
                break;
            }
            case 2: {
                n3 = this.getMeasuredWidth();
                n4 = (int)((float)n3 / this.zzqt);
                break;
            }
            default: {
                return;
            }
        }
        this.setMeasuredDimension(n3, n4);
    }

    protected final void onDraw(Canvas canvas) {
        if (this.zzqr != null) {
            canvas.clipPath(this.zzqr.getClipPath(this.getWidth(), this.getHeight()));
        }
        super.onDraw(canvas);
        if (this.zzqq != 0) {
            canvas.drawColor(this.zzqq);
        }
    }

    private final void zzc(boolean bl) {
        if (this.mOnImageLoadedListener != null) {
            this.mOnImageLoadedListener.onImageLoaded(this.zzqn, null, bl);
        }
    }

    public static interface ClipPathProvider {
        public Path getClipPath(int var1, int var2);
    }
}

