/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images;

import android.app.ActivityManager;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.ResultReceiver;
import android.os.SystemClock;
import android.support.v4.util.LruCache;
import android.util.Log;
import android.widget.ImageView;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.images.ImageRequest;
import com.google.android.gms.common.images.internal.PostProcessedResourceCache;
import com.google.android.gms.common.internal.Asserts;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class ImageManager {
    private static final Object zzov = new Object();
    private static HashSet<Uri> zzow = new HashSet();
    private static ImageManager zzox;
    private static ImageManager zzoy;
    public static final int PRIORITY_HIGH = 3;
    public static final int PRIORITY_MEDIUM = 2;
    public static final int PRIORITY_LOW = 1;
    private final Context mContext;
    private final Handler mHandler;
    private final ExecutorService zzoz;
    private final zza zzpa;
    private final PostProcessedResourceCache zzpb;
    private final Map<ImageRequest, ImageReceiver> zzpc;
    private final Map<Uri, ImageReceiver> zzpd;
    private final Map<Uri, Long> zzpe;

    public static ImageManager create(Context context) {
        return ImageManager.create(context, false);
    }

    public static ImageManager create(Context context, boolean bl) {
        if (bl) {
            if (zzoy == null) {
                zzoy = new ImageManager(context, true);
            }
            return zzoy;
        }
        if (zzox == null) {
            zzox = new ImageManager(context, false);
        }
        return zzox;
    }

    private ImageManager(Context context, boolean bl) {
        this.mContext = context.getApplicationContext();
        this.mHandler = new Handler(Looper.getMainLooper());
        this.zzoz = Executors.newFixedThreadPool(4);
        if (bl) {
            this.zzpa = new zza(this.mContext);
            this.mContext.registerComponentCallbacks((ComponentCallbacks)new zzd(this.zzpa));
        } else {
            this.zzpa = null;
        }
        this.zzpb = new PostProcessedResourceCache();
        this.zzpc = new HashMap<ImageRequest, ImageReceiver>();
        this.zzpd = new HashMap<Uri, ImageReceiver>();
        this.zzpe = new HashMap<Uri, Long>();
    }

    public final void loadImage(ImageView imageView, Uri uri) {
        ImageRequest.ImageViewImageRequest imageViewImageRequest = new ImageRequest.ImageViewImageRequest(imageView, uri);
        this.loadImage(imageViewImageRequest);
    }

    public final void loadImage(ImageView imageView, int n) {
        ImageRequest.ImageViewImageRequest imageViewImageRequest = new ImageRequest.ImageViewImageRequest(imageView, n);
        this.loadImage(imageViewImageRequest);
    }

    public final void loadImage(ImageView imageView, Uri uri, int n) {
        ImageRequest.ImageViewImageRequest imageViewImageRequest = new ImageRequest.ImageViewImageRequest(imageView, uri);
        imageViewImageRequest.setNoDataPlaceholder(n);
        this.loadImage(imageViewImageRequest);
    }

    public final void loadImage(OnImageLoadedListener onImageLoadedListener, Uri uri) {
        ImageRequest.ListenerImageRequest listenerImageRequest = new ImageRequest.ListenerImageRequest(onImageLoadedListener, uri);
        this.loadImage(listenerImageRequest);
    }

    public final void loadImage(OnImageLoadedListener onImageLoadedListener, Uri uri, int n) {
        ImageRequest.ListenerImageRequest listenerImageRequest = new ImageRequest.ListenerImageRequest(onImageLoadedListener, uri);
        listenerImageRequest.setNoDataPlaceholder(n);
        this.loadImage(listenerImageRequest);
    }

    public final void loadImage(ImageRequest imageRequest) {
        Asserts.checkMainThread((String)"ImageManager.loadImage() must be called in the main thread");
        new zzc(imageRequest).run();
    }

    private final Bitmap zza(ImageRequest.zza zza2) {
        if (this.zzpa == null) {
            return null;
        }
        return (Bitmap)this.zzpa.get(zza2);
    }

    private static final class zza
    extends LruCache<ImageRequest.zza, Bitmap> {
        public zza(Context context) {
            Context context2 = context;
            ActivityManager activityManager = (ActivityManager)context2.getSystemService("activity");
            int n = (context2.getApplicationInfo().flags & 0x100000) != 0 ? activityManager.getLargeMemoryClass() : activityManager.getMemoryClass();
            int n2 = n * 0x100000;
            super((int)(0.33f * (float)n2));
        }

        protected final /* synthetic */ int sizeOf(Object object, Object object2) {
            Bitmap bitmap = (Bitmap)object2;
            return bitmap.getHeight() * bitmap.getRowBytes();
        }

        protected final /* synthetic */ void entryRemoved(boolean bl, Object object, Object object2, Object object3) {
            Bitmap bitmap = (Bitmap)object3;
            Bitmap bitmap2 = (Bitmap)object2;
            ImageRequest.zza zza2 = (ImageRequest.zza)object;
            super.entryRemoved(bl, (Object)zza2, (Object)bitmap2, (Object)bitmap);
        }
    }

    private static final class zzd
    implements ComponentCallbacks2 {
        private final zza zzpa;

        public zzd(zza zza2) {
            this.zzpa = zza2;
        }

        public final void onConfigurationChanged(Configuration configuration) {
        }

        public final void onLowMemory() {
            this.zzpa.evictAll();
        }

        public final void onTrimMemory(int n) {
            if (n >= 60) {
                this.zzpa.evictAll();
                return;
            }
            if (n >= 20) {
                this.zzpa.trimToSize(this.zzpa.size() / 2);
            }
        }
    }

    private final class zze
    implements Runnable {
        private final Uri mUri;
        private final Bitmap mBitmap;
        private final CountDownLatch zzfd;
        private boolean zzpj;

        public zze(Uri uri, Bitmap bitmap, boolean bl, CountDownLatch countDownLatch) {
            this.mUri = uri;
            this.mBitmap = bitmap;
            this.zzpj = bl;
            this.zzfd = countDownLatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            ImageReceiver imageReceiver;
            boolean bl;
            Asserts.checkMainThread((String)"OnBitmapLoadedRunnable must be executed in the main thread");
            boolean bl2 = bl = this.mBitmap != null;
            if (ImageManager.this.zzpa != null) {
                if (this.zzpj) {
                    ImageManager.this.zzpa.evictAll();
                    System.gc();
                    this.zzpj = false;
                    ImageManager.this.mHandler.post((Runnable)this);
                    return;
                }
                if (bl) {
                    ImageManager.this.zzpa.put(new ImageRequest.zza(this.mUri), this.mBitmap);
                }
            }
            if ((imageReceiver = (ImageReceiver)((Object)ImageManager.this.zzpd.remove(this.mUri))) != null) {
                boolean bl3 = bl;
                ImageReceiver imageReceiver2 = imageReceiver;
                zze zze2 = this;
                ArrayList arrayList = imageReceiver2.zzpf;
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    ImageRequest imageRequest = (ImageRequest)arrayList.get(i);
                    if (bl3) {
                        imageRequest.zza(zze2.ImageManager.this.mContext, zze2.mBitmap, false);
                    } else {
                        zze2.ImageManager.this.zzpe.put(zze2.mUri, SystemClock.elapsedRealtime());
                        imageRequest.zza(zze2.ImageManager.this.mContext, zze2.ImageManager.this.zzpb, false);
                    }
                    if (imageRequest instanceof ImageRequest.ListenerImageRequest) continue;
                    zze2.ImageManager.this.zzpc.remove(imageRequest);
                }
            }
            this.zzfd.countDown();
            Object object = zzov;
            synchronized (object) {
                zzow.remove(this.mUri);
                return;
            }
        }
    }

    private final class zzb
    implements Runnable {
        private final Uri mUri;
        private final ParcelFileDescriptor zzph;

        public zzb(Uri uri, ParcelFileDescriptor parcelFileDescriptor) {
            this.mUri = uri;
            this.zzph = parcelFileDescriptor;
        }

        @Override
        public final void run() {
            Asserts.checkNotMainThread((String)"LoadBitmapFromDiskRunnable can't be executed in the main thread");
            boolean bl = false;
            Bitmap bitmap = null;
            if (this.zzph != null) {
                try {
                    bitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)this.zzph.getFileDescriptor());
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    String string2 = String.valueOf(this.mUri);
                    Log.e((String)"ImageManager", (String)new StringBuilder(34 + String.valueOf(string2).length()).append("OOM while loading bitmap for uri: ").append(string2).toString(), (Throwable)outOfMemoryError);
                    bl = true;
                }
                try {
                    this.zzph.close();
                }
                catch (IOException iOException) {
                    Log.e((String)"ImageManager", (String)"closed failed", (Throwable)iOException);
                }
            }
            CountDownLatch countDownLatch = new CountDownLatch(1);
            ImageManager.this.mHandler.post((Runnable)new zze(this.mUri, bitmap, bl, countDownLatch));
            try {
                countDownLatch.await();
                return;
            }
            catch (InterruptedException interruptedException) {
                String string3 = String.valueOf(this.mUri);
                Log.w((String)"ImageManager", (String)new StringBuilder(32 + String.valueOf(string3).length()).append("Latch interrupted while posting ").append(string3).toString());
                return;
            }
        }
    }

    @KeepName
    private final class ImageReceiver
    extends ResultReceiver {
        private final Uri mUri;
        private final ArrayList<ImageRequest> zzpf;

        ImageReceiver(Uri uri) {
            super(new Handler(Looper.getMainLooper()));
            this.mUri = uri;
            this.zzpf = new ArrayList();
        }

        public final void zza(ImageRequest imageRequest) {
            Asserts.checkMainThread((String)"ImageReceiver.addImageRequest() must be called in the main thread");
            this.zzpf.add(imageRequest);
        }

        public final void zzb(ImageRequest imageRequest) {
            Asserts.checkMainThread((String)"ImageReceiver.removeImageRequest() must be called in the main thread");
            this.zzpf.remove(imageRequest);
        }

        public final void zzco() {
            Intent intent = new Intent("com.google.android.gms.common.images.LOAD_IMAGE");
            intent.putExtra("com.google.android.gms.extras.uri", (Parcelable)this.mUri);
            intent.putExtra("com.google.android.gms.extras.resultReceiver", (Parcelable)this);
            intent.putExtra("com.google.android.gms.extras.priority", 3);
            ImageManager.this.mContext.sendBroadcast(intent);
        }

        public final void onReceiveResult(int n, Bundle bundle) {
            ParcelFileDescriptor parcelFileDescriptor = (ParcelFileDescriptor)bundle.getParcelable("com.google.android.gms.extra.fileDescriptor");
            ImageManager.this.zzoz.execute(new zzb(this.mUri, parcelFileDescriptor));
        }
    }

    private final class zzc
    implements Runnable {
        private final ImageRequest zzpi;

        public zzc(ImageRequest imageRequest) {
            this.zzpi = imageRequest;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            Asserts.checkMainThread((String)"LoadImageRunnable must be executed on the main thread");
            ImageReceiver imageReceiver = (ImageReceiver)((Object)ImageManager.this.zzpc.get(this.zzpi));
            if (imageReceiver != null) {
                ImageManager.this.zzpc.remove(this.zzpi);
                imageReceiver.zzb(this.zzpi);
            }
            ImageRequest.zza zza2 = this.zzpi.zzpk;
            if (zza2.uri == null) {
                this.zzpi.zza(ImageManager.this.mContext, ImageManager.this.zzpb, true);
                return;
            }
            Bitmap bitmap = ImageManager.this.zza(zza2);
            if (bitmap != null) {
                this.zzpi.zza(ImageManager.this.mContext, bitmap, true);
                return;
            }
            Long l = (Long)ImageManager.this.zzpe.get(zza2.uri);
            if (l != null) {
                if (SystemClock.elapsedRealtime() - l < 3600000L) {
                    this.zzpi.zza(ImageManager.this.mContext, ImageManager.this.zzpb, true);
                    return;
                }
                ImageManager.this.zzpe.remove(zza2.uri);
            }
            this.zzpi.zza(ImageManager.this.mContext, ImageManager.this.zzpb);
            imageReceiver = (ImageReceiver)((Object)ImageManager.this.zzpd.get(zza2.uri));
            if (imageReceiver == null) {
                imageReceiver = new ImageReceiver(zza2.uri);
                ImageManager.this.zzpd.put(zza2.uri, imageReceiver);
            }
            imageReceiver.zza(this.zzpi);
            if (!(this.zzpi instanceof ImageRequest.ListenerImageRequest)) {
                ImageManager.this.zzpc.put(this.zzpi, imageReceiver);
            }
            Object object = zzov;
            synchronized (object) {
                if (!zzow.contains(zza2.uri)) {
                    zzow.add(zza2.uri);
                    imageReceiver.zzco();
                }
                return;
            }
        }
    }

    public static interface OnImageLoadedListener {
        public void onImageLoaded(Uri var1, Drawable var2, boolean var3);
    }
}

