/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import android.os.Bundle;
import com.google.android.gms.common.data.DataBuffer;
import com.google.android.gms.common.data.DataBufferIterator;
import com.google.android.gms.common.data.zzb;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;

public final class SortedDataBuffer<T>
implements DataBuffer<T> {
    private final DataBuffer<T> zzok;
    private final Integer[] zzol;

    public SortedDataBuffer(DataBuffer<T> dataBuffer, Comparator<T> comparator) {
        this.zzok = dataBuffer;
        this.zzol = new Integer[dataBuffer.getCount()];
        for (int i = 0; i < this.zzol.length; ++i) {
            this.zzol[i] = i;
        }
        Arrays.sort(this.zzol, new zzb(this, comparator));
    }

    @Override
    public final int getCount() {
        return this.zzol.length;
    }

    @Override
    public final T get(int n) {
        return this.zzok.get(this.zzol[n]);
    }

    @Override
    public final void release() {
        this.zzok.release();
    }

    @Override
    public final Bundle getMetadata() {
        return this.zzok.getMetadata();
    }

    @Override
    public final void close() {
        this.zzok.release();
    }

    @Override
    public final boolean isClosed() {
        return this.zzok.isClosed();
    }

    @Override
    public final Iterator<T> iterator() {
        return new DataBufferIterator(this);
    }

    @Override
    public final Iterator<T> singleRefIterator() {
        return this.iterator();
    }

    static /* synthetic */ DataBuffer zza(SortedDataBuffer sortedDataBuffer) {
        return sortedDataBuffer.zzok;
    }
}

