/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import android.text.TextUtils;
import com.google.android.gms.common.data.AbstractDataBuffer;
import com.google.android.gms.common.data.DataBufferObserver;
import com.google.android.gms.common.data.DataBufferObserverSet;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.EntityBuffer;
import com.google.android.gms.common.data.ExclusionFilterable;
import com.google.android.gms.common.data.FilteredDataBuffer;
import com.google.android.gms.common.util.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;

@VisibleForTesting
public final class ExclusionFilteredDataBuffer<T>
extends FilteredDataBuffer<T>
implements DataBufferObserver.Observable,
ExclusionFilterable {
    private AbstractDataBuffer<T> zzoc;
    private final String zzod;
    private final HashSet<Integer> zzoe = new HashSet();
    private DataBufferObserverSet zzof;

    public ExclusionFilteredDataBuffer(AbstractDataBuffer<T> abstractDataBuffer, String string2) {
        super(abstractDataBuffer);
        this.zzoc = abstractDataBuffer;
        this.zzod = string2;
        this.zzof = new DataBufferObserverSet();
    }

    @Override
    public final void addObserver(DataBufferObserver dataBufferObserver) {
        this.zzof.addObserver(dataBufferObserver);
    }

    @Override
    public final void removeObserver(DataBufferObserver dataBufferObserver) {
        this.zzof.removeObserver(dataBufferObserver);
    }

    @Override
    public final int getCount() {
        return this.mDataBuffer.getCount() - this.zzoe.size();
    }

    @Override
    public final int computeRealPosition(int n) {
        if (this.zzoe.isEmpty()) {
            return n;
        }
        if (n < 0 || n >= this.getCount()) {
            throw new IllegalArgumentException(new StringBuilder(53).append("Position ").append(n).append(" is out of bounds for this buffer").toString());
        }
        int n2 = 0;
        int n3 = this.mDataBuffer.getCount();
        for (int i = 0; i < n3; ++i) {
            if (this.zzoe.contains(i)) continue;
            if (n2 == n) {
                return i;
            }
            ++n2;
        }
        return -1;
    }

    @Override
    public final void release() {
        super.release();
        this.zzof.clear();
    }

    @Override
    public final void filterOut(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        ArrayList<Integer> arrayList = null;
        if (this.zzof.hasObservers()) {
            arrayList = new ArrayList<Integer>();
        }
        ArrayList<Integer> arrayList2 = this.zza(string2, arrayList);
        if (this.zzof.hasObservers()) {
            int n = 0;
            int n2 = 0;
            for (int i = arrayList2.size() - 1; i >= 0; --i) {
                int n3;
                int n4 = n3 = arrayList.get(i).intValue();
                if (n3 < 0) continue;
                int n5 = arrayList2.get(i);
                this.zzoe.add(n5);
                if (n2 == 0) {
                    n = n3;
                    n2 = 1;
                    continue;
                }
                if (n3 == n - 1) {
                    --n;
                    ++n2;
                    continue;
                }
                this.zzof.onDataRangeRemoved(n, n2);
                n = n3;
                n2 = 1;
            }
            if (n2 > 0) {
                this.zzof.onDataRangeRemoved(n, n2);
            }
            return;
        }
        this.zzoe.addAll(arrayList2);
    }

    @Override
    public final void unfilter(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        ArrayList<Integer> arrayList = null;
        if (this.zzof.hasObservers()) {
            arrayList = new ArrayList<Integer>();
        }
        ArrayList<Integer> arrayList2 = this.zza(string2, arrayList);
        if (this.zzof.hasObservers()) {
            int n = 0;
            int n2 = 0;
            for (int i = arrayList2.size() - 1; i >= 0; --i) {
                int n3;
                int n4 = n3 = arrayList.get(i).intValue();
                if (!(n3 < 0)) continue;
                int n5 = arrayList2.get(i);
                this.zzoe.remove(n5);
                int n6 = -n3 - 1;
                if (n2 == 0) {
                    n = n6;
                    n2 = 1;
                    continue;
                }
                if (n6 == n) {
                    ++n2;
                    continue;
                }
                this.zzof.onDataRangeInserted(n, n2);
                n = n6;
                n2 = 1;
            }
            if (n2 > 0) {
                this.zzof.onDataRangeInserted(n, n2);
            }
            return;
        }
        this.zzoe.removeAll(arrayList2);
    }

    @Override
    public final void clearFilters() {
        if (!this.zzof.hasObservers()) {
            this.zzoe.clear();
            return;
        }
        int n = this.zzoe.size();
        Integer[] integerArray = new Integer[n];
        integerArray = this.zzoe.toArray(integerArray);
        Arrays.sort((Object[])integerArray);
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            int n4 = integerArray[i];
            this.zzoe.remove(n4);
            if (n3 == 0) {
                n2 = n4;
                n3 = 1;
                continue;
            }
            if (n4 == n2 + n3) {
                ++n3;
                continue;
            }
            this.zzof.onDataRangeRemoved(n2, n3);
            n2 = n4;
            n3 = 1;
        }
        if (n3 > 0) {
            this.zzof.onDataRangeRemoved(n2, n3);
        }
    }

    private final ArrayList<Integer> zza(String string2, ArrayList<Integer> arrayList) {
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        if (arrayList != null) {
            arrayList.clear();
        }
        DataHolder dataHolder = this.zzoc.mDataHolder;
        String string3 = this.zzod;
        boolean bl = this.zzoc instanceof EntityBuffer;
        int n = 0;
        int n2 = this.zzoc.getCount();
        for (int i = 0; i < n2; ++i) {
            int n3 = bl ? ((EntityBuffer)this.zzoc).zzi(i) : i;
            int n4 = dataHolder.getWindowIndex(n3);
            String string4 = dataHolder.getString(string3, n3, n4);
            int n5 = n++;
            if (arrayList != null && this.zzoe.contains(i)) {
                n5 = -n - 1;
            }
            if (TextUtils.isEmpty((CharSequence)string4) || !string4.equals(string2)) continue;
            arrayList2.add(i);
            if (arrayList == null) continue;
            arrayList.add(n5);
        }
        return arrayList2;
    }
}

