/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import android.content.Context;
import android.os.Bundle;
import com.google.android.gms.common.data.DataBuffer;
import com.google.android.gms.common.data.DataBufferIterator;
import com.google.android.gms.common.data.ExclusionFilterable;
import com.google.android.gms.common.data.TextFilterable;
import com.google.android.gms.common.util.VisibleForTesting;
import java.util.ArrayList;
import java.util.Iterator;

@VisibleForTesting
public final class ConcatenatedDataBuffer<T>
implements DataBuffer<T>,
ExclusionFilterable,
TextFilterable {
    private final ArrayList<DataBuffer<T>> zznf = new ArrayList();
    private final ArrayList<Integer> zzng = new ArrayList();
    private int zznh;
    private Bundle mBundle;

    public ConcatenatedDataBuffer() {
    }

    public ConcatenatedDataBuffer(DataBuffer<T> dataBuffer) {
        this.append(dataBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int getCount() {
        ConcatenatedDataBuffer concatenatedDataBuffer = this;
        synchronized (concatenatedDataBuffer) {
            return this.zznh;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final T get(int n) {
        ConcatenatedDataBuffer concatenatedDataBuffer = this;
        synchronized (concatenatedDataBuffer) {
            int n2 = this.zznf.size();
            for (int i = 0; i < n2; ++i) {
                DataBuffer<T> dataBuffer;
                int n3 = this.zzng.get(i);
                if (n >= n3 || (dataBuffer = this.zznf.get(i)) == null) continue;
                return dataBuffer.get(n - n3 + dataBuffer.getCount());
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void release() {
        ConcatenatedDataBuffer concatenatedDataBuffer = this;
        synchronized (concatenatedDataBuffer) {
            int n = this.zznf.size();
            for (int i = 0; i < n; ++i) {
                DataBuffer<T> dataBuffer = this.zznf.get(i);
                if (dataBuffer == null) continue;
                dataBuffer.release();
            }
            this.zznf.clear();
            this.zzng.clear();
            this.mBundle = null;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void append(DataBuffer<T> dataBuffer) {
        if (dataBuffer == null) {
            return;
        }
        ConcatenatedDataBuffer concatenatedDataBuffer = this;
        synchronized (concatenatedDataBuffer) {
            Bundle bundle;
            if (this.zznf.isEmpty()) {
                this.mBundle = new Bundle();
                bundle = dataBuffer.getMetadata();
                if (bundle != null) {
                    this.mBundle.putString("prev_page_token", bundle.getString("prev_page_token"));
                }
            }
            this.zznf.add(dataBuffer);
            this.computeCounts();
            bundle = dataBuffer.getMetadata();
            if (bundle != null) {
                this.mBundle.putString("next_page_token", bundle.getString("next_page_token"));
            } else {
                this.mBundle.remove("next_page_token");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Bundle getMetadata() {
        ConcatenatedDataBuffer concatenatedDataBuffer = this;
        synchronized (concatenatedDataBuffer) {
            return this.mBundle;
        }
    }

    @Override
    @Deprecated
    public final void close() {
        this.release();
    }

    @Override
    @Deprecated
    public final boolean isClosed() {
        return false;
    }

    @Override
    public final Iterator<T> iterator() {
        return new DataBufferIterator(this);
    }

    @Override
    public final Iterator<T> singleRefIterator() {
        return this.iterator();
    }

    public final void computeCounts() {
        int n = 0;
        this.zzng.clear();
        int n2 = this.zznf.size();
        for (int i = 0; i < n2; ++i) {
            DataBuffer<T> dataBuffer = this.zznf.get(i);
            if (dataBuffer != null) {
                n += dataBuffer.getCount();
            }
            this.zzng.add(n);
        }
        this.zznh = n;
    }

    public static <T> ConcatenatedDataBuffer<T> extend(ConcatenatedDataBuffer<T> concatenatedDataBuffer, DataBuffer<T> dataBuffer) {
        ConcatenatedDataBuffer<T> concatenatedDataBuffer2 = new ConcatenatedDataBuffer<T>();
        ArrayList<DataBuffer<T>> arrayList = concatenatedDataBuffer.zznf;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            DataBuffer<T> dataBuffer2 = arrayList.get(i);
            DataBuffer<T> dataBuffer3 = dataBuffer2;
            concatenatedDataBuffer2.append(dataBuffer3);
        }
        concatenatedDataBuffer2.append(dataBuffer);
        return concatenatedDataBuffer2;
    }

    @Override
    public final void filterOut(String string2) {
        int n = this.zznf.size();
        for (int i = 0; i < n; ++i) {
            DataBuffer<T> dataBuffer = this.zznf.get(i);
            if (!(dataBuffer instanceof ExclusionFilterable)) continue;
            ((ExclusionFilterable)((Object)dataBuffer)).filterOut(string2);
        }
        this.computeCounts();
    }

    @Override
    public final void unfilter(String string2) {
        int n = this.zznf.size();
        for (int i = 0; i < n; ++i) {
            DataBuffer<T> dataBuffer = this.zznf.get(i);
            if (!(dataBuffer instanceof ExclusionFilterable)) continue;
            ((ExclusionFilterable)((Object)dataBuffer)).unfilter(string2);
        }
        this.computeCounts();
    }

    @Override
    public final void clearFilters() {
        int n = this.zznf.size();
        for (int i = 0; i < n; ++i) {
            DataBuffer<T> dataBuffer = this.zznf.get(i);
            if (!(dataBuffer instanceof ExclusionFilterable)) continue;
            ((ExclusionFilterable)((Object)dataBuffer)).clearFilters();
        }
        this.computeCounts();
    }

    @Override
    public final void setFilterTerm(Context context, String string2) {
        int n = this.zznf.size();
        for (int i = 0; i < n; ++i) {
            DataBuffer<T> dataBuffer = this.zznf.get(i);
            if (!(dataBuffer instanceof TextFilterable)) continue;
            ((TextFilterable)((Object)dataBuffer)).setFilterTerm(context, string2);
        }
        this.computeCounts();
    }

    @Override
    public final void setFilterTerm(Context context, TextFilterable.StringFilter stringFilter, String string2) {
        int n = this.zznf.size();
        for (int i = 0; i < n; ++i) {
            DataBuffer<T> dataBuffer = this.zznf.get(i);
            if (!(dataBuffer instanceof TextFilterable)) continue;
            ((TextFilterable)((Object)dataBuffer)).setFilterTerm(context, stringFilter, string2);
        }
        this.computeCounts();
    }
}

