/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.api.internal.SignInConnectionListener;
import com.google.android.gms.common.api.internal.zzav;
import com.google.android.gms.common.api.internal.zzbd;
import com.google.android.gms.common.api.internal.zzbp;
import com.google.android.gms.common.api.internal.zzp;
import com.google.android.gms.common.api.internal.zzs;
import com.google.android.gms.common.api.internal.zzt;
import com.google.android.gms.common.api.internal.zzu;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.signin.SignInClient;
import com.google.android.gms.signin.SignInOptions;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import javax.annotation.concurrent.GuardedBy;

final class zzr
implements zzbp {
    private final Context mContext;
    private final zzav zzfq;
    private final Looper zzcn;
    private final zzbd zzfr;
    private final zzbd zzfs;
    private final Map<Api.AnyClientKey<?>, zzbd> zzft;
    private final Set<SignInConnectionListener> zzfu = Collections.newSetFromMap(new WeakHashMap());
    private final Api.Client zzfv;
    private Bundle zzfw;
    private ConnectionResult zzfx = null;
    private ConnectionResult zzfy = null;
    private boolean zzfz = false;
    private final Lock zzga;
    @GuardedBy(value="mLock")
    private int zzgb = 0;

    public static zzr zza(Context context, zzav zzav2, Lock lock, Looper looper, GoogleApiAvailabilityLight googleApiAvailabilityLight, Map<Api.AnyClientKey<?>, Api.Client> map, ClientSettings clientSettings, Map<Api<?>, Boolean> map2, Api.AbstractClientBuilder<? extends SignInClient, SignInOptions> abstractClientBuilder, ArrayList<zzp> arrayList) {
        Object object;
        Api.Client client = null;
        ArrayMap arrayMap2 = new ArrayMap();
        ArrayMap arrayMap3 = new ArrayMap();
        for (Map.Entry<Api.AnyClientKey<?>, Api.Client> arrayMap4 : map.entrySet()) {
            object = arrayMap4.getValue();
            if (object.providesSignIn()) {
                client = object;
            }
            if (object.requiresSignIn()) {
                arrayMap2.put(arrayMap4.getKey(), object);
                continue;
            }
            arrayMap3.put(arrayMap4.getKey(), object);
        }
        Preconditions.checkState((!arrayMap2.isEmpty() ? 1 : 0) != 0, (Object)"CompositeGoogleApiClient should not be used without any APIs that require sign-in.");
        ArrayMap arrayMap5 = new ArrayMap();
        ArrayMap arrayMap = new ArrayMap();
        for (Api api : map2.keySet()) {
            Api.AnyClientKey<?> anyClientKey = api.getClientKey();
            if (arrayMap2.containsKey(anyClientKey)) {
                arrayMap5.put(api, map2.get(api));
                continue;
            }
            if (arrayMap3.containsKey(anyClientKey)) {
                arrayMap.put(api, map2.get(api));
                continue;
            }
            throw new IllegalStateException("Each API in the isOptionalMap must have a corresponding client in the clients map.");
        }
        object = new ArrayList<zzp>();
        ArrayList<zzp> arrayList2 = new ArrayList<zzp>();
        ArrayList<zzp> arrayList3 = arrayList;
        int n = arrayList3.size();
        for (int i = 0; i < n; ++i) {
            zzp zzp2 = arrayList3.get(i);
            zzp zzp3 = zzp2;
            if (arrayMap5.containsKey(zzp3.mApi)) {
                ((ArrayList)object).add(zzp3);
                continue;
            }
            if (arrayMap.containsKey(zzp3.mApi)) {
                arrayList2.add(zzp3);
                continue;
            }
            throw new IllegalStateException("Each ClientCallbacks must have a corresponding API in the isOptionalMap");
        }
        return new zzr(context, zzav2, lock, looper, googleApiAvailabilityLight, (Map<Api.AnyClientKey<?>, Api.Client>)arrayMap2, (Map<Api.AnyClientKey<?>, Api.Client>)arrayMap3, clientSettings, abstractClientBuilder, client, (ArrayList<zzp>)object, arrayList2, (Map<Api<?>, Boolean>)arrayMap5, (Map<Api<?>, Boolean>)arrayMap);
    }

    private zzr(Context context, zzav zzav2, Lock lock, Looper looper, GoogleApiAvailabilityLight googleApiAvailabilityLight, Map<Api.AnyClientKey<?>, Api.Client> map, Map<Api.AnyClientKey<?>, Api.Client> map2, ClientSettings clientSettings, Api.AbstractClientBuilder<? extends SignInClient, SignInOptions> abstractClientBuilder, Api.Client client, ArrayList<zzp> arrayList, ArrayList<zzp> arrayList2, Map<Api<?>, Boolean> map3, Map<Api<?>, Boolean> map4) {
        this.mContext = context;
        this.zzfq = zzav2;
        this.zzga = lock;
        this.zzcn = looper;
        this.zzfv = client;
        this.zzfr = new zzbd(context, this.zzfq, lock, looper, googleApiAvailabilityLight, map2, null, map4, null, arrayList2, new zzt(this, null));
        this.zzfs = new zzbd(context, this.zzfq, lock, looper, googleApiAvailabilityLight, map, clientSettings, map3, abstractClientBuilder, arrayList, new zzu(this, null));
        ArrayMap arrayMap = new ArrayMap();
        for (Api.AnyClientKey<?> anyClientKey : map2.keySet()) {
            arrayMap.put(anyClientKey, (Object)this.zzfr);
        }
        for (Api.AnyClientKey<?> anyClientKey : map.keySet()) {
            arrayMap.put(anyClientKey, (Object)this.zzfs);
        }
        this.zzft = Collections.unmodifiableMap(arrayMap);
    }

    @Override
    @GuardedBy(value="mLock")
    public final <A extends Api.AnyClient, R extends Result, T extends BaseImplementation.ApiMethodImpl<R, A>> T enqueue(@NonNull T t) {
        if (this.zza(t)) {
            if (this.zzac()) {
                t.setFailedResult(new Status(4, null, this.zzad()));
                return t;
            }
            return this.zzfs.enqueue(t);
        }
        return this.zzfr.enqueue(t);
    }

    @Override
    @GuardedBy(value="mLock")
    public final <A extends Api.AnyClient, T extends BaseImplementation.ApiMethodImpl<? extends Result, A>> T execute(@NonNull T t) {
        if (this.zza(t)) {
            if (this.zzac()) {
                t.setFailedResult(new Status(4, null, this.zzad()));
                return t;
            }
            return this.zzfs.execute(t);
        }
        return this.zzfr.execute(t);
    }

    @Override
    @GuardedBy(value="mLock")
    @Nullable
    public final ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        if (this.zzft.get(api.getClientKey()).equals(this.zzfs)) {
            if (this.zzac()) {
                return new ConnectionResult(4, this.zzad());
            }
            return this.zzfs.getConnectionResult(api);
        }
        return this.zzfr.getConnectionResult(api);
    }

    @Override
    @GuardedBy(value="mLock")
    public final void connect() {
        this.zzgb = 2;
        this.zzfz = false;
        zzr zzr2 = this;
        this.zzfy = null;
        zzr2.zzfx = null;
        zzr2.zzfr.connect();
        zzr2.zzfs.connect();
    }

    @Override
    @GuardedBy(value="mLock")
    public final ConnectionResult blockingConnect() {
        throw new UnsupportedOperationException();
    }

    @Override
    @GuardedBy(value="mLock")
    public final ConnectionResult blockingConnect(long l, @NonNull TimeUnit timeUnit) {
        throw new UnsupportedOperationException();
    }

    @Override
    @GuardedBy(value="mLock")
    public final void disconnect() {
        this.zzfy = null;
        this.zzfx = null;
        this.zzgb = 0;
        this.zzfr.disconnect();
        this.zzfs.disconnect();
        this.zzab();
    }

    @Override
    public final boolean isConnected() {
        this.zzga.lock();
        try {
            boolean bl = this.zzfr.isConnected() && (this.zzfs.isConnected() || this.zzac() || this.zzgb == 1);
            return bl;
        }
        finally {
            this.zzga.unlock();
        }
    }

    @Override
    public final boolean isConnecting() {
        this.zzga.lock();
        try {
            boolean bl = this.zzgb == 2;
            return bl;
        }
        finally {
            this.zzga.unlock();
        }
    }

    @Override
    public final boolean maybeSignIn(SignInConnectionListener signInConnectionListener) {
        this.zzga.lock();
        try {
            if ((this.isConnecting() || this.isConnected()) && !this.zzfs.isConnected()) {
                this.zzfu.add(signInConnectionListener);
                if (this.zzgb == 0) {
                    this.zzgb = 1;
                }
                this.zzfy = null;
                this.zzfs.connect();
                return true;
            }
        }
        finally {
            this.zzga.unlock();
        }
        return false;
    }

    @Override
    @GuardedBy(value="mLock")
    public final void zzz() {
        this.zzfr.zzz();
        this.zzfs.zzz();
    }

    @Override
    public final void maybeSignOut() {
        this.zzga.lock();
        try {
            boolean bl = this.isConnecting();
            this.zzfs.disconnect();
            this.zzfy = new ConnectionResult(4);
            if (bl) {
                new Handler(this.zzcn).post((Runnable)new zzs(this));
            } else {
                this.zzab();
            }
            return;
        }
        finally {
            this.zzga.unlock();
        }
    }

    @GuardedBy(value="mLock")
    private final void zzaa() {
        if (zzr.zzb(this.zzfx)) {
            if (zzr.zzb(this.zzfy) || this.zzac()) {
                zzr zzr2 = this;
                switch (zzr2.zzgb) {
                    case 2: {
                        zzr2.zzfq.zzb(zzr2.zzfw);
                    }
                    case 1: {
                        zzr2.zzab();
                        break;
                    }
                    default: {
                        Log.wtf((String)"CompositeGAC", (String)"Attempted to call success callbacks in CONNECTION_MODE_NONE. Callbacks should be disabled via GmsClientSupervisor", (Throwable)((Object)new AssertionError()));
                    }
                }
                zzr2.zzgb = 0;
                return;
            }
            if (this.zzfy != null) {
                if (this.zzgb == 1) {
                    this.zzab();
                    return;
                }
                this.zza(this.zzfy);
                this.zzfr.disconnect();
                return;
            }
        } else {
            if (this.zzfx != null && zzr.zzb(this.zzfy)) {
                this.zzfs.disconnect();
                this.zza(this.zzfx);
                return;
            }
            if (this.zzfx != null && this.zzfy != null) {
                ConnectionResult connectionResult = this.zzfx;
                if (this.zzfs.zzje < this.zzfr.zzje) {
                    connectionResult = this.zzfy;
                }
                this.zza(connectionResult);
            }
        }
    }

    @GuardedBy(value="mLock")
    private final void zza(ConnectionResult connectionResult) {
        switch (this.zzgb) {
            case 2: {
                this.zzfq.zzc(connectionResult);
            }
            case 1: {
                this.zzab();
                break;
            }
            default: {
                Log.wtf((String)"CompositeGAC", (String)"Attempted to call failure callbacks in CONNECTION_MODE_NONE. Callbacks should be disabled via GmsClientSupervisor", (Throwable)new Exception());
            }
        }
        this.zzgb = 0;
    }

    @GuardedBy(value="mLock")
    private final void zzab() {
        Iterator<SignInConnectionListener> iterator = this.zzfu.iterator();
        while (iterator.hasNext()) {
            iterator.next().onComplete();
        }
        this.zzfu.clear();
    }

    @GuardedBy(value="mLock")
    private final void zza(int n, boolean bl) {
        this.zzfq.zzb(n, bl);
        this.zzfy = null;
        this.zzfx = null;
    }

    @GuardedBy(value="mLock")
    private final boolean zzac() {
        return this.zzfy != null && this.zzfy.getErrorCode() == 4;
    }

    private final boolean zza(BaseImplementation.ApiMethodImpl<? extends Result, ? extends Api.AnyClient> apiMethodImpl) {
        Api.AnyClientKey<? extends Api.AnyClient> anyClientKey = apiMethodImpl.getClientKey();
        Preconditions.checkArgument((boolean)this.zzft.containsKey(anyClientKey), (Object)"GoogleApiClient is not configured to use the API required for this call.");
        return this.zzft.get(anyClientKey).equals(this.zzfs);
    }

    @Nullable
    private final PendingIntent zzad() {
        if (this.zzfv == null) {
            return null;
        }
        return PendingIntent.getActivity((Context)this.mContext, (int)System.identityHashCode(this.zzfq), (Intent)this.zzfv.getSignInIntent(), (int)0x8000000);
    }

    private final void zza(Bundle bundle) {
        if (this.zzfw == null) {
            this.zzfw = bundle;
            return;
        }
        if (bundle != null) {
            this.zzfw.putAll(bundle);
        }
    }

    private static boolean zzb(ConnectionResult connectionResult) {
        return connectionResult != null && connectionResult.isSuccess();
    }

    @Override
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        printWriter.append(string2).append("authClient").println(":");
        this.zzfs.dump(String.valueOf(string2).concat("  "), fileDescriptor, printWriter, stringArray);
        printWriter.append(string2).append("anonClient").println(":");
        this.zzfr.dump(String.valueOf(string2).concat("  "), fileDescriptor, printWriter, stringArray);
    }

    static /* synthetic */ Lock zza(zzr zzr2) {
        return zzr2.zzga;
    }

    static /* synthetic */ void zzb(zzr zzr2) {
        zzr2.zzaa();
    }

    static /* synthetic */ void zza(zzr zzr2, Bundle bundle) {
        zzr2.zza(bundle);
    }

    static /* synthetic */ ConnectionResult zza(zzr zzr2, ConnectionResult connectionResult) {
        zzr2.zzfx = connectionResult;
        return zzr2.zzfx;
    }

    static /* synthetic */ boolean zzc(zzr zzr2) {
        return zzr2.zzfz;
    }

    static /* synthetic */ ConnectionResult zzd(zzr zzr2) {
        return zzr2.zzfy;
    }

    static /* synthetic */ boolean zza(zzr zzr2, boolean bl) {
        zzr2.zzfz = bl;
        return zzr2.zzfz;
    }

    static /* synthetic */ void zza(zzr zzr2, int n, boolean bl) {
        zzr2.zza(n, bl);
    }

    static /* synthetic */ zzbd zze(zzr zzr2) {
        return zzr2.zzfs;
    }

    static /* synthetic */ ConnectionResult zzb(zzr zzr2, ConnectionResult connectionResult) {
        zzr2.zzfy = connectionResult;
        return zzr2.zzfy;
    }

    static /* synthetic */ zzbd zzf(zzr zzr2) {
        return zzr2.zzfr;
    }
}

