/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.internal.LifecycleCallback;
import com.google.android.gms.common.api.internal.LifecycleFragment;
import com.google.android.gms.common.api.internal.zzl;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.util.VisibleForTesting;
import java.util.concurrent.atomic.AtomicReference;

public abstract class zzk
extends LifecycleCallback
implements DialogInterface.OnCancelListener {
    protected volatile boolean mStarted;
    protected final AtomicReference<zzl> zzer = new AtomicReference<Object>(null);
    private final Handler zzes = new Handler(Looper.getMainLooper());
    protected final GoogleApiAvailability zzdg;

    protected zzk(LifecycleFragment lifecycleFragment) {
        this(lifecycleFragment, GoogleApiAvailability.getInstance());
    }

    @VisibleForTesting
    private zzk(LifecycleFragment lifecycleFragment, GoogleApiAvailability googleApiAvailability) {
        super(lifecycleFragment);
        this.zzdg = googleApiAvailability;
    }

    public void onCancel(DialogInterface dialogInterface) {
        this.zza(new ConnectionResult(13, null), zzk.zza(this.zzer.get()));
        this.zzt();
    }

    public final void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        if (bundle != null) {
            zzl zzl2;
            Bundle bundle2 = bundle;
            if (bundle2.getBoolean("resolving_error", false)) {
                ConnectionResult connectionResult = new ConnectionResult(bundle2.getInt("failed_status"), (PendingIntent)bundle2.getParcelable("failed_resolution"));
                int n = bundle2.getInt("failed_client_id", -1);
                zzl2 = new zzl(connectionResult, n);
            } else {
                zzl2 = null;
            }
            this.zzer.set(zzl2);
        }
    }

    public final void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        Bundle bundle2 = bundle;
        zzl zzl2 = this.zzer.get();
        if (zzl2 != null) {
            bundle2.putBoolean("resolving_error", true);
            bundle2.putInt("failed_client_id", zzl2.zzu());
            bundle2.putInt("failed_status", zzl2.getConnectionResult().getErrorCode());
            bundle2.putParcelable("failed_resolution", (Parcelable)zzl2.getConnectionResult().getResolution());
        }
    }

    public void onStart() {
        super.onStart();
        this.mStarted = true;
    }

    public final void onActivityResult(int n, int n2, Intent intent) {
        boolean bl = false;
        zzl zzl2 = this.zzer.get();
        switch (n) {
            case 2: {
                int n3 = this.zzdg.isGooglePlayServicesAvailable((Context)this.getActivity());
                if (n3 == 0) {
                    bl = true;
                }
                if (zzl2 == null) {
                    return;
                }
                if (zzl2.getConnectionResult().getErrorCode() != 18 || n3 != 18) break;
                return;
            }
            case 1: {
                if (n2 == -1) {
                    bl = true;
                    break;
                }
                if (n2 != 0) break;
                int n4 = 13;
                if (intent != null) {
                    n4 = intent.getIntExtra("<<ResolutionFailureErrorDetail>>", 13);
                }
                zzl2 = new zzl(new ConnectionResult(n4, null), zzk.zza(zzl2));
                this.zzer.set(zzl2);
            }
        }
        if (bl) {
            this.zzt();
            return;
        }
        if (zzl2 != null) {
            this.zza(zzl2.getConnectionResult(), zzl2.zzu());
        }
    }

    public void onStop() {
        super.onStop();
        this.mStarted = false;
    }

    protected abstract void zza(ConnectionResult var1, int var2);

    protected abstract void zzr();

    protected final void zzt() {
        this.zzer.set(null);
        this.zzr();
    }

    public final void zzb(ConnectionResult connectionResult, int n) {
        zzl zzl2 = new zzl(connectionResult, n);
        if (this.zzer.compareAndSet(null, zzl2)) {
            this.zzes.post((Runnable)new zzm(this, zzl2));
        }
    }

    private static int zza(@Nullable zzl zzl2) {
        if (zzl2 == null) {
            return -1;
        }
        return zzl2.zzu();
    }
}

