/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.BinderThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.internal.zzbz;
import com.google.android.gms.common.api.internal.zzca;
import com.google.android.gms.common.api.internal.zzcb;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ResolveAccountResponse;
import com.google.android.gms.signin.SignIn;
import com.google.android.gms.signin.SignInClient;
import com.google.android.gms.signin.SignInOptions;
import com.google.android.gms.signin.internal.BaseSignInCallbacks;
import com.google.android.gms.signin.internal.SignInResponse;
import java.util.Set;

public final class zzby
extends BaseSignInCallbacks
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener {
    private static Api.AbstractClientBuilder<? extends SignInClient, SignInOptions> zzlv = SignIn.CLIENT_BUILDER;
    private final Context mContext;
    private final Handler mHandler;
    private final Api.AbstractClientBuilder<? extends SignInClient, SignInOptions> zzby;
    private Set<Scope> mScopes;
    private ClientSettings zzgf;
    private SignInClient zzhn;
    private zzcb zzlw;

    @WorkerThread
    public zzby(Context context, Handler handler, @NonNull ClientSettings clientSettings) {
        this(context, handler, clientSettings, zzlv);
    }

    @WorkerThread
    public zzby(Context context, Handler handler, @NonNull ClientSettings clientSettings, Api.AbstractClientBuilder<? extends SignInClient, SignInOptions> abstractClientBuilder) {
        this.mContext = context;
        this.mHandler = handler;
        this.zzgf = (ClientSettings)Preconditions.checkNotNull((Object)clientSettings, (Object)"ClientSettings must not be null");
        this.mScopes = clientSettings.getRequiredScopes();
        this.zzby = abstractClientBuilder;
    }

    @WorkerThread
    public final void zza(zzcb zzcb2) {
        if (this.zzhn != null) {
            this.zzhn.disconnect();
        }
        this.zzgf.setClientSessionId(System.identityHashCode(this));
        this.zzhn = this.zzby.buildClient(this.mContext, this.mHandler.getLooper(), this.zzgf, this.zzgf.getSignInOptions(), this, this);
        this.zzlw = zzcb2;
        if (this.mScopes == null || this.mScopes.isEmpty()) {
            this.mHandler.post((Runnable)new zzbz(this));
            return;
        }
        this.zzhn.connect();
    }

    public final SignInClient zzbt() {
        return this.zzhn;
    }

    public final void zzbz() {
        if (this.zzhn != null) {
            this.zzhn.disconnect();
        }
    }

    @Override
    @WorkerThread
    public final void onConnected(@Nullable Bundle bundle) {
        this.zzhn.signIn(this);
    }

    @Override
    @WorkerThread
    public final void onConnectionSuspended(int n) {
        this.zzhn.disconnect();
    }

    @Override
    @WorkerThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        this.zzlw.zzg(connectionResult);
    }

    @Override
    @BinderThread
    public final void onSignInComplete(SignInResponse signInResponse) {
        this.mHandler.post((Runnable)new zzca(this, signInResponse));
    }

    @WorkerThread
    private final void zzb(SignInResponse signInResponse) {
        ConnectionResult connectionResult = signInResponse.getConnectionResult();
        if (connectionResult.isSuccess()) {
            ResolveAccountResponse resolveAccountResponse = signInResponse.getResolveAccountResponse();
            ConnectionResult connectionResult2 = resolveAccountResponse.getConnectionResult();
            if (!connectionResult2.isSuccess()) {
                String string2 = String.valueOf(connectionResult2);
                Log.wtf((String)"SignInCoordinator", (String)new StringBuilder(48 + String.valueOf(string2).length()).append("Sign-in succeeded with resolve account failure: ").append(string2).toString(), (Throwable)new Exception());
                this.zzlw.zzg(connectionResult2);
                this.zzhn.disconnect();
                return;
            }
            this.zzlw.zza(resolveAccountResponse.getAccountAccessor(), this.mScopes);
        } else {
            this.zzlw.zzg(connectionResult);
        }
        this.zzhn.disconnect();
    }

    static /* synthetic */ zzcb zza(zzby zzby2) {
        return zzby2.zzlw;
    }

    static /* synthetic */ void zza(zzby zzby2, SignInResponse signInResponse) {
        zzby2.zzb(signInResponse);
    }
}

