/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.GuardedBy;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.NotificationCompat;
import android.util.Log;
import android.util.TypedValue;
import android.view.View;
import android.widget.ProgressBar;
import com.google.android.gms.base.R;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.ErrorDialogFragment;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.SupportErrorDialogFragment;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.GoogleApiActivity;
import com.google.android.gms.common.api.internal.GoogleApiManager;
import com.google.android.gms.common.api.internal.GooglePlayServicesUpdatedReceiver;
import com.google.android.gms.common.api.internal.LifecycleFragment;
import com.google.android.gms.common.api.internal.zzbt;
import com.google.android.gms.common.api.internal.zzh;
import com.google.android.gms.common.internal.ConnectionErrorMessages;
import com.google.android.gms.common.internal.DialogRedirect;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.DeviceProperties;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public class GoogleApiAvailability
extends GoogleApiAvailabilityLight {
    private static final Object mLock = new Object();
    private static final GoogleApiAvailability zzas = new GoogleApiAvailability();
    @GuardedBy(value="mLock")
    private String zzat;
    public static final int GOOGLE_PLAY_SERVICES_VERSION_CODE = GoogleApiAvailabilityLight.GOOGLE_PLAY_SERVICES_VERSION_CODE;
    public static final String GOOGLE_PLAY_SERVICES_PACKAGE = "com.google.android.gms";

    public static GoogleApiAvailability getInstance() {
        return zzas;
    }

    GoogleApiAvailability() {
    }

    @MainThread
    public Task<Void> makeGooglePlayServicesAvailable(Activity activity) {
        Preconditions.checkMainThread((String)"makeGooglePlayServicesAvailable must be called from the main thread");
        int n = this.isGooglePlayServicesAvailable((Context)activity);
        if (n == 0) {
            return Tasks.forResult(null);
        }
        zzbt zzbt2 = zzbt.zzd(activity);
        ConnectionResult connectionResult = new ConnectionResult(n, null);
        zzbt2.zzb(connectionResult, 0);
        return zzbt2.getTask();
    }

    public Dialog getErrorDialog(Activity activity, int n, int n2) {
        return this.getErrorDialog(activity, n, n2, null);
    }

    public Dialog getErrorDialog(Activity activity, int n, int n2, DialogInterface.OnCancelListener onCancelListener) {
        Intent intent = this.getErrorResolutionIntent((Context)activity, n, "d");
        return GoogleApiAvailability.zza((Context)activity, n, DialogRedirect.getInstance(activity, intent, n2), onCancelListener);
    }

    public boolean showErrorDialogFragment(Activity activity, int n, int n2) {
        return this.showErrorDialogFragment(activity, n, n2, null);
    }

    public boolean showErrorDialogFragment(Activity activity, @NonNull LifecycleFragment lifecycleFragment, int n, int n2, DialogInterface.OnCancelListener onCancelListener) {
        Intent intent = this.getErrorResolutionIntent((Context)activity, n, "d");
        Dialog dialog = GoogleApiAvailability.zza((Context)activity, n, DialogRedirect.getInstance(lifecycleFragment, intent, n2), onCancelListener);
        if (dialog == null) {
            return false;
        }
        GoogleApiAvailability.zza(activity, dialog, "GooglePlayServicesErrorDialog", onCancelListener);
        return true;
    }

    public boolean showErrorDialogFragment(Activity activity, int n, int n2, DialogInterface.OnCancelListener onCancelListener) {
        Dialog dialog = this.getErrorDialog(activity, n, n2, onCancelListener);
        if (dialog == null) {
            return false;
        }
        GoogleApiAvailability.zza(activity, dialog, "GooglePlayServicesErrorDialog", onCancelListener);
        return true;
    }

    public void showErrorNotification(Context context, int n) {
        this.showErrorNotification(context, n, null);
    }

    public void showErrorNotification(Context context, int n, String string2) {
        PendingIntent pendingIntent = this.getErrorResolutionPendingIntent(context, n, 0, "n");
        this.zza(context, n, string2, pendingIntent);
    }

    public void showErrorNotification(Context context, ConnectionResult connectionResult) {
        PendingIntent pendingIntent = this.getErrorResolutionPendingIntent(context, connectionResult);
        this.zza(context, connectionResult.getErrorCode(), null, pendingIntent);
    }

    public boolean showWrappedErrorNotification(Context context, ConnectionResult connectionResult, int n) {
        PendingIntent pendingIntent = this.getErrorResolutionPendingIntent(context, connectionResult);
        if (pendingIntent != null) {
            this.zza(context, connectionResult.getErrorCode(), null, GoogleApiActivity.zza(context, pendingIntent, n));
            return true;
        }
        return false;
    }

    public Dialog showUpdatingDialog(Activity activity, DialogInterface.OnCancelListener onCancelListener) {
        ProgressBar progressBar = new ProgressBar((Context)activity, null, 16842874);
        progressBar.setIndeterminate(true);
        progressBar.setVisibility(0);
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)activity);
        builder.setView((View)progressBar);
        builder.setMessage((CharSequence)ConnectionErrorMessages.getErrorMessage((Context)activity, 18));
        builder.setPositiveButton((CharSequence)"", null);
        AlertDialog alertDialog = builder.create();
        GoogleApiAvailability.zza(activity, (Dialog)alertDialog, "GooglePlayServicesUpdatingDialog", onCancelListener);
        return alertDialog;
    }

    @Nullable
    public GooglePlayServicesUpdatedReceiver registerCallbackOnUpdate(Context context, GooglePlayServicesUpdatedReceiver.Callback callback) {
        IntentFilter intentFilter = new IntentFilter("android.intent.action.PACKAGE_ADDED");
        intentFilter.addDataScheme("package");
        GooglePlayServicesUpdatedReceiver googlePlayServicesUpdatedReceiver = new GooglePlayServicesUpdatedReceiver(callback);
        context.registerReceiver((BroadcastReceiver)googlePlayServicesUpdatedReceiver, intentFilter);
        googlePlayServicesUpdatedReceiver.zzc(context);
        if (!this.isUninstalledAppPossiblyUpdating(context, GOOGLE_PLAY_SERVICES_PACKAGE)) {
            callback.zzv();
            googlePlayServicesUpdatedReceiver.unregister();
            return null;
        }
        return googlePlayServicesUpdatedReceiver;
    }

    public Task<Void> checkApiAvailability(GoogleApi<?> googleApi, GoogleApi<?> ... googleApiArray) {
        return this.checkApiAvailabilityAndPackages(googleApi, googleApiArray).continueWith((Continuation)new com.google.android.gms.common.zza(this));
    }

    public Task<Map<zzh<?>, String>> checkApiAvailabilityAndPackages(GoogleApi<?> googleApi, GoogleApi<?> ... googleApiArray) {
        Preconditions.checkNotNull(googleApi, (Object)"Requested API must not be null.");
        Object object = googleApiArray;
        int n = googleApiArray.length;
        for (int i = 0; i < n; ++i) {
            Preconditions.checkNotNull(object[i], (Object)"Requested API must not be null.");
        }
        object = new ArrayList(googleApiArray.length + 1);
        object.add(googleApi);
        object.addAll(Arrays.asList(googleApiArray));
        return GoogleApiManager.zzbf().zza((Iterable<? extends GoogleApi<?>>)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting(otherwise=2)
    private final String zzb() {
        Object object = mLock;
        synchronized (object) {
            return this.zzat;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=26)
    public void setDefaultNotificationChannelId(@NonNull Context context, @NonNull String string2) {
        if (PlatformVersion.isAtLeastO()) {
            Preconditions.checkNotNull((Object)((NotificationManager)context.getSystemService("notification")).getNotificationChannel(string2));
        }
        Object object = mLock;
        synchronized (object) {
            this.zzat = string2;
            return;
        }
    }

    public int isGooglePlayServicesAvailable(Context context) {
        return super.isGooglePlayServicesAvailable(context);
    }

    public int isGooglePlayServicesAvailable(Context context, int n) {
        return super.isGooglePlayServicesAvailable(context, n);
    }

    public final boolean isUserResolvableError(int n) {
        return super.isUserResolvableError(n);
    }

    @Deprecated
    @Nullable
    public Intent getErrorResolutionIntent(int n) {
        return super.getErrorResolutionIntent(n);
    }

    @Nullable
    public Intent getErrorResolutionIntent(Context context, int n, @Nullable String string2) {
        return super.getErrorResolutionIntent(context, n, string2);
    }

    @Nullable
    public PendingIntent getErrorResolutionPendingIntent(Context context, int n, int n2) {
        return super.getErrorResolutionPendingIntent(context, n, n2);
    }

    @Nullable
    public PendingIntent getErrorResolutionPendingIntent(Context context, ConnectionResult connectionResult) {
        if (connectionResult.hasResolution()) {
            return connectionResult.getResolution();
        }
        return this.getErrorResolutionPendingIntent(context, connectionResult.getErrorCode(), 0);
    }

    @Nullable
    public PendingIntent getErrorResolutionPendingIntent(Context context, int n, int n2, @Nullable String string2) {
        return super.getErrorResolutionPendingIntent(context, n, n2, string2);
    }

    public int getClientVersion(Context context) {
        return super.getClientVersion(context);
    }

    public int getApkVersion(Context context) {
        return super.getApkVersion(context);
    }

    public boolean isPlayServicesPossiblyUpdating(Context context, int n) {
        return super.isPlayServicesPossiblyUpdating(context, n);
    }

    public boolean isPlayStorePossiblyUpdating(Context context, int n) {
        return super.isPlayStorePossiblyUpdating(context, n);
    }

    public final String getErrorString(int n) {
        return super.getErrorString(n);
    }

    static Dialog zza(Context context, int n, DialogRedirect dialogRedirect, DialogInterface.OnCancelListener onCancelListener) {
        String string2;
        String string3;
        if (n == 0) {
            return null;
        }
        AlertDialog.Builder builder = null;
        TypedValue typedValue = new TypedValue();
        context.getTheme().resolveAttribute(16843529, typedValue, true);
        String string4 = context.getResources().getResourceEntryName(typedValue.resourceId);
        if ("Theme.Dialog.Alert".equals(string4)) {
            builder = new AlertDialog.Builder(context, 5);
        }
        if (builder == null) {
            builder = new AlertDialog.Builder(context);
        }
        builder.setMessage((CharSequence)ConnectionErrorMessages.getErrorMessage(context, n));
        if (onCancelListener != null) {
            builder.setOnCancelListener(onCancelListener);
        }
        if ((string3 = ConnectionErrorMessages.getErrorDialogButtonMessage(context, n)) != null) {
            builder.setPositiveButton((CharSequence)string3, (DialogInterface.OnClickListener)dialogRedirect);
        }
        if ((string2 = ConnectionErrorMessages.getErrorTitle(context, n)) != null) {
            builder.setTitle((CharSequence)string2);
        }
        return builder.create();
    }

    static void zza(Activity activity, Dialog dialog, String string2, DialogInterface.OnCancelListener onCancelListener) {
        boolean bl = activity instanceof FragmentActivity;
        if (bl) {
            FragmentManager fragmentManager = ((FragmentActivity)activity).getSupportFragmentManager();
            SupportErrorDialogFragment.newInstance(dialog, onCancelListener).show(fragmentManager, string2);
            return;
        }
        android.app.FragmentManager fragmentManager = activity.getFragmentManager();
        ErrorDialogFragment.newInstance(dialog, onCancelListener).show(fragmentManager, string2);
    }

    @TargetApi(value=20)
    private final void zza(Context context, int n, String string2, PendingIntent pendingIntent) {
        int n2;
        Notification notification;
        Notification.Builder builder;
        if (n == 18) {
            this.zza(context);
            return;
        }
        if (pendingIntent == null) {
            if (n == 6) {
                Log.w((String)"GoogleApiAvailability", (String)"Missing resolution for ConnectionResult.RESOLUTION_REQUIRED. Call GoogleApiAvailability#showErrorNotification(Context, ConnectionResult) instead.");
            }
            return;
        }
        String string3 = ConnectionErrorMessages.getErrorNotificationTitle(context, n);
        String string4 = ConnectionErrorMessages.getErrorNotificationMessage(context, n);
        Resources resources = context.getResources();
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        if (DeviceProperties.isWearable((Context)context)) {
            Preconditions.checkState((boolean)PlatformVersion.isAtLeastKitKatWatch());
            builder = new Notification.Builder(context).setSmallIcon(context.getApplicationInfo().icon).setPriority(2).setAutoCancel(true).setContentTitle((CharSequence)string3).setStyle((Notification.Style)new Notification.BigTextStyle().bigText((CharSequence)string4));
            if (DeviceProperties.isWearableWithoutPlayStore((Context)context)) {
                builder.addAction(R.drawable.common_full_open_on_phone, (CharSequence)resources.getString(R.string.common_open_on_phone), pendingIntent);
            } else {
                builder.setContentIntent(pendingIntent);
            }
            if (PlatformVersion.isAtLeastO()) {
                Notification.Builder builder2 = builder;
                NotificationManager notificationManager2 = notificationManager;
                Context context2 = context;
                GoogleApiAvailability googleApiAvailability = this;
                if (PlatformVersion.isAtLeastO()) {
                    String string5 = googleApiAvailability.zza(context2, notificationManager2);
                    builder2.setChannelId(string5);
                }
            }
            notification = builder.build();
        } else {
            builder = new NotificationCompat.Builder(context).setSmallIcon(17301642).setTicker((CharSequence)resources.getString(R.string.common_google_play_services_notification_ticker)).setWhen(System.currentTimeMillis()).setAutoCancel(true).setContentIntent(pendingIntent).setContentTitle((CharSequence)string3).setContentText((CharSequence)string4).setLocalOnly(true).setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)string4));
            if (PlatformVersion.isAtLeastO()) {
                Notification.Builder builder3 = builder;
                NotificationManager notificationManager3 = notificationManager;
                Context context3 = context;
                GoogleApiAvailability googleApiAvailability = this;
                if (PlatformVersion.isAtLeastO()) {
                    String string6 = googleApiAvailability.zza(context3, notificationManager3);
                    builder3.setChannelId(string6);
                }
            }
            notification = builder.build();
        }
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                n2 = 10436;
                GooglePlayServicesUtilLight.zzbt.set(false);
                break;
            }
            default: {
                n2 = 39789;
            }
        }
        if (string2 == null) {
            notificationManager.notify(n2, notification);
            return;
        }
        notificationManager.notify(string2, n2, notification);
    }

    @TargetApi(value=26)
    private final String zza(Context context, NotificationManager notificationManager) {
        Preconditions.checkState((boolean)PlatformVersion.isAtLeastO());
        String string2 = this.zzb();
        if (string2 == null) {
            string2 = "com.google.android.gms.availability";
            NotificationChannel notificationChannel = notificationManager.getNotificationChannel(string2);
            String string3 = ConnectionErrorMessages.getDefaultNotificationChannelName(context);
            if (notificationChannel == null) {
                notificationManager.createNotificationChannel(new NotificationChannel(string2, (CharSequence)string3, 4));
            } else if (!string3.equals(notificationChannel.getName())) {
                notificationChannel.setName((CharSequence)string3);
                notificationManager.createNotificationChannel(notificationChannel);
            }
        }
        return string2;
    }

    final void zza(Context context) {
        new zza(context).sendEmptyMessageDelayed(1, 120000L);
    }

    @SuppressLint(value={"HandlerLeak"})
    private final class zza
    extends Handler {
        private final Context zzau;

        public zza(Context context) {
            super(Looper.myLooper() == null ? Looper.getMainLooper() : Looper.myLooper());
            this.zzau = context.getApplicationContext();
        }

        public final void handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    int n = GoogleApiAvailability.this.isGooglePlayServicesAvailable(this.zzau);
                    if (!GoogleApiAvailability.this.isUserResolvableError(n)) break;
                    GoogleApiAvailability.this.showErrorNotification(this.zzau, n);
                    return;
                }
                default: {
                    int n = message.what;
                    Log.w((String)"GoogleApiAvailability", (String)new StringBuilder(50).append("Don't know how to handle this message: ").append(n).toString());
                }
            }
        }
    }
}

