/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.zzbay;
import com.google.android.gms.internal.zzbbi;
import com.google.android.gms.internal.zzbbj;
import com.google.android.gms.internal.zzbca;
import com.google.android.gms.internal.zzbcd;
import com.google.android.gms.internal.zzbco;
import com.google.android.gms.internal.zzbcp;
import com.google.android.gms.internal.zzbcw;
import com.google.android.gms.internal.zzbcy;
import com.google.android.gms.internal.zzbcz;
import com.google.android.gms.internal.zzbdp;
import com.google.android.gms.internal.zzbdq;
import com.google.android.gms.internal.zzbei;
import com.google.android.gms.internal.zzctk;
import com.google.android.gms.internal.zzctl;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

public final class zzbcx
implements zzbbj,
zzbdp {
    private final Lock zzaCv;
    private final Condition zzaDS;
    private final Context mContext;
    private final zze zzaCF;
    private final zzbcz zzaDT;
    final Map<Api.zzc<?>, Api.zze> zzaDF;
    final Map<Api.zzc<?>, ConnectionResult> zzaDU = new HashMap();
    private zzq zzaCA;
    private Map<Api<?>, Boolean> zzaCD;
    private Api.zza<? extends zzctk, zzctl> zzaBe;
    private volatile zzbcw zzaDV;
    private ConnectionResult zzaDW = null;
    int zzaDX;
    final zzbcp zzaCl;
    final zzbdq zzaDY;

    public zzbcx(Context context, zzbcp zzbcp2, Lock lock, Looper looper, zze zze2, Map<Api.zzc<?>, Api.zze> map, zzq zzq2, Map<Api<?>, Boolean> map2, Api.zza<? extends zzctk, zzctl> zza2, ArrayList<zzbbi> arrayList, zzbdq zzbdq2) {
        this.mContext = context;
        this.zzaCv = lock;
        this.zzaCF = zze2;
        this.zzaDF = map;
        this.zzaCA = zzq2;
        this.zzaCD = map2;
        this.zzaBe = zza2;
        this.zzaCl = zzbcp2;
        this.zzaDY = zzbdq2;
        ArrayList<zzbbi> arrayList2 = arrayList;
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            zzbbi zzbbi2 = arrayList2.get(i);
            zzbbi2.zza(this);
        }
        this.zzaDT = new zzbcz(this, looper);
        this.zzaDS = lock.newCondition();
        this.zzaDV = new zzbco(this);
    }

    @Override
    public final <A extends Api.zzb, R extends Result, T extends zzbay<R, A>> T zzd(@NonNull T t) {
        t.zzpC();
        return this.zzaDV.zzd(t);
    }

    @Override
    public final <A extends Api.zzb, T extends zzbay<? extends Result, A>> T zze(@NonNull T t) {
        t.zzpC();
        return this.zzaDV.zze(t);
    }

    @Override
    public final void connect() {
        this.zzaDV.connect();
    }

    @Override
    public final ConnectionResult blockingConnect() {
        this.connect();
        while (this.isConnecting()) {
            try {
                this.zzaDS.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.zzazX;
        }
        if (this.zzaDW != null) {
            return this.zzaDW;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public final ConnectionResult blockingConnect(long l, TimeUnit timeUnit) {
        this.connect();
        long l2 = timeUnit.toNanos(l);
        while (this.isConnecting()) {
            try {
                if (l2 <= 0L) {
                    this.disconnect();
                    return new ConnectionResult(14, null);
                }
                l2 = this.zzaDS.awaitNanos(l2);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.zzazX;
        }
        if (this.zzaDW != null) {
            return this.zzaDW;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public final void disconnect() {
        if (this.zzaDV.disconnect()) {
            this.zzaDU.clear();
        }
    }

    @Override
    @Nullable
    public final ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        Api.zzc<?> zzc2 = api.zzpd();
        if (this.zzaDF.containsKey(zzc2)) {
            if (this.zzaDF.get(zzc2).isConnected()) {
                return ConnectionResult.zzazX;
            }
            if (this.zzaDU.containsKey(zzc2)) {
                return this.zzaDU.get(zzc2);
            }
        }
        return null;
    }

    final void zzqh() {
        this.zzaCv.lock();
        try {
            this.zzaDV = new zzbcd(this, this.zzaCA, this.zzaCD, this.zzaCF, this.zzaBe, this.zzaCv, this.mContext);
            this.zzaDV.begin();
            this.zzaDS.signalAll();
            return;
        }
        finally {
            this.zzaCv.unlock();
        }
    }

    final void zzqi() {
        this.zzaCv.lock();
        try {
            this.zzaCl.zzqe();
            this.zzaDV = new zzbca(this);
            this.zzaDV.begin();
            this.zzaDS.signalAll();
            return;
        }
        finally {
            this.zzaCv.unlock();
        }
    }

    final void zzg(ConnectionResult connectionResult) {
        this.zzaCv.lock();
        try {
            this.zzaDW = connectionResult;
            this.zzaDV = new zzbco(this);
            this.zzaDV.begin();
            this.zzaDS.signalAll();
            return;
        }
        finally {
            this.zzaCv.unlock();
        }
    }

    @Override
    public final boolean isConnected() {
        return this.zzaDV instanceof zzbca;
    }

    @Override
    public final boolean isConnecting() {
        return this.zzaDV instanceof zzbcd;
    }

    @Override
    public final boolean zza(zzbei zzbei2) {
        return false;
    }

    @Override
    public final void zzpl() {
    }

    @Override
    public final void zzpE() {
        if (this.isConnected()) {
            ((zzbca)this.zzaDV).zzpU();
        }
    }

    @Override
    public final void zza(@NonNull ConnectionResult connectionResult, @NonNull Api<?> api, boolean bl) {
        this.zzaCv.lock();
        try {
            this.zzaDV.zza(connectionResult, api, bl);
            return;
        }
        finally {
            this.zzaCv.unlock();
        }
    }

    @Override
    public final void onConnected(@Nullable Bundle bundle) {
        this.zzaCv.lock();
        try {
            this.zzaDV.onConnected(bundle);
            return;
        }
        finally {
            this.zzaCv.unlock();
        }
    }

    @Override
    public final void onConnectionSuspended(int n) {
        this.zzaCv.lock();
        try {
            this.zzaDV.onConnectionSuspended(n);
            return;
        }
        finally {
            this.zzaCv.unlock();
        }
    }

    final void zza(zzbcy zzbcy2) {
        Message message = this.zzaDT.obtainMessage(1, zzbcy2);
        this.zzaDT.sendMessage(message);
    }

    final void zza(RuntimeException runtimeException) {
        Message message = this.zzaDT.obtainMessage(2, runtimeException);
        this.zzaDT.sendMessage(message);
    }

    @Override
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        String string3 = String.valueOf(string2).concat("  ");
        printWriter.append(string2).append("mState=").println(this.zzaDV);
        for (Api<?> api : this.zzaCD.keySet()) {
            printWriter.append(string2).append(api.getName()).println(":");
            this.zzaDF.get(api.zzpd()).dump(string3, fileDescriptor, printWriter, stringArray);
        }
    }

    static /* synthetic */ Lock zza(zzbcx zzbcx2) {
        return zzbcx2.zzaCv;
    }

    static /* synthetic */ zzbcw zzb(zzbcx zzbcx2) {
        return zzbcx2.zzaDV;
    }
}

