/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.ResultTransform;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.TransformedResult;
import com.google.android.gms.common.internal.zzao;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.internal.zzbbf;
import com.google.android.gms.internal.zzbbg;
import com.google.android.gms.internal.zzbbh;
import com.google.android.gms.internal.zzbes;
import com.google.android.gms.internal.zzbex;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public abstract class zzbbe<R extends Result>
extends PendingResult<R> {
    static final ThreadLocal<Boolean> zzaBV = new zzbbf();
    private final Object zzaBW = new Object();
    private zzbbg<R> zzaBX;
    private WeakReference<GoogleApiClient> zzaBY;
    private final CountDownLatch zztJ = new CountDownLatch(1);
    private final ArrayList<PendingResult.zza> zzaBZ = new ArrayList();
    private ResultCallback<? super R> zzaCa;
    private final AtomicReference<zzbex> zzaCb = new AtomicReference();
    private R zzaBj;
    private Status mStatus;
    private zzbbh zzaCc;
    private volatile boolean zzaCd;
    private boolean zzJ;
    private boolean zzaCe;
    private zzao zzaCf;
    private volatile zzbes<R> zzaCg;
    private boolean zzaCh = false;

    @Deprecated
    zzbbe() {
        this.zzaBX = new zzbbg(Looper.getMainLooper());
        this.zzaBY = new WeakReference<Object>(null);
    }

    protected zzbbe(GoogleApiClient googleApiClient) {
        Looper looper = googleApiClient != null ? googleApiClient.getLooper() : Looper.getMainLooper();
        this.zzaBX = new zzbbg(looper);
        this.zzaBY = new WeakReference<GoogleApiClient>(googleApiClient);
    }

    @Deprecated
    protected zzbbe(Looper looper) {
        this.zzaBX = new zzbbg(looper);
        this.zzaBY = new WeakReference<Object>(null);
    }

    public final boolean isReady() {
        return this.zztJ.getCount() == 0L;
    }

    @Override
    public final R await() {
        zzbo.zza((Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"await must not be called on the UI thread");
        zzbo.zza((!this.zzaCd ? 1 : 0) != 0, (Object)"Result has already been consumed");
        zzbo.zza((this.zzaCg == null ? 1 : 0) != 0, (Object)"Cannot await if then() has been called.");
        try {
            this.zztJ.await();
        }
        catch (InterruptedException interruptedException) {
            this.zzs(Status.zzaBn);
        }
        zzbo.zza((boolean)this.isReady(), (Object)"Result is not ready.");
        return this.get();
    }

    @Override
    public final R await(long l, TimeUnit timeUnit) {
        zzbo.zza((l <= 0L || Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"await must not be called on the UI thread when time is greater than zero.");
        zzbo.zza((!this.zzaCd ? 1 : 0) != 0, (Object)"Result has already been consumed.");
        zzbo.zza((this.zzaCg == null ? 1 : 0) != 0, (Object)"Cannot await if then() has been called.");
        try {
            if (!this.zztJ.await(l, timeUnit)) {
                this.zzs(Status.zzaBp);
            }
        }
        catch (InterruptedException interruptedException) {
            this.zzs(Status.zzaBn);
        }
        zzbo.zza((boolean)this.isReady(), (Object)"Result is not ready.");
        return this.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setResultCallback(ResultCallback<? super R> resultCallback) {
        Object object = this.zzaBW;
        synchronized (object) {
            if (resultCallback == null) {
                this.zzaCa = null;
                return;
            }
            zzbo.zza((!this.zzaCd ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            zzbo.zza((this.zzaCg == null ? 1 : 0) != 0, (Object)"Cannot set callbacks if then() has been called.");
            if (this.isCanceled()) {
                return;
            }
            if (this.isReady()) {
                this.zzaBX.zza(resultCallback, (R)this.get());
            } else {
                this.zzaCa = resultCallback;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setResultCallback(ResultCallback<? super R> resultCallback, long l, TimeUnit timeUnit) {
        Object object = this.zzaBW;
        synchronized (object) {
            if (resultCallback == null) {
                this.zzaCa = null;
                return;
            }
            zzbo.zza((!this.zzaCd ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            zzbo.zza((this.zzaCg == null ? 1 : 0) != 0, (Object)"Cannot set callbacks if then() has been called.");
            if (this.isCanceled()) {
                return;
            }
            if (this.isReady()) {
                this.zzaBX.zza(resultCallback, (R)this.get());
            } else {
                this.zzaCa = resultCallback;
                long l2 = timeUnit.toMillis(l);
                zzbbe zzbbe2 = this;
                zzbbg<R> zzbbg2 = this.zzaBX;
                zzbbg2.sendMessageDelayed(zzbbg2.obtainMessage(2, zzbbe2), l2);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(PendingResult.zza zza2) {
        zzbo.zzb((zza2 != null ? 1 : 0) != 0, (Object)"Callback cannot be null.");
        Object object = this.zzaBW;
        synchronized (object) {
            if (this.isReady()) {
                zza2.zzo(this.mStatus);
            } else {
                this.zzaBZ.add(zza2);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        Object object = this.zzaBW;
        synchronized (object) {
            if (this.zzJ || this.zzaCd) {
                return;
            }
            if (this.zzaCf != null) {
                try {
                    this.zzaCf.cancel();
                }
                catch (RemoteException remoteException) {}
            }
            zzbbe.zzc(this.zzaBj);
            this.zzJ = true;
            this.zzb(this.zzb(Status.zzaBq));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzpB() {
        Object object = this.zzaBW;
        synchronized (object) {
            if ((GoogleApiClient)this.zzaBY.get() == null || !this.zzaCh) {
                this.cancel();
            }
            return this.isCanceled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCanceled() {
        Object object = this.zzaBW;
        synchronized (object) {
            return this.zzJ;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S extends Result> TransformedResult<S> then(ResultTransform<? super R, ? extends S> resultTransform) {
        zzbo.zza((!this.zzaCd ? 1 : 0) != 0, (Object)"Result has already been consumed.");
        Object object = this.zzaBW;
        synchronized (object) {
            zzbo.zza((this.zzaCg == null ? 1 : 0) != 0, (Object)"Cannot call then() twice.");
            zzbo.zza((this.zzaCa == null ? 1 : 0) != 0, (Object)"Cannot call then() if callbacks are set.");
            zzbo.zza((!this.zzJ ? 1 : 0) != 0, (Object)"Cannot call then() if result was canceled.");
            this.zzaCh = true;
            this.zzaCg = new zzbes(this.zzaBY);
            TransformedResult<? extends S> transformedResult = this.zzaCg.then(resultTransform);
            if (this.isReady()) {
                this.zzaBX.zza(this.zzaCg, this.get());
            } else {
                this.zzaCa = this.zzaCg;
            }
            return transformedResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setResult(R r) {
        Object object = this.zzaBW;
        synchronized (object) {
            if (!this.zzaCe && !this.zzJ) {
                if (this.isReady()) {
                    // empty if block
                }
            } else {
                zzbbe.zzc(r);
                return;
            }
            zzbo.zza((!this.isReady() ? 1 : 0) != 0, (Object)"Results have already been set");
            zzbo.zza((!this.zzaCd ? 1 : 0) != 0, (Object)"Result has already been consumed");
            this.zzb(r);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzs(Status status) {
        Object object = this.zzaBW;
        synchronized (object) {
            if (!this.isReady()) {
                this.setResult(this.zzb(status));
                this.zzaCe = true;
            }
            return;
        }
    }

    @NonNull
    protected abstract R zzb(Status var1);

    public final void zza(zzbex zzbex2) {
        this.zzaCb.set(zzbex2);
    }

    @Override
    public final Integer zzpo() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void zza(zzao zzao2) {
        Object object = this.zzaBW;
        synchronized (object) {
            this.zzaCf = zzao2;
            return;
        }
    }

    public final void zzpC() {
        this.zzaCh = this.zzaCh || zzaBV.get() != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final R get() {
        R r;
        Object object = this.zzaBW;
        synchronized (object) {
            zzbo.zza((!this.zzaCd ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            zzbo.zza((boolean)this.isReady(), (Object)"Result is not ready.");
            r = this.zzaBj;
            this.zzaBj = null;
            this.zzaCa = null;
            this.zzaCd = true;
        }
        zzbbe zzbbe2 = this;
        zzbex zzbex2 = zzbbe2.zzaCb.getAndSet(null);
        if (zzbex2 != null) {
            zzbex2.zzc(zzbbe2);
        }
        return r;
    }

    private final void zzb(R r) {
        this.zzaBj = r;
        this.zzaCf = null;
        this.zztJ.countDown();
        this.mStatus = this.zzaBj.getStatus();
        if (this.zzJ) {
            this.zzaCa = null;
        } else if (this.zzaCa == null) {
            if (this.zzaBj instanceof Releasable) {
                this.zzaCc = new zzbbh(this, null);
            }
        } else {
            this.zzaBX.removeMessages(2);
            this.zzaBX.zza(this.zzaCa, (R)this.get());
        }
        ArrayList<PendingResult.zza> arrayList = this.zzaBZ;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            PendingResult.zza zza2 = arrayList.get(i);
            zza2.zzo(this.mStatus);
        }
        this.zzaBZ.clear();
    }

    public static void zzc(Result result) {
        if (result instanceof Releasable) {
            try {
                ((Releasable)result).release();
                return;
            }
            catch (RuntimeException runtimeException) {
                String string2 = String.valueOf(result);
                Log.w((String)"BasePendingResult", (String)new StringBuilder(18 + String.valueOf(string2).length()).append("Unable to release ").append(string2).toString(), (Throwable)runtimeException);
            }
        }
    }

    static /* synthetic */ Result zza(zzbbe zzbbe2) {
        return zzbbe2.zzaBj;
    }
}

