/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.flexbox;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.util.SparseIntArray;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.flexbox.FlexContainer;
import com.google.android.flexbox.FlexItem;
import com.google.android.flexbox.FlexLine;
import com.google.android.flexbox.FlexboxHelper;
import com.google.android.flexbox.R;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

public class FlexboxLayout
extends ViewGroup
implements FlexContainer {
    private int mFlexDirection;
    private int mFlexWrap;
    private int mJustifyContent;
    private int mAlignItems;
    private int mAlignContent;
    public static final int SHOW_DIVIDER_NONE = 0;
    public static final int SHOW_DIVIDER_BEGINNING = 1;
    public static final int SHOW_DIVIDER_MIDDLE = 2;
    public static final int SHOW_DIVIDER_END = 4;
    @Nullable
    private Drawable mDividerDrawableHorizontal;
    @Nullable
    private Drawable mDividerDrawableVertical;
    private int mShowDividerHorizontal;
    private int mShowDividerVertical;
    private int mDividerHorizontalHeight;
    private int mDividerVerticalWidth;
    private int[] mReorderedIndices;
    private SparseIntArray mOrderCache;
    private FlexboxHelper mFlexboxHelper = new FlexboxHelper(this);
    private List<FlexLine> mFlexLines = new ArrayList<FlexLine>();

    public FlexboxLayout(Context context) {
        this(context, null);
    }

    public FlexboxLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public FlexboxLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        int dividerModeHorizontal;
        int dividerModeVertical;
        int dividerMode;
        Drawable drawableVertical;
        Drawable drawableHorizontal;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.FlexboxLayout, defStyleAttr, 0);
        this.mFlexDirection = a.getInt(R.styleable.FlexboxLayout_flexDirection, 0);
        this.mFlexWrap = a.getInt(R.styleable.FlexboxLayout_flexWrap, 0);
        this.mJustifyContent = a.getInt(R.styleable.FlexboxLayout_justifyContent, 0);
        this.mAlignItems = a.getInt(R.styleable.FlexboxLayout_alignItems, 4);
        this.mAlignContent = a.getInt(R.styleable.FlexboxLayout_alignContent, 5);
        Drawable drawable = a.getDrawable(R.styleable.FlexboxLayout_dividerDrawable);
        if (drawable != null) {
            this.setDividerDrawableHorizontal(drawable);
            this.setDividerDrawableVertical(drawable);
        }
        if ((drawableHorizontal = a.getDrawable(R.styleable.FlexboxLayout_dividerDrawableHorizontal)) != null) {
            this.setDividerDrawableHorizontal(drawableHorizontal);
        }
        if ((drawableVertical = a.getDrawable(R.styleable.FlexboxLayout_dividerDrawableVertical)) != null) {
            this.setDividerDrawableVertical(drawableVertical);
        }
        if ((dividerMode = a.getInt(R.styleable.FlexboxLayout_showDivider, 0)) != 0) {
            this.mShowDividerVertical = dividerMode;
            this.mShowDividerHorizontal = dividerMode;
        }
        if ((dividerModeVertical = a.getInt(R.styleable.FlexboxLayout_showDividerVertical, 0)) != 0) {
            this.mShowDividerVertical = dividerModeVertical;
        }
        if ((dividerModeHorizontal = a.getInt(R.styleable.FlexboxLayout_showDividerHorizontal, 0)) != 0) {
            this.mShowDividerHorizontal = dividerModeHorizontal;
        }
        a.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.mOrderCache == null) {
            this.mOrderCache = new SparseIntArray(this.getChildCount());
        }
        if (this.mFlexboxHelper.isOrderChangedFromLastMeasurement(this.mOrderCache)) {
            this.mReorderedIndices = this.mFlexboxHelper.createReorderedIndices(this.mOrderCache);
        }
        switch (this.mFlexDirection) {
            case 0: 
            case 1: {
                this.measureHorizontal(widthMeasureSpec, heightMeasureSpec);
                break;
            }
            case 2: 
            case 3: {
                this.measureVertical(widthMeasureSpec, heightMeasureSpec);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid value for the flex direction is set: " + this.mFlexDirection);
            }
        }
    }

    @Override
    public int getFlexItemCount() {
        return this.getChildCount();
    }

    @Override
    public View getFlexItemAt(int index) {
        return this.getChildAt(index);
    }

    public View getReorderedChildAt(int index) {
        if (index < 0 || index >= this.mReorderedIndices.length) {
            return null;
        }
        return this.getChildAt(this.mReorderedIndices[index]);
    }

    @Override
    public View getReorderedFlexItemAt(int index) {
        return this.getReorderedChildAt(index);
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        if (this.mOrderCache == null) {
            this.mOrderCache = new SparseIntArray(this.getChildCount());
        }
        this.mReorderedIndices = this.mFlexboxHelper.createReorderedIndices(child, index, params, this.mOrderCache);
        super.addView(child, index, params);
    }

    private void measureHorizontal(int widthMeasureSpec, int heightMeasureSpec) {
        this.mFlexLines.clear();
        FlexboxHelper.FlexLinesResult flexLinesResult = this.mFlexboxHelper.calculateHorizontalFlexLines(widthMeasureSpec, heightMeasureSpec);
        this.mFlexLines = flexLinesResult.mFlexLines;
        this.mFlexboxHelper.determineMainSize(widthMeasureSpec, heightMeasureSpec);
        if (this.mAlignItems == 3) {
            int viewIndex = 0;
            for (FlexLine flexLine : this.mFlexLines) {
                int largestHeightInLine = Integer.MIN_VALUE;
                for (int i = viewIndex; i < viewIndex + flexLine.mItemCount; ++i) {
                    View child = this.getReorderedChildAt(i);
                    LayoutParams lp = (LayoutParams)child.getLayoutParams();
                    if (this.mFlexWrap != 2) {
                        int marginTop = flexLine.mMaxBaseline - child.getBaseline();
                        marginTop = Math.max(marginTop, lp.topMargin);
                        largestHeightInLine = Math.max(largestHeightInLine, child.getHeight() + marginTop + lp.bottomMargin);
                        continue;
                    }
                    int marginBottom = flexLine.mMaxBaseline - child.getMeasuredHeight() + child.getBaseline();
                    marginBottom = Math.max(marginBottom, lp.bottomMargin);
                    largestHeightInLine = Math.max(largestHeightInLine, child.getHeight() + lp.topMargin + marginBottom);
                }
                flexLine.mCrossSize = largestHeightInLine;
                viewIndex += flexLine.mItemCount;
            }
        }
        this.mFlexboxHelper.determineCrossSize(widthMeasureSpec, heightMeasureSpec, this.getPaddingTop() + this.getPaddingBottom());
        this.mFlexboxHelper.stretchViews();
        this.setMeasuredDimensionForFlex(this.mFlexDirection, widthMeasureSpec, heightMeasureSpec, flexLinesResult.mChildState);
    }

    private void measureVertical(int widthMeasureSpec, int heightMeasureSpec) {
        this.mFlexLines.clear();
        FlexboxHelper.FlexLinesResult flexLinesResult = this.mFlexboxHelper.calculateVerticalFlexLines(widthMeasureSpec, heightMeasureSpec);
        this.mFlexLines = flexLinesResult.mFlexLines;
        this.mFlexboxHelper.determineMainSize(widthMeasureSpec, heightMeasureSpec);
        this.mFlexboxHelper.determineCrossSize(widthMeasureSpec, heightMeasureSpec, this.getPaddingLeft() + this.getPaddingRight());
        this.mFlexboxHelper.stretchViews();
        this.setMeasuredDimensionForFlex(this.mFlexDirection, widthMeasureSpec, heightMeasureSpec, flexLinesResult.mChildState);
    }

    private void setMeasuredDimensionForFlex(int flexDirection, int widthMeasureSpec, int heightMeasureSpec, int childState) {
        int heightSizeAndState;
        int widthSizeAndState;
        int calculatedMaxWidth;
        int calculatedMaxHeight;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        switch (flexDirection) {
            case 0: 
            case 1: {
                calculatedMaxHeight = this.getSumOfCrossSize() + this.getPaddingTop() + this.getPaddingBottom();
                calculatedMaxWidth = this.getLargestMainSize();
                break;
            }
            case 2: 
            case 3: {
                calculatedMaxHeight = this.getLargestMainSize();
                calculatedMaxWidth = this.getSumOfCrossSize() + this.getPaddingLeft() + this.getPaddingRight();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid flex direction: " + flexDirection);
            }
        }
        switch (widthMode) {
            case 0x40000000: {
                if (widthSize < calculatedMaxWidth) {
                    childState = ViewCompat.combineMeasuredStates((int)childState, (int)0x1000000);
                }
                widthSizeAndState = ViewCompat.resolveSizeAndState((int)widthSize, (int)widthMeasureSpec, (int)childState);
                break;
            }
            case -2147483648: {
                if (widthSize < calculatedMaxWidth) {
                    childState = ViewCompat.combineMeasuredStates((int)childState, (int)0x1000000);
                } else {
                    widthSize = calculatedMaxWidth;
                }
                widthSizeAndState = ViewCompat.resolveSizeAndState((int)widthSize, (int)widthMeasureSpec, (int)childState);
                break;
            }
            case 0: {
                widthSizeAndState = ViewCompat.resolveSizeAndState((int)calculatedMaxWidth, (int)widthMeasureSpec, (int)childState);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown width mode is set: " + widthMode);
            }
        }
        switch (heightMode) {
            case 0x40000000: {
                if (heightSize < calculatedMaxHeight) {
                    childState = ViewCompat.combineMeasuredStates((int)childState, (int)256);
                }
                heightSizeAndState = ViewCompat.resolveSizeAndState((int)heightSize, (int)heightMeasureSpec, (int)childState);
                break;
            }
            case -2147483648: {
                if (heightSize < calculatedMaxHeight) {
                    childState = ViewCompat.combineMeasuredStates((int)childState, (int)256);
                } else {
                    heightSize = calculatedMaxHeight;
                }
                heightSizeAndState = ViewCompat.resolveSizeAndState((int)heightSize, (int)heightMeasureSpec, (int)childState);
                break;
            }
            case 0: {
                heightSizeAndState = ViewCompat.resolveSizeAndState((int)calculatedMaxHeight, (int)heightMeasureSpec, (int)childState);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown height mode is set: " + heightMode);
            }
        }
        this.setMeasuredDimension(widthSizeAndState, heightSizeAndState);
    }

    @Override
    public int getLargestMainSize() {
        int largestSize = Integer.MIN_VALUE;
        for (FlexLine flexLine : this.mFlexLines) {
            largestSize = Math.max(largestSize, flexLine.mMainSize);
        }
        return largestSize;
    }

    @Override
    public int getSumOfCrossSize() {
        int sum = 0;
        int size = this.mFlexLines.size();
        for (int i = 0; i < size; ++i) {
            FlexLine flexLine = this.mFlexLines.get(i);
            if (this.hasDividerBeforeFlexLine(i)) {
                sum = this.isMainAxisDirectionHorizontal() ? (sum += this.mDividerHorizontalHeight) : (sum += this.mDividerVerticalWidth);
            }
            if (this.hasEndDividerAfterFlexLine(i)) {
                sum = this.isMainAxisDirectionHorizontal() ? (sum += this.mDividerHorizontalHeight) : (sum += this.mDividerVerticalWidth);
            }
            sum += flexLine.mCrossSize;
        }
        return sum;
    }

    @Override
    public boolean isMainAxisDirectionHorizontal() {
        return this.mFlexDirection == 0 || this.mFlexDirection == 1;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int layoutDirection = ViewCompat.getLayoutDirection((View)this);
        switch (this.mFlexDirection) {
            case 0: {
                boolean isRtl = layoutDirection == 1;
                this.layoutHorizontal(isRtl, left, top, right, bottom);
                break;
            }
            case 1: {
                boolean isRtl = layoutDirection != 1;
                this.layoutHorizontal(isRtl, left, top, right, bottom);
                break;
            }
            case 2: {
                boolean isRtl;
                boolean bl = isRtl = layoutDirection == 1;
                if (this.mFlexWrap == 2) {
                    isRtl = !isRtl;
                }
                this.layoutVertical(isRtl, false, left, top, right, bottom);
                break;
            }
            case 3: {
                boolean isRtl;
                boolean bl = isRtl = layoutDirection == 1;
                if (this.mFlexWrap == 2) {
                    isRtl = !isRtl;
                }
                this.layoutVertical(isRtl, true, left, top, right, bottom);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid flex direction is set: " + this.mFlexDirection);
            }
        }
    }

    private void layoutHorizontal(boolean isRtl, int left, int top, int right, int bottom) {
        int paddingLeft = this.getPaddingLeft();
        int paddingRight = this.getPaddingRight();
        int height = bottom - top;
        int width = right - left;
        int childBottom = height - this.getPaddingBottom();
        int childTop = this.getPaddingTop();
        int size = this.mFlexLines.size();
        for (int i = 0; i < size; ++i) {
            float childRight;
            float childLeft;
            FlexLine flexLine = this.mFlexLines.get(i);
            if (this.hasDividerBeforeFlexLine(i)) {
                childBottom -= this.mDividerHorizontalHeight;
                childTop += this.mDividerHorizontalHeight;
            }
            float spaceBetweenItem = 0.0f;
            switch (this.mJustifyContent) {
                case 0: {
                    childLeft = paddingLeft;
                    childRight = width - paddingRight;
                    break;
                }
                case 1: {
                    childLeft = width - flexLine.mMainSize + paddingRight;
                    childRight = flexLine.mMainSize - paddingLeft;
                    break;
                }
                case 2: {
                    childLeft = (float)paddingLeft + (float)(width - flexLine.mMainSize) / 2.0f;
                    childRight = (float)(width - paddingRight) - (float)(width - flexLine.mMainSize) / 2.0f;
                    break;
                }
                case 4: {
                    int visibleCount = flexLine.getItemCountNotGone();
                    if (visibleCount != 0) {
                        spaceBetweenItem = (float)(width - flexLine.mMainSize) / (float)visibleCount;
                    }
                    childLeft = (float)paddingLeft + spaceBetweenItem / 2.0f;
                    childRight = (float)(width - paddingRight) - spaceBetweenItem / 2.0f;
                    break;
                }
                case 3: {
                    childLeft = paddingLeft;
                    int visibleItem = flexLine.getItemCountNotGone();
                    float denominator = visibleItem != 1 ? (float)(visibleItem - 1) : 1.0f;
                    spaceBetweenItem = (float)(width - flexLine.mMainSize) / denominator;
                    childRight = width - paddingRight;
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid justifyContent is set: " + this.mJustifyContent);
                }
            }
            spaceBetweenItem = Math.max(spaceBetweenItem, 0.0f);
            for (int j = 0; j < flexLine.mItemCount; ++j) {
                int index = flexLine.mFirstIndex + j;
                View child = this.getReorderedChildAt(index);
                if (child == null || child.getVisibility() == 8) continue;
                LayoutParams lp = (LayoutParams)child.getLayoutParams();
                childLeft += (float)lp.leftMargin;
                childRight -= (float)lp.rightMargin;
                int beforeDividerLength = 0;
                int endDividerLength = 0;
                if (this.hasDividerBeforeChildAtAlongMainAxis(index, j)) {
                    beforeDividerLength = this.mDividerVerticalWidth;
                    childLeft += (float)beforeDividerLength;
                    childRight -= (float)beforeDividerLength;
                }
                if (j == flexLine.mItemCount - 1 && (this.mShowDividerVertical & 4) > 0) {
                    endDividerLength = this.mDividerVerticalWidth;
                }
                if (this.mFlexWrap == 2) {
                    if (isRtl) {
                        this.mFlexboxHelper.layoutSingleChildHorizontal(child, flexLine, Math.round(childRight) - child.getMeasuredWidth(), childBottom - child.getMeasuredHeight(), Math.round(childRight), childBottom);
                    } else {
                        this.mFlexboxHelper.layoutSingleChildHorizontal(child, flexLine, Math.round(childLeft), childBottom - child.getMeasuredHeight(), Math.round(childLeft) + child.getMeasuredWidth(), childBottom);
                    }
                } else if (isRtl) {
                    this.mFlexboxHelper.layoutSingleChildHorizontal(child, flexLine, Math.round(childRight) - child.getMeasuredWidth(), childTop, Math.round(childRight), childTop + child.getMeasuredHeight());
                } else {
                    this.mFlexboxHelper.layoutSingleChildHorizontal(child, flexLine, Math.round(childLeft), childTop, Math.round(childLeft) + child.getMeasuredWidth(), childTop + child.getMeasuredHeight());
                }
                childLeft += (float)child.getMeasuredWidth() + spaceBetweenItem + (float)lp.rightMargin;
                childRight -= (float)child.getMeasuredWidth() + spaceBetweenItem + (float)lp.leftMargin;
                if (isRtl) {
                    flexLine.updatePositionFromView(child, endDividerLength, 0, beforeDividerLength, 0);
                    continue;
                }
                flexLine.updatePositionFromView(child, beforeDividerLength, 0, endDividerLength, 0);
            }
            childTop += flexLine.mCrossSize;
            childBottom -= flexLine.mCrossSize;
        }
    }

    private void layoutVertical(boolean isRtl, boolean fromBottomToTop, int left, int top, int right, int bottom) {
        int paddingTop = this.getPaddingTop();
        int paddingBottom = this.getPaddingBottom();
        int paddingRight = this.getPaddingRight();
        int childLeft = this.getPaddingLeft();
        int width = right - left;
        int height = bottom - top;
        int childRight = width - paddingRight;
        int size = this.mFlexLines.size();
        for (int i = 0; i < size; ++i) {
            float childBottom;
            float childTop;
            FlexLine flexLine = this.mFlexLines.get(i);
            if (this.hasDividerBeforeFlexLine(i)) {
                childLeft += this.mDividerVerticalWidth;
                childRight -= this.mDividerVerticalWidth;
            }
            float spaceBetweenItem = 0.0f;
            switch (this.mJustifyContent) {
                case 0: {
                    childTop = paddingTop;
                    childBottom = height - paddingBottom;
                    break;
                }
                case 1: {
                    childTop = height - flexLine.mMainSize + paddingBottom;
                    childBottom = flexLine.mMainSize - paddingTop;
                    break;
                }
                case 2: {
                    childTop = (float)paddingTop + (float)(height - flexLine.mMainSize) / 2.0f;
                    childBottom = (float)(height - paddingBottom) - (float)(height - flexLine.mMainSize) / 2.0f;
                    break;
                }
                case 4: {
                    int visibleCount = flexLine.getItemCountNotGone();
                    if (visibleCount != 0) {
                        spaceBetweenItem = (float)(height - flexLine.mMainSize) / (float)visibleCount;
                    }
                    childTop = (float)paddingTop + spaceBetweenItem / 2.0f;
                    childBottom = (float)(height - paddingBottom) - spaceBetweenItem / 2.0f;
                    break;
                }
                case 3: {
                    childTop = paddingTop;
                    int visibleItem = flexLine.getItemCountNotGone();
                    float denominator = visibleItem != 1 ? (float)(visibleItem - 1) : 1.0f;
                    spaceBetweenItem = (float)(height - flexLine.mMainSize) / denominator;
                    childBottom = height - paddingBottom;
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid justifyContent is set: " + this.mJustifyContent);
                }
            }
            spaceBetweenItem = Math.max(spaceBetweenItem, 0.0f);
            for (int j = 0; j < flexLine.mItemCount; ++j) {
                int index = flexLine.mFirstIndex + j;
                View child = this.getReorderedChildAt(index);
                if (child == null || child.getVisibility() == 8) continue;
                LayoutParams lp = (LayoutParams)child.getLayoutParams();
                childTop += (float)lp.topMargin;
                childBottom -= (float)lp.bottomMargin;
                int beforeDividerLength = 0;
                int endDividerLength = 0;
                if (this.hasDividerBeforeChildAtAlongMainAxis(index, j)) {
                    beforeDividerLength = this.mDividerHorizontalHeight;
                    childTop += (float)beforeDividerLength;
                    childBottom -= (float)beforeDividerLength;
                }
                if (j == flexLine.mItemCount - 1 && (this.mShowDividerHorizontal & 4) > 0) {
                    endDividerLength = this.mDividerHorizontalHeight;
                }
                if (isRtl) {
                    if (fromBottomToTop) {
                        this.mFlexboxHelper.layoutSingleChildVertical(child, flexLine, true, childRight - child.getMeasuredWidth(), Math.round(childBottom) - child.getMeasuredHeight(), childRight, Math.round(childBottom));
                    } else {
                        this.mFlexboxHelper.layoutSingleChildVertical(child, flexLine, true, childRight - child.getMeasuredWidth(), Math.round(childTop), childRight, Math.round(childTop) + child.getMeasuredHeight());
                    }
                } else if (fromBottomToTop) {
                    this.mFlexboxHelper.layoutSingleChildVertical(child, flexLine, false, childLeft, Math.round(childBottom) - child.getMeasuredHeight(), childLeft + child.getMeasuredWidth(), Math.round(childBottom));
                } else {
                    this.mFlexboxHelper.layoutSingleChildVertical(child, flexLine, false, childLeft, Math.round(childTop), childLeft + child.getMeasuredWidth(), Math.round(childTop) + child.getMeasuredHeight());
                }
                childTop += (float)child.getMeasuredHeight() + spaceBetweenItem + (float)lp.bottomMargin;
                childBottom -= (float)child.getMeasuredHeight() + spaceBetweenItem + (float)lp.topMargin;
                if (fromBottomToTop) {
                    flexLine.updatePositionFromView(child, 0, endDividerLength, 0, beforeDividerLength);
                    continue;
                }
                flexLine.updatePositionFromView(child, 0, beforeDividerLength, 0, endDividerLength);
            }
            childLeft += flexLine.mCrossSize;
            childRight -= flexLine.mCrossSize;
        }
    }

    protected void onDraw(Canvas canvas) {
        if (this.mDividerDrawableVertical == null && this.mDividerDrawableHorizontal == null) {
            return;
        }
        if (this.mShowDividerHorizontal == 0 && this.mShowDividerVertical == 0) {
            return;
        }
        int layoutDirection = ViewCompat.getLayoutDirection((View)this);
        boolean fromBottomToTop = false;
        switch (this.mFlexDirection) {
            case 0: {
                boolean isRtl;
                boolean bl = isRtl = layoutDirection == 1;
                if (this.mFlexWrap == 2) {
                    fromBottomToTop = true;
                }
                this.drawDividersHorizontal(canvas, isRtl, fromBottomToTop);
                break;
            }
            case 1: {
                boolean isRtl;
                boolean bl = isRtl = layoutDirection != 1;
                if (this.mFlexWrap == 2) {
                    fromBottomToTop = true;
                }
                this.drawDividersHorizontal(canvas, isRtl, fromBottomToTop);
                break;
            }
            case 2: {
                boolean isRtl;
                boolean bl = isRtl = layoutDirection == 1;
                if (this.mFlexWrap == 2) {
                    isRtl = !isRtl;
                }
                this.drawDividersVertical(canvas, isRtl, false);
                break;
            }
            case 3: {
                boolean isRtl;
                boolean bl = isRtl = layoutDirection == 1;
                if (this.mFlexWrap == 2) {
                    isRtl = !isRtl;
                }
                this.drawDividersVertical(canvas, isRtl, true);
            }
        }
    }

    private void drawDividersHorizontal(Canvas canvas, boolean isRtl, boolean fromBottomToTop) {
        int currentViewIndex = 0;
        int paddingLeft = this.getPaddingLeft();
        int paddingRight = this.getPaddingRight();
        int horizontalDividerLength = Math.max(0, this.getWidth() - paddingRight - paddingLeft);
        int size = this.mFlexLines.size();
        for (int i = 0; i < size; ++i) {
            int horizontalDividerTop;
            FlexLine flexLine = this.mFlexLines.get(i);
            for (int j = 0; j < flexLine.mItemCount; ++j) {
                int dividerLeft;
                View view = this.getReorderedChildAt(currentViewIndex);
                if (view == null || view.getVisibility() == 8) continue;
                LayoutParams lp = (LayoutParams)view.getLayoutParams();
                if (this.hasDividerBeforeChildAtAlongMainAxis(currentViewIndex, j)) {
                    dividerLeft = isRtl ? view.getRight() + lp.rightMargin : view.getLeft() - lp.leftMargin - this.mDividerVerticalWidth;
                    this.drawVerticalDivider(canvas, dividerLeft, flexLine.mTop, flexLine.mCrossSize);
                }
                if (j == flexLine.mItemCount - 1 && (this.mShowDividerVertical & 4) > 0) {
                    dividerLeft = isRtl ? view.getLeft() - lp.leftMargin - this.mDividerVerticalWidth : view.getRight() + lp.rightMargin;
                    this.drawVerticalDivider(canvas, dividerLeft, flexLine.mTop, flexLine.mCrossSize);
                }
                ++currentViewIndex;
            }
            if (this.hasDividerBeforeFlexLine(i)) {
                horizontalDividerTop = fromBottomToTop ? flexLine.mBottom : flexLine.mTop - this.mDividerHorizontalHeight;
                this.drawHorizontalDivider(canvas, paddingLeft, horizontalDividerTop, horizontalDividerLength);
            }
            if (!this.hasEndDividerAfterFlexLine(i) || (this.mShowDividerHorizontal & 4) <= 0) continue;
            horizontalDividerTop = fromBottomToTop ? flexLine.mTop - this.mDividerHorizontalHeight : flexLine.mBottom;
            this.drawHorizontalDivider(canvas, paddingLeft, horizontalDividerTop, horizontalDividerLength);
        }
    }

    private void drawDividersVertical(Canvas canvas, boolean isRtl, boolean fromBottomToTop) {
        int currentViewIndex = 0;
        int paddingTop = this.getPaddingTop();
        int paddingBottom = this.getPaddingBottom();
        int verticalDividerLength = Math.max(0, this.getHeight() - paddingBottom - paddingTop);
        int size = this.mFlexLines.size();
        for (int i = 0; i < size; ++i) {
            int verticalDividerLeft;
            FlexLine flexLine = this.mFlexLines.get(i);
            for (int j = 0; j < flexLine.mItemCount; ++j) {
                int dividerTop;
                View view = this.getReorderedChildAt(currentViewIndex);
                if (view == null || view.getVisibility() == 8) continue;
                LayoutParams lp = (LayoutParams)view.getLayoutParams();
                if (this.hasDividerBeforeChildAtAlongMainAxis(currentViewIndex, j)) {
                    dividerTop = fromBottomToTop ? view.getBottom() + lp.bottomMargin : view.getTop() - lp.topMargin - this.mDividerHorizontalHeight;
                    this.drawHorizontalDivider(canvas, flexLine.mLeft, dividerTop, flexLine.mCrossSize);
                }
                if (j == flexLine.mItemCount - 1 && (this.mShowDividerHorizontal & 4) > 0) {
                    dividerTop = fromBottomToTop ? view.getTop() - lp.topMargin - this.mDividerHorizontalHeight : view.getBottom() + lp.bottomMargin;
                    this.drawHorizontalDivider(canvas, flexLine.mLeft, dividerTop, flexLine.mCrossSize);
                }
                ++currentViewIndex;
            }
            if (this.hasDividerBeforeFlexLine(i)) {
                verticalDividerLeft = isRtl ? flexLine.mRight : flexLine.mLeft - this.mDividerVerticalWidth;
                this.drawVerticalDivider(canvas, verticalDividerLeft, paddingTop, verticalDividerLength);
            }
            if (!this.hasEndDividerAfterFlexLine(i) || (this.mShowDividerVertical & 4) <= 0) continue;
            verticalDividerLeft = isRtl ? flexLine.mLeft - this.mDividerVerticalWidth : flexLine.mRight;
            this.drawVerticalDivider(canvas, verticalDividerLeft, paddingTop, verticalDividerLength);
        }
    }

    private void drawVerticalDivider(Canvas canvas, int left, int top, int length) {
        if (this.mDividerDrawableVertical == null) {
            return;
        }
        this.mDividerDrawableVertical.setBounds(left, top, left + this.mDividerVerticalWidth, top + length);
        this.mDividerDrawableVertical.draw(canvas);
    }

    private void drawHorizontalDivider(Canvas canvas, int left, int top, int length) {
        if (this.mDividerDrawableHorizontal == null) {
            return;
        }
        this.mDividerDrawableHorizontal.setBounds(left, top, left + length, top + this.mDividerHorizontalHeight);
        this.mDividerDrawableHorizontal.draw(canvas);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    @Override
    public int getFlexDirection() {
        return this.mFlexDirection;
    }

    @Override
    public void setFlexDirection(int flexDirection) {
        if (this.mFlexDirection != flexDirection) {
            this.mFlexDirection = flexDirection;
            this.requestLayout();
        }
    }

    @Override
    public int getFlexWrap() {
        return this.mFlexWrap;
    }

    @Override
    public void setFlexWrap(int flexWrap) {
        if (this.mFlexWrap != flexWrap) {
            this.mFlexWrap = flexWrap;
            this.requestLayout();
        }
    }

    @Override
    public int getJustifyContent() {
        return this.mJustifyContent;
    }

    @Override
    public void setJustifyContent(int justifyContent) {
        if (this.mJustifyContent != justifyContent) {
            this.mJustifyContent = justifyContent;
            this.requestLayout();
        }
    }

    @Override
    public int getAlignItems() {
        return this.mAlignItems;
    }

    @Override
    public void setAlignItems(int alignItems) {
        if (this.mAlignItems != alignItems) {
            this.mAlignItems = alignItems;
            this.requestLayout();
        }
    }

    @Override
    public int getAlignContent() {
        return this.mAlignContent;
    }

    @Override
    public void setAlignContent(int alignContent) {
        if (this.mAlignContent != alignContent) {
            this.mAlignContent = alignContent;
            this.requestLayout();
        }
    }

    @Override
    public List<FlexLine> getFlexLines() {
        ArrayList<FlexLine> result = new ArrayList<FlexLine>(this.mFlexLines.size());
        for (FlexLine flexLine : this.mFlexLines) {
            if (flexLine.getItemCountNotGone() == 0) continue;
            result.add(flexLine);
        }
        return result;
    }

    @Override
    public int getDecorationLengthMainAxis(View view, int index, int indexInFlexLine) {
        int decorationLength = 0;
        if (this.isMainAxisDirectionHorizontal()) {
            if (this.hasDividerBeforeChildAtAlongMainAxis(index, indexInFlexLine)) {
                decorationLength += this.mDividerVerticalWidth;
            }
            if ((this.mShowDividerVertical & 4) > 0) {
                decorationLength += this.mDividerVerticalWidth;
            }
        } else {
            if (this.hasDividerBeforeChildAtAlongMainAxis(index, indexInFlexLine)) {
                decorationLength += this.mDividerHorizontalHeight;
            }
            if ((this.mShowDividerHorizontal & 4) > 0) {
                decorationLength += this.mDividerHorizontalHeight;
            }
        }
        return decorationLength;
    }

    @Override
    public int getDecorationLengthCrossAxis(View view) {
        return 0;
    }

    @Override
    public void onNewFlexLineAdded(FlexLine flexLine) {
        if (this.isMainAxisDirectionHorizontal()) {
            if ((this.mShowDividerVertical & 4) > 0) {
                flexLine.mMainSize += this.mDividerVerticalWidth;
                flexLine.mDividerLengthInMainSize += this.mDividerVerticalWidth;
            }
        } else if ((this.mShowDividerHorizontal & 4) > 0) {
            flexLine.mMainSize += this.mDividerHorizontalHeight;
            flexLine.mDividerLengthInMainSize += this.mDividerHorizontalHeight;
        }
    }

    @Override
    public int getChildWidthMeasureSpec(int widthSpec, int padding, int childDimension) {
        return FlexboxLayout.getChildMeasureSpec((int)widthSpec, (int)padding, (int)childDimension);
    }

    @Override
    public int getChildHeightMeasureSpec(int heightSpec, int padding, int childDimension) {
        return FlexboxLayout.getChildMeasureSpec((int)heightSpec, (int)padding, (int)childDimension);
    }

    @Override
    public void onNewFlexItemAdded(View view, int index, int indexInFlexLine, FlexLine flexLine) {
        if (this.hasDividerBeforeChildAtAlongMainAxis(index, indexInFlexLine)) {
            if (this.isMainAxisDirectionHorizontal()) {
                flexLine.mMainSize += this.mDividerVerticalWidth;
                flexLine.mDividerLengthInMainSize += this.mDividerVerticalWidth;
            } else {
                flexLine.mMainSize += this.mDividerHorizontalHeight;
                flexLine.mDividerLengthInMainSize += this.mDividerHorizontalHeight;
            }
        }
    }

    @Override
    public void setFlexLines(List<FlexLine> flexLines) {
        this.mFlexLines = flexLines;
    }

    @Override
    public List<FlexLine> getFlexLinesInternal() {
        return this.mFlexLines;
    }

    @Override
    public void updateViewCache(int position, View view) {
    }

    @Nullable
    public Drawable getDividerDrawableHorizontal() {
        return this.mDividerDrawableHorizontal;
    }

    @Nullable
    public Drawable getDividerDrawableVertical() {
        return this.mDividerDrawableVertical;
    }

    public void setDividerDrawable(Drawable divider) {
        this.setDividerDrawableHorizontal(divider);
        this.setDividerDrawableVertical(divider);
    }

    public void setDividerDrawableHorizontal(@Nullable Drawable divider) {
        if (divider == this.mDividerDrawableHorizontal) {
            return;
        }
        this.mDividerDrawableHorizontal = divider;
        this.mDividerHorizontalHeight = divider != null ? divider.getIntrinsicHeight() : 0;
        this.setWillNotDrawFlag();
        this.requestLayout();
    }

    public void setDividerDrawableVertical(@Nullable Drawable divider) {
        if (divider == this.mDividerDrawableVertical) {
            return;
        }
        this.mDividerDrawableVertical = divider;
        this.mDividerVerticalWidth = divider != null ? divider.getIntrinsicWidth() : 0;
        this.setWillNotDrawFlag();
        this.requestLayout();
    }

    public int getShowDividerVertical() {
        return this.mShowDividerVertical;
    }

    public int getShowDividerHorizontal() {
        return this.mShowDividerHorizontal;
    }

    public void setShowDivider(int dividerMode) {
        this.setShowDividerVertical(dividerMode);
        this.setShowDividerHorizontal(dividerMode);
    }

    public void setShowDividerVertical(int dividerMode) {
        if (dividerMode != this.mShowDividerVertical) {
            this.mShowDividerVertical = dividerMode;
            this.requestLayout();
        }
    }

    public void setShowDividerHorizontal(int dividerMode) {
        if (dividerMode != this.mShowDividerHorizontal) {
            this.mShowDividerHorizontal = dividerMode;
            this.requestLayout();
        }
    }

    private void setWillNotDrawFlag() {
        if (this.mDividerDrawableHorizontal == null && this.mDividerDrawableVertical == null) {
            this.setWillNotDraw(true);
        } else {
            this.setWillNotDraw(false);
        }
    }

    private boolean hasDividerBeforeChildAtAlongMainAxis(int index, int indexInFlexLine) {
        if (this.allViewsAreGoneBefore(index, indexInFlexLine)) {
            if (this.isMainAxisDirectionHorizontal()) {
                return (this.mShowDividerVertical & 1) != 0;
            }
            return (this.mShowDividerHorizontal & 1) != 0;
        }
        if (this.isMainAxisDirectionHorizontal()) {
            return (this.mShowDividerVertical & 2) != 0;
        }
        return (this.mShowDividerHorizontal & 2) != 0;
    }

    private boolean allViewsAreGoneBefore(int index, int indexInFlexLine) {
        for (int i = 1; i <= indexInFlexLine; ++i) {
            View view = this.getReorderedChildAt(index - i);
            if (view == null || view.getVisibility() == 8) continue;
            return false;
        }
        return true;
    }

    private boolean hasDividerBeforeFlexLine(int flexLineIndex) {
        if (flexLineIndex < 0 || flexLineIndex >= this.mFlexLines.size()) {
            return false;
        }
        if (this.allFlexLinesAreDummyBefore(flexLineIndex)) {
            if (this.isMainAxisDirectionHorizontal()) {
                return (this.mShowDividerHorizontal & 1) != 0;
            }
            return (this.mShowDividerVertical & 1) != 0;
        }
        if (this.isMainAxisDirectionHorizontal()) {
            return (this.mShowDividerHorizontal & 2) != 0;
        }
        return (this.mShowDividerVertical & 2) != 0;
    }

    private boolean allFlexLinesAreDummyBefore(int flexLineIndex) {
        for (int i = 0; i < flexLineIndex; ++i) {
            if (this.mFlexLines.get(i).getItemCountNotGone() <= 0) continue;
            return false;
        }
        return true;
    }

    private boolean hasEndDividerAfterFlexLine(int flexLineIndex) {
        if (flexLineIndex < 0 || flexLineIndex >= this.mFlexLines.size()) {
            return false;
        }
        for (int i = flexLineIndex + 1; i < this.mFlexLines.size(); ++i) {
            if (this.mFlexLines.get(i).getItemCountNotGone() <= 0) continue;
            return false;
        }
        if (this.isMainAxisDirectionHorizontal()) {
            return (this.mShowDividerHorizontal & 4) != 0;
        }
        return (this.mShowDividerVertical & 4) != 0;
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams
    implements FlexItem {
        private int mOrder = 1;
        private float mFlexGrow = 0.0f;
        private float mFlexShrink = 1.0f;
        private int mAlignSelf = -1;
        private float mFlexBasisPercent = -1.0f;
        private int mMinWidth;
        private int mMinHeight;
        private int mMaxWidth = 0xFFFFFF;
        private int mMaxHeight = 0xFFFFFF;
        private boolean mWrapBefore;
        public static final Parcelable.Creator<LayoutParams> CREATOR = new Parcelable.Creator<LayoutParams>(){

            public LayoutParams createFromParcel(Parcel source) {
                return new LayoutParams(source);
            }

            public LayoutParams[] newArray(int size) {
                return new LayoutParams[size];
            }
        };

        public LayoutParams(Context context, AttributeSet attrs) {
            super(context, attrs);
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.FlexboxLayout_Layout);
            this.mOrder = a.getInt(R.styleable.FlexboxLayout_Layout_layout_order, 1);
            this.mFlexGrow = a.getFloat(R.styleable.FlexboxLayout_Layout_layout_flexGrow, 0.0f);
            this.mFlexShrink = a.getFloat(R.styleable.FlexboxLayout_Layout_layout_flexShrink, 1.0f);
            this.mAlignSelf = a.getInt(R.styleable.FlexboxLayout_Layout_layout_alignSelf, -1);
            this.mFlexBasisPercent = a.getFraction(R.styleable.FlexboxLayout_Layout_layout_flexBasisPercent, 1, 1, -1.0f);
            this.mMinWidth = a.getDimensionPixelSize(R.styleable.FlexboxLayout_Layout_layout_minWidth, 0);
            this.mMinHeight = a.getDimensionPixelSize(R.styleable.FlexboxLayout_Layout_layout_minHeight, 0);
            this.mMaxWidth = a.getDimensionPixelSize(R.styleable.FlexboxLayout_Layout_layout_maxWidth, 0xFFFFFF);
            this.mMaxHeight = a.getDimensionPixelSize(R.styleable.FlexboxLayout_Layout_layout_maxHeight, 0xFFFFFF);
            this.mWrapBefore = a.getBoolean(R.styleable.FlexboxLayout_Layout_layout_wrapBefore, false);
            a.recycle();
        }

        public LayoutParams(LayoutParams source) {
            super((ViewGroup.MarginLayoutParams)source);
            this.mOrder = source.mOrder;
            this.mFlexGrow = source.mFlexGrow;
            this.mFlexShrink = source.mFlexShrink;
            this.mAlignSelf = source.mAlignSelf;
            this.mFlexBasisPercent = source.mFlexBasisPercent;
            this.mMinWidth = source.mMinWidth;
            this.mMinHeight = source.mMinHeight;
            this.mMaxWidth = source.mMaxWidth;
            this.mMaxHeight = source.mMaxHeight;
            this.mWrapBefore = source.mWrapBefore;
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }

        public LayoutParams(int width, int height) {
            super(new ViewGroup.LayoutParams(width, height));
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        @Override
        public int getWidth() {
            return this.width;
        }

        @Override
        public void setWidth(int width) {
            this.width = width;
        }

        @Override
        public int getHeight() {
            return this.height;
        }

        @Override
        public void setHeight(int height) {
            this.height = height;
        }

        @Override
        public int getOrder() {
            return this.mOrder;
        }

        @Override
        public void setOrder(int order) {
            this.mOrder = order;
        }

        @Override
        public float getFlexGrow() {
            return this.mFlexGrow;
        }

        @Override
        public void setFlexGrow(float flexGrow) {
            this.mFlexGrow = flexGrow;
        }

        @Override
        public float getFlexShrink() {
            return this.mFlexShrink;
        }

        @Override
        public void setFlexShrink(float flexShrink) {
            this.mFlexShrink = flexShrink;
        }

        @Override
        public int getAlignSelf() {
            return this.mAlignSelf;
        }

        @Override
        public void setAlignSelf(int alignSelf) {
            this.mAlignSelf = alignSelf;
        }

        @Override
        public int getMinWidth() {
            return this.mMinWidth;
        }

        @Override
        public void setMinWidth(int minWidth) {
            this.mMinWidth = minWidth;
        }

        @Override
        public int getMinHeight() {
            return this.mMinHeight;
        }

        @Override
        public void setMinHeight(int minHeight) {
            this.mMinHeight = minHeight;
        }

        @Override
        public int getMaxWidth() {
            return this.mMaxWidth;
        }

        @Override
        public void setMaxWidth(int maxWidth) {
            this.mMaxWidth = maxWidth;
        }

        @Override
        public int getMaxHeight() {
            return this.mMaxHeight;
        }

        @Override
        public void setMaxHeight(int maxHeight) {
            this.mMaxHeight = maxHeight;
        }

        @Override
        public boolean isWrapBefore() {
            return this.mWrapBefore;
        }

        @Override
        public void setWrapBefore(boolean wrapBefore) {
            this.mWrapBefore = wrapBefore;
        }

        @Override
        public float getFlexBasisPercent() {
            return this.mFlexBasisPercent;
        }

        @Override
        public void setFlexBasisPercent(float flexBasisPercent) {
            this.mFlexBasisPercent = flexBasisPercent;
        }

        @Override
        public int getMarginLeft() {
            return this.leftMargin;
        }

        @Override
        public int getMarginTop() {
            return this.topMargin;
        }

        @Override
        public int getMarginRight() {
            return this.rightMargin;
        }

        @Override
        public int getMarginBottom() {
            return this.bottomMargin;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mOrder);
            dest.writeFloat(this.mFlexGrow);
            dest.writeFloat(this.mFlexShrink);
            dest.writeInt(this.mAlignSelf);
            dest.writeFloat(this.mFlexBasisPercent);
            dest.writeInt(this.mMinWidth);
            dest.writeInt(this.mMinHeight);
            dest.writeInt(this.mMaxWidth);
            dest.writeInt(this.mMaxHeight);
            dest.writeByte(this.mWrapBefore ? (byte)1 : 0);
            dest.writeInt(this.bottomMargin);
            dest.writeInt(this.leftMargin);
            dest.writeInt(this.rightMargin);
            dest.writeInt(this.topMargin);
            dest.writeInt(this.height);
            dest.writeInt(this.width);
        }

        protected LayoutParams(Parcel in) {
            super(0, 0);
            this.mOrder = in.readInt();
            this.mFlexGrow = in.readFloat();
            this.mFlexShrink = in.readFloat();
            this.mAlignSelf = in.readInt();
            this.mFlexBasisPercent = in.readFloat();
            this.mMinWidth = in.readInt();
            this.mMinHeight = in.readInt();
            this.mMaxWidth = in.readInt();
            this.mMaxHeight = in.readInt();
            this.mWrapBefore = in.readByte() != 0;
            this.bottomMargin = in.readInt();
            this.leftMargin = in.readInt();
            this.rightMargin = in.readInt();
            this.topMargin = in.readInt();
            this.height = in.readInt();
            this.width = in.readInt();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DividerMode {
    }
}

