/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.flexbox;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.NonNull;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.util.SparseIntArray;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.flexbox.R;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class FlexboxLayout
extends ViewGroup {
    public static final int FLEX_DIRECTION_ROW = 0;
    public static final int FLEX_DIRECTION_ROW_REVERSE = 1;
    public static final int FLEX_DIRECTION_COLUMN = 2;
    public static final int FLEX_DIRECTION_COLUMN_REVERSE = 3;
    private int mFlexDirection;
    public static final int FLEX_WRAP_NOWRAP = 0;
    public static final int FLEX_WRAP_WRAP = 1;
    public static final int FLEX_WRAP_WRAP_REVERSE = 2;
    private int mFlexWrap;
    public static final int JUSTIFY_CONTENT_FLEX_START = 0;
    public static final int JUSTIFY_CONTENT_FLEX_END = 1;
    public static final int JUSTIFY_CONTENT_CENTER = 2;
    public static final int JUSTIFY_CONTENT_SPACE_BETWEEN = 3;
    public static final int JUSTIFY_CONTENT_SPACE_AROUND = 4;
    private int mJustifyContent;
    public static final int ALIGN_ITEMS_FLEX_START = 0;
    public static final int ALIGN_ITEMS_FLEX_END = 1;
    public static final int ALIGN_ITEMS_CENTER = 2;
    public static final int ALIGN_ITEMS_BASELINE = 3;
    public static final int ALIGN_ITEMS_STRETCH = 4;
    private int mAlignItems;
    public static final int ALIGN_CONTENT_FLEX_START = 0;
    public static final int ALIGN_CONTENT_FLEX_END = 1;
    public static final int ALIGN_CONTENT_CENTER = 2;
    public static final int ALIGN_CONTENT_SPACE_BETWEEN = 3;
    public static final int ALIGN_CONTENT_SPACE_AROUND = 4;
    public static final int ALIGN_CONTENT_STRETCH = 5;
    private int mAlignContent;
    private int[] mReorderedIndices;
    private SparseIntArray mOrderCache;
    private List<FlexLine> mFlexLines = new ArrayList<FlexLine>();
    private boolean[] mChildrenFrozen;

    public FlexboxLayout(Context context) {
        this(context, null);
    }

    public FlexboxLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public FlexboxLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.FlexboxLayout, defStyleAttr, 0);
        this.mFlexDirection = a.getInt(R.styleable.FlexboxLayout_flexDirection, 0);
        this.mFlexWrap = a.getInt(R.styleable.FlexboxLayout_flexWrap, 0);
        this.mJustifyContent = a.getInt(R.styleable.FlexboxLayout_justifyContent, 0);
        this.mAlignItems = a.getInt(R.styleable.FlexboxLayout_alignItems, 4);
        this.mAlignContent = a.getInt(R.styleable.FlexboxLayout_alignContent, 5);
        a.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.isOrderChangedFromLastMeasurement()) {
            this.mReorderedIndices = this.createReorderedIndices();
        }
        if (this.mChildrenFrozen == null || this.mChildrenFrozen.length < this.getChildCount()) {
            this.mChildrenFrozen = new boolean[this.getChildCount()];
        }
        switch (this.mFlexDirection) {
            case 0: 
            case 1: {
                this.measureHorizontal(widthMeasureSpec, heightMeasureSpec);
                break;
            }
            case 2: 
            case 3: {
                this.measureVertical(widthMeasureSpec, heightMeasureSpec);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid value for the flex direction is set: " + this.mFlexDirection);
            }
        }
        Arrays.fill(this.mChildrenFrozen, false);
    }

    public View getReorderedChildAt(int index) {
        if (index < 0 || index >= this.mReorderedIndices.length) {
            return null;
        }
        return this.getChildAt(this.mReorderedIndices[index]);
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        this.mReorderedIndices = this.createReorderedIndices(child, index, params);
        super.addView(child, index, params);
    }

    private int[] createReorderedIndices(View viewBeforeAdded, int indexForViewBeforeAdded, ViewGroup.LayoutParams paramsForViewBeforeAdded) {
        int childCount = this.getChildCount();
        List<Order> orders = this.createOrders(childCount);
        Order orderForViewToBeAdded = new Order();
        orderForViewToBeAdded.order = viewBeforeAdded != null && paramsForViewBeforeAdded instanceof LayoutParams ? ((LayoutParams)paramsForViewBeforeAdded).order : 1;
        if (indexForViewBeforeAdded == -1 || indexForViewBeforeAdded == childCount) {
            orderForViewToBeAdded.index = childCount;
        } else if (indexForViewBeforeAdded < this.getChildCount()) {
            orderForViewToBeAdded.index = indexForViewBeforeAdded;
            for (int i = indexForViewBeforeAdded; i < childCount; ++i) {
                ++orders.get((int)i).index;
            }
        } else {
            orderForViewToBeAdded.index = childCount;
        }
        orders.add(orderForViewToBeAdded);
        return this.sortOrdersIntoReorderedIndices(childCount + 1, orders);
    }

    private int[] createReorderedIndices() {
        int childCount = this.getChildCount();
        List<Order> orders = this.createOrders(childCount);
        return this.sortOrdersIntoReorderedIndices(childCount, orders);
    }

    private int[] sortOrdersIntoReorderedIndices(int childCount, List<Order> orders) {
        Collections.sort(orders);
        if (this.mOrderCache == null) {
            this.mOrderCache = new SparseIntArray(childCount);
        }
        this.mOrderCache.clear();
        int[] reorderedIndices = new int[childCount];
        int i = 0;
        for (Order order : orders) {
            reorderedIndices[i] = order.index;
            this.mOrderCache.append(i, order.order);
            ++i;
        }
        return reorderedIndices;
    }

    @NonNull
    private List<Order> createOrders(int childCount) {
        ArrayList<Order> orders = new ArrayList<Order>();
        int i = 0;
        while (i < childCount) {
            View child = this.getChildAt(i);
            LayoutParams params = (LayoutParams)child.getLayoutParams();
            Order order = new Order();
            order.order = params.order;
            order.index = i++;
            orders.add(order);
        }
        return orders;
    }

    private boolean isOrderChangedFromLastMeasurement() {
        int childCount = this.getChildCount();
        if (this.mOrderCache == null) {
            this.mOrderCache = new SparseIntArray(childCount);
        }
        if (this.mOrderCache.size() != childCount) {
            return true;
        }
        for (int i = 0; i < childCount; ++i) {
            View view = this.getChildAt(i);
            if (view == null) continue;
            LayoutParams lp = (LayoutParams)view.getLayoutParams();
            if (lp.order == this.mOrderCache.get(i)) continue;
            return true;
        }
        return false;
    }

    private void measureHorizontal(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int childState = 0;
        this.mFlexLines.clear();
        int childCount = this.getChildCount();
        int paddingStart = ViewCompat.getPaddingStart((View)this);
        int paddingEnd = ViewCompat.getPaddingEnd((View)this);
        int largestHeightInRow = Integer.MIN_VALUE;
        FlexLine flexLine = new FlexLine();
        flexLine.mainSize = paddingStart + paddingEnd;
        for (int i = 0; i < childCount; ++i) {
            View child = this.getReorderedChildAt(i);
            if (child == null) {
                this.addFlexLineIfLastFlexItem(i, childCount, flexLine);
                continue;
            }
            if (child.getVisibility() == 8) {
                ++flexLine.itemCount;
                this.addFlexLineIfLastFlexItem(i, childCount, flexLine);
                continue;
            }
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (lp.alignSelf == 4) {
                flexLine.indicesAlignSelfStretch.add(i);
            }
            int childWidth = lp.width;
            if (lp.flexBasisPercent != -1.0f && widthMode == 0x40000000) {
                childWidth = Math.round((float)widthSize * lp.flexBasisPercent);
            }
            int childWidthMeasureSpec = FlexboxLayout.getChildMeasureSpec((int)widthMeasureSpec, (int)(this.getPaddingLeft() + this.getPaddingRight() + lp.leftMargin + lp.rightMargin), (int)childWidth);
            int childHeightMeasureSpec = FlexboxLayout.getChildMeasureSpec((int)heightMeasureSpec, (int)(this.getPaddingTop() + this.getPaddingBottom() + lp.topMargin + lp.bottomMargin), (int)lp.height);
            child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
            this.checkSizeConstraints(child);
            childState = ViewCompat.combineMeasuredStates((int)childState, (int)ViewCompat.getMeasuredState((View)child));
            largestHeightInRow = Math.max(largestHeightInRow, child.getMeasuredHeight() + lp.topMargin + lp.bottomMargin);
            if (this.isWrapRequired(this.mFlexWrap, widthMode, widthSize, flexLine.mainSize, child.getMeasuredWidth() + lp.leftMargin + lp.rightMargin, lp)) {
                this.mFlexLines.add(flexLine);
                flexLine = new FlexLine();
                flexLine.itemCount = 1;
                flexLine.mainSize = paddingStart + paddingEnd;
                largestHeightInRow = child.getMeasuredHeight() + lp.topMargin + lp.bottomMargin;
            } else {
                ++flexLine.itemCount;
            }
            flexLine.mainSize += child.getMeasuredWidth() + lp.leftMargin + lp.rightMargin;
            flexLine.totalFlexGrow += lp.flexGrow;
            flexLine.totalFlexShrink += lp.flexShrink;
            flexLine.crossSize = Math.max(flexLine.crossSize, largestHeightInRow);
            flexLine.maxBaseline = this.mFlexWrap != 2 ? Math.max(flexLine.maxBaseline, child.getBaseline() + lp.topMargin) : Math.max(flexLine.maxBaseline, child.getMeasuredHeight() - child.getBaseline() + lp.bottomMargin);
            this.addFlexLineIfLastFlexItem(i, childCount, flexLine);
        }
        this.determineMainSize(this.mFlexDirection, widthMeasureSpec, heightMeasureSpec);
        if (this.mAlignItems == 3) {
            int viewIndex = 0;
            for (FlexLine flexLine2 : this.mFlexLines) {
                int largestHeightInLine = Integer.MIN_VALUE;
                for (int i = viewIndex; i < viewIndex + flexLine2.itemCount; ++i) {
                    View child = this.getReorderedChildAt(i);
                    LayoutParams lp = (LayoutParams)child.getLayoutParams();
                    if (this.mFlexWrap != 2) {
                        int marginTop = flexLine2.maxBaseline - child.getBaseline();
                        marginTop = Math.max(marginTop, lp.topMargin);
                        largestHeightInLine = Math.max(largestHeightInLine, child.getHeight() + marginTop + lp.bottomMargin);
                        continue;
                    }
                    int marginBottom = flexLine2.maxBaseline - child.getMeasuredHeight() + child.getBaseline();
                    marginBottom = Math.max(marginBottom, lp.bottomMargin);
                    largestHeightInLine = Math.max(largestHeightInLine, child.getHeight() + lp.topMargin + marginBottom);
                }
                flexLine2.crossSize = largestHeightInLine;
                viewIndex += flexLine2.itemCount;
            }
        }
        this.determineCrossSize(this.mFlexDirection, widthMeasureSpec, heightMeasureSpec, this.getPaddingTop() + this.getPaddingBottom());
        this.stretchViews(this.mFlexDirection, this.mAlignItems);
        this.setMeasuredDimensionForFlex(this.mFlexDirection, widthMeasureSpec, heightMeasureSpec, childState);
    }

    private void measureVertical(int widthMeasureSpec, int heightMeasureSpec) {
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int childState = 0;
        this.mFlexLines.clear();
        int childCount = this.getChildCount();
        int paddingTop = this.getPaddingTop();
        int paddingBottom = this.getPaddingBottom();
        int largestWidthInColumn = Integer.MIN_VALUE;
        FlexLine flexLine = new FlexLine();
        flexLine.mainSize = paddingTop + paddingBottom;
        for (int i = 0; i < childCount; ++i) {
            View child = this.getReorderedChildAt(i);
            if (child == null) {
                this.addFlexLineIfLastFlexItem(i, childCount, flexLine);
                continue;
            }
            if (child.getVisibility() == 8) {
                ++flexLine.itemCount;
                this.addFlexLineIfLastFlexItem(i, childCount, flexLine);
                continue;
            }
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (lp.alignSelf == 4) {
                flexLine.indicesAlignSelfStretch.add(i);
            }
            int childHeight = lp.height;
            if (lp.flexBasisPercent != -1.0f && heightMode == 0x40000000) {
                childHeight = Math.round((float)heightSize * lp.flexBasisPercent);
            }
            int childWidthMeasureSpec = FlexboxLayout.getChildMeasureSpec((int)widthMeasureSpec, (int)(this.getPaddingLeft() + this.getPaddingRight() + lp.leftMargin + lp.rightMargin), (int)lp.width);
            int childHeightMeasureSpec = FlexboxLayout.getChildMeasureSpec((int)heightMeasureSpec, (int)(this.getPaddingTop() + this.getPaddingBottom() + lp.topMargin + lp.bottomMargin), (int)childHeight);
            child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
            this.checkSizeConstraints(child);
            childState = ViewCompat.combineMeasuredStates((int)childState, (int)ViewCompat.getMeasuredState((View)child));
            largestWidthInColumn = Math.max(largestWidthInColumn, child.getMeasuredWidth() + lp.leftMargin + lp.rightMargin);
            if (this.isWrapRequired(this.mFlexWrap, heightMode, heightSize, flexLine.mainSize, child.getMeasuredHeight() + lp.topMargin + lp.bottomMargin, lp)) {
                this.mFlexLines.add(flexLine);
                flexLine = new FlexLine();
                flexLine.itemCount = 1;
                flexLine.mainSize = paddingTop + paddingBottom;
                largestWidthInColumn = child.getMeasuredWidth() + lp.leftMargin + lp.rightMargin;
            } else {
                ++flexLine.itemCount;
            }
            flexLine.mainSize += child.getMeasuredHeight() + lp.topMargin + lp.bottomMargin;
            flexLine.totalFlexGrow += lp.flexGrow;
            flexLine.totalFlexShrink += lp.flexShrink;
            flexLine.crossSize = Math.max(flexLine.crossSize, largestWidthInColumn);
            this.addFlexLineIfLastFlexItem(i, childCount, flexLine);
        }
        this.determineMainSize(this.mFlexDirection, widthMeasureSpec, heightMeasureSpec);
        this.determineCrossSize(this.mFlexDirection, widthMeasureSpec, heightMeasureSpec, this.getPaddingLeft() + this.getPaddingRight());
        this.stretchViews(this.mFlexDirection, this.mAlignItems);
        this.setMeasuredDimensionForFlex(this.mFlexDirection, widthMeasureSpec, heightMeasureSpec, childState);
    }

    private void checkSizeConstraints(View view) {
        boolean needsMeasure = false;
        LayoutParams lp = (LayoutParams)view.getLayoutParams();
        int childWidth = view.getMeasuredWidth();
        int childHeight = view.getMeasuredHeight();
        if (view.getMeasuredWidth() < lp.minWidth) {
            needsMeasure = true;
            childWidth = lp.minWidth;
        } else if (view.getMeasuredWidth() > lp.maxWidth) {
            needsMeasure = true;
            childWidth = lp.maxWidth;
        }
        if (childHeight < lp.minHeight) {
            needsMeasure = true;
            childHeight = lp.minHeight;
        } else if (childHeight > lp.maxHeight) {
            needsMeasure = true;
            childHeight = lp.maxHeight;
        }
        if (needsMeasure) {
            view.measure(View.MeasureSpec.makeMeasureSpec((int)childWidth, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)childHeight, (int)0x40000000));
        }
    }

    private void addFlexLineIfLastFlexItem(int childIndex, int childCount, FlexLine flexLine) {
        if (childIndex == childCount - 1 && flexLine.itemCount != 0) {
            this.mFlexLines.add(flexLine);
        }
    }

    private void determineMainSize(int flexDirection, int widthMeasureSpec, int heightMeasureSpec) {
        int paddingAlongMainAxis;
        int mainSize;
        switch (flexDirection) {
            case 0: 
            case 1: {
                int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
                int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
                mainSize = widthMode == 0x40000000 ? widthSize : this.getLargestMainSize();
                paddingAlongMainAxis = this.getPaddingLeft() + this.getPaddingRight();
                break;
            }
            case 2: 
            case 3: {
                int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
                int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
                mainSize = heightMode == 0x40000000 ? heightSize : this.getLargestMainSize();
                paddingAlongMainAxis = this.getPaddingTop() + this.getPaddingBottom();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid flex direction: " + flexDirection);
            }
        }
        int childIndex = 0;
        for (FlexLine flexLine : this.mFlexLines) {
            if (flexLine.mainSize < mainSize) {
                childIndex = this.expandFlexItems(flexLine, flexDirection, mainSize, paddingAlongMainAxis, childIndex);
                continue;
            }
            childIndex = this.shrinkFlexItems(flexLine, flexDirection, mainSize, paddingAlongMainAxis, childIndex);
        }
    }

    private int expandFlexItems(FlexLine flexLine, int flexDirection, int maxMainSize, int paddingAlongMainAxis, int startIndex) {
        int childIndex = startIndex;
        if (flexLine.totalFlexGrow <= 0.0f || maxMainSize < flexLine.mainSize) {
            return childIndex += flexLine.itemCount;
        }
        int sizeBeforeExpand = flexLine.mainSize;
        boolean needsReexpand = false;
        float unitSpace = (float)(maxMainSize - flexLine.mainSize) / flexLine.totalFlexGrow;
        flexLine.mainSize = paddingAlongMainAxis;
        float accumulatedRoundError = 0.0f;
        for (int i = 0; i < flexLine.itemCount; ++i) {
            View child = this.getReorderedChildAt(childIndex);
            if (child == null) continue;
            if (child.getVisibility() == 8) {
                ++childIndex;
                continue;
            }
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (flexDirection == 0 || flexDirection == 1) {
                if (!this.mChildrenFrozen[childIndex]) {
                    int newWidth;
                    float rawCalculatedWidth = (float)child.getMeasuredWidth() + unitSpace * lp.flexGrow;
                    if (i == flexLine.itemCount - 1) {
                        rawCalculatedWidth += accumulatedRoundError;
                        accumulatedRoundError = 0.0f;
                    }
                    if ((newWidth = Math.round(rawCalculatedWidth)) > lp.maxWidth) {
                        needsReexpand = true;
                        newWidth = lp.maxWidth;
                        this.mChildrenFrozen[childIndex] = true;
                        flexLine.totalFlexGrow -= lp.flexGrow;
                    } else if ((double)(accumulatedRoundError += rawCalculatedWidth - (float)newWidth) > 1.0) {
                        ++newWidth;
                        accumulatedRoundError = (float)((double)accumulatedRoundError - 1.0);
                    } else if ((double)accumulatedRoundError < -1.0) {
                        --newWidth;
                        accumulatedRoundError = (float)((double)accumulatedRoundError + 1.0);
                    }
                    child.measure(View.MeasureSpec.makeMeasureSpec((int)newWidth, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)child.getMeasuredHeight(), (int)0x40000000));
                }
                flexLine.mainSize += child.getMeasuredWidth() + lp.leftMargin + lp.rightMargin;
            } else {
                if (!this.mChildrenFrozen[childIndex]) {
                    int newHeight;
                    float rawCalculatedHeight = (float)child.getMeasuredHeight() + unitSpace * lp.flexGrow;
                    if (i == flexLine.itemCount - 1) {
                        rawCalculatedHeight += accumulatedRoundError;
                        accumulatedRoundError = 0.0f;
                    }
                    if ((newHeight = Math.round(rawCalculatedHeight)) > lp.maxHeight) {
                        needsReexpand = true;
                        newHeight = lp.maxHeight;
                        this.mChildrenFrozen[childIndex] = true;
                        flexLine.totalFlexGrow -= lp.flexGrow;
                    } else if ((double)(accumulatedRoundError += rawCalculatedHeight - (float)newHeight) > 1.0) {
                        ++newHeight;
                        accumulatedRoundError = (float)((double)accumulatedRoundError - 1.0);
                    } else if ((double)accumulatedRoundError < -1.0) {
                        --newHeight;
                        accumulatedRoundError = (float)((double)accumulatedRoundError + 1.0);
                    }
                    child.measure(View.MeasureSpec.makeMeasureSpec((int)child.getMeasuredWidth(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)newHeight, (int)0x40000000));
                }
                flexLine.mainSize += child.getMeasuredHeight() + lp.topMargin + lp.bottomMargin;
            }
            ++childIndex;
        }
        if (needsReexpand && sizeBeforeExpand != flexLine.mainSize) {
            this.expandFlexItems(flexLine, flexDirection, maxMainSize, paddingAlongMainAxis, startIndex);
        }
        return childIndex;
    }

    private int shrinkFlexItems(FlexLine flexLine, int flexDirection, int maxMainSize, int paddingAlongMainAxis, int startIndex) {
        int childIndex = startIndex;
        int sizeBeforeShrink = flexLine.mainSize;
        if (flexLine.totalFlexShrink <= 0.0f || maxMainSize > flexLine.mainSize) {
            return childIndex += flexLine.itemCount;
        }
        boolean needsReshrink = false;
        float unitShrink = (float)(flexLine.mainSize - maxMainSize) / flexLine.totalFlexShrink;
        float accumulatedRoundError = 0.0f;
        flexLine.mainSize = paddingAlongMainAxis;
        for (int i = 0; i < flexLine.itemCount; ++i) {
            View child = this.getReorderedChildAt(childIndex);
            if (child == null) continue;
            if (child.getVisibility() == 8) {
                ++childIndex;
                continue;
            }
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (flexDirection == 0 || flexDirection == 1) {
                if (!this.mChildrenFrozen[childIndex]) {
                    int newWidth;
                    float rawCalculatedWidth = (float)child.getMeasuredWidth() - unitShrink * lp.flexShrink;
                    if (i == flexLine.itemCount - 1) {
                        rawCalculatedWidth += accumulatedRoundError;
                        accumulatedRoundError = 0.0f;
                    }
                    if ((newWidth = Math.round(rawCalculatedWidth)) < lp.minWidth) {
                        needsReshrink = true;
                        newWidth = lp.minWidth;
                        this.mChildrenFrozen[childIndex] = true;
                        flexLine.totalFlexShrink -= lp.flexShrink;
                    } else if ((double)(accumulatedRoundError += rawCalculatedWidth - (float)newWidth) > 1.0) {
                        ++newWidth;
                        accumulatedRoundError -= 1.0f;
                    } else if ((double)accumulatedRoundError < -1.0) {
                        --newWidth;
                        accumulatedRoundError += 1.0f;
                    }
                    child.measure(View.MeasureSpec.makeMeasureSpec((int)newWidth, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)child.getMeasuredHeight(), (int)0x40000000));
                }
                flexLine.mainSize += child.getMeasuredWidth() + lp.leftMargin + lp.rightMargin;
            } else {
                if (!this.mChildrenFrozen[childIndex]) {
                    int newHeight;
                    float rawCalculatedHeight = (float)child.getMeasuredHeight() - unitShrink * lp.flexShrink;
                    if (i == flexLine.itemCount - 1) {
                        rawCalculatedHeight += accumulatedRoundError;
                        accumulatedRoundError = 0.0f;
                    }
                    if ((newHeight = Math.round(rawCalculatedHeight)) < lp.minHeight) {
                        needsReshrink = true;
                        newHeight = lp.minHeight;
                        this.mChildrenFrozen[childIndex] = true;
                        flexLine.totalFlexShrink -= lp.flexShrink;
                    } else if ((double)(accumulatedRoundError += rawCalculatedHeight - (float)newHeight) > 1.0) {
                        ++newHeight;
                        accumulatedRoundError -= 1.0f;
                    } else if ((double)accumulatedRoundError < -1.0) {
                        --newHeight;
                        accumulatedRoundError += 1.0f;
                    }
                    child.measure(View.MeasureSpec.makeMeasureSpec((int)child.getMeasuredWidth(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)newHeight, (int)0x40000000));
                }
                flexLine.mainSize += child.getMeasuredHeight() + lp.topMargin + lp.bottomMargin;
            }
            ++childIndex;
        }
        if (needsReshrink && sizeBeforeShrink != flexLine.mainSize) {
            this.shrinkFlexItems(flexLine, flexDirection, maxMainSize, paddingAlongMainAxis, startIndex);
        }
        return childIndex;
    }

    private void determineCrossSize(int flexDirection, int widthMeasureSpec, int heightMeasureSpec, int paddingAlongCrossAxis) {
        int size;
        int mode;
        switch (flexDirection) {
            case 0: 
            case 1: {
                mode = View.MeasureSpec.getMode((int)heightMeasureSpec);
                size = View.MeasureSpec.getSize((int)heightMeasureSpec);
                break;
            }
            case 2: 
            case 3: {
                mode = View.MeasureSpec.getMode((int)widthMeasureSpec);
                size = View.MeasureSpec.getSize((int)widthMeasureSpec);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid flex direction: " + flexDirection);
            }
        }
        if (mode == 0x40000000) {
            int totalCrossSize = this.getSumOfCrossSize() + paddingAlongCrossAxis;
            if (this.mFlexLines.size() == 1) {
                this.mFlexLines.get((int)0).crossSize = size - paddingAlongCrossAxis;
            } else if (this.mFlexLines.size() >= 2 && totalCrossSize < size) {
                switch (this.mAlignContent) {
                    case 5: {
                        float freeSpaceUnit = (float)(size - totalCrossSize) / (float)this.mFlexLines.size();
                        float accumulatedError = 0.0f;
                        for (int i = 0; i < this.mFlexLines.size(); ++i) {
                            int newCrossSize;
                            FlexLine flexLine = this.mFlexLines.get(i);
                            float newCrossSizeAsFloat = (float)flexLine.crossSize + freeSpaceUnit;
                            if (i == this.mFlexLines.size() - 1) {
                                newCrossSizeAsFloat += accumulatedError;
                                accumulatedError = 0.0f;
                            }
                            if ((accumulatedError += newCrossSizeAsFloat - (float)(newCrossSize = Math.round(newCrossSizeAsFloat))) > 1.0f) {
                                accumulatedError -= 1.0f;
                            } else if (accumulatedError < -1.0f) {
                                --newCrossSize;
                                accumulatedError += 1.0f;
                            }
                            flexLine.crossSize = ++newCrossSize;
                        }
                        break;
                    }
                    case 4: {
                        int spaceTopAndBottom = size - totalCrossSize;
                        int numberOfSpaces = this.mFlexLines.size() * 2;
                        ArrayList<FlexLine> newFlexLines = new ArrayList<FlexLine>();
                        FlexLine dummySpaceFlexLine = new FlexLine();
                        dummySpaceFlexLine.crossSize = spaceTopAndBottom /= numberOfSpaces;
                        for (FlexLine flexLine : this.mFlexLines) {
                            newFlexLines.add(dummySpaceFlexLine);
                            newFlexLines.add(flexLine);
                            newFlexLines.add(dummySpaceFlexLine);
                        }
                        this.mFlexLines = newFlexLines;
                        break;
                    }
                    case 3: {
                        float spaceBetweenFlexLine = size - totalCrossSize;
                        int numberOfSpaces = this.mFlexLines.size() - 1;
                        spaceBetweenFlexLine /= (float)numberOfSpaces;
                        float accumulatedError = 0.0f;
                        ArrayList<FlexLine> newFlexLines = new ArrayList<FlexLine>();
                        for (int i = 0; i < this.mFlexLines.size(); ++i) {
                            FlexLine flexLine = this.mFlexLines.get(i);
                            newFlexLines.add(flexLine);
                            if (i == this.mFlexLines.size() - 1) continue;
                            FlexLine dummySpaceFlexLine = new FlexLine();
                            if (i == this.mFlexLines.size() - 2) {
                                dummySpaceFlexLine.crossSize = Math.round(spaceBetweenFlexLine + accumulatedError);
                                accumulatedError = 0.0f;
                            } else {
                                dummySpaceFlexLine.crossSize = Math.round(spaceBetweenFlexLine);
                            }
                            accumulatedError += spaceBetweenFlexLine - (float)dummySpaceFlexLine.crossSize;
                            if (accumulatedError > 1.0f) {
                                ++dummySpaceFlexLine.crossSize;
                                accumulatedError -= 1.0f;
                            } else if (accumulatedError < -1.0f) {
                                --dummySpaceFlexLine.crossSize;
                                accumulatedError += 1.0f;
                            }
                            newFlexLines.add(dummySpaceFlexLine);
                        }
                        this.mFlexLines = newFlexLines;
                        break;
                    }
                    case 2: {
                        int spaceAboveAndBottom = size - totalCrossSize;
                        ArrayList<FlexLine> newFlexLines = new ArrayList<FlexLine>();
                        FlexLine dummySpaceFlexLine = new FlexLine();
                        dummySpaceFlexLine.crossSize = spaceAboveAndBottom /= 2;
                        for (int i = 0; i < this.mFlexLines.size(); ++i) {
                            if (i == 0) {
                                newFlexLines.add(dummySpaceFlexLine);
                            }
                            FlexLine flexLine = this.mFlexLines.get(i);
                            newFlexLines.add(flexLine);
                            if (i != this.mFlexLines.size() - 1) continue;
                            newFlexLines.add(dummySpaceFlexLine);
                        }
                        this.mFlexLines = newFlexLines;
                        break;
                    }
                    case 1: {
                        int spaceTop = size - totalCrossSize;
                        FlexLine dummySpaceFlexLine = new FlexLine();
                        dummySpaceFlexLine.crossSize = spaceTop;
                        this.mFlexLines.add(0, dummySpaceFlexLine);
                        break;
                    }
                }
            }
        }
    }

    private void stretchViews(int flexDirection, int alignItems) {
        if (alignItems == 4) {
            int viewIndex = 0;
            for (FlexLine flexLine : this.mFlexLines) {
                int i = 0;
                while (i < flexLine.itemCount) {
                    View view = this.getReorderedChildAt(viewIndex);
                    LayoutParams lp = (LayoutParams)view.getLayoutParams();
                    if (lp.alignSelf == -1 || lp.alignSelf == 4) {
                        switch (flexDirection) {
                            case 0: 
                            case 1: {
                                this.stretchViewVertically(view, flexLine.crossSize);
                                break;
                            }
                            case 2: 
                            case 3: {
                                this.stretchViewHorizontally(view, flexLine.crossSize);
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Invalid flex direction: " + flexDirection);
                            }
                        }
                    }
                    ++i;
                    ++viewIndex;
                }
            }
        } else {
            for (FlexLine flexLine : this.mFlexLines) {
                block11: for (Integer index : flexLine.indicesAlignSelfStretch) {
                    View view = this.getReorderedChildAt(index);
                    switch (flexDirection) {
                        case 0: 
                        case 1: {
                            this.stretchViewVertically(view, flexLine.crossSize);
                            continue block11;
                        }
                        case 2: 
                        case 3: {
                            this.stretchViewHorizontally(view, flexLine.crossSize);
                            continue block11;
                        }
                    }
                    throw new IllegalArgumentException("Invalid flex direction: " + flexDirection);
                }
            }
        }
    }

    private void stretchViewVertically(View view, int crossSize) {
        LayoutParams lp = (LayoutParams)view.getLayoutParams();
        int newHeight = crossSize - lp.topMargin - lp.bottomMargin;
        newHeight = Math.max(newHeight, 0);
        view.measure(View.MeasureSpec.makeMeasureSpec((int)view.getMeasuredWidth(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)newHeight, (int)0x40000000));
    }

    private void stretchViewHorizontally(View view, int crossSize) {
        LayoutParams lp = (LayoutParams)view.getLayoutParams();
        int newWidth = crossSize - lp.leftMargin - lp.rightMargin;
        newWidth = Math.max(newWidth, 0);
        view.measure(View.MeasureSpec.makeMeasureSpec((int)newWidth, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)view.getMeasuredHeight(), (int)0x40000000));
    }

    private void setMeasuredDimensionForFlex(int flexDirection, int widthMeasureSpec, int heightMeasureSpec, int childState) {
        int heightSizeAndState;
        int widthSizeAndState;
        int calculatedMaxWidth;
        int calculatedMaxHeight;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        switch (flexDirection) {
            case 0: 
            case 1: {
                calculatedMaxHeight = this.getSumOfCrossSize() + this.getPaddingTop() + this.getPaddingBottom();
                calculatedMaxWidth = this.getLargestMainSize();
                break;
            }
            case 2: 
            case 3: {
                calculatedMaxHeight = this.getLargestMainSize();
                calculatedMaxWidth = this.getSumOfCrossSize() + this.getPaddingLeft() + this.getPaddingRight();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid flex direction: " + flexDirection);
            }
        }
        switch (widthMode) {
            case 0x40000000: {
                if (widthSize < calculatedMaxWidth) {
                    childState = ViewCompat.combineMeasuredStates((int)childState, (int)0x1000000);
                }
                widthSizeAndState = ViewCompat.resolveSizeAndState((int)widthSize, (int)widthMeasureSpec, (int)childState);
                break;
            }
            case -2147483648: {
                if (widthSize < calculatedMaxWidth) {
                    childState = ViewCompat.combineMeasuredStates((int)childState, (int)0x1000000);
                } else {
                    widthSize = calculatedMaxWidth;
                }
                widthSizeAndState = ViewCompat.resolveSizeAndState((int)widthSize, (int)widthMeasureSpec, (int)childState);
                break;
            }
            case 0: {
                widthSizeAndState = ViewCompat.resolveSizeAndState((int)calculatedMaxWidth, (int)widthMeasureSpec, (int)childState);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown width mode is set: " + widthMode);
            }
        }
        switch (heightMode) {
            case 0x40000000: {
                if (heightSize < calculatedMaxHeight) {
                    childState = ViewCompat.combineMeasuredStates((int)childState, (int)256);
                }
                heightSizeAndState = ViewCompat.resolveSizeAndState((int)heightSize, (int)heightMeasureSpec, (int)childState);
                break;
            }
            case -2147483648: {
                if (heightSize < calculatedMaxHeight) {
                    childState = ViewCompat.combineMeasuredStates((int)childState, (int)256);
                } else {
                    heightSize = calculatedMaxHeight;
                }
                heightSizeAndState = ViewCompat.resolveSizeAndState((int)heightSize, (int)heightMeasureSpec, (int)childState);
                break;
            }
            case 0: {
                heightSizeAndState = ViewCompat.resolveSizeAndState((int)calculatedMaxHeight, (int)heightMeasureSpec, (int)childState);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown height mode is set: " + heightMode);
            }
        }
        this.setMeasuredDimension(widthSizeAndState, heightSizeAndState);
    }

    private boolean isWrapRequired(int flexWrap, int mode, int maxSize, int currentLength, int childLength, LayoutParams lp) {
        if (flexWrap == 0) {
            return false;
        }
        if (lp.wrapBefore) {
            return true;
        }
        return (mode == 0x40000000 || mode == Integer.MIN_VALUE) && maxSize < currentLength + childLength;
    }

    private int getLargestMainSize() {
        int largestSize = Integer.MIN_VALUE;
        for (FlexLine flexLine : this.mFlexLines) {
            largestSize = Math.max(largestSize, flexLine.mainSize);
        }
        return largestSize;
    }

    private int getSumOfCrossSize() {
        int sum = 0;
        for (FlexLine flexLine : this.mFlexLines) {
            sum += flexLine.crossSize;
        }
        return sum;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int layoutDirection = ViewCompat.getLayoutDirection((View)this);
        switch (this.mFlexDirection) {
            case 0: {
                boolean isRtl = layoutDirection == 1;
                this.layoutHorizontal(isRtl, left, top, right, bottom);
                break;
            }
            case 1: {
                boolean isRtl = layoutDirection != 1;
                this.layoutHorizontal(isRtl, left, top, right, bottom);
                break;
            }
            case 2: {
                boolean isRtl;
                boolean bl = isRtl = layoutDirection == 1;
                if (this.mFlexWrap == 2) {
                    isRtl = !isRtl;
                }
                this.layoutVertical(isRtl, false, left, top, right, bottom);
                break;
            }
            case 3: {
                boolean isRtl;
                boolean bl = isRtl = layoutDirection == 1;
                if (this.mFlexWrap == 2) {
                    isRtl = !isRtl;
                }
                this.layoutVertical(isRtl, true, left, top, right, bottom);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid flex direction is set: " + this.mFlexDirection);
            }
        }
    }

    private void layoutHorizontal(boolean isRtl, int left, int top, int right, int bottom) {
        int paddingLeft = this.getPaddingLeft();
        int paddingRight = this.getPaddingRight();
        int currentViewIndex = 0;
        int height = bottom - top;
        int width = right - left;
        int childBottom = height - this.getPaddingBottom();
        int childTop = this.getPaddingTop();
        for (FlexLine flexLine : this.mFlexLines) {
            float childRight;
            float childLeft;
            float spaceBetweenItem = 0.0f;
            switch (this.mJustifyContent) {
                case 0: {
                    childLeft = paddingLeft;
                    childRight = width - paddingRight;
                    break;
                }
                case 1: {
                    childLeft = width - flexLine.mainSize + paddingRight;
                    childRight = flexLine.mainSize - paddingLeft;
                    break;
                }
                case 2: {
                    childLeft = (float)paddingLeft + (float)(width - flexLine.mainSize) / 2.0f;
                    childRight = (float)(width - paddingRight) - (float)(width - flexLine.mainSize) / 2.0f;
                    break;
                }
                case 4: {
                    if (flexLine.itemCount != 0) {
                        spaceBetweenItem = (float)(width - flexLine.mainSize) / (float)flexLine.itemCount;
                    }
                    childLeft = (float)paddingLeft + spaceBetweenItem / 2.0f;
                    childRight = (float)(width - paddingRight) - spaceBetweenItem / 2.0f;
                    break;
                }
                case 3: {
                    childLeft = paddingLeft;
                    float denominator = flexLine.itemCount != 1 ? (float)(flexLine.itemCount - 1) : 1.0f;
                    spaceBetweenItem = (float)(width - flexLine.mainSize) / denominator;
                    childRight = width - paddingRight;
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid justifyContent is set: " + this.mJustifyContent);
                }
            }
            spaceBetweenItem = Math.max(spaceBetweenItem, 0.0f);
            for (int i = 0; i < flexLine.itemCount; ++i) {
                View child = this.getReorderedChildAt(currentViewIndex);
                if (child == null) continue;
                if (child.getVisibility() == 8) {
                    ++currentViewIndex;
                    continue;
                }
                LayoutParams lp = (LayoutParams)child.getLayoutParams();
                childLeft += (float)lp.leftMargin;
                childRight -= (float)lp.rightMargin;
                if (this.mFlexWrap == 2) {
                    if (isRtl) {
                        this.layoutSingleChildHorizontal(child, flexLine, this.mFlexWrap, this.mAlignItems, Math.round(childRight) - child.getMeasuredWidth(), childBottom - child.getMeasuredHeight(), Math.round(childRight), childBottom);
                    } else {
                        this.layoutSingleChildHorizontal(child, flexLine, this.mFlexWrap, this.mAlignItems, Math.round(childLeft), childBottom - child.getMeasuredHeight(), Math.round(childLeft) + child.getMeasuredWidth(), childBottom);
                    }
                } else if (isRtl) {
                    this.layoutSingleChildHorizontal(child, flexLine, this.mFlexWrap, this.mAlignItems, Math.round(childRight) - child.getMeasuredWidth(), childTop, Math.round(childRight), childTop + child.getMeasuredHeight());
                } else {
                    this.layoutSingleChildHorizontal(child, flexLine, this.mFlexWrap, this.mAlignItems, Math.round(childLeft), childTop, Math.round(childLeft) + child.getMeasuredWidth(), childTop + child.getMeasuredHeight());
                }
                childLeft += (float)child.getMeasuredWidth() + spaceBetweenItem + (float)lp.rightMargin;
                childRight -= (float)child.getMeasuredWidth() + spaceBetweenItem + (float)lp.leftMargin;
                ++currentViewIndex;
            }
            childTop += flexLine.crossSize;
            childBottom -= flexLine.crossSize;
        }
    }

    private void layoutSingleChildHorizontal(View view, FlexLine flexLine, int flexWrap, int alignItems, int left, int top, int right, int bottom) {
        LayoutParams lp = (LayoutParams)view.getLayoutParams();
        if (lp.alignSelf != -1) {
            alignItems = lp.alignSelf;
        }
        int crossSize = flexLine.crossSize;
        switch (alignItems) {
            case 0: 
            case 4: {
                if (flexWrap != 2) {
                    view.layout(left, top + lp.topMargin, right, bottom + lp.topMargin);
                    break;
                }
                view.layout(left, top - lp.bottomMargin, right, bottom - lp.bottomMargin);
                break;
            }
            case 3: {
                if (flexWrap != 2) {
                    int marginTop = flexLine.maxBaseline - view.getBaseline();
                    marginTop = Math.max(marginTop, lp.topMargin);
                    view.layout(left, top + marginTop, right, bottom + marginTop);
                    break;
                }
                int marginBottom = flexLine.maxBaseline - view.getMeasuredHeight() + view.getBaseline();
                marginBottom = Math.max(marginBottom, lp.bottomMargin);
                view.layout(left, top - marginBottom, right, bottom - marginBottom);
                break;
            }
            case 1: {
                if (flexWrap != 2) {
                    view.layout(left, top + crossSize - view.getMeasuredHeight() - lp.bottomMargin, right, top + crossSize - lp.bottomMargin);
                    break;
                }
                view.layout(left, top - crossSize + view.getMeasuredHeight() + lp.topMargin, right, bottom - crossSize + view.getMeasuredHeight() + lp.topMargin);
                break;
            }
            case 2: {
                int topFromCrossAxis = (crossSize - view.getMeasuredHeight()) / 2;
                if (flexWrap != 2) {
                    view.layout(left, top + topFromCrossAxis + lp.topMargin - lp.bottomMargin, right, top + topFromCrossAxis + view.getMeasuredHeight() + lp.topMargin - lp.bottomMargin);
                    break;
                }
                view.layout(left, top - topFromCrossAxis + lp.topMargin - lp.bottomMargin, right, top - topFromCrossAxis + view.getMeasuredHeight() + lp.topMargin - lp.bottomMargin);
            }
        }
    }

    private void layoutVertical(boolean isRtl, boolean fromBottomToTop, int left, int top, int right, int bottom) {
        int paddingTop = this.getPaddingTop();
        int paddingBottom = this.getPaddingBottom();
        int paddingRight = this.getPaddingRight();
        int childLeft = this.getPaddingLeft();
        int currentViewIndex = 0;
        int width = right - left;
        int height = bottom - top;
        int childRight = width - paddingRight;
        for (FlexLine flexLine : this.mFlexLines) {
            float childBottom;
            float childTop;
            float spaceBetweenItem = 0.0f;
            switch (this.mJustifyContent) {
                case 0: {
                    childTop = paddingTop;
                    childBottom = height - paddingBottom;
                    break;
                }
                case 1: {
                    childTop = height - flexLine.mainSize + paddingBottom;
                    childBottom = flexLine.mainSize - paddingTop;
                    break;
                }
                case 2: {
                    childTop = (float)paddingTop + (float)(height - flexLine.mainSize) / 2.0f;
                    childBottom = (float)(height - paddingBottom) - (float)(height - flexLine.mainSize) / 2.0f;
                    break;
                }
                case 4: {
                    if (flexLine.itemCount != 0) {
                        spaceBetweenItem = (float)(height - flexLine.mainSize) / (float)flexLine.itemCount;
                    }
                    childTop = (float)paddingTop + spaceBetweenItem / 2.0f;
                    childBottom = (float)(height - paddingBottom) - spaceBetweenItem / 2.0f;
                    break;
                }
                case 3: {
                    childTop = paddingTop;
                    float denominator = flexLine.itemCount != 1 ? (float)(flexLine.itemCount - 1) : 1.0f;
                    spaceBetweenItem = (float)(height - flexLine.mainSize) / denominator;
                    childBottom = height - paddingBottom;
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid justifyContent is set: " + this.mJustifyContent);
                }
            }
            spaceBetweenItem = Math.max(spaceBetweenItem, 0.0f);
            for (int i = 0; i < flexLine.itemCount; ++i) {
                View child = this.getReorderedChildAt(currentViewIndex);
                if (child == null) continue;
                if (child.getVisibility() == 8) {
                    ++currentViewIndex;
                    continue;
                }
                LayoutParams lp = (LayoutParams)child.getLayoutParams();
                childTop += (float)lp.topMargin;
                childBottom -= (float)lp.bottomMargin;
                if (isRtl) {
                    if (fromBottomToTop) {
                        this.layoutSingleChildVertical(child, flexLine, true, this.mAlignItems, childRight - child.getMeasuredWidth(), Math.round(childBottom) - child.getMeasuredHeight(), childRight, Math.round(childBottom));
                    } else {
                        this.layoutSingleChildVertical(child, flexLine, true, this.mAlignItems, childRight - child.getMeasuredWidth(), Math.round(childTop), childRight, Math.round(childTop) + child.getMeasuredHeight());
                    }
                } else if (fromBottomToTop) {
                    this.layoutSingleChildVertical(child, flexLine, false, this.mAlignItems, childLeft, Math.round(childBottom) - child.getMeasuredHeight(), childLeft + child.getMeasuredWidth(), Math.round(childBottom));
                } else {
                    this.layoutSingleChildVertical(child, flexLine, false, this.mAlignItems, childLeft, Math.round(childTop), childLeft + child.getMeasuredWidth(), Math.round(childTop) + child.getMeasuredHeight());
                }
                childTop += (float)child.getMeasuredHeight() + spaceBetweenItem + (float)lp.bottomMargin;
                childBottom -= (float)child.getMeasuredHeight() + spaceBetweenItem + (float)lp.topMargin;
                ++currentViewIndex;
            }
            childLeft += flexLine.crossSize;
            childRight -= flexLine.crossSize;
        }
    }

    private void layoutSingleChildVertical(View view, FlexLine flexLine, boolean isRtl, int alignItems, int left, int top, int right, int bottom) {
        LayoutParams lp = (LayoutParams)view.getLayoutParams();
        if (lp.alignSelf != -1) {
            alignItems = lp.alignSelf;
        }
        int crossSize = flexLine.crossSize;
        switch (alignItems) {
            case 0: 
            case 3: 
            case 4: {
                if (!isRtl) {
                    view.layout(left + lp.leftMargin, top, right + lp.leftMargin, bottom);
                    break;
                }
                view.layout(left - lp.rightMargin, top, right - lp.rightMargin, bottom);
                break;
            }
            case 1: {
                if (!isRtl) {
                    view.layout(left + crossSize - view.getMeasuredWidth() - lp.rightMargin, top, right + crossSize - view.getMeasuredWidth() - lp.rightMargin, bottom);
                    break;
                }
                view.layout(left - crossSize + view.getMeasuredWidth() + lp.leftMargin, top, right - crossSize + view.getMeasuredWidth() + lp.leftMargin, bottom);
                break;
            }
            case 2: {
                int leftFromCrossAxis = (crossSize - view.getMeasuredWidth()) / 2;
                if (!isRtl) {
                    view.layout(left + leftFromCrossAxis + lp.leftMargin - lp.rightMargin, top, right + leftFromCrossAxis + lp.leftMargin - lp.rightMargin, bottom);
                    break;
                }
                view.layout(left - leftFromCrossAxis + lp.leftMargin - lp.rightMargin, top, right - leftFromCrossAxis + lp.leftMargin - lp.rightMargin, bottom);
            }
        }
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    public int getFlexDirection() {
        return this.mFlexDirection;
    }

    public void setFlexDirection(int flexDirection) {
        if (this.mFlexDirection != flexDirection) {
            this.mFlexDirection = flexDirection;
            this.requestLayout();
        }
    }

    public int getFlexWrap() {
        return this.mFlexWrap;
    }

    public void setFlexWrap(int flexWrap) {
        if (this.mFlexWrap != flexWrap) {
            this.mFlexWrap = flexWrap;
            this.requestLayout();
        }
    }

    public int getJustifyContent() {
        return this.mJustifyContent;
    }

    public void setJustifyContent(int justifyContent) {
        if (this.mJustifyContent != justifyContent) {
            this.mJustifyContent = justifyContent;
            this.requestLayout();
        }
    }

    public int getAlignItems() {
        return this.mAlignItems;
    }

    public void setAlignItems(int alignItems) {
        if (this.mAlignItems != alignItems) {
            this.mAlignItems = alignItems;
            this.requestLayout();
        }
    }

    public int getAlignContent() {
        return this.mAlignContent;
    }

    public void setAlignContent(int alignContent) {
        if (this.mAlignContent != alignContent) {
            this.mAlignContent = alignContent;
            this.requestLayout();
        }
    }

    private static class FlexLine {
        int mainSize;
        int crossSize;
        int itemCount;
        float totalFlexGrow;
        float totalFlexShrink;
        int maxBaseline;
        List<Integer> indicesAlignSelfStretch = new ArrayList<Integer>();

        private FlexLine() {
        }
    }

    private static class Order
    implements Comparable<Order> {
        int index;
        int order;

        private Order() {
        }

        @Override
        public int compareTo(@NonNull Order another) {
            if (this.order != another.order) {
                return this.order - another.order;
            }
            return this.index - another.index;
        }

        public String toString() {
            return "Order{order=" + this.order + ", index=" + this.index + '}';
        }
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        private static final int ORDER_DEFAULT = 1;
        private static final float FLEX_GROW_DEFAULT = 0.0f;
        private static final float FLEX_SHRINK_DEFAULT = 1.0f;
        public static final float FLEX_BASIS_PERCENT_DEFAULT = -1.0f;
        public static final int ALIGN_SELF_AUTO = -1;
        public static final int ALIGN_SELF_FLEX_START = 0;
        public static final int ALIGN_SELF_FLEX_END = 1;
        public static final int ALIGN_SELF_CENTER = 2;
        public static final int ALIGN_SELF_BASELINE = 3;
        public static final int ALIGN_SELF_STRETCH = 4;
        private static final int MAX_SIZE = 0xFFFFFF;
        public int order = 1;
        public float flexGrow = 0.0f;
        public float flexShrink = 1.0f;
        public int alignSelf = -1;
        public float flexBasisPercent = -1.0f;
        public int minWidth;
        public int minHeight;
        public int maxWidth = 0xFFFFFF;
        public int maxHeight = 0xFFFFFF;
        public boolean wrapBefore;

        public LayoutParams(Context context, AttributeSet attrs) {
            super(context, attrs);
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.FlexboxLayout_Layout);
            this.order = a.getInt(R.styleable.FlexboxLayout_Layout_layout_order, 1);
            this.flexGrow = a.getFloat(R.styleable.FlexboxLayout_Layout_layout_flexGrow, 0.0f);
            this.flexShrink = a.getFloat(R.styleable.FlexboxLayout_Layout_layout_flexShrink, 1.0f);
            this.alignSelf = a.getInt(R.styleable.FlexboxLayout_Layout_layout_alignSelf, -1);
            this.flexBasisPercent = a.getFraction(R.styleable.FlexboxLayout_Layout_layout_flexBasisPercent, 1, 1, -1.0f);
            this.minWidth = a.getDimensionPixelSize(R.styleable.FlexboxLayout_Layout_layout_minWidth, 0);
            this.minHeight = a.getDimensionPixelSize(R.styleable.FlexboxLayout_Layout_layout_minHeight, 0);
            this.maxWidth = a.getDimensionPixelSize(R.styleable.FlexboxLayout_Layout_layout_maxWidth, 0xFFFFFF);
            this.maxHeight = a.getDimensionPixelSize(R.styleable.FlexboxLayout_Layout_layout_maxHeight, 0xFFFFFF);
            this.wrapBefore = a.getBoolean(R.styleable.FlexboxLayout_Layout_layout_wrapBefore, false);
            a.recycle();
        }

        public LayoutParams(LayoutParams source) {
            super((ViewGroup.MarginLayoutParams)source);
            this.order = source.order;
            this.flexGrow = source.flexGrow;
            this.flexShrink = source.flexShrink;
            this.alignSelf = source.alignSelf;
            this.flexBasisPercent = source.flexBasisPercent;
            this.minWidth = source.minWidth;
            this.minHeight = source.minHeight;
            this.maxWidth = source.maxWidth;
            this.maxHeight = source.maxHeight;
            this.wrapBefore = source.wrapBefore;
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }

        public LayoutParams(int width, int height) {
            super(new ViewGroup.LayoutParams(width, height));
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AlignContent {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AlignItems {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface JustifyContent {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FlexWrap {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FlexDirection {
    }
}

