/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ext.mediasession;

import android.os.Bundle;
import android.os.ResultReceiver;
import android.support.v4.media.MediaDescriptionCompat;
import android.support.v4.media.session.MediaSessionCompat;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.ControlDispatcher;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.ext.mediasession.MediaSessionConnector;
import com.google.android.exoplayer2.util.Assertions;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;

public abstract class TimelineQueueNavigator
implements MediaSessionConnector.QueueNavigator {
    public static final int DEFAULT_MAX_QUEUE_SIZE = 10;
    private final MediaSessionCompat mediaSession;
    private final Timeline.Window window;
    private final int maxQueueSize;
    private long activeQueueItemId;

    public TimelineQueueNavigator(MediaSessionCompat mediaSession) {
        this(mediaSession, 10);
    }

    public TimelineQueueNavigator(MediaSessionCompat mediaSession, int maxQueueSize) {
        Assertions.checkState((maxQueueSize > 0 ? 1 : 0) != 0);
        this.mediaSession = mediaSession;
        this.maxQueueSize = maxQueueSize;
        this.activeQueueItemId = -1L;
        this.window = new Timeline.Window();
    }

    public abstract MediaDescriptionCompat getMediaDescription(Player var1, int var2);

    @Override
    public long getSupportedQueueNavigatorActions(Player player) {
        boolean enableSkipTo = false;
        boolean enablePrevious = false;
        boolean enableNext = false;
        Timeline timeline = player.getCurrentTimeline();
        if (!timeline.isEmpty() && !player.isPlayingAd()) {
            timeline.getWindow(player.getCurrentWindowIndex(), this.window);
            enableSkipTo = timeline.getWindowCount() > 1;
            enablePrevious = this.window.isSeekable || !this.window.isDynamic || player.hasPrevious();
            enableNext = this.window.isDynamic || player.hasNext();
        }
        long actions = 0L;
        if (enableSkipTo) {
            actions |= 0x1000L;
        }
        if (enablePrevious) {
            actions |= 0x10L;
        }
        if (enableNext) {
            actions |= 0x20L;
        }
        return actions;
    }

    @Override
    public final void onTimelineChanged(Player player) {
        this.publishFloatingQueueWindow(player);
    }

    @Override
    public final void onCurrentWindowIndexChanged(Player player) {
        if (this.activeQueueItemId == -1L || player.getCurrentTimeline().getWindowCount() > this.maxQueueSize) {
            this.publishFloatingQueueWindow(player);
        } else if (!player.getCurrentTimeline().isEmpty()) {
            this.activeQueueItemId = player.getCurrentWindowIndex();
        }
    }

    @Override
    public final long getActiveQueueItemId(@Nullable Player player) {
        return this.activeQueueItemId;
    }

    @Override
    public void onSkipToPrevious(Player player, ControlDispatcher controlDispatcher) {
        controlDispatcher.dispatchPrevious(player);
    }

    @Override
    public void onSkipToQueueItem(Player player, ControlDispatcher controlDispatcher, long id) {
        Timeline timeline = player.getCurrentTimeline();
        if (timeline.isEmpty() || player.isPlayingAd()) {
            return;
        }
        int windowIndex = (int)id;
        if (0 <= windowIndex && windowIndex < timeline.getWindowCount()) {
            controlDispatcher.dispatchSeekTo(player, windowIndex, -9223372036854775807L);
        }
    }

    @Override
    public void onSkipToNext(Player player, ControlDispatcher controlDispatcher) {
        controlDispatcher.dispatchNext(player);
    }

    @Override
    public boolean onCommand(Player player, ControlDispatcher controlDispatcher, String command, @Nullable Bundle extras, @Nullable ResultReceiver cb) {
        return false;
    }

    private void publishFloatingQueueWindow(Player player) {
        Timeline timeline = player.getCurrentTimeline();
        if (timeline.isEmpty()) {
            this.mediaSession.setQueue(Collections.emptyList());
            this.activeQueueItemId = -1L;
            return;
        }
        ArrayDeque<MediaSessionCompat.QueueItem> queue = new ArrayDeque<MediaSessionCompat.QueueItem>();
        int queueSize = Math.min(this.maxQueueSize, timeline.getWindowCount());
        int currentWindowIndex = player.getCurrentWindowIndex();
        queue.add(new MediaSessionCompat.QueueItem(this.getMediaDescription(player, currentWindowIndex), (long)currentWindowIndex));
        int firstWindowIndex = currentWindowIndex;
        int lastWindowIndex = currentWindowIndex;
        boolean shuffleModeEnabled = player.getShuffleModeEnabled();
        while ((firstWindowIndex != -1 || lastWindowIndex != -1) && queue.size() < queueSize) {
            if (lastWindowIndex != -1 && (lastWindowIndex = timeline.getNextWindowIndex(lastWindowIndex, 0, shuffleModeEnabled)) != -1) {
                queue.add(new MediaSessionCompat.QueueItem(this.getMediaDescription(player, lastWindowIndex), (long)lastWindowIndex));
            }
            if (firstWindowIndex == -1 || queue.size() >= queueSize || (firstWindowIndex = timeline.getPreviousWindowIndex(firstWindowIndex, 0, shuffleModeEnabled)) == -1) continue;
            queue.addFirst(new MediaSessionCompat.QueueItem(this.getMediaDescription(player, firstWindowIndex), (long)firstWindowIndex));
        }
        this.mediaSession.setQueue(new ArrayList(queue));
        this.activeQueueItemId = currentWindowIndex;
    }
}

