/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ext.mediasession;

import android.os.Bundle;
import android.os.ResultReceiver;
import android.support.v4.media.MediaDescriptionCompat;
import android.support.v4.media.session.MediaControllerCompat;
import android.support.v4.media.session.MediaSessionCompat;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.ControlDispatcher;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.ext.mediasession.MediaSessionConnector;
import com.google.android.exoplayer2.source.ConcatenatingMediaSource;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.util.Util;
import java.util.List;

public final class TimelineQueueEditor
implements MediaSessionConnector.QueueEditor,
MediaSessionConnector.CommandReceiver {
    public static final String COMMAND_MOVE_QUEUE_ITEM = "exo_move_window";
    public static final String EXTRA_FROM_INDEX = "from_index";
    public static final String EXTRA_TO_INDEX = "to_index";
    private final MediaControllerCompat mediaController;
    private final QueueDataAdapter queueDataAdapter;
    private final MediaSourceFactory sourceFactory;
    private final MediaDescriptionEqualityChecker equalityChecker;
    private final ConcatenatingMediaSource queueMediaSource;

    public TimelineQueueEditor(MediaControllerCompat mediaController, ConcatenatingMediaSource queueMediaSource, QueueDataAdapter queueDataAdapter, MediaSourceFactory sourceFactory) {
        this(mediaController, queueMediaSource, queueDataAdapter, sourceFactory, new MediaIdEqualityChecker());
    }

    public TimelineQueueEditor(MediaControllerCompat mediaController, ConcatenatingMediaSource queueMediaSource, QueueDataAdapter queueDataAdapter, MediaSourceFactory sourceFactory, MediaDescriptionEqualityChecker equalityChecker) {
        this.mediaController = mediaController;
        this.queueMediaSource = queueMediaSource;
        this.queueDataAdapter = queueDataAdapter;
        this.sourceFactory = sourceFactory;
        this.equalityChecker = equalityChecker;
    }

    @Override
    public void onAddQueueItem(Player player, MediaDescriptionCompat description) {
        this.onAddQueueItem(player, description, player.getCurrentTimeline().getWindowCount());
    }

    @Override
    public void onAddQueueItem(Player player, MediaDescriptionCompat description, int index) {
        MediaSource mediaSource = this.sourceFactory.createMediaSource(description);
        if (mediaSource != null) {
            this.queueDataAdapter.add(index, description);
            this.queueMediaSource.addMediaSource(index, mediaSource);
        }
    }

    @Override
    public void onRemoveQueueItem(Player player, MediaDescriptionCompat description) {
        List queue = this.mediaController.getQueue();
        for (int i = 0; i < queue.size(); ++i) {
            if (!this.equalityChecker.equals(((MediaSessionCompat.QueueItem)queue.get(i)).getDescription(), description)) continue;
            this.queueDataAdapter.remove(i);
            this.queueMediaSource.removeMediaSource(i);
            return;
        }
    }

    @Override
    public boolean onCommand(Player player, ControlDispatcher controlDispatcher, String command, @Nullable Bundle extras, @Nullable ResultReceiver cb) {
        if (!COMMAND_MOVE_QUEUE_ITEM.equals(command) || extras == null) {
            return false;
        }
        int from = extras.getInt(EXTRA_FROM_INDEX, -1);
        int to = extras.getInt(EXTRA_TO_INDEX, -1);
        if (from != -1 && to != -1) {
            this.queueDataAdapter.move(from, to);
            this.queueMediaSource.moveMediaSource(from, to);
        }
        return true;
    }

    public static final class MediaIdEqualityChecker
    implements MediaDescriptionEqualityChecker {
        @Override
        public boolean equals(MediaDescriptionCompat d1, MediaDescriptionCompat d2) {
            return Util.areEqual((Object)d1.getMediaId(), (Object)d2.getMediaId());
        }
    }

    static interface MediaDescriptionEqualityChecker {
        public boolean equals(MediaDescriptionCompat var1, MediaDescriptionCompat var2);
    }

    public static interface QueueDataAdapter {
        public void add(int var1, MediaDescriptionCompat var2);

        public void remove(int var1);

        public void move(int var1, int var2);
    }

    public static interface MediaSourceFactory {
        @Nullable
        public MediaSource createMediaSource(MediaDescriptionCompat var1);
    }
}

