/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ext.mediasession;

import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.ResultReceiver;
import android.os.SystemClock;
import android.support.v4.media.MediaDescriptionCompat;
import android.support.v4.media.MediaMetadataCompat;
import android.support.v4.media.RatingCompat;
import android.support.v4.media.session.MediaControllerCompat;
import android.support.v4.media.session.MediaSessionCompat;
import android.support.v4.media.session.PlaybackStateCompat;
import android.util.Pair;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.ControlDispatcher;
import com.google.android.exoplayer2.DefaultControlDispatcher;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.ExoPlayerLibraryInfo;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.ErrorMessageProvider;
import com.google.android.exoplayer2.util.Util;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;

public final class MediaSessionConnector {
    public static final long ALL_PLAYBACK_ACTIONS = 2360143L;
    public static final long DEFAULT_PLAYBACK_ACTIONS = 2360143L;
    public static final String EXTRAS_SPEED = "EXO_SPEED";
    private static final long BASE_PLAYBACK_ACTIONS = 2359815L;
    private static final int BASE_MEDIA_SESSION_FLAGS = 3;
    private static final int EDITOR_MEDIA_SESSION_FLAGS = 7;
    private static final MediaMetadataCompat METADATA_EMPTY;
    public final MediaSessionCompat mediaSession;
    private final Looper looper;
    private final ComponentListener componentListener;
    private final ArrayList<CommandReceiver> commandReceivers;
    private final ArrayList<CommandReceiver> customCommandReceivers;
    private ControlDispatcher controlDispatcher;
    private CustomActionProvider[] customActionProviders;
    private Map<String, CustomActionProvider> customActionMap;
    @Nullable
    private MediaMetadataProvider mediaMetadataProvider;
    @Nullable
    private Player player;
    @Nullable
    private ErrorMessageProvider<? super ExoPlaybackException> errorMessageProvider;
    @Nullable
    private Pair<Integer, CharSequence> customError;
    @Nullable
    private Bundle customErrorExtras;
    @Nullable
    private PlaybackPreparer playbackPreparer;
    @Nullable
    private QueueNavigator queueNavigator;
    @Nullable
    private QueueEditor queueEditor;
    @Nullable
    private RatingCallback ratingCallback;
    @Nullable
    private CaptionCallback captionCallback;
    @Nullable
    private MediaButtonEventHandler mediaButtonEventHandler;
    private long enabledPlaybackActions;

    public MediaSessionConnector(MediaSessionCompat mediaSession) {
        this.mediaSession = mediaSession;
        this.looper = Util.getCurrentOrMainLooper();
        this.componentListener = new ComponentListener();
        this.commandReceivers = new ArrayList();
        this.customCommandReceivers = new ArrayList();
        this.controlDispatcher = new DefaultControlDispatcher();
        this.customActionProviders = new CustomActionProvider[0];
        this.customActionMap = Collections.emptyMap();
        this.mediaMetadataProvider = new DefaultMediaMetadataProvider(mediaSession.getController(), null);
        this.enabledPlaybackActions = 2360143L;
        mediaSession.setFlags(3);
        mediaSession.setCallback((MediaSessionCompat.Callback)this.componentListener, new Handler(this.looper));
    }

    public void setPlayer(@Nullable Player player) {
        Assertions.checkArgument((player == null || player.getApplicationLooper() == this.looper ? 1 : 0) != 0);
        if (this.player != null) {
            this.player.removeListener((Player.EventListener)this.componentListener);
        }
        this.player = player;
        if (player != null) {
            player.addListener((Player.EventListener)this.componentListener);
        }
        this.invalidateMediaSessionPlaybackState();
        this.invalidateMediaSessionMetadata();
    }

    public void setPlaybackPreparer(@Nullable PlaybackPreparer playbackPreparer) {
        if (this.playbackPreparer != playbackPreparer) {
            this.unregisterCommandReceiver(this.playbackPreparer);
            this.playbackPreparer = playbackPreparer;
            this.registerCommandReceiver(playbackPreparer);
            this.invalidateMediaSessionPlaybackState();
        }
    }

    public void setControlDispatcher(ControlDispatcher controlDispatcher) {
        if (this.controlDispatcher != controlDispatcher) {
            this.controlDispatcher = controlDispatcher;
            this.invalidateMediaSessionPlaybackState();
        }
    }

    public void setMediaButtonEventHandler(@Nullable MediaButtonEventHandler mediaButtonEventHandler) {
        this.mediaButtonEventHandler = mediaButtonEventHandler;
    }

    public void setEnabledPlaybackActions(long enabledPlaybackActions) {
        if (this.enabledPlaybackActions != (enabledPlaybackActions &= 0x24034FL)) {
            this.enabledPlaybackActions = enabledPlaybackActions;
            this.invalidateMediaSessionPlaybackState();
        }
    }

    @Deprecated
    public void setRewindIncrementMs(int rewindMs) {
        if (this.controlDispatcher instanceof DefaultControlDispatcher) {
            ((DefaultControlDispatcher)this.controlDispatcher).setRewindIncrementMs((long)rewindMs);
            this.invalidateMediaSessionPlaybackState();
        }
    }

    @Deprecated
    public void setFastForwardIncrementMs(int fastForwardMs) {
        if (this.controlDispatcher instanceof DefaultControlDispatcher) {
            ((DefaultControlDispatcher)this.controlDispatcher).setFastForwardIncrementMs((long)fastForwardMs);
            this.invalidateMediaSessionPlaybackState();
        }
    }

    public void setErrorMessageProvider(@Nullable ErrorMessageProvider<? super ExoPlaybackException> errorMessageProvider) {
        if (this.errorMessageProvider != errorMessageProvider) {
            this.errorMessageProvider = errorMessageProvider;
            this.invalidateMediaSessionPlaybackState();
        }
    }

    public void setQueueNavigator(@Nullable QueueNavigator queueNavigator) {
        if (this.queueNavigator != queueNavigator) {
            this.unregisterCommandReceiver(this.queueNavigator);
            this.queueNavigator = queueNavigator;
            this.registerCommandReceiver(queueNavigator);
        }
    }

    public void setQueueEditor(@Nullable QueueEditor queueEditor) {
        if (this.queueEditor != queueEditor) {
            this.unregisterCommandReceiver(this.queueEditor);
            this.queueEditor = queueEditor;
            this.registerCommandReceiver(queueEditor);
            this.mediaSession.setFlags(queueEditor == null ? 3 : 7);
        }
    }

    public void setRatingCallback(@Nullable RatingCallback ratingCallback) {
        if (this.ratingCallback != ratingCallback) {
            this.unregisterCommandReceiver(this.ratingCallback);
            this.ratingCallback = ratingCallback;
            this.registerCommandReceiver(this.ratingCallback);
        }
    }

    public void setCaptionCallback(@Nullable CaptionCallback captionCallback) {
        if (this.captionCallback != captionCallback) {
            this.unregisterCommandReceiver(this.captionCallback);
            this.captionCallback = captionCallback;
            this.registerCommandReceiver(this.captionCallback);
        }
    }

    public void setCustomErrorMessage(@Nullable CharSequence message) {
        int code = message == null ? 0 : 1;
        this.setCustomErrorMessage(message, code);
    }

    public void setCustomErrorMessage(@Nullable CharSequence message, int code) {
        this.setCustomErrorMessage(message, code, null);
    }

    public void setCustomErrorMessage(@Nullable CharSequence message, int code, @Nullable Bundle extras) {
        this.customError = message == null ? null : new Pair((Object)code, (Object)message);
        this.customErrorExtras = message == null ? null : extras;
        this.invalidateMediaSessionPlaybackState();
    }

    public void setCustomActionProviders(CustomActionProvider ... customActionProviders) {
        this.customActionProviders = customActionProviders == null ? new CustomActionProvider[]{} : customActionProviders;
        this.invalidateMediaSessionPlaybackState();
    }

    public void setMediaMetadataProvider(@Nullable MediaMetadataProvider mediaMetadataProvider) {
        if (this.mediaMetadataProvider != mediaMetadataProvider) {
            this.mediaMetadataProvider = mediaMetadataProvider;
            this.invalidateMediaSessionMetadata();
        }
    }

    public final void invalidateMediaSessionMetadata() {
        MediaMetadataCompat metadata = this.mediaMetadataProvider != null && this.player != null ? this.mediaMetadataProvider.getMetadata(this.player) : METADATA_EMPTY;
        this.mediaSession.setMetadata(metadata);
    }

    public final void invalidateMediaSessionPlaybackState() {
        int sessionPlaybackState;
        PlaybackStateCompat.Builder builder = new PlaybackStateCompat.Builder();
        Player player = this.player;
        if (player == null) {
            builder.setActions(this.buildPrepareActions()).setState(0, 0L, 0.0f, SystemClock.elapsedRealtime());
            this.mediaSession.setRepeatMode(0);
            this.mediaSession.setShuffleMode(0);
            this.mediaSession.setPlaybackState(builder.build());
            return;
        }
        HashMap<String, CustomActionProvider> currentActions = new HashMap<String, CustomActionProvider>();
        for (CustomActionProvider customActionProvider : this.customActionProviders) {
            PlaybackStateCompat.CustomAction customAction = customActionProvider.getCustomAction(player);
            if (customAction == null) continue;
            currentActions.put(customAction.getAction(), customActionProvider);
            builder.addCustomAction(customAction);
        }
        this.customActionMap = Collections.unmodifiableMap(currentActions);
        Bundle extras = new Bundle();
        ExoPlaybackException playbackError = player.getPlayerError();
        boolean reportError = playbackError != null || this.customError != null;
        int n = sessionPlaybackState = reportError ? 7 : MediaSessionConnector.getMediaSessionPlaybackState(player.getPlaybackState(), player.getPlayWhenReady());
        if (this.customError != null) {
            builder.setErrorMessage(((Integer)this.customError.first).intValue(), (CharSequence)this.customError.second);
            if (this.customErrorExtras != null) {
                extras.putAll(this.customErrorExtras);
            }
        } else if (playbackError != null && this.errorMessageProvider != null) {
            Pair message = this.errorMessageProvider.getErrorMessage((Throwable)playbackError);
            builder.setErrorMessage(((Integer)message.first).intValue(), (CharSequence)message.second);
        }
        long activeQueueItemId = this.queueNavigator != null ? this.queueNavigator.getActiveQueueItemId(player) : -1L;
        float playbackSpeed = player.getPlaybackParameters().speed;
        extras.putFloat(EXTRAS_SPEED, playbackSpeed);
        float sessionPlaybackSpeed = player.isPlaying() ? playbackSpeed : 0.0f;
        builder.setActions(this.buildPrepareActions() | this.buildPlaybackActions(player)).setActiveQueueItemId(activeQueueItemId).setBufferedPosition(player.getBufferedPosition()).setState(sessionPlaybackState, player.getCurrentPosition(), sessionPlaybackSpeed, SystemClock.elapsedRealtime()).setExtras(extras);
        int repeatMode = player.getRepeatMode();
        this.mediaSession.setRepeatMode(repeatMode == 1 ? 1 : (repeatMode == 2 ? 2 : 0));
        this.mediaSession.setShuffleMode(player.getShuffleModeEnabled() ? 1 : 0);
        this.mediaSession.setPlaybackState(builder.build());
    }

    public final void invalidateMediaSessionQueue() {
        if (this.queueNavigator != null && this.player != null) {
            this.queueNavigator.onTimelineChanged(this.player);
        }
    }

    public void registerCustomCommandReceiver(@Nullable CommandReceiver commandReceiver) {
        if (commandReceiver != null && !this.customCommandReceivers.contains(commandReceiver)) {
            this.customCommandReceivers.add(commandReceiver);
        }
    }

    public void unregisterCustomCommandReceiver(@Nullable CommandReceiver commandReceiver) {
        if (commandReceiver != null) {
            this.customCommandReceivers.remove(commandReceiver);
        }
    }

    private void registerCommandReceiver(@Nullable CommandReceiver commandReceiver) {
        if (commandReceiver != null && !this.commandReceivers.contains(commandReceiver)) {
            this.commandReceivers.add(commandReceiver);
        }
    }

    private void unregisterCommandReceiver(@Nullable CommandReceiver commandReceiver) {
        if (commandReceiver != null) {
            this.commandReceivers.remove(commandReceiver);
        }
    }

    private long buildPrepareActions() {
        return this.playbackPreparer == null ? 0L : 0x3EC00L & this.playbackPreparer.getSupportedPrepareActions();
    }

    private long buildPlaybackActions(Player player) {
        boolean enableSeeking = false;
        boolean enableRewind = false;
        boolean enableFastForward = false;
        boolean enableSetRating = false;
        boolean enableSetCaptioningEnabled = false;
        Timeline timeline = player.getCurrentTimeline();
        if (!timeline.isEmpty() && !player.isPlayingAd()) {
            enableSeeking = player.isCurrentWindowSeekable();
            enableRewind = enableSeeking && this.controlDispatcher.isRewindEnabled();
            enableFastForward = enableSeeking && this.controlDispatcher.isFastForwardEnabled();
            enableSetRating = this.ratingCallback != null;
            enableSetCaptioningEnabled = this.captionCallback != null && this.captionCallback.hasCaptions(player);
        }
        long playbackActions = 2359815L;
        if (enableSeeking) {
            playbackActions |= 0x100L;
        }
        if (enableFastForward) {
            playbackActions |= 0x40L;
        }
        if (enableRewind) {
            playbackActions |= 8L;
        }
        long actions = playbackActions &= this.enabledPlaybackActions;
        if (this.queueNavigator != null) {
            actions |= 0x1030L & this.queueNavigator.getSupportedQueueNavigatorActions(player);
        }
        if (enableSetRating) {
            actions |= 0x80L;
        }
        if (enableSetCaptioningEnabled) {
            actions |= 0x100000L;
        }
        return actions;
    }

    @EnsuresNonNullIf(result=true, expression={"player"})
    private boolean canDispatchPlaybackAction(long action) {
        return this.player != null && (this.enabledPlaybackActions & action) != 0L;
    }

    @EnsuresNonNullIf(result=true, expression={"playbackPreparer"})
    private boolean canDispatchToPlaybackPreparer(long action) {
        return this.playbackPreparer != null && (this.playbackPreparer.getSupportedPrepareActions() & action) != 0L;
    }

    @EnsuresNonNullIf(result=true, expression={"player", "queueNavigator"})
    private boolean canDispatchToQueueNavigator(long action) {
        return this.player != null && this.queueNavigator != null && (this.queueNavigator.getSupportedQueueNavigatorActions(this.player) & action) != 0L;
    }

    @EnsuresNonNullIf(result=true, expression={"player", "ratingCallback"})
    private boolean canDispatchSetRating() {
        return this.player != null && this.ratingCallback != null;
    }

    @EnsuresNonNullIf(result=true, expression={"player", "captionCallback"})
    private boolean canDispatchSetCaptioningEnabled() {
        return this.player != null && this.captionCallback != null;
    }

    @EnsuresNonNullIf(result=true, expression={"player", "queueEditor"})
    private boolean canDispatchQueueEdit() {
        return this.player != null && this.queueEditor != null;
    }

    @EnsuresNonNullIf(result=true, expression={"player", "mediaButtonEventHandler"})
    private boolean canDispatchMediaButtonEvent() {
        return this.player != null && this.mediaButtonEventHandler != null;
    }

    private void seekTo(Player player, int windowIndex, long positionMs) {
        this.controlDispatcher.dispatchSeekTo(player, windowIndex, positionMs);
    }

    private static int getMediaSessionPlaybackState(int exoPlayerPlaybackState, boolean playWhenReady) {
        switch (exoPlayerPlaybackState) {
            case 2: {
                return playWhenReady ? 6 : 2;
            }
            case 3: {
                return playWhenReady ? 3 : 2;
            }
            case 4: {
                return 1;
            }
        }
        return 0;
    }

    static {
        ExoPlayerLibraryInfo.registerModule((String)"goog.exo.mediasession");
        METADATA_EMPTY = new MediaMetadataCompat.Builder().build();
    }

    private class ComponentListener
    extends MediaSessionCompat.Callback
    implements Player.EventListener {
        private int currentWindowIndex;
        private int currentWindowCount;

        private ComponentListener() {
        }

        public void onTimelineChanged(Timeline timeline, int reason) {
            Player player = (Player)Assertions.checkNotNull((Object)MediaSessionConnector.this.player);
            int windowCount = player.getCurrentTimeline().getWindowCount();
            int windowIndex = player.getCurrentWindowIndex();
            if (MediaSessionConnector.this.queueNavigator != null) {
                MediaSessionConnector.this.queueNavigator.onTimelineChanged(player);
                MediaSessionConnector.this.invalidateMediaSessionPlaybackState();
            } else if (this.currentWindowCount != windowCount || this.currentWindowIndex != windowIndex) {
                MediaSessionConnector.this.invalidateMediaSessionPlaybackState();
            }
            this.currentWindowCount = windowCount;
            this.currentWindowIndex = windowIndex;
            MediaSessionConnector.this.invalidateMediaSessionMetadata();
        }

        public void onPlaybackStateChanged(int playbackState) {
            MediaSessionConnector.this.invalidateMediaSessionPlaybackState();
        }

        public void onPlayWhenReadyChanged(boolean playWhenReady, int reason) {
            MediaSessionConnector.this.invalidateMediaSessionPlaybackState();
        }

        public void onIsPlayingChanged(boolean isPlaying) {
            MediaSessionConnector.this.invalidateMediaSessionPlaybackState();
        }

        public void onRepeatModeChanged(int repeatMode) {
            MediaSessionConnector.this.invalidateMediaSessionPlaybackState();
        }

        public void onShuffleModeEnabledChanged(boolean shuffleModeEnabled) {
            MediaSessionConnector.this.invalidateMediaSessionPlaybackState();
            MediaSessionConnector.this.invalidateMediaSessionQueue();
        }

        public void onPositionDiscontinuity(int reason) {
            Player player = (Player)Assertions.checkNotNull((Object)MediaSessionConnector.this.player);
            if (this.currentWindowIndex != player.getCurrentWindowIndex()) {
                if (MediaSessionConnector.this.queueNavigator != null) {
                    MediaSessionConnector.this.queueNavigator.onCurrentWindowIndexChanged(player);
                }
                this.currentWindowIndex = player.getCurrentWindowIndex();
                MediaSessionConnector.this.invalidateMediaSessionPlaybackState();
                MediaSessionConnector.this.invalidateMediaSessionMetadata();
                return;
            }
            MediaSessionConnector.this.invalidateMediaSessionPlaybackState();
        }

        public void onPlaybackParametersChanged(PlaybackParameters playbackParameters) {
            MediaSessionConnector.this.invalidateMediaSessionPlaybackState();
        }

        public void onPlay() {
            if (MediaSessionConnector.this.canDispatchPlaybackAction(4L)) {
                if (MediaSessionConnector.this.player.getPlaybackState() == 1) {
                    if (MediaSessionConnector.this.playbackPreparer != null) {
                        MediaSessionConnector.this.playbackPreparer.onPrepare(true);
                    } else {
                        MediaSessionConnector.this.controlDispatcher.dispatchPrepare(MediaSessionConnector.this.player);
                    }
                } else if (MediaSessionConnector.this.player.getPlaybackState() == 4) {
                    MediaSessionConnector.this.seekTo(MediaSessionConnector.this.player, MediaSessionConnector.this.player.getCurrentWindowIndex(), -9223372036854775807L);
                }
                MediaSessionConnector.this.controlDispatcher.dispatchSetPlayWhenReady((Player)Assertions.checkNotNull((Object)MediaSessionConnector.this.player), true);
            }
        }

        public void onPause() {
            if (MediaSessionConnector.this.canDispatchPlaybackAction(2L)) {
                MediaSessionConnector.this.controlDispatcher.dispatchSetPlayWhenReady(MediaSessionConnector.this.player, false);
            }
        }

        public void onSeekTo(long positionMs) {
            if (MediaSessionConnector.this.canDispatchPlaybackAction(256L)) {
                MediaSessionConnector.this.seekTo(MediaSessionConnector.this.player, MediaSessionConnector.this.player.getCurrentWindowIndex(), positionMs);
            }
        }

        public void onFastForward() {
            if (MediaSessionConnector.this.canDispatchPlaybackAction(64L)) {
                MediaSessionConnector.this.controlDispatcher.dispatchFastForward(MediaSessionConnector.this.player);
            }
        }

        public void onRewind() {
            if (MediaSessionConnector.this.canDispatchPlaybackAction(8L)) {
                MediaSessionConnector.this.controlDispatcher.dispatchRewind(MediaSessionConnector.this.player);
            }
        }

        public void onStop() {
            if (MediaSessionConnector.this.canDispatchPlaybackAction(1L)) {
                MediaSessionConnector.this.controlDispatcher.dispatchStop(MediaSessionConnector.this.player, true);
            }
        }

        public void onSetShuffleMode(int shuffleMode) {
            if (MediaSessionConnector.this.canDispatchPlaybackAction(0x200000L)) {
                boolean shuffleModeEnabled;
                switch (shuffleMode) {
                    case 1: 
                    case 2: {
                        shuffleModeEnabled = true;
                        break;
                    }
                    default: {
                        shuffleModeEnabled = false;
                    }
                }
                MediaSessionConnector.this.controlDispatcher.dispatchSetShuffleModeEnabled(MediaSessionConnector.this.player, shuffleModeEnabled);
            }
        }

        public void onSetRepeatMode(int mediaSessionRepeatMode) {
            if (MediaSessionConnector.this.canDispatchPlaybackAction(262144L)) {
                int repeatMode;
                switch (mediaSessionRepeatMode) {
                    case 2: 
                    case 3: {
                        repeatMode = 2;
                        break;
                    }
                    case 1: {
                        repeatMode = 1;
                        break;
                    }
                    default: {
                        repeatMode = 0;
                    }
                }
                MediaSessionConnector.this.controlDispatcher.dispatchSetRepeatMode(MediaSessionConnector.this.player, repeatMode);
            }
        }

        public void onSkipToNext() {
            if (MediaSessionConnector.this.canDispatchToQueueNavigator(32L)) {
                MediaSessionConnector.this.queueNavigator.onSkipToNext(MediaSessionConnector.this.player, MediaSessionConnector.this.controlDispatcher);
            }
        }

        public void onSkipToPrevious() {
            if (MediaSessionConnector.this.canDispatchToQueueNavigator(16L)) {
                MediaSessionConnector.this.queueNavigator.onSkipToPrevious(MediaSessionConnector.this.player, MediaSessionConnector.this.controlDispatcher);
            }
        }

        public void onSkipToQueueItem(long id) {
            if (MediaSessionConnector.this.canDispatchToQueueNavigator(4096L)) {
                MediaSessionConnector.this.queueNavigator.onSkipToQueueItem(MediaSessionConnector.this.player, MediaSessionConnector.this.controlDispatcher, id);
            }
        }

        public void onCustomAction(String action, @Nullable Bundle extras) {
            if (MediaSessionConnector.this.player != null && MediaSessionConnector.this.customActionMap.containsKey(action)) {
                ((CustomActionProvider)MediaSessionConnector.this.customActionMap.get(action)).onCustomAction(MediaSessionConnector.this.player, MediaSessionConnector.this.controlDispatcher, action, extras);
                MediaSessionConnector.this.invalidateMediaSessionPlaybackState();
            }
        }

        public void onCommand(String command, @Nullable Bundle extras, @Nullable ResultReceiver cb) {
            if (MediaSessionConnector.this.player != null) {
                int i;
                for (i = 0; i < MediaSessionConnector.this.commandReceivers.size(); ++i) {
                    if (!((CommandReceiver)MediaSessionConnector.this.commandReceivers.get(i)).onCommand(MediaSessionConnector.this.player, MediaSessionConnector.this.controlDispatcher, command, extras, cb)) continue;
                    return;
                }
                for (i = 0; i < MediaSessionConnector.this.customCommandReceivers.size(); ++i) {
                    if (!((CommandReceiver)MediaSessionConnector.this.customCommandReceivers.get(i)).onCommand(MediaSessionConnector.this.player, MediaSessionConnector.this.controlDispatcher, command, extras, cb)) continue;
                    return;
                }
            }
        }

        public void onPrepare() {
            if (MediaSessionConnector.this.canDispatchToPlaybackPreparer(16384L)) {
                MediaSessionConnector.this.playbackPreparer.onPrepare(false);
            }
        }

        public void onPrepareFromMediaId(String mediaId, @Nullable Bundle extras) {
            if (MediaSessionConnector.this.canDispatchToPlaybackPreparer(32768L)) {
                MediaSessionConnector.this.playbackPreparer.onPrepareFromMediaId(mediaId, false, extras);
            }
        }

        public void onPrepareFromSearch(String query, @Nullable Bundle extras) {
            if (MediaSessionConnector.this.canDispatchToPlaybackPreparer(65536L)) {
                MediaSessionConnector.this.playbackPreparer.onPrepareFromSearch(query, false, extras);
            }
        }

        public void onPrepareFromUri(Uri uri, @Nullable Bundle extras) {
            if (MediaSessionConnector.this.canDispatchToPlaybackPreparer(131072L)) {
                MediaSessionConnector.this.playbackPreparer.onPrepareFromUri(uri, false, extras);
            }
        }

        public void onPlayFromMediaId(String mediaId, @Nullable Bundle extras) {
            if (MediaSessionConnector.this.canDispatchToPlaybackPreparer(1024L)) {
                MediaSessionConnector.this.playbackPreparer.onPrepareFromMediaId(mediaId, true, extras);
            }
        }

        public void onPlayFromSearch(String query, @Nullable Bundle extras) {
            if (MediaSessionConnector.this.canDispatchToPlaybackPreparer(2048L)) {
                MediaSessionConnector.this.playbackPreparer.onPrepareFromSearch(query, true, extras);
            }
        }

        public void onPlayFromUri(Uri uri, @Nullable Bundle extras) {
            if (MediaSessionConnector.this.canDispatchToPlaybackPreparer(8192L)) {
                MediaSessionConnector.this.playbackPreparer.onPrepareFromUri(uri, true, extras);
            }
        }

        public void onSetRating(RatingCompat rating) {
            if (MediaSessionConnector.this.canDispatchSetRating()) {
                MediaSessionConnector.this.ratingCallback.onSetRating(MediaSessionConnector.this.player, rating);
            }
        }

        public void onSetRating(RatingCompat rating, @Nullable Bundle extras) {
            if (MediaSessionConnector.this.canDispatchSetRating()) {
                MediaSessionConnector.this.ratingCallback.onSetRating(MediaSessionConnector.this.player, rating, extras);
            }
        }

        public void onAddQueueItem(MediaDescriptionCompat description) {
            if (MediaSessionConnector.this.canDispatchQueueEdit()) {
                MediaSessionConnector.this.queueEditor.onAddQueueItem(MediaSessionConnector.this.player, description);
            }
        }

        public void onAddQueueItem(MediaDescriptionCompat description, int index) {
            if (MediaSessionConnector.this.canDispatchQueueEdit()) {
                MediaSessionConnector.this.queueEditor.onAddQueueItem(MediaSessionConnector.this.player, description, index);
            }
        }

        public void onRemoveQueueItem(MediaDescriptionCompat description) {
            if (MediaSessionConnector.this.canDispatchQueueEdit()) {
                MediaSessionConnector.this.queueEditor.onRemoveQueueItem(MediaSessionConnector.this.player, description);
            }
        }

        public void onSetCaptioningEnabled(boolean enabled) {
            if (MediaSessionConnector.this.canDispatchSetCaptioningEnabled()) {
                MediaSessionConnector.this.captionCallback.onSetCaptioningEnabled(MediaSessionConnector.this.player, enabled);
            }
        }

        public boolean onMediaButtonEvent(Intent mediaButtonEvent) {
            boolean isHandled = MediaSessionConnector.this.canDispatchMediaButtonEvent() && MediaSessionConnector.this.mediaButtonEventHandler.onMediaButtonEvent(MediaSessionConnector.this.player, MediaSessionConnector.this.controlDispatcher, mediaButtonEvent);
            return isHandled || super.onMediaButtonEvent(mediaButtonEvent);
        }
    }

    public static final class DefaultMediaMetadataProvider
    implements MediaMetadataProvider {
        private final MediaControllerCompat mediaController;
        private final String metadataExtrasPrefix;

        public DefaultMediaMetadataProvider(MediaControllerCompat mediaController, @Nullable String metadataExtrasPrefix) {
            this.mediaController = mediaController;
            this.metadataExtrasPrefix = metadataExtrasPrefix != null ? metadataExtrasPrefix : "";
        }

        @Override
        public MediaMetadataCompat getMetadata(Player player) {
            if (player.getCurrentTimeline().isEmpty()) {
                return METADATA_EMPTY;
            }
            MediaMetadataCompat.Builder builder = new MediaMetadataCompat.Builder();
            if (player.isPlayingAd()) {
                builder.putLong("android.media.metadata.ADVERTISEMENT", 1L);
            }
            builder.putLong("android.media.metadata.DURATION", player.isCurrentWindowDynamic() || player.getDuration() == -9223372036854775807L ? -1L : player.getDuration());
            long activeQueueItemId = this.mediaController.getPlaybackState().getActiveQueueItemId();
            if (activeQueueItemId != -1L) {
                List queue = this.mediaController.getQueue();
                for (int i = 0; queue != null && i < queue.size(); ++i) {
                    Uri mediaUri;
                    String mediaId;
                    Uri iconUri;
                    Bitmap iconBitmap;
                    CharSequence displayDescription;
                    CharSequence subtitle;
                    CharSequence title;
                    MediaSessionCompat.QueueItem queueItem = (MediaSessionCompat.QueueItem)queue.get(i);
                    if (queueItem.getQueueId() != activeQueueItemId) continue;
                    MediaDescriptionCompat description = queueItem.getDescription();
                    Bundle extras = description.getExtras();
                    if (extras != null) {
                        for (String key : extras.keySet()) {
                            Object value = extras.get(key);
                            if (value instanceof String) {
                                builder.putString(this.metadataExtrasPrefix + key, (String)value);
                                continue;
                            }
                            if (value instanceof CharSequence) {
                                builder.putText(this.metadataExtrasPrefix + key, (CharSequence)value);
                                continue;
                            }
                            if (value instanceof Long) {
                                builder.putLong(this.metadataExtrasPrefix + key, ((Long)value).longValue());
                                continue;
                            }
                            if (value instanceof Integer) {
                                builder.putLong(this.metadataExtrasPrefix + key, (long)((Integer)value).intValue());
                                continue;
                            }
                            if (value instanceof Bitmap) {
                                builder.putBitmap(this.metadataExtrasPrefix + key, (Bitmap)value);
                                continue;
                            }
                            if (!(value instanceof RatingCompat)) continue;
                            builder.putRating(this.metadataExtrasPrefix + key, (RatingCompat)value);
                        }
                    }
                    if ((title = description.getTitle()) != null) {
                        String titleString = String.valueOf(title);
                        builder.putString("android.media.metadata.TITLE", titleString);
                        builder.putString("android.media.metadata.DISPLAY_TITLE", titleString);
                    }
                    if ((subtitle = description.getSubtitle()) != null) {
                        builder.putString("android.media.metadata.DISPLAY_SUBTITLE", String.valueOf(subtitle));
                    }
                    if ((displayDescription = description.getDescription()) != null) {
                        builder.putString("android.media.metadata.DISPLAY_DESCRIPTION", String.valueOf(displayDescription));
                    }
                    if ((iconBitmap = description.getIconBitmap()) != null) {
                        builder.putBitmap("android.media.metadata.DISPLAY_ICON", iconBitmap);
                    }
                    if ((iconUri = description.getIconUri()) != null) {
                        builder.putString("android.media.metadata.DISPLAY_ICON_URI", String.valueOf(iconUri));
                    }
                    if ((mediaId = description.getMediaId()) != null) {
                        builder.putString("android.media.metadata.MEDIA_ID", mediaId);
                    }
                    if ((mediaUri = description.getMediaUri()) == null) break;
                    builder.putString("android.media.metadata.MEDIA_URI", String.valueOf(mediaUri));
                    break;
                }
            }
            return builder.build();
        }
    }

    public static interface MediaMetadataProvider {
        public MediaMetadataCompat getMetadata(Player var1);
    }

    public static interface CustomActionProvider {
        public void onCustomAction(Player var1, ControlDispatcher var2, String var3, @Nullable Bundle var4);

        @Nullable
        public PlaybackStateCompat.CustomAction getCustomAction(Player var1);
    }

    public static interface MediaButtonEventHandler {
        public boolean onMediaButtonEvent(Player var1, ControlDispatcher var2, Intent var3);
    }

    public static interface CaptionCallback
    extends CommandReceiver {
        public void onSetCaptioningEnabled(Player var1, boolean var2);

        public boolean hasCaptions(Player var1);
    }

    public static interface RatingCallback
    extends CommandReceiver {
        public void onSetRating(Player var1, RatingCompat var2);

        public void onSetRating(Player var1, RatingCompat var2, @Nullable Bundle var3);
    }

    public static interface QueueEditor
    extends CommandReceiver {
        public void onAddQueueItem(Player var1, MediaDescriptionCompat var2);

        public void onAddQueueItem(Player var1, MediaDescriptionCompat var2, int var3);

        public void onRemoveQueueItem(Player var1, MediaDescriptionCompat var2);
    }

    public static interface QueueNavigator
    extends CommandReceiver {
        public static final long ACTIONS = 4144L;

        public long getSupportedQueueNavigatorActions(Player var1);

        public void onTimelineChanged(Player var1);

        public void onCurrentWindowIndexChanged(Player var1);

        public long getActiveQueueItemId(@Nullable Player var1);

        public void onSkipToPrevious(Player var1, ControlDispatcher var2);

        public void onSkipToQueueItem(Player var1, ControlDispatcher var2, long var3);

        public void onSkipToNext(Player var1, ControlDispatcher var2);
    }

    public static interface PlaybackPreparer
    extends CommandReceiver {
        public static final long ACTIONS = 257024L;

        public long getSupportedPrepareActions();

        public void onPrepare(boolean var1);

        public void onPrepareFromMediaId(String var1, boolean var2, @Nullable Bundle var3);

        public void onPrepareFromSearch(String var1, boolean var2, @Nullable Bundle var3);

        public void onPrepareFromUri(Uri var1, boolean var2, @Nullable Bundle var3);
    }

    public static interface CommandReceiver {
        public boolean onCommand(Player var1, ControlDispatcher var2, String var3, @Nullable Bundle var4, @Nullable ResultReceiver var5);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PlaybackActions {
    }
}

