/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ext.ima;

import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import com.google.ads.interactivemedia.v3.api.AdDisplayContainer;
import com.google.ads.interactivemedia.v3.api.AdError;
import com.google.ads.interactivemedia.v3.api.AdErrorEvent;
import com.google.ads.interactivemedia.v3.api.AdEvent;
import com.google.ads.interactivemedia.v3.api.AdPodInfo;
import com.google.ads.interactivemedia.v3.api.AdsLoader;
import com.google.ads.interactivemedia.v3.api.AdsManager;
import com.google.ads.interactivemedia.v3.api.AdsManagerLoadedEvent;
import com.google.ads.interactivemedia.v3.api.AdsRenderingSettings;
import com.google.ads.interactivemedia.v3.api.AdsRequest;
import com.google.ads.interactivemedia.v3.api.ImaSdkSettings;
import com.google.ads.interactivemedia.v3.api.player.AdMediaInfo;
import com.google.ads.interactivemedia.v3.api.player.ContentProgressProvider;
import com.google.ads.interactivemedia.v3.api.player.VideoAdPlayer;
import com.google.ads.interactivemedia.v3.api.player.VideoProgressUpdate;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.ext.ima.ImaUtil;
import com.google.android.exoplayer2.source.ads.AdPlaybackState;
import com.google.android.exoplayer2.source.ads.AdsLoader;
import com.google.android.exoplayer2.source.ads.AdsMediaSource;
import com.google.android.exoplayer2.trackselection.TrackSelectionArray;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.Util;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

final class AdTagLoader
implements Player.EventListener {
    private static final String TAG = "AdTagLoader";
    private static final String IMA_SDK_SETTINGS_PLAYER_TYPE = "google/exo.ext.ima";
    private static final String IMA_SDK_SETTINGS_PLAYER_VERSION = "2.13.2";
    private static final int AD_PROGRESS_UPDATE_INTERVAL_MS = 100;
    private static final long IMA_DURATION_UNSET = -1L;
    private static final long THRESHOLD_END_OF_CONTENT_MS = 5000L;
    private static final long THRESHOLD_AD_PRELOAD_MS = 4000L;
    private static final long THRESHOLD_AD_MATCH_US = 1000L;
    private static final int IMA_AD_STATE_NONE = 0;
    private static final int IMA_AD_STATE_PLAYING = 1;
    private static final int IMA_AD_STATE_PAUSED = 2;
    private final ImaUtil.Configuration configuration;
    private final ImaUtil.ImaFactory imaFactory;
    private final List<String> supportedMimeTypes;
    private final DataSpec adTagDataSpec;
    private final Object adsId;
    private final Timeline.Period period;
    private final Handler handler;
    private final ComponentListener componentListener;
    private final List<AdsLoader.EventListener> eventListeners;
    private final List<VideoAdPlayer.VideoAdPlayerCallback> adCallbacks;
    private final Runnable updateAdProgressRunnable;
    private final BiMap<AdMediaInfo, AdInfo> adInfoByAdMediaInfo;
    private final AdDisplayContainer adDisplayContainer;
    private final AdsLoader adsLoader;
    @Nullable
    private Object pendingAdRequestContext;
    @Nullable
    private Player player;
    private VideoProgressUpdate lastContentProgress;
    private VideoProgressUpdate lastAdProgress;
    private int lastVolumePercent;
    @Nullable
    private AdsManager adsManager;
    private boolean isAdsManagerInitialized;
    @Nullable
    private AdsMediaSource.AdLoadException pendingAdLoadError;
    private Timeline timeline;
    private long contentDurationMs;
    private AdPlaybackState adPlaybackState;
    private boolean released;
    private boolean imaPausedContent;
    private int imaAdState;
    @Nullable
    private AdMediaInfo imaAdMediaInfo;
    @Nullable
    private AdInfo imaAdInfo;
    private boolean sentContentComplete;
    private boolean playingAd;
    private boolean bufferingAd;
    private int playingAdIndexInAdGroup;
    @Nullable
    private AdInfo pendingAdPrepareErrorAdInfo;
    private long fakeContentProgressElapsedRealtimeMs;
    private long fakeContentProgressOffsetMs;
    private long pendingContentPositionMs;
    private boolean sentPendingContentPositionMs;
    private long waitingForPreloadElapsedRealtimeMs;

    public AdTagLoader(Context context, ImaUtil.Configuration configuration, ImaUtil.ImaFactory imaFactory, List<String> supportedMimeTypes, DataSpec adTagDataSpec, Object adsId, @Nullable ViewGroup adViewGroup) {
        this.configuration = configuration;
        this.imaFactory = imaFactory;
        ImaSdkSettings imaSdkSettings = configuration.imaSdkSettings;
        if (imaSdkSettings == null) {
            imaSdkSettings = imaFactory.createImaSdkSettings();
            if (configuration.debugModeEnabled) {
                imaSdkSettings.setDebugMode(true);
            }
        }
        imaSdkSettings.setPlayerType(IMA_SDK_SETTINGS_PLAYER_TYPE);
        imaSdkSettings.setPlayerVersion(IMA_SDK_SETTINGS_PLAYER_VERSION);
        this.supportedMimeTypes = supportedMimeTypes;
        this.adTagDataSpec = adTagDataSpec;
        this.adsId = adsId;
        this.period = new Timeline.Period();
        this.handler = Util.createHandler((Looper)ImaUtil.getImaLooper(), null);
        this.componentListener = new ComponentListener();
        this.eventListeners = new ArrayList<AdsLoader.EventListener>();
        this.adCallbacks = new ArrayList<VideoAdPlayer.VideoAdPlayerCallback>(1);
        if (configuration.applicationVideoAdPlayerCallback != null) {
            this.adCallbacks.add(configuration.applicationVideoAdPlayerCallback);
        }
        this.updateAdProgressRunnable = this::updateAdProgress;
        this.adInfoByAdMediaInfo = HashBiMap.create();
        this.lastContentProgress = VideoProgressUpdate.VIDEO_TIME_NOT_READY;
        this.lastAdProgress = VideoProgressUpdate.VIDEO_TIME_NOT_READY;
        this.fakeContentProgressElapsedRealtimeMs = -9223372036854775807L;
        this.fakeContentProgressOffsetMs = -9223372036854775807L;
        this.pendingContentPositionMs = -9223372036854775807L;
        this.waitingForPreloadElapsedRealtimeMs = -9223372036854775807L;
        this.contentDurationMs = -9223372036854775807L;
        this.timeline = Timeline.EMPTY;
        this.adPlaybackState = AdPlaybackState.NONE;
        this.adDisplayContainer = adViewGroup != null ? imaFactory.createAdDisplayContainer(adViewGroup, this.componentListener) : imaFactory.createAudioAdDisplayContainer(context, this.componentListener);
        if (configuration.companionAdSlots != null) {
            this.adDisplayContainer.setCompanionSlots(configuration.companionAdSlots);
        }
        this.adsLoader = this.requestAds(context, imaSdkSettings, this.adDisplayContainer);
    }

    public AdsLoader getAdsLoader() {
        return this.adsLoader;
    }

    public AdDisplayContainer getAdDisplayContainer() {
        return this.adDisplayContainer;
    }

    public void skipAd() {
        if (this.adsManager != null) {
            this.adsManager.skip();
        }
    }

    public void focusSkipButton() {
        if (this.adsManager != null) {
            this.adsManager.focus();
        }
    }

    public void addListenerWithAdView(AdsLoader.EventListener eventListener, AdsLoader.AdViewProvider adViewProvider) {
        boolean isStarted = !this.eventListeners.isEmpty();
        this.eventListeners.add(eventListener);
        if (isStarted) {
            if (!AdPlaybackState.NONE.equals((Object)this.adPlaybackState)) {
                eventListener.onAdPlaybackState(this.adPlaybackState);
            }
            return;
        }
        this.lastVolumePercent = 0;
        this.lastAdProgress = VideoProgressUpdate.VIDEO_TIME_NOT_READY;
        this.lastContentProgress = VideoProgressUpdate.VIDEO_TIME_NOT_READY;
        this.maybeNotifyPendingAdLoadError();
        if (!AdPlaybackState.NONE.equals((Object)this.adPlaybackState)) {
            eventListener.onAdPlaybackState(this.adPlaybackState);
        } else if (this.adsManager != null) {
            this.adPlaybackState = new AdPlaybackState(this.adsId, ImaUtil.getAdGroupTimesUsForCuePoints(this.adsManager.getAdCuePoints()));
            this.updateAdPlaybackState();
        }
        for (AdsLoader.OverlayInfo overlayInfo : adViewProvider.getAdOverlayInfos()) {
            this.adDisplayContainer.registerFriendlyObstruction(this.imaFactory.createFriendlyObstruction(overlayInfo.view, ImaUtil.getFriendlyObstructionPurpose(overlayInfo.purpose), overlayInfo.reasonDetail));
        }
    }

    public void maybePreloadAds(long contentPositionMs, long contentDurationMs) {
        this.maybeInitializeAdsManager(contentPositionMs, contentDurationMs);
    }

    public void activate(Player player) {
        this.player = player;
        player.addListener((Player.EventListener)this);
        boolean playWhenReady = player.getPlayWhenReady();
        this.onTimelineChanged(player.getCurrentTimeline(), 1);
        AdsManager adsManager = this.adsManager;
        if (!AdPlaybackState.NONE.equals((Object)this.adPlaybackState) && adsManager != null && this.imaPausedContent) {
            long contentPositionMs = AdTagLoader.getContentPeriodPositionMs(player, this.timeline, this.period);
            int adGroupForPositionIndex = this.adPlaybackState.getAdGroupIndexForPositionUs(C.msToUs((long)contentPositionMs), C.msToUs((long)this.contentDurationMs));
            if (adGroupForPositionIndex != -1 && this.imaAdInfo != null && this.imaAdInfo.adGroupIndex != adGroupForPositionIndex) {
                if (this.configuration.debugModeEnabled) {
                    String string = String.valueOf(this.imaAdInfo);
                    Log.d((String)TAG, (String)new StringBuilder(24 + String.valueOf(string).length()).append("Discarding preloaded ad ").append(string).toString());
                }
                adsManager.discardAdBreak();
            }
            if (playWhenReady) {
                adsManager.resume();
            }
        }
    }

    public void deactivate() {
        Player player = (Player)Assertions.checkNotNull((Object)this.player);
        if (!AdPlaybackState.NONE.equals((Object)this.adPlaybackState) && this.imaPausedContent) {
            if (this.adsManager != null) {
                this.adsManager.pause();
            }
            this.adPlaybackState = this.adPlaybackState.withAdResumePositionUs(this.playingAd ? C.msToUs((long)player.getCurrentPosition()) : 0L);
        }
        this.lastVolumePercent = this.getPlayerVolumePercent();
        this.lastAdProgress = this.getAdVideoProgressUpdate();
        this.lastContentProgress = this.getContentVideoProgressUpdate();
        player.removeListener((Player.EventListener)this);
        this.player = null;
    }

    public void removeListener(AdsLoader.EventListener eventListener) {
        this.eventListeners.remove(eventListener);
        if (this.eventListeners.isEmpty()) {
            this.adDisplayContainer.unregisterAllFriendlyObstructions();
        }
    }

    public void release() {
        if (this.released) {
            return;
        }
        this.released = true;
        this.pendingAdRequestContext = null;
        this.destroyAdsManager();
        this.adsLoader.removeAdsLoadedListener((AdsLoader.AdsLoadedListener)this.componentListener);
        this.adsLoader.removeAdErrorListener((AdErrorEvent.AdErrorListener)this.componentListener);
        if (this.configuration.applicationAdErrorListener != null) {
            this.adsLoader.removeAdErrorListener(this.configuration.applicationAdErrorListener);
        }
        this.adsLoader.release();
        this.imaPausedContent = false;
        this.imaAdState = 0;
        this.imaAdMediaInfo = null;
        this.stopUpdatingAdProgress();
        this.imaAdInfo = null;
        this.pendingAdLoadError = null;
        this.adPlaybackState = new AdPlaybackState(this.adsId, new long[0]);
        this.updateAdPlaybackState();
    }

    public void handlePrepareComplete(int adGroupIndex, int adIndexInAdGroup) {
        AdMediaInfo adMediaInfo;
        AdInfo adInfo = new AdInfo(adGroupIndex, adIndexInAdGroup);
        if (this.configuration.debugModeEnabled) {
            String string = String.valueOf(adInfo);
            Log.d((String)TAG, (String)new StringBuilder(12 + String.valueOf(string).length()).append("Prepared ad ").append(string).toString());
        }
        if ((adMediaInfo = (AdMediaInfo)this.adInfoByAdMediaInfo.inverse().get((Object)adInfo)) != null) {
            for (int i = 0; i < this.adCallbacks.size(); ++i) {
                this.adCallbacks.get(i).onLoaded(adMediaInfo);
            }
        } else {
            String string = String.valueOf(adInfo);
            Log.w((String)TAG, (String)new StringBuilder(23 + String.valueOf(string).length()).append("Unexpected prepared ad ").append(string).toString());
        }
    }

    public void handlePrepareError(int adGroupIndex, int adIndexInAdGroup, IOException exception) {
        if (this.player == null) {
            return;
        }
        try {
            this.handleAdPrepareError(adGroupIndex, adIndexInAdGroup, exception);
        }
        catch (RuntimeException e) {
            this.maybeNotifyInternalError("handlePrepareError", e);
        }
    }

    public void onTimelineChanged(Timeline timeline, int reason) {
        if (timeline.isEmpty()) {
            return;
        }
        this.timeline = timeline;
        Player player = (Player)Assertions.checkNotNull((Object)this.player);
        long contentDurationUs = timeline.getPeriod((int)player.getCurrentPeriodIndex(), (Timeline.Period)this.period).durationUs;
        this.contentDurationMs = C.usToMs((long)contentDurationUs);
        if (contentDurationUs != this.adPlaybackState.contentDurationUs) {
            this.adPlaybackState = this.adPlaybackState.withContentDurationUs(contentDurationUs);
            this.updateAdPlaybackState();
        }
        long contentPositionMs = AdTagLoader.getContentPeriodPositionMs(player, timeline, this.period);
        this.maybeInitializeAdsManager(contentPositionMs, this.contentDurationMs);
        this.handleTimelineOrPositionChanged();
    }

    public void onPositionDiscontinuity(int reason) {
        this.handleTimelineOrPositionChanged();
    }

    public void onPlaybackStateChanged(int playbackState) {
        Player player = this.player;
        if (this.adsManager == null || player == null) {
            return;
        }
        if (playbackState == 2 && !player.isPlayingAd() && this.isWaitingForAdToLoad()) {
            this.waitingForPreloadElapsedRealtimeMs = SystemClock.elapsedRealtime();
        } else if (playbackState == 3) {
            this.waitingForPreloadElapsedRealtimeMs = -9223372036854775807L;
        }
        this.handlePlayerStateChanged(player.getPlayWhenReady(), playbackState);
    }

    public void onPlayWhenReadyChanged(boolean playWhenReady, int reason) {
        if (this.adsManager == null || this.player == null) {
            return;
        }
        if (this.imaAdState == 1 && !playWhenReady) {
            this.adsManager.pause();
            return;
        }
        if (this.imaAdState == 2 && playWhenReady) {
            this.adsManager.resume();
            return;
        }
        this.handlePlayerStateChanged(playWhenReady, this.player.getPlaybackState());
    }

    public void onPlayerError(ExoPlaybackException error) {
        if (this.imaAdState != 0) {
            AdMediaInfo adMediaInfo = (AdMediaInfo)Assertions.checkNotNull((Object)this.imaAdMediaInfo);
            for (int i = 0; i < this.adCallbacks.size(); ++i) {
                this.adCallbacks.get(i).onError(adMediaInfo);
            }
        }
    }

    private AdsLoader requestAds(Context context, ImaSdkSettings imaSdkSettings, AdDisplayContainer adDisplayContainer) {
        AdsRequest request;
        AdsLoader adsLoader = this.imaFactory.createAdsLoader(context, imaSdkSettings, adDisplayContainer);
        adsLoader.addAdErrorListener((AdErrorEvent.AdErrorListener)this.componentListener);
        if (this.configuration.applicationAdErrorListener != null) {
            adsLoader.addAdErrorListener(this.configuration.applicationAdErrorListener);
        }
        adsLoader.addAdsLoadedListener((AdsLoader.AdsLoadedListener)this.componentListener);
        try {
            request = ImaUtil.getAdsRequestForAdTagDataSpec(this.imaFactory, this.adTagDataSpec);
        }
        catch (IOException e) {
            this.adPlaybackState = new AdPlaybackState(this.adsId, new long[0]);
            this.updateAdPlaybackState();
            this.pendingAdLoadError = AdsMediaSource.AdLoadException.createForAllAds((Exception)e);
            this.maybeNotifyPendingAdLoadError();
            return adsLoader;
        }
        this.pendingAdRequestContext = new Object();
        request.setUserRequestContext(this.pendingAdRequestContext);
        if (this.configuration.enableContinuousPlayback != null) {
            request.setContinuousPlayback(this.configuration.enableContinuousPlayback.booleanValue());
        }
        if (this.configuration.vastLoadTimeoutMs != -1) {
            request.setVastLoadTimeout((float)this.configuration.vastLoadTimeoutMs);
        }
        request.setContentProgressProvider((ContentProgressProvider)this.componentListener);
        adsLoader.requestAds(request);
        return adsLoader;
    }

    private void maybeInitializeAdsManager(long contentPositionMs, long contentDurationMs) {
        AdsManager adsManager = this.adsManager;
        if (!this.isAdsManagerInitialized && adsManager != null) {
            this.isAdsManagerInitialized = true;
            AdsRenderingSettings adsRenderingSettings = this.setupAdsRendering(contentPositionMs, contentDurationMs);
            if (adsRenderingSettings == null) {
                this.destroyAdsManager();
            } else {
                adsManager.init(adsRenderingSettings);
                adsManager.start();
                if (this.configuration.debugModeEnabled) {
                    String string = String.valueOf(adsRenderingSettings);
                    Log.d((String)TAG, (String)new StringBuilder(41 + String.valueOf(string).length()).append("Initialized with ads rendering settings: ").append(string).toString());
                }
            }
            this.updateAdPlaybackState();
        }
    }

    @Nullable
    private AdsRenderingSettings setupAdsRendering(long contentPositionMs, long contentDurationMs) {
        AdsRenderingSettings adsRenderingSettings = this.imaFactory.createAdsRenderingSettings();
        adsRenderingSettings.setEnablePreloading(true);
        adsRenderingSettings.setMimeTypes(this.configuration.adMediaMimeTypes != null ? this.configuration.adMediaMimeTypes : this.supportedMimeTypes);
        if (this.configuration.mediaLoadTimeoutMs != -1) {
            adsRenderingSettings.setLoadVideoTimeout(this.configuration.mediaLoadTimeoutMs);
        }
        if (this.configuration.mediaBitrate != -1) {
            adsRenderingSettings.setBitrateKbps(this.configuration.mediaBitrate / 1000);
        }
        adsRenderingSettings.setFocusSkipButtonWhenAvailable(this.configuration.focusSkipButtonWhenAvailable);
        if (this.configuration.adUiElements != null) {
            adsRenderingSettings.setUiElements(this.configuration.adUiElements);
        }
        long[] adGroupTimesUs = this.adPlaybackState.adGroupTimesUs;
        int adGroupForPositionIndex = this.adPlaybackState.getAdGroupIndexForPositionUs(C.msToUs((long)contentPositionMs), C.msToUs((long)contentDurationMs));
        if (adGroupForPositionIndex != -1) {
            boolean playAdWhenStartingPlayback;
            boolean bl = playAdWhenStartingPlayback = this.configuration.playAdBeforeStartPosition || adGroupTimesUs[adGroupForPositionIndex] == C.msToUs((long)contentPositionMs);
            if (!playAdWhenStartingPlayback) {
                ++adGroupForPositionIndex;
            } else if (AdTagLoader.hasMidrollAdGroups(adGroupTimesUs)) {
                this.pendingContentPositionMs = contentPositionMs;
            }
            if (adGroupForPositionIndex > 0) {
                for (int i = 0; i < adGroupForPositionIndex; ++i) {
                    this.adPlaybackState = this.adPlaybackState.withSkippedAdGroup(i);
                }
                if (adGroupForPositionIndex == adGroupTimesUs.length) {
                    return null;
                }
                long adGroupForPositionTimeUs = adGroupTimesUs[adGroupForPositionIndex];
                long adGroupBeforePositionTimeUs = adGroupTimesUs[adGroupForPositionIndex - 1];
                if (adGroupForPositionTimeUs == Long.MIN_VALUE) {
                    adsRenderingSettings.setPlayAdsAfterTime((double)adGroupBeforePositionTimeUs / 1000000.0 + 1.0);
                } else {
                    double midpointTimeUs = (double)(adGroupForPositionTimeUs + adGroupBeforePositionTimeUs) / 2.0;
                    adsRenderingSettings.setPlayAdsAfterTime(midpointTimeUs / 1000000.0);
                }
            }
        }
        return adsRenderingSettings;
    }

    private VideoProgressUpdate getContentVideoProgressUpdate() {
        long contentPositionMs;
        boolean hasContentDuration;
        boolean bl = hasContentDuration = this.contentDurationMs != -9223372036854775807L;
        if (this.pendingContentPositionMs != -9223372036854775807L) {
            this.sentPendingContentPositionMs = true;
            contentPositionMs = this.pendingContentPositionMs;
        } else {
            if (this.player == null) {
                return this.lastContentProgress;
            }
            if (this.fakeContentProgressElapsedRealtimeMs != -9223372036854775807L) {
                long elapsedSinceEndMs = SystemClock.elapsedRealtime() - this.fakeContentProgressElapsedRealtimeMs;
                contentPositionMs = this.fakeContentProgressOffsetMs + elapsedSinceEndMs;
            } else if (this.imaAdState == 0 && !this.playingAd && hasContentDuration) {
                contentPositionMs = AdTagLoader.getContentPeriodPositionMs(this.player, this.timeline, this.period);
            } else {
                return VideoProgressUpdate.VIDEO_TIME_NOT_READY;
            }
        }
        long contentDurationMs = hasContentDuration ? this.contentDurationMs : -1L;
        return new VideoProgressUpdate(contentPositionMs, contentDurationMs);
    }

    private VideoProgressUpdate getAdVideoProgressUpdate() {
        if (this.player == null) {
            return this.lastAdProgress;
        }
        if (this.imaAdState != 0 && this.playingAd) {
            long adDuration = this.player.getDuration();
            return adDuration == -9223372036854775807L ? VideoProgressUpdate.VIDEO_TIME_NOT_READY : new VideoProgressUpdate(this.player.getCurrentPosition(), adDuration);
        }
        return VideoProgressUpdate.VIDEO_TIME_NOT_READY;
    }

    private void updateAdProgress() {
        VideoProgressUpdate videoProgressUpdate = this.getAdVideoProgressUpdate();
        if (this.configuration.debugModeEnabled) {
            String string = String.valueOf(ImaUtil.getStringForVideoProgressUpdate(videoProgressUpdate));
            Log.d((String)TAG, (String)(string.length() != 0 ? "Ad progress: ".concat(string) : new String("Ad progress: ")));
        }
        AdMediaInfo adMediaInfo = (AdMediaInfo)Assertions.checkNotNull((Object)this.imaAdMediaInfo);
        for (int i = 0; i < this.adCallbacks.size(); ++i) {
            this.adCallbacks.get(i).onAdProgress(adMediaInfo, videoProgressUpdate);
        }
        this.handler.removeCallbacks(this.updateAdProgressRunnable);
        this.handler.postDelayed(this.updateAdProgressRunnable, 100L);
    }

    private void stopUpdatingAdProgress() {
        this.handler.removeCallbacks(this.updateAdProgressRunnable);
    }

    private int getPlayerVolumePercent() {
        Player player = this.player;
        if (player == null) {
            return this.lastVolumePercent;
        }
        Player.AudioComponent audioComponent = player.getAudioComponent();
        if (audioComponent != null) {
            return (int)(audioComponent.getVolume() * 100.0f);
        }
        TrackSelectionArray trackSelections = player.getCurrentTrackSelections();
        for (int i = 0; i < player.getRendererCount() && i < trackSelections.length; ++i) {
            if (player.getRendererType(i) != 1 || trackSelections.get(i) == null) continue;
            return 100;
        }
        return 0;
    }

    private void handleAdEvent(AdEvent adEvent) {
        if (this.adsManager == null) {
            return;
        }
        switch (adEvent.getType()) {
            case AD_BREAK_FETCH_ERROR: {
                double adGroupTimeSeconds;
                String adGroupTimeSecondsString = (String)Assertions.checkNotNull((Object)((String)adEvent.getAdData().get("adBreakTime")));
                if (this.configuration.debugModeEnabled) {
                    Log.d((String)TAG, (String)new StringBuilder(30 + String.valueOf(adGroupTimeSecondsString).length()).append("Fetch error for ad at ").append(adGroupTimeSecondsString).append(" seconds").toString());
                }
                int adGroupIndex = (adGroupTimeSeconds = Double.parseDouble(adGroupTimeSecondsString)) == -1.0 ? this.adPlaybackState.adGroupCount - 1 : this.getAdGroupIndexForCuePointTimeSeconds(adGroupTimeSeconds);
                this.markAdGroupInErrorStateAndClearPendingContentPosition(adGroupIndex);
                break;
            }
            case CONTENT_PAUSE_REQUESTED: {
                this.imaPausedContent = true;
                this.pauseContentInternal();
                break;
            }
            case TAPPED: {
                for (int i = 0; i < this.eventListeners.size(); ++i) {
                    this.eventListeners.get(i).onAdTapped();
                }
                break;
            }
            case CLICKED: {
                for (int i = 0; i < this.eventListeners.size(); ++i) {
                    this.eventListeners.get(i).onAdClicked();
                }
                break;
            }
            case CONTENT_RESUME_REQUESTED: {
                this.imaPausedContent = false;
                this.resumeContentInternal();
                break;
            }
            case LOG: {
                Map adData = adEvent.getAdData();
                String string = String.valueOf(adData);
                String message = new StringBuilder(9 + String.valueOf(string).length()).append("AdEvent: ").append(string).toString();
                Log.i((String)TAG, (String)message);
                break;
            }
        }
    }

    private void pauseContentInternal() {
        this.imaAdState = 0;
        if (this.sentPendingContentPositionMs) {
            this.pendingContentPositionMs = -9223372036854775807L;
            this.sentPendingContentPositionMs = false;
        }
    }

    private void resumeContentInternal() {
        if (this.imaAdInfo != null) {
            this.adPlaybackState = this.adPlaybackState.withSkippedAdGroup(this.imaAdInfo.adGroupIndex);
            this.updateAdPlaybackState();
        }
    }

    private boolean isWaitingForAdToLoad() {
        long contentPositionMs;
        Player player = this.player;
        if (player == null) {
            return false;
        }
        int adGroupIndex = this.getLoadingAdGroupIndex();
        if (adGroupIndex == -1) {
            return false;
        }
        AdPlaybackState.AdGroup adGroup = this.adPlaybackState.adGroups[adGroupIndex];
        if (adGroup.count != -1 && adGroup.count != 0 && adGroup.states[0] != 0) {
            return false;
        }
        long adGroupTimeMs = C.usToMs((long)this.adPlaybackState.adGroupTimesUs[adGroupIndex]);
        long timeUntilAdMs = adGroupTimeMs - (contentPositionMs = AdTagLoader.getContentPeriodPositionMs(player, this.timeline, this.period));
        return timeUntilAdMs < this.configuration.adPreloadTimeoutMs;
    }

    private void handlePlayerStateChanged(boolean playWhenReady, int playbackState) {
        int i;
        AdMediaInfo adMediaInfo;
        if (this.playingAd && this.imaAdState == 1) {
            if (!this.bufferingAd && playbackState == 2) {
                this.bufferingAd = true;
                adMediaInfo = (AdMediaInfo)Assertions.checkNotNull((Object)this.imaAdMediaInfo);
                for (i = 0; i < this.adCallbacks.size(); ++i) {
                    this.adCallbacks.get(i).onBuffering(adMediaInfo);
                }
                this.stopUpdatingAdProgress();
            } else if (this.bufferingAd && playbackState == 3) {
                this.bufferingAd = false;
                this.updateAdProgress();
            }
        }
        if (this.imaAdState == 0 && playbackState == 2 && playWhenReady) {
            this.ensureSentContentCompleteIfAtEndOfStream();
        } else if (this.imaAdState != 0 && playbackState == 4) {
            adMediaInfo = this.imaAdMediaInfo;
            if (adMediaInfo == null) {
                Log.w((String)TAG, (String)"onEnded without ad media info");
            } else {
                for (i = 0; i < this.adCallbacks.size(); ++i) {
                    this.adCallbacks.get(i).onEnded(adMediaInfo);
                }
            }
            if (this.configuration.debugModeEnabled) {
                Log.d((String)TAG, (String)"VideoAdPlayerCallback.onEnded in onPlaybackStateChanged");
            }
        }
    }

    private void handleTimelineOrPositionChanged() {
        boolean adFinished;
        Player player = this.player;
        if (this.adsManager == null || player == null) {
            return;
        }
        if (!this.playingAd && !player.isPlayingAd()) {
            this.ensureSentContentCompleteIfAtEndOfStream();
            if (!this.sentContentComplete && !this.timeline.isEmpty()) {
                long positionMs = AdTagLoader.getContentPeriodPositionMs(player, this.timeline, this.period);
                this.timeline.getPeriod(player.getCurrentPeriodIndex(), this.period);
                int newAdGroupIndex = this.period.getAdGroupIndexForPositionUs(C.msToUs((long)positionMs));
                if (newAdGroupIndex != -1) {
                    this.sentPendingContentPositionMs = false;
                    this.pendingContentPositionMs = positionMs;
                }
            }
        }
        boolean wasPlayingAd = this.playingAd;
        int oldPlayingAdIndexInAdGroup = this.playingAdIndexInAdGroup;
        this.playingAd = player.isPlayingAd();
        this.playingAdIndexInAdGroup = this.playingAd ? player.getCurrentAdIndexInAdGroup() : -1;
        boolean bl = adFinished = wasPlayingAd && this.playingAdIndexInAdGroup != oldPlayingAdIndexInAdGroup;
        if (adFinished) {
            AdMediaInfo adMediaInfo = this.imaAdMediaInfo;
            if (adMediaInfo == null) {
                Log.w((String)TAG, (String)"onEnded without ad media info");
            } else {
                AdInfo adInfo = (AdInfo)this.adInfoByAdMediaInfo.get((Object)adMediaInfo);
                if (this.playingAdIndexInAdGroup == -1 || adInfo != null && adInfo.adIndexInAdGroup < this.playingAdIndexInAdGroup) {
                    for (int i = 0; i < this.adCallbacks.size(); ++i) {
                        this.adCallbacks.get(i).onEnded(adMediaInfo);
                    }
                    if (this.configuration.debugModeEnabled) {
                        Log.d((String)TAG, (String)"VideoAdPlayerCallback.onEnded in onTimelineChanged/onPositionDiscontinuity");
                    }
                }
            }
        }
        if (!this.sentContentComplete && !wasPlayingAd && this.playingAd && this.imaAdState == 0) {
            int adGroupIndex = player.getCurrentAdGroupIndex();
            if (this.adPlaybackState.adGroupTimesUs[adGroupIndex] == Long.MIN_VALUE) {
                this.sendContentComplete();
            } else {
                this.fakeContentProgressElapsedRealtimeMs = SystemClock.elapsedRealtime();
                this.fakeContentProgressOffsetMs = C.usToMs((long)this.adPlaybackState.adGroupTimesUs[adGroupIndex]);
                if (this.fakeContentProgressOffsetMs == Long.MIN_VALUE) {
                    this.fakeContentProgressOffsetMs = this.contentDurationMs;
                }
            }
        }
    }

    private void loadAdInternal(AdMediaInfo adMediaInfo, AdPodInfo adPodInfo) {
        if (this.adsManager == null) {
            if (this.configuration.debugModeEnabled) {
                String string = this.getAdMediaInfoString(adMediaInfo);
                String string2 = String.valueOf(adPodInfo);
                Log.d((String)TAG, (String)new StringBuilder(30 + String.valueOf(string).length() + String.valueOf(string2).length()).append("loadAd after release ").append(string).append(", ad pod ").append(string2).toString());
            }
            return;
        }
        int adGroupIndex = this.getAdGroupIndexForAdPod(adPodInfo);
        int adIndexInAdGroup = adPodInfo.getAdPosition() - 1;
        AdInfo adInfo = new AdInfo(adGroupIndex, adIndexInAdGroup);
        this.adInfoByAdMediaInfo.forcePut((Object)adMediaInfo, (Object)adInfo);
        if (this.configuration.debugModeEnabled) {
            String string = String.valueOf(this.getAdMediaInfoString(adMediaInfo));
            Log.d((String)TAG, (String)(string.length() != 0 ? "loadAd ".concat(string) : new String("loadAd ")));
        }
        if (this.adPlaybackState.isAdInErrorState(adGroupIndex, adIndexInAdGroup)) {
            return;
        }
        AdPlaybackState.AdGroup adGroup = this.adPlaybackState.adGroups[adInfo.adGroupIndex];
        this.adPlaybackState = this.adPlaybackState.withAdCount(adInfo.adGroupIndex, Math.max(adPodInfo.getTotalAds(), adGroup.states.length));
        adGroup = this.adPlaybackState.adGroups[adInfo.adGroupIndex];
        for (int i = 0; i < adIndexInAdGroup; ++i) {
            if (adGroup.states[i] != 0) continue;
            this.adPlaybackState = this.adPlaybackState.withAdLoadError(adGroupIndex, i);
        }
        Uri adUri = Uri.parse((String)adMediaInfo.getUrl());
        this.adPlaybackState = this.adPlaybackState.withAdUri(adInfo.adGroupIndex, adInfo.adIndexInAdGroup, adUri);
        this.updateAdPlaybackState();
    }

    private void playAdInternal(AdMediaInfo adMediaInfo) {
        if (this.configuration.debugModeEnabled) {
            String string = String.valueOf(this.getAdMediaInfoString(adMediaInfo));
            Log.d((String)TAG, (String)(string.length() != 0 ? "playAd ".concat(string) : new String("playAd ")));
        }
        if (this.adsManager == null) {
            return;
        }
        if (this.imaAdState == 1) {
            Log.w((String)TAG, (String)"Unexpected playAd without stopAd");
        }
        if (this.imaAdState == 0) {
            int i;
            this.fakeContentProgressElapsedRealtimeMs = -9223372036854775807L;
            this.fakeContentProgressOffsetMs = -9223372036854775807L;
            this.imaAdState = 1;
            this.imaAdMediaInfo = adMediaInfo;
            this.imaAdInfo = (AdInfo)Assertions.checkNotNull((Object)((AdInfo)this.adInfoByAdMediaInfo.get((Object)adMediaInfo)));
            for (i = 0; i < this.adCallbacks.size(); ++i) {
                this.adCallbacks.get(i).onPlay(adMediaInfo);
            }
            if (this.pendingAdPrepareErrorAdInfo != null && this.pendingAdPrepareErrorAdInfo.equals(this.imaAdInfo)) {
                this.pendingAdPrepareErrorAdInfo = null;
                for (i = 0; i < this.adCallbacks.size(); ++i) {
                    this.adCallbacks.get(i).onError(adMediaInfo);
                }
            }
            this.updateAdProgress();
        } else {
            this.imaAdState = 1;
            Assertions.checkState((boolean)adMediaInfo.equals(this.imaAdMediaInfo));
            for (int i = 0; i < this.adCallbacks.size(); ++i) {
                this.adCallbacks.get(i).onResume(adMediaInfo);
            }
        }
        if (this.player == null || !this.player.getPlayWhenReady()) {
            ((AdsManager)Assertions.checkNotNull((Object)this.adsManager)).pause();
        }
    }

    private void pauseAdInternal(AdMediaInfo adMediaInfo) {
        if (this.configuration.debugModeEnabled) {
            String string = String.valueOf(this.getAdMediaInfoString(adMediaInfo));
            Log.d((String)TAG, (String)(string.length() != 0 ? "pauseAd ".concat(string) : new String("pauseAd ")));
        }
        if (this.adsManager == null) {
            return;
        }
        if (this.imaAdState == 0) {
            return;
        }
        if (this.configuration.debugModeEnabled && !adMediaInfo.equals(this.imaAdMediaInfo)) {
            String string = this.getAdMediaInfoString(adMediaInfo);
            String string2 = this.getAdMediaInfoString(this.imaAdMediaInfo);
            Log.w((String)TAG, (String)new StringBuilder(34 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Unexpected pauseAd for ").append(string).append(", expected ").append(string2).toString());
        }
        this.imaAdState = 2;
        for (int i = 0; i < this.adCallbacks.size(); ++i) {
            this.adCallbacks.get(i).onPause(adMediaInfo);
        }
    }

    private void stopAdInternal(AdMediaInfo adMediaInfo) {
        if (this.configuration.debugModeEnabled) {
            String string = String.valueOf(this.getAdMediaInfoString(adMediaInfo));
            Log.d((String)TAG, (String)(string.length() != 0 ? "stopAd ".concat(string) : new String("stopAd ")));
        }
        if (this.adsManager == null) {
            return;
        }
        if (this.imaAdState == 0) {
            AdInfo adInfo = (AdInfo)this.adInfoByAdMediaInfo.get((Object)adMediaInfo);
            if (adInfo != null) {
                this.adPlaybackState = this.adPlaybackState.withSkippedAd(adInfo.adGroupIndex, adInfo.adIndexInAdGroup);
                this.updateAdPlaybackState();
            }
            return;
        }
        this.imaAdState = 0;
        this.stopUpdatingAdProgress();
        Assertions.checkNotNull((Object)this.imaAdInfo);
        int adGroupIndex = this.imaAdInfo.adGroupIndex;
        int adIndexInAdGroup = this.imaAdInfo.adIndexInAdGroup;
        if (this.adPlaybackState.isAdInErrorState(adGroupIndex, adIndexInAdGroup)) {
            return;
        }
        this.adPlaybackState = this.adPlaybackState.withPlayedAd(adGroupIndex, adIndexInAdGroup).withAdResumePositionUs(0L);
        this.updateAdPlaybackState();
        if (!this.playingAd) {
            this.imaAdMediaInfo = null;
            this.imaAdInfo = null;
        }
    }

    private void handleAdGroupLoadError(Exception error) {
        int adGroupIndex = this.getLoadingAdGroupIndex();
        if (adGroupIndex == -1) {
            Log.w((String)TAG, (String)"Unable to determine ad group index for ad group load error", (Throwable)error);
            return;
        }
        this.markAdGroupInErrorStateAndClearPendingContentPosition(adGroupIndex);
        if (this.pendingAdLoadError == null) {
            this.pendingAdLoadError = AdsMediaSource.AdLoadException.createForAdGroup((Exception)error, (int)adGroupIndex);
        }
    }

    private void markAdGroupInErrorStateAndClearPendingContentPosition(int adGroupIndex) {
        AdPlaybackState.AdGroup adGroup = this.adPlaybackState.adGroups[adGroupIndex];
        if (adGroup.count == -1) {
            this.adPlaybackState = this.adPlaybackState.withAdCount(adGroupIndex, Math.max(1, adGroup.states.length));
            adGroup = this.adPlaybackState.adGroups[adGroupIndex];
        }
        for (int i = 0; i < adGroup.count; ++i) {
            if (adGroup.states[i] != 0) continue;
            if (this.configuration.debugModeEnabled) {
                int n = i;
                Log.d((String)TAG, (String)new StringBuilder(47).append("Removing ad ").append(n).append(" in ad group ").append(adGroupIndex).toString());
            }
            this.adPlaybackState = this.adPlaybackState.withAdLoadError(adGroupIndex, i);
        }
        this.updateAdPlaybackState();
        this.pendingContentPositionMs = -9223372036854775807L;
        this.fakeContentProgressElapsedRealtimeMs = -9223372036854775807L;
    }

    private void handleAdPrepareError(int adGroupIndex, int adIndexInAdGroup, Exception exception) {
        if (this.configuration.debugModeEnabled) {
            Log.d((String)TAG, (String)new StringBuilder(53).append("Prepare error for ad ").append(adIndexInAdGroup).append(" in group ").append(adGroupIndex).toString(), (Throwable)exception);
        }
        if (this.adsManager == null) {
            Log.w((String)TAG, (String)"Ignoring ad prepare error after release");
            return;
        }
        if (this.imaAdState == 0) {
            this.fakeContentProgressElapsedRealtimeMs = SystemClock.elapsedRealtime();
            this.fakeContentProgressOffsetMs = C.usToMs((long)this.adPlaybackState.adGroupTimesUs[adGroupIndex]);
            if (this.fakeContentProgressOffsetMs == Long.MIN_VALUE) {
                this.fakeContentProgressOffsetMs = this.contentDurationMs;
            }
            this.pendingAdPrepareErrorAdInfo = new AdInfo(adGroupIndex, adIndexInAdGroup);
        } else {
            int i;
            AdMediaInfo adMediaInfo = (AdMediaInfo)Assertions.checkNotNull((Object)this.imaAdMediaInfo);
            if (adIndexInAdGroup > this.playingAdIndexInAdGroup) {
                for (i = 0; i < this.adCallbacks.size(); ++i) {
                    this.adCallbacks.get(i).onEnded(adMediaInfo);
                }
            }
            this.playingAdIndexInAdGroup = this.adPlaybackState.adGroups[adGroupIndex].getFirstAdIndexToPlay();
            for (i = 0; i < this.adCallbacks.size(); ++i) {
                this.adCallbacks.get(i).onError((AdMediaInfo)Assertions.checkNotNull((Object)adMediaInfo));
            }
        }
        this.adPlaybackState = this.adPlaybackState.withAdLoadError(adGroupIndex, adIndexInAdGroup);
        this.updateAdPlaybackState();
    }

    private void ensureSentContentCompleteIfAtEndOfStream() {
        if (!this.sentContentComplete && this.contentDurationMs != -9223372036854775807L && this.pendingContentPositionMs == -9223372036854775807L && AdTagLoader.getContentPeriodPositionMs((Player)Assertions.checkNotNull((Object)this.player), this.timeline, this.period) + 5000L >= this.contentDurationMs) {
            this.sendContentComplete();
        }
    }

    private void sendContentComplete() {
        int i;
        for (i = 0; i < this.adCallbacks.size(); ++i) {
            this.adCallbacks.get(i).onContentComplete();
        }
        this.sentContentComplete = true;
        if (this.configuration.debugModeEnabled) {
            Log.d((String)TAG, (String)"adsLoader.contentComplete");
        }
        for (i = 0; i < this.adPlaybackState.adGroupCount; ++i) {
            if (this.adPlaybackState.adGroupTimesUs[i] == Long.MIN_VALUE) continue;
            this.adPlaybackState = this.adPlaybackState.withSkippedAdGroup(i);
        }
        this.updateAdPlaybackState();
    }

    private void updateAdPlaybackState() {
        for (int i = 0; i < this.eventListeners.size(); ++i) {
            this.eventListeners.get(i).onAdPlaybackState(this.adPlaybackState);
        }
    }

    private void maybeNotifyPendingAdLoadError() {
        if (this.pendingAdLoadError != null) {
            for (int i = 0; i < this.eventListeners.size(); ++i) {
                this.eventListeners.get(i).onAdLoadError(this.pendingAdLoadError, this.adTagDataSpec);
            }
            this.pendingAdLoadError = null;
        }
    }

    private void maybeNotifyInternalError(String name, Exception cause) {
        int i;
        String string = String.valueOf(name);
        String message = string.length() != 0 ? "Internal error in ".concat(string) : new String("Internal error in ");
        Log.e((String)TAG, (String)message, (Throwable)cause);
        for (i = 0; i < this.adPlaybackState.adGroupCount; ++i) {
            this.adPlaybackState = this.adPlaybackState.withSkippedAdGroup(i);
        }
        this.updateAdPlaybackState();
        for (i = 0; i < this.eventListeners.size(); ++i) {
            this.eventListeners.get(i).onAdLoadError(AdsMediaSource.AdLoadException.createForUnexpected((RuntimeException)new RuntimeException(message, cause)), this.adTagDataSpec);
        }
    }

    private int getAdGroupIndexForAdPod(AdPodInfo adPodInfo) {
        if (adPodInfo.getPodIndex() == -1) {
            return this.adPlaybackState.adGroupCount - 1;
        }
        return this.getAdGroupIndexForCuePointTimeSeconds(adPodInfo.getTimeOffset());
    }

    private int getLoadingAdGroupIndex() {
        if (this.player == null) {
            return -1;
        }
        long playerPositionUs = C.msToUs((long)AdTagLoader.getContentPeriodPositionMs(this.player, this.timeline, this.period));
        int adGroupIndex = this.adPlaybackState.getAdGroupIndexForPositionUs(playerPositionUs, C.msToUs((long)this.contentDurationMs));
        if (adGroupIndex == -1) {
            adGroupIndex = this.adPlaybackState.getAdGroupIndexAfterPositionUs(playerPositionUs, C.msToUs((long)this.contentDurationMs));
        }
        return adGroupIndex;
    }

    private int getAdGroupIndexForCuePointTimeSeconds(double cuePointTimeSeconds) {
        float cuePointTimeSecondsFloat = (float)cuePointTimeSeconds;
        long adPodTimeUs = Math.round((double)cuePointTimeSecondsFloat * 1000000.0);
        for (int adGroupIndex = 0; adGroupIndex < this.adPlaybackState.adGroupCount; ++adGroupIndex) {
            long adGroupTimeUs = this.adPlaybackState.adGroupTimesUs[adGroupIndex];
            if (adGroupTimeUs == Long.MIN_VALUE || Math.abs(adGroupTimeUs - adPodTimeUs) >= 1000L) continue;
            return adGroupIndex;
        }
        throw new IllegalStateException("Failed to find cue point");
    }

    private String getAdMediaInfoString(@Nullable AdMediaInfo adMediaInfo) {
        AdInfo adInfo = (AdInfo)this.adInfoByAdMediaInfo.get((Object)adMediaInfo);
        String string = adMediaInfo == null ? "null" : adMediaInfo.getUrl();
        String string2 = String.valueOf(adInfo);
        return new StringBuilder(15 + String.valueOf(string).length() + String.valueOf(string2).length()).append("AdMediaInfo[").append(string).append(", ").append(string2).append("]").toString();
    }

    private static long getContentPeriodPositionMs(Player player, Timeline timeline, Timeline.Period period) {
        long contentWindowPositionMs = player.getContentPosition();
        if (timeline.isEmpty()) {
            return contentWindowPositionMs;
        }
        return contentWindowPositionMs - timeline.getPeriod(player.getCurrentPeriodIndex(), period).getPositionInWindowMs();
    }

    private static boolean hasMidrollAdGroups(long[] adGroupTimesUs) {
        int count = adGroupTimesUs.length;
        if (count == 1) {
            return adGroupTimesUs[0] != 0L && adGroupTimesUs[0] != Long.MIN_VALUE;
        }
        if (count == 2) {
            return adGroupTimesUs[0] != 0L || adGroupTimesUs[1] != Long.MIN_VALUE;
        }
        return true;
    }

    private void destroyAdsManager() {
        if (this.adsManager != null) {
            this.adsManager.removeAdErrorListener((AdErrorEvent.AdErrorListener)this.componentListener);
            if (this.configuration.applicationAdErrorListener != null) {
                this.adsManager.removeAdErrorListener(this.configuration.applicationAdErrorListener);
            }
            this.adsManager.removeAdEventListener((AdEvent.AdEventListener)this.componentListener);
            if (this.configuration.applicationAdEventListener != null) {
                this.adsManager.removeAdEventListener(this.configuration.applicationAdEventListener);
            }
            this.adsManager.destroy();
            this.adsManager = null;
        }
    }

    private static final class AdInfo {
        public final int adGroupIndex;
        public final int adIndexInAdGroup;

        public AdInfo(int adGroupIndex, int adIndexInAdGroup) {
            this.adGroupIndex = adGroupIndex;
            this.adIndexInAdGroup = adIndexInAdGroup;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AdInfo adInfo = (AdInfo)o;
            if (this.adGroupIndex != adInfo.adGroupIndex) {
                return false;
            }
            return this.adIndexInAdGroup == adInfo.adIndexInAdGroup;
        }

        public int hashCode() {
            int result = this.adGroupIndex;
            result = 31 * result + this.adIndexInAdGroup;
            return result;
        }

        public String toString() {
            int n = this.adGroupIndex;
            int n2 = this.adIndexInAdGroup;
            return new StringBuilder(26).append("(").append(n).append(", ").append(n2).append(')').toString();
        }
    }

    private final class ComponentListener
    implements AdsLoader.AdsLoadedListener,
    ContentProgressProvider,
    AdEvent.AdEventListener,
    AdErrorEvent.AdErrorListener,
    VideoAdPlayer {
        private ComponentListener() {
        }

        public void onAdsManagerLoaded(AdsManagerLoadedEvent adsManagerLoadedEvent) {
            AdsManager adsManager = adsManagerLoadedEvent.getAdsManager();
            if (!Util.areEqual((Object)AdTagLoader.this.pendingAdRequestContext, (Object)adsManagerLoadedEvent.getUserRequestContext())) {
                adsManager.destroy();
                return;
            }
            AdTagLoader.this.pendingAdRequestContext = null;
            AdTagLoader.this.adsManager = adsManager;
            adsManager.addAdErrorListener((AdErrorEvent.AdErrorListener)this);
            if (((AdTagLoader)AdTagLoader.this).configuration.applicationAdErrorListener != null) {
                adsManager.addAdErrorListener(((AdTagLoader)AdTagLoader.this).configuration.applicationAdErrorListener);
            }
            adsManager.addAdEventListener((AdEvent.AdEventListener)this);
            if (((AdTagLoader)AdTagLoader.this).configuration.applicationAdEventListener != null) {
                adsManager.addAdEventListener(((AdTagLoader)AdTagLoader.this).configuration.applicationAdEventListener);
            }
            try {
                AdTagLoader.this.adPlaybackState = new AdPlaybackState(AdTagLoader.this.adsId, ImaUtil.getAdGroupTimesUsForCuePoints(adsManager.getAdCuePoints()));
                AdTagLoader.this.updateAdPlaybackState();
            }
            catch (RuntimeException e) {
                AdTagLoader.this.maybeNotifyInternalError("onAdsManagerLoaded", e);
            }
        }

        public VideoProgressUpdate getContentProgress() {
            VideoProgressUpdate videoProgressUpdate = AdTagLoader.this.getContentVideoProgressUpdate();
            if (((AdTagLoader)AdTagLoader.this).configuration.debugModeEnabled) {
                String string = String.valueOf(ImaUtil.getStringForVideoProgressUpdate(videoProgressUpdate));
                Log.d((String)AdTagLoader.TAG, (String)(string.length() != 0 ? "Content progress: ".concat(string) : new String("Content progress: ")));
            }
            if (AdTagLoader.this.waitingForPreloadElapsedRealtimeMs != -9223372036854775807L) {
                long stuckElapsedRealtimeMs = SystemClock.elapsedRealtime() - AdTagLoader.this.waitingForPreloadElapsedRealtimeMs;
                if (stuckElapsedRealtimeMs >= 4000L) {
                    AdTagLoader.this.waitingForPreloadElapsedRealtimeMs = -9223372036854775807L;
                    AdTagLoader.this.handleAdGroupLoadError(new IOException("Ad preloading timed out"));
                    AdTagLoader.this.maybeNotifyPendingAdLoadError();
                }
            } else if (AdTagLoader.this.pendingContentPositionMs != -9223372036854775807L && AdTagLoader.this.player != null && AdTagLoader.this.player.getPlaybackState() == 2 && AdTagLoader.this.isWaitingForAdToLoad()) {
                AdTagLoader.this.waitingForPreloadElapsedRealtimeMs = SystemClock.elapsedRealtime();
            }
            return videoProgressUpdate;
        }

        public void onAdEvent(AdEvent adEvent) {
            AdEvent.AdEventType adEventType = adEvent.getType();
            if (((AdTagLoader)AdTagLoader.this).configuration.debugModeEnabled && adEventType != AdEvent.AdEventType.AD_PROGRESS) {
                String string = String.valueOf(adEventType);
                Log.d((String)AdTagLoader.TAG, (String)new StringBuilder(11 + String.valueOf(string).length()).append("onAdEvent: ").append(string).toString());
            }
            try {
                AdTagLoader.this.handleAdEvent(adEvent);
            }
            catch (RuntimeException e) {
                AdTagLoader.this.maybeNotifyInternalError("onAdEvent", e);
            }
        }

        public void onAdError(AdErrorEvent adErrorEvent) {
            AdError error = adErrorEvent.getError();
            if (((AdTagLoader)AdTagLoader.this).configuration.debugModeEnabled) {
                Log.d((String)AdTagLoader.TAG, (String)"onAdError", (Throwable)error);
            }
            if (AdTagLoader.this.adsManager == null) {
                AdTagLoader.this.pendingAdRequestContext = null;
                AdTagLoader.this.adPlaybackState = new AdPlaybackState(AdTagLoader.this.adsId, new long[0]);
                AdTagLoader.this.updateAdPlaybackState();
            } else if (ImaUtil.isAdGroupLoadError(error)) {
                try {
                    AdTagLoader.this.handleAdGroupLoadError((Exception)error);
                }
                catch (RuntimeException e) {
                    AdTagLoader.this.maybeNotifyInternalError("onAdError", e);
                }
            }
            if (AdTagLoader.this.pendingAdLoadError == null) {
                AdTagLoader.this.pendingAdLoadError = AdsMediaSource.AdLoadException.createForAllAds((Exception)error);
            }
            AdTagLoader.this.maybeNotifyPendingAdLoadError();
        }

        public void addCallback(VideoAdPlayer.VideoAdPlayerCallback videoAdPlayerCallback) {
            AdTagLoader.this.adCallbacks.add(videoAdPlayerCallback);
        }

        public void removeCallback(VideoAdPlayer.VideoAdPlayerCallback videoAdPlayerCallback) {
            AdTagLoader.this.adCallbacks.remove(videoAdPlayerCallback);
        }

        public VideoProgressUpdate getAdProgress() {
            throw new IllegalStateException("Unexpected call to getAdProgress when using preloading");
        }

        public int getVolume() {
            return AdTagLoader.this.getPlayerVolumePercent();
        }

        public void loadAd(AdMediaInfo adMediaInfo, AdPodInfo adPodInfo) {
            try {
                AdTagLoader.this.loadAdInternal(adMediaInfo, adPodInfo);
            }
            catch (RuntimeException e) {
                AdTagLoader.this.maybeNotifyInternalError("loadAd", e);
            }
        }

        public void playAd(AdMediaInfo adMediaInfo) {
            try {
                AdTagLoader.this.playAdInternal(adMediaInfo);
            }
            catch (RuntimeException e) {
                AdTagLoader.this.maybeNotifyInternalError("playAd", e);
            }
        }

        public void pauseAd(AdMediaInfo adMediaInfo) {
            try {
                AdTagLoader.this.pauseAdInternal(adMediaInfo);
            }
            catch (RuntimeException e) {
                AdTagLoader.this.maybeNotifyInternalError("pauseAd", e);
            }
        }

        public void stopAd(AdMediaInfo adMediaInfo) {
            try {
                AdTagLoader.this.stopAdInternal(adMediaInfo);
            }
            catch (RuntimeException e) {
                AdTagLoader.this.maybeNotifyInternalError("stopAd", e);
            }
        }

        public void release() {
        }
    }
}

