/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ext.ima;

import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.ads.interactivemedia.v3.api.AdDisplayContainer;
import com.google.ads.interactivemedia.v3.api.AdError;
import com.google.ads.interactivemedia.v3.api.AdErrorEvent;
import com.google.ads.interactivemedia.v3.api.AdEvent;
import com.google.ads.interactivemedia.v3.api.AdPodInfo;
import com.google.ads.interactivemedia.v3.api.AdsLoader;
import com.google.ads.interactivemedia.v3.api.AdsManager;
import com.google.ads.interactivemedia.v3.api.AdsManagerLoadedEvent;
import com.google.ads.interactivemedia.v3.api.AdsRenderingSettings;
import com.google.ads.interactivemedia.v3.api.AdsRequest;
import com.google.ads.interactivemedia.v3.api.ImaSdkFactory;
import com.google.ads.interactivemedia.v3.api.ImaSdkSettings;
import com.google.ads.interactivemedia.v3.api.UiElement;
import com.google.ads.interactivemedia.v3.api.player.AdMediaInfo;
import com.google.ads.interactivemedia.v3.api.player.ContentProgressProvider;
import com.google.ads.interactivemedia.v3.api.player.VideoAdPlayer;
import com.google.ads.interactivemedia.v3.api.player.VideoProgressUpdate;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.ExoPlayerLibraryInfo;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.ext.ima.AdPlaybackStateFactory;
import com.google.android.exoplayer2.source.ads.AdPlaybackState;
import com.google.android.exoplayer2.source.ads.AdsLoader;
import com.google.android.exoplayer2.source.ads.AdsMediaSource;
import com.google.android.exoplayer2.trackselection.TrackSelectionArray;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ImaAdsLoader
implements Player.EventListener,
AdsLoader {
    private static final boolean DEBUG = false;
    private static final String TAG = "ImaAdsLoader";
    private static final String IMA_SDK_SETTINGS_PLAYER_TYPE = "google/exo.ext.ima";
    private static final String IMA_SDK_SETTINGS_PLAYER_VERSION = "2.11.8";
    private static final int AD_PROGRESS_UPDATE_INTERVAL_MS = 100;
    private static final long IMA_DURATION_UNSET = -1L;
    private static final long THRESHOLD_END_OF_CONTENT_MS = 5000L;
    private static final long THRESHOLD_AD_PRELOAD_MS = 4000L;
    private static final long THRESHOLD_AD_MATCH_US = 1000L;
    private static final int TIMEOUT_UNSET = -1;
    private static final int BITRATE_UNSET = -1;
    private static final int IMA_AD_STATE_NONE = 0;
    private static final int IMA_AD_STATE_PLAYING = 1;
    private static final int IMA_AD_STATE_PAUSED = 2;
    @Nullable
    private final Uri adTagUri;
    @Nullable
    private final String adsResponse;
    private final long adPreloadTimeoutMs;
    private final int vastLoadTimeoutMs;
    private final int mediaLoadTimeoutMs;
    private final boolean focusSkipButtonWhenAvailable;
    private final boolean playAdBeforeStartPosition;
    private final int mediaBitrate;
    @Nullable
    private final Set<UiElement> adUiElements;
    @Nullable
    private final AdEvent.AdEventListener adEventListener;
    private final ImaFactory imaFactory;
    private final Timeline.Period period;
    private final Handler handler;
    private final ComponentListener componentListener;
    private final List<VideoAdPlayer.VideoAdPlayerCallback> adCallbacks;
    private final AdDisplayContainer adDisplayContainer;
    private final com.google.ads.interactivemedia.v3.api.AdsLoader adsLoader;
    private final Runnable updateAdProgressRunnable;
    private final Map<AdMediaInfo, AdInfo> adInfoByAdMediaInfo;
    private boolean wasSetPlayerCalled;
    @Nullable
    private Player nextPlayer;
    @Nullable
    private Object pendingAdRequestContext;
    private List<String> supportedMimeTypes;
    @Nullable
    private AdsLoader.EventListener eventListener;
    @Nullable
    private Player player;
    private VideoProgressUpdate lastContentProgress;
    private VideoProgressUpdate lastAdProgress;
    private int lastVolumePercent;
    @Nullable
    private AdsManager adsManager;
    private boolean isAdsManagerInitialized;
    private boolean hasAdPlaybackState;
    @Nullable
    private AdsMediaSource.AdLoadException pendingAdLoadError;
    private Timeline timeline;
    private long contentDurationMs;
    private AdPlaybackState adPlaybackState;
    private boolean imaPausedContent;
    private int imaAdState;
    @Nullable
    private AdMediaInfo imaAdMediaInfo;
    @Nullable
    private AdInfo imaAdInfo;
    private boolean sentContentComplete;
    private boolean playingAd;
    private boolean bufferingAd;
    private int playingAdIndexInAdGroup;
    @Nullable
    private AdInfo pendingAdPrepareErrorAdInfo;
    private long fakeContentProgressElapsedRealtimeMs;
    private long fakeContentProgressOffsetMs;
    private long pendingContentPositionMs;
    private boolean sentPendingContentPositionMs;
    private long waitingForPreloadElapsedRealtimeMs;

    public ImaAdsLoader(Context context, Uri adTagUri) {
        this(context, adTagUri, null, null, 10000L, -1, -1, -1, true, true, null, null, new DefaultImaFactory());
    }

    private ImaAdsLoader(Context context, @Nullable Uri adTagUri, @Nullable ImaSdkSettings imaSdkSettings, @Nullable String adsResponse, long adPreloadTimeoutMs, int vastLoadTimeoutMs, int mediaLoadTimeoutMs, int mediaBitrate, boolean focusSkipButtonWhenAvailable, boolean playAdBeforeStartPosition, @Nullable Set<UiElement> adUiElements, @Nullable AdEvent.AdEventListener adEventListener, ImaFactory imaFactory) {
        Assertions.checkArgument((adTagUri != null || adsResponse != null ? 1 : 0) != 0);
        this.adTagUri = adTagUri;
        this.adsResponse = adsResponse;
        this.adPreloadTimeoutMs = adPreloadTimeoutMs;
        this.vastLoadTimeoutMs = vastLoadTimeoutMs;
        this.mediaLoadTimeoutMs = mediaLoadTimeoutMs;
        this.mediaBitrate = mediaBitrate;
        this.focusSkipButtonWhenAvailable = focusSkipButtonWhenAvailable;
        this.playAdBeforeStartPosition = playAdBeforeStartPosition;
        this.adUiElements = adUiElements;
        this.adEventListener = adEventListener;
        this.imaFactory = imaFactory;
        if (imaSdkSettings == null) {
            imaSdkSettings = imaFactory.createImaSdkSettings();
        }
        imaSdkSettings.setPlayerType(IMA_SDK_SETTINGS_PLAYER_TYPE);
        imaSdkSettings.setPlayerVersion(IMA_SDK_SETTINGS_PLAYER_VERSION);
        this.period = new Timeline.Period();
        this.handler = Util.createHandler((Looper)ImaAdsLoader.getImaLooper(), null);
        this.componentListener = new ComponentListener();
        this.adCallbacks = new ArrayList<VideoAdPlayer.VideoAdPlayerCallback>(1);
        this.adDisplayContainer = imaFactory.createAdDisplayContainer();
        this.adDisplayContainer.setPlayer((VideoAdPlayer)this.componentListener);
        this.adsLoader = imaFactory.createAdsLoader(context.getApplicationContext(), imaSdkSettings, this.adDisplayContainer);
        this.adsLoader.addAdErrorListener((AdErrorEvent.AdErrorListener)this.componentListener);
        this.adsLoader.addAdsLoadedListener((AdsLoader.AdsLoadedListener)this.componentListener);
        this.updateAdProgressRunnable = this::updateAdProgress;
        this.adInfoByAdMediaInfo = new HashMap<AdMediaInfo, AdInfo>();
        this.supportedMimeTypes = Collections.emptyList();
        this.lastContentProgress = VideoProgressUpdate.VIDEO_TIME_NOT_READY;
        this.lastAdProgress = VideoProgressUpdate.VIDEO_TIME_NOT_READY;
        this.fakeContentProgressElapsedRealtimeMs = -9223372036854775807L;
        this.fakeContentProgressOffsetMs = -9223372036854775807L;
        this.pendingContentPositionMs = -9223372036854775807L;
        this.waitingForPreloadElapsedRealtimeMs = -9223372036854775807L;
        this.contentDurationMs = -9223372036854775807L;
        this.timeline = Timeline.EMPTY;
        this.adPlaybackState = AdPlaybackState.NONE;
    }

    public com.google.ads.interactivemedia.v3.api.AdsLoader getAdsLoader() {
        return this.adsLoader;
    }

    public AdDisplayContainer getAdDisplayContainer() {
        return this.adDisplayContainer;
    }

    public void requestAds(ViewGroup adViewGroup) {
        if (this.hasAdPlaybackState || this.adsManager != null || this.pendingAdRequestContext != null) {
            return;
        }
        this.adDisplayContainer.setAdContainer(adViewGroup);
        AdsRequest request = this.imaFactory.createAdsRequest();
        if (this.adTagUri != null) {
            request.setAdTagUrl(this.adTagUri.toString());
        } else {
            request.setAdsResponse((String)Util.castNonNull((Object)this.adsResponse));
        }
        if (this.vastLoadTimeoutMs != -1) {
            request.setVastLoadTimeout((float)this.vastLoadTimeoutMs);
        }
        request.setContentProgressProvider((ContentProgressProvider)this.componentListener);
        this.pendingAdRequestContext = new Object();
        request.setUserRequestContext(this.pendingAdRequestContext);
        this.adsLoader.requestAds(request);
    }

    public void setPlayer(@Nullable Player player) {
        Assertions.checkState((Looper.myLooper() == ImaAdsLoader.getImaLooper() ? 1 : 0) != 0);
        Assertions.checkState((player == null || player.getApplicationLooper() == ImaAdsLoader.getImaLooper() ? 1 : 0) != 0);
        this.nextPlayer = player;
        this.wasSetPlayerCalled = true;
    }

    public void setSupportedContentTypes(int ... contentTypes) {
        ArrayList<String> supportedMimeTypes = new ArrayList<String>();
        for (int contentType : contentTypes) {
            if (contentType == 0) {
                supportedMimeTypes.add("application/dash+xml");
                continue;
            }
            if (contentType == 2) {
                supportedMimeTypes.add("application/x-mpegURL");
                continue;
            }
            if (contentType != 3) continue;
            supportedMimeTypes.addAll(Arrays.asList("video/mp4", "video/webm", "video/3gpp", "audio/mp4", "audio/mpeg"));
        }
        this.supportedMimeTypes = Collections.unmodifiableList(supportedMimeTypes);
    }

    public void start(AdsLoader.EventListener eventListener, AdsLoader.AdViewProvider adViewProvider) {
        View[] adOverlayViews;
        Assertions.checkState((boolean)this.wasSetPlayerCalled, (Object)"Set player using adsLoader.setPlayer before preparing the player.");
        this.player = this.nextPlayer;
        if (this.player == null) {
            return;
        }
        this.player.addListener((Player.EventListener)this);
        boolean playWhenReady = this.player.getPlayWhenReady();
        this.eventListener = eventListener;
        this.lastVolumePercent = 0;
        this.lastAdProgress = VideoProgressUpdate.VIDEO_TIME_NOT_READY;
        this.lastContentProgress = VideoProgressUpdate.VIDEO_TIME_NOT_READY;
        ViewGroup adViewGroup = adViewProvider.getAdViewGroup();
        this.adDisplayContainer.setAdContainer(adViewGroup);
        for (View view : adOverlayViews = adViewProvider.getAdOverlayViews()) {
            this.adDisplayContainer.registerVideoControlsOverlay(view);
        }
        this.maybeNotifyPendingAdLoadError();
        if (this.hasAdPlaybackState) {
            eventListener.onAdPlaybackState(this.adPlaybackState);
            if (this.adsManager != null && this.imaPausedContent && playWhenReady) {
                this.adsManager.resume();
            }
        } else if (this.adsManager != null) {
            this.adPlaybackState = AdPlaybackStateFactory.fromCuePoints(this.adsManager.getAdCuePoints());
            this.updateAdPlaybackState();
        } else {
            this.requestAds(adViewGroup);
        }
    }

    public void stop() {
        Player player = this.player;
        if (player == null) {
            return;
        }
        if (this.adsManager != null && this.imaPausedContent) {
            this.adsManager.pause();
            this.adPlaybackState = this.adPlaybackState.withAdResumePositionUs(this.playingAd ? C.msToUs((long)player.getCurrentPosition()) : 0L);
        }
        this.lastVolumePercent = this.getPlayerVolumePercent();
        this.lastAdProgress = this.getAdVideoProgressUpdate();
        this.lastContentProgress = this.getContentVideoProgressUpdate();
        this.adDisplayContainer.unregisterAllVideoControlsOverlays();
        player.removeListener((Player.EventListener)this);
        this.player = null;
        this.eventListener = null;
    }

    public void release() {
        this.pendingAdRequestContext = null;
        this.destroyAdsManager();
        this.adsLoader.removeAdsLoadedListener((AdsLoader.AdsLoadedListener)this.componentListener);
        this.adsLoader.removeAdErrorListener((AdErrorEvent.AdErrorListener)this.componentListener);
        this.imaPausedContent = false;
        this.imaAdState = 0;
        this.imaAdMediaInfo = null;
        this.stopUpdatingAdProgress();
        this.imaAdInfo = null;
        this.pendingAdLoadError = null;
        this.adPlaybackState = AdPlaybackState.NONE;
        this.hasAdPlaybackState = true;
        this.updateAdPlaybackState();
    }

    public void handlePrepareError(int adGroupIndex, int adIndexInAdGroup, IOException exception) {
        if (this.player == null) {
            return;
        }
        try {
            this.handleAdPrepareError(adGroupIndex, adIndexInAdGroup, exception);
        }
        catch (RuntimeException e) {
            this.maybeNotifyInternalError("handlePrepareError", e);
        }
    }

    public void onTimelineChanged(Timeline timeline, int reason) {
        if (timeline.isEmpty()) {
            return;
        }
        Assertions.checkArgument((timeline.getPeriodCount() == 1 ? 1 : 0) != 0);
        this.timeline = timeline;
        long contentDurationUs = timeline.getPeriod((int)0, (Timeline.Period)this.period).durationUs;
        this.contentDurationMs = C.usToMs((long)contentDurationUs);
        if (contentDurationUs != -9223372036854775807L) {
            this.adPlaybackState = this.adPlaybackState.withContentDurationUs(contentDurationUs);
        }
        AdsManager adsManager = this.adsManager;
        if (!this.isAdsManagerInitialized && adsManager != null) {
            this.isAdsManagerInitialized = true;
            AdsRenderingSettings adsRenderingSettings = this.setupAdsRendering();
            if (adsRenderingSettings == null) {
                this.destroyAdsManager();
            } else {
                adsManager.init(adsRenderingSettings);
                adsManager.start();
            }
            this.updateAdPlaybackState();
        }
        this.handleTimelineOrPositionChanged();
    }

    public void onPositionDiscontinuity(int reason) {
        this.handleTimelineOrPositionChanged();
    }

    public void onPlayerStateChanged(boolean playWhenReady, int playbackState) {
        Player player = this.player;
        if (this.adsManager == null || player == null) {
            return;
        }
        if (playbackState == 2 && !player.isPlayingAd()) {
            long contentPositionMs;
            int adGroupIndex = this.getLoadingAdGroupIndex();
            if (adGroupIndex == -1) {
                return;
            }
            AdPlaybackState.AdGroup adGroup = this.adPlaybackState.adGroups[adGroupIndex];
            if (adGroup.count != -1 && adGroup.count != 0 && adGroup.states[0] != 0) {
                return;
            }
            long adGroupTimeMs = C.usToMs((long)this.adPlaybackState.adGroupTimesUs[adGroupIndex]);
            long timeUntilAdMs = adGroupTimeMs - (contentPositionMs = ImaAdsLoader.getContentPeriodPositionMs(player, this.timeline, this.period));
            if (timeUntilAdMs < this.adPreloadTimeoutMs) {
                this.waitingForPreloadElapsedRealtimeMs = SystemClock.elapsedRealtime();
            }
        } else if (playbackState == 3) {
            this.waitingForPreloadElapsedRealtimeMs = -9223372036854775807L;
        }
        if (this.imaAdState == 1 && !playWhenReady) {
            this.adsManager.pause();
            return;
        }
        if (this.imaAdState == 2 && playWhenReady) {
            this.adsManager.resume();
            return;
        }
        this.handlePlayerStateChanged(playWhenReady, playbackState);
    }

    public void onPlayerError(ExoPlaybackException error) {
        if (this.imaAdState != 0) {
            AdMediaInfo adMediaInfo = (AdMediaInfo)Assertions.checkNotNull((Object)this.imaAdMediaInfo);
            for (int i = 0; i < this.adCallbacks.size(); ++i) {
                this.adCallbacks.get(i).onError(adMediaInfo);
            }
        }
    }

    @Nullable
    private AdsRenderingSettings setupAdsRendering() {
        AdsRenderingSettings adsRenderingSettings = this.imaFactory.createAdsRenderingSettings();
        adsRenderingSettings.setEnablePreloading(true);
        adsRenderingSettings.setMimeTypes(this.supportedMimeTypes);
        if (this.mediaLoadTimeoutMs != -1) {
            adsRenderingSettings.setLoadVideoTimeout(this.mediaLoadTimeoutMs);
        }
        if (this.mediaBitrate != -1) {
            adsRenderingSettings.setBitrateKbps(this.mediaBitrate / 1000);
        }
        adsRenderingSettings.setFocusSkipButtonWhenAvailable(this.focusSkipButtonWhenAvailable);
        if (this.adUiElements != null) {
            adsRenderingSettings.setUiElements(this.adUiElements);
        }
        long[] adGroupTimesUs = this.adPlaybackState.adGroupTimesUs;
        long contentPositionMs = ImaAdsLoader.getContentPeriodPositionMs((Player)Assertions.checkNotNull((Object)this.player), this.timeline, this.period);
        int adGroupForPositionIndex = this.adPlaybackState.getAdGroupIndexForPositionUs(C.msToUs((long)contentPositionMs), C.msToUs((long)this.contentDurationMs));
        if (adGroupForPositionIndex != -1) {
            boolean playAdWhenStartingPlayback;
            boolean bl = playAdWhenStartingPlayback = this.playAdBeforeStartPosition || adGroupTimesUs[adGroupForPositionIndex] == C.msToUs((long)contentPositionMs);
            if (!playAdWhenStartingPlayback) {
                ++adGroupForPositionIndex;
            } else if (ImaAdsLoader.hasMidrollAdGroups(adGroupTimesUs)) {
                this.pendingContentPositionMs = contentPositionMs;
            }
            if (adGroupForPositionIndex > 0) {
                for (int i = 0; i < adGroupForPositionIndex; ++i) {
                    this.adPlaybackState = this.adPlaybackState.withSkippedAdGroup(i);
                }
                if (adGroupForPositionIndex == adGroupTimesUs.length) {
                    return null;
                }
                long adGroupForPositionTimeUs = adGroupTimesUs[adGroupForPositionIndex];
                long adGroupBeforePositionTimeUs = adGroupTimesUs[adGroupForPositionIndex - 1];
                if (adGroupForPositionTimeUs == Long.MIN_VALUE) {
                    adsRenderingSettings.setPlayAdsAfterTime((double)adGroupBeforePositionTimeUs / 1000000.0 + 1.0);
                } else {
                    double midpointTimeUs = (double)(adGroupForPositionTimeUs + adGroupBeforePositionTimeUs) / 2.0;
                    adsRenderingSettings.setPlayAdsAfterTime(midpointTimeUs / 1000000.0);
                }
            }
        }
        return adsRenderingSettings;
    }

    private void handleAdEvent(AdEvent adEvent) {
        switch (adEvent.getType()) {
            case AD_BREAK_FETCH_ERROR: {
                String adGroupTimeSecondsString = (String)Assertions.checkNotNull(adEvent.getAdData().get("adBreakTime"));
                int adGroupTimeSeconds = Integer.parseInt(adGroupTimeSecondsString);
                int adGroupIndex = adGroupTimeSeconds == -1 ? this.adPlaybackState.adGroupCount - 1 : Util.linearSearch((long[])this.adPlaybackState.adGroupTimesUs, (long)(1000000L * (long)adGroupTimeSeconds));
                AdPlaybackState.AdGroup adGroup = this.adPlaybackState.adGroups[adGroupIndex];
                if (adGroup.count == -1) {
                    this.adPlaybackState = this.adPlaybackState.withAdCount(adGroupIndex, Math.max(1, adGroup.states.length));
                    adGroup = this.adPlaybackState.adGroups[adGroupIndex];
                }
                for (int i = 0; i < adGroup.count; ++i) {
                    if (adGroup.states[i] != 0) continue;
                    this.adPlaybackState = this.adPlaybackState.withAdLoadError(adGroupIndex, i);
                }
                this.updateAdPlaybackState();
                break;
            }
            case CONTENT_PAUSE_REQUESTED: {
                this.imaPausedContent = true;
                this.pauseContentInternal();
                break;
            }
            case TAPPED: {
                if (this.eventListener == null) break;
                this.eventListener.onAdTapped();
                break;
            }
            case CLICKED: {
                if (this.eventListener == null) break;
                this.eventListener.onAdClicked();
                break;
            }
            case CONTENT_RESUME_REQUESTED: {
                this.imaPausedContent = false;
                this.resumeContentInternal();
                break;
            }
            case LOG: {
                Map adData = adEvent.getAdData();
                String message = "AdEvent: " + adData;
                Log.i((String)TAG, (String)message);
                break;
            }
        }
    }

    private VideoProgressUpdate getContentVideoProgressUpdate() {
        long contentPositionMs;
        boolean hasContentDuration;
        if (this.player == null) {
            return this.lastContentProgress;
        }
        boolean bl = hasContentDuration = this.contentDurationMs != -9223372036854775807L;
        if (this.pendingContentPositionMs != -9223372036854775807L) {
            this.sentPendingContentPositionMs = true;
            contentPositionMs = this.pendingContentPositionMs;
        } else if (this.fakeContentProgressElapsedRealtimeMs != -9223372036854775807L) {
            long elapsedSinceEndMs = SystemClock.elapsedRealtime() - this.fakeContentProgressElapsedRealtimeMs;
            contentPositionMs = this.fakeContentProgressOffsetMs + elapsedSinceEndMs;
        } else if (this.imaAdState == 0 && !this.playingAd && hasContentDuration) {
            contentPositionMs = ImaAdsLoader.getContentPeriodPositionMs(this.player, this.timeline, this.period);
        } else {
            return VideoProgressUpdate.VIDEO_TIME_NOT_READY;
        }
        long contentDurationMs = hasContentDuration ? this.contentDurationMs : -1L;
        return new VideoProgressUpdate(contentPositionMs, contentDurationMs);
    }

    private VideoProgressUpdate getAdVideoProgressUpdate() {
        if (this.player == null) {
            return this.lastAdProgress;
        }
        if (this.imaAdState != 0 && this.playingAd) {
            long adDuration = this.player.getDuration();
            return adDuration == -9223372036854775807L ? VideoProgressUpdate.VIDEO_TIME_NOT_READY : new VideoProgressUpdate(this.player.getCurrentPosition(), adDuration);
        }
        return VideoProgressUpdate.VIDEO_TIME_NOT_READY;
    }

    private void updateAdProgress() {
        VideoProgressUpdate videoProgressUpdate = this.getAdVideoProgressUpdate();
        AdMediaInfo adMediaInfo = (AdMediaInfo)Assertions.checkNotNull((Object)this.imaAdMediaInfo);
        for (int i = 0; i < this.adCallbacks.size(); ++i) {
            this.adCallbacks.get(i).onAdProgress(adMediaInfo, videoProgressUpdate);
        }
        this.handler.removeCallbacks(this.updateAdProgressRunnable);
        this.handler.postDelayed(this.updateAdProgressRunnable, 100L);
    }

    private void stopUpdatingAdProgress() {
        this.handler.removeCallbacks(this.updateAdProgressRunnable);
    }

    private int getPlayerVolumePercent() {
        Player player = this.player;
        if (player == null) {
            return this.lastVolumePercent;
        }
        Player.AudioComponent audioComponent = player.getAudioComponent();
        if (audioComponent != null) {
            return (int)(audioComponent.getVolume() * 100.0f);
        }
        TrackSelectionArray trackSelections = player.getCurrentTrackSelections();
        for (int i = 0; i < player.getRendererCount() && i < trackSelections.length; ++i) {
            if (player.getRendererType(i) != 1 || trackSelections.get(i) == null) continue;
            return 100;
        }
        return 0;
    }

    private void handlePlayerStateChanged(boolean playWhenReady, int playbackState) {
        int i;
        AdMediaInfo adMediaInfo;
        if (this.playingAd && this.imaAdState == 1) {
            if (!this.bufferingAd && playbackState == 2) {
                adMediaInfo = (AdMediaInfo)Assertions.checkNotNull((Object)this.imaAdMediaInfo);
                for (i = 0; i < this.adCallbacks.size(); ++i) {
                    this.adCallbacks.get(i).onBuffering(adMediaInfo);
                }
                this.stopUpdatingAdProgress();
            } else if (this.bufferingAd && playbackState == 3) {
                this.bufferingAd = false;
                this.updateAdProgress();
            }
        }
        if (this.imaAdState == 0 && playbackState == 2 && playWhenReady) {
            this.ensureSentContentCompleteIfAtEndOfStream();
        } else if (this.imaAdState != 0 && playbackState == 4) {
            adMediaInfo = (AdMediaInfo)Assertions.checkNotNull((Object)this.imaAdMediaInfo);
            if (adMediaInfo == null) {
                Log.w((String)TAG, (String)"onEnded without ad media info");
            } else {
                for (i = 0; i < this.adCallbacks.size(); ++i) {
                    this.adCallbacks.get(i).onEnded(adMediaInfo);
                }
            }
        }
    }

    private void handleTimelineOrPositionChanged() {
        boolean adFinished;
        Player player = this.player;
        if (this.adsManager == null || player == null) {
            return;
        }
        if (!this.playingAd && !player.isPlayingAd()) {
            this.ensureSentContentCompleteIfAtEndOfStream();
            if (!this.sentContentComplete && !this.timeline.isEmpty()) {
                long positionMs = ImaAdsLoader.getContentPeriodPositionMs(player, this.timeline, this.period);
                this.timeline.getPeriod(0, this.period);
                int newAdGroupIndex = this.period.getAdGroupIndexForPositionUs(C.msToUs((long)positionMs));
                if (newAdGroupIndex != -1) {
                    this.sentPendingContentPositionMs = false;
                    this.pendingContentPositionMs = positionMs;
                }
            }
        }
        boolean wasPlayingAd = this.playingAd;
        int oldPlayingAdIndexInAdGroup = this.playingAdIndexInAdGroup;
        this.playingAd = player.isPlayingAd();
        this.playingAdIndexInAdGroup = this.playingAd ? player.getCurrentAdIndexInAdGroup() : -1;
        boolean bl = adFinished = wasPlayingAd && this.playingAdIndexInAdGroup != oldPlayingAdIndexInAdGroup;
        if (adFinished) {
            AdMediaInfo adMediaInfo = this.imaAdMediaInfo;
            if (adMediaInfo == null) {
                Log.w((String)TAG, (String)"onEnded without ad media info");
            } else {
                for (int i = 0; i < this.adCallbacks.size(); ++i) {
                    this.adCallbacks.get(i).onEnded(adMediaInfo);
                }
            }
        }
        if (!this.sentContentComplete && !wasPlayingAd && this.playingAd && this.imaAdState == 0) {
            int adGroupIndex = player.getCurrentAdGroupIndex();
            if (this.adPlaybackState.adGroupTimesUs[adGroupIndex] == Long.MIN_VALUE) {
                this.sendContentComplete();
            } else {
                this.fakeContentProgressElapsedRealtimeMs = SystemClock.elapsedRealtime();
                this.fakeContentProgressOffsetMs = C.usToMs((long)this.adPlaybackState.adGroupTimesUs[adGroupIndex]);
                if (this.fakeContentProgressOffsetMs == Long.MIN_VALUE) {
                    this.fakeContentProgressOffsetMs = this.contentDurationMs;
                }
            }
        }
    }

    private void resumeContentInternal() {
        if (this.imaAdInfo != null) {
            this.adPlaybackState = this.adPlaybackState.withSkippedAdGroup(this.imaAdInfo.adGroupIndex);
            this.updateAdPlaybackState();
        }
    }

    private void pauseContentInternal() {
        this.imaAdState = 0;
        if (this.sentPendingContentPositionMs) {
            this.pendingContentPositionMs = -9223372036854775807L;
            this.sentPendingContentPositionMs = false;
        }
    }

    private void stopAdInternal() {
        this.imaAdState = 0;
        this.stopUpdatingAdProgress();
        Assertions.checkNotNull((Object)this.imaAdInfo);
        int adGroupIndex = this.imaAdInfo.adGroupIndex;
        int adIndexInAdGroup = this.imaAdInfo.adIndexInAdGroup;
        if (this.adPlaybackState.isAdInErrorState(adGroupIndex, adIndexInAdGroup)) {
            return;
        }
        this.adPlaybackState = this.adPlaybackState.withPlayedAd(adGroupIndex, adIndexInAdGroup).withAdResumePositionUs(0L);
        this.updateAdPlaybackState();
        if (!this.playingAd) {
            this.imaAdMediaInfo = null;
            this.imaAdInfo = null;
        }
    }

    private void handleAdGroupLoadError(Exception error) {
        if (this.player == null) {
            return;
        }
        int adGroupIndex = this.getLoadingAdGroupIndex();
        if (adGroupIndex == -1) {
            Log.w((String)TAG, (String)"Unable to determine ad group index for ad group load error", (Throwable)error);
            return;
        }
        AdPlaybackState.AdGroup adGroup = this.adPlaybackState.adGroups[adGroupIndex];
        if (adGroup.count == -1) {
            this.adPlaybackState = this.adPlaybackState.withAdCount(adGroupIndex, Math.max(1, adGroup.states.length));
            adGroup = this.adPlaybackState.adGroups[adGroupIndex];
        }
        for (int i = 0; i < adGroup.count; ++i) {
            if (adGroup.states[i] != 0) continue;
            this.adPlaybackState = this.adPlaybackState.withAdLoadError(adGroupIndex, i);
        }
        this.updateAdPlaybackState();
        if (this.pendingAdLoadError == null) {
            this.pendingAdLoadError = AdsMediaSource.AdLoadException.createForAdGroup((Exception)error, (int)adGroupIndex);
        }
        this.pendingContentPositionMs = -9223372036854775807L;
        this.fakeContentProgressElapsedRealtimeMs = -9223372036854775807L;
    }

    private void handleAdPrepareError(int adGroupIndex, int adIndexInAdGroup, Exception exception) {
        if (this.adsManager == null) {
            Log.w((String)TAG, (String)"Ignoring ad prepare error after release");
            return;
        }
        if (this.imaAdState == 0) {
            this.fakeContentProgressElapsedRealtimeMs = SystemClock.elapsedRealtime();
            this.fakeContentProgressOffsetMs = C.usToMs((long)this.adPlaybackState.adGroupTimesUs[adGroupIndex]);
            if (this.fakeContentProgressOffsetMs == Long.MIN_VALUE) {
                this.fakeContentProgressOffsetMs = this.contentDurationMs;
            }
            this.pendingAdPrepareErrorAdInfo = new AdInfo(adGroupIndex, adIndexInAdGroup);
        } else {
            int i;
            AdMediaInfo adMediaInfo = (AdMediaInfo)Assertions.checkNotNull((Object)this.imaAdMediaInfo);
            if (adIndexInAdGroup > this.playingAdIndexInAdGroup) {
                for (i = 0; i < this.adCallbacks.size(); ++i) {
                    this.adCallbacks.get(i).onEnded(adMediaInfo);
                }
            }
            this.playingAdIndexInAdGroup = this.adPlaybackState.adGroups[adGroupIndex].getFirstAdIndexToPlay();
            for (i = 0; i < this.adCallbacks.size(); ++i) {
                this.adCallbacks.get(i).onError((AdMediaInfo)Assertions.checkNotNull((Object)adMediaInfo));
            }
        }
        this.adPlaybackState = this.adPlaybackState.withAdLoadError(adGroupIndex, adIndexInAdGroup);
        this.updateAdPlaybackState();
    }

    private void ensureSentContentCompleteIfAtEndOfStream() {
        if (!this.sentContentComplete && this.contentDurationMs != -9223372036854775807L && this.pendingContentPositionMs == -9223372036854775807L && ImaAdsLoader.getContentPeriodPositionMs((Player)Assertions.checkNotNull((Object)this.player), this.timeline, this.period) + 5000L >= this.contentDurationMs) {
            this.sendContentComplete();
        }
    }

    private void sendContentComplete() {
        this.adsLoader.contentComplete();
        this.sentContentComplete = true;
        for (int i = 0; i < this.adPlaybackState.adGroupCount; ++i) {
            if (this.adPlaybackState.adGroupTimesUs[i] == Long.MIN_VALUE) continue;
            this.adPlaybackState = this.adPlaybackState.withSkippedAdGroup(i);
        }
        this.updateAdPlaybackState();
    }

    private void updateAdPlaybackState() {
        if (this.eventListener != null) {
            this.eventListener.onAdPlaybackState(this.adPlaybackState);
        }
    }

    private void maybeNotifyPendingAdLoadError() {
        if (this.pendingAdLoadError != null && this.eventListener != null) {
            this.eventListener.onAdLoadError(this.pendingAdLoadError, ImaAdsLoader.getAdsDataSpec(this.adTagUri));
            this.pendingAdLoadError = null;
        }
    }

    private void maybeNotifyInternalError(String name, Exception cause) {
        String message = "Internal error in " + name;
        Log.e((String)TAG, (String)message, (Throwable)cause);
        for (int i = 0; i < this.adPlaybackState.adGroupCount; ++i) {
            this.adPlaybackState = this.adPlaybackState.withSkippedAdGroup(i);
        }
        this.updateAdPlaybackState();
        if (this.eventListener != null) {
            this.eventListener.onAdLoadError(AdsMediaSource.AdLoadException.createForUnexpected((RuntimeException)new RuntimeException(message, cause)), ImaAdsLoader.getAdsDataSpec(this.adTagUri));
        }
    }

    private int getAdGroupIndexForAdPod(AdPodInfo adPodInfo) {
        if (adPodInfo.getPodIndex() == -1) {
            return this.adPlaybackState.adGroupCount - 1;
        }
        long adPodTimeUs = Math.round((double)((float)adPodInfo.getTimeOffset()) * 1000000.0);
        for (int adGroupIndex = 0; adGroupIndex < this.adPlaybackState.adGroupCount; ++adGroupIndex) {
            long adGroupTimeUs = this.adPlaybackState.adGroupTimesUs[adGroupIndex];
            if (adGroupTimeUs == Long.MIN_VALUE || Math.abs(adGroupTimeUs - adPodTimeUs) >= 1000L) continue;
            return adGroupIndex;
        }
        throw new IllegalStateException("Failed to find cue point");
    }

    private int getLoadingAdGroupIndex() {
        long playerPositionUs = C.msToUs((long)ImaAdsLoader.getContentPeriodPositionMs((Player)Assertions.checkNotNull((Object)this.player), this.timeline, this.period));
        int adGroupIndex = this.adPlaybackState.getAdGroupIndexForPositionUs(playerPositionUs, C.msToUs((long)this.contentDurationMs));
        if (adGroupIndex == -1) {
            adGroupIndex = this.adPlaybackState.getAdGroupIndexAfterPositionUs(playerPositionUs, C.msToUs((long)this.contentDurationMs));
        }
        return adGroupIndex;
    }

    private String getAdMediaInfoString(AdMediaInfo adMediaInfo) {
        AdInfo adInfo = this.adInfoByAdMediaInfo.get(adMediaInfo);
        return "AdMediaInfo[" + adMediaInfo.getUrl() + (adInfo != null ? ", " + adInfo : "") + "]";
    }

    private static DataSpec getAdsDataSpec(@Nullable Uri adTagUri) {
        return new DataSpec(adTagUri != null ? adTagUri : Uri.EMPTY);
    }

    private static long getContentPeriodPositionMs(Player player, Timeline timeline, Timeline.Period period) {
        long contentWindowPositionMs = player.getContentPosition();
        return contentWindowPositionMs - (timeline.isEmpty() ? 0L : timeline.getPeriod(0, period).getPositionInWindowMs());
    }

    private static boolean isAdGroupLoadError(AdError adError) {
        return adError.getErrorCode() == AdError.AdErrorCode.VAST_LINEAR_ASSET_MISMATCH || adError.getErrorCode() == AdError.AdErrorCode.UNKNOWN_ERROR;
    }

    private static Looper getImaLooper() {
        return Looper.getMainLooper();
    }

    private static boolean hasMidrollAdGroups(long[] adGroupTimesUs) {
        int count = adGroupTimesUs.length;
        if (count == 1) {
            return adGroupTimesUs[0] != 0L && adGroupTimesUs[0] != Long.MIN_VALUE;
        }
        if (count == 2) {
            return adGroupTimesUs[0] != 0L || adGroupTimesUs[1] != Long.MIN_VALUE;
        }
        return true;
    }

    private void destroyAdsManager() {
        if (this.adsManager != null) {
            this.adsManager.removeAdErrorListener((AdErrorEvent.AdErrorListener)this.componentListener);
            this.adsManager.removeAdEventListener((AdEvent.AdEventListener)this.componentListener);
            if (this.adEventListener != null) {
                this.adsManager.removeAdEventListener(this.adEventListener);
            }
            this.adsManager.destroy();
            this.adsManager = null;
        }
    }

    static {
        ExoPlayerLibraryInfo.registerModule((String)"goog.exo.ima");
    }

    private static final class DefaultImaFactory
    implements ImaFactory {
        private DefaultImaFactory() {
        }

        @Override
        public ImaSdkSettings createImaSdkSettings() {
            return ImaSdkFactory.getInstance().createImaSdkSettings();
        }

        @Override
        public AdsRenderingSettings createAdsRenderingSettings() {
            return ImaSdkFactory.getInstance().createAdsRenderingSettings();
        }

        @Override
        public AdDisplayContainer createAdDisplayContainer() {
            return ImaSdkFactory.getInstance().createAdDisplayContainer();
        }

        @Override
        public AdsRequest createAdsRequest() {
            return ImaSdkFactory.getInstance().createAdsRequest();
        }

        @Override
        public com.google.ads.interactivemedia.v3.api.AdsLoader createAdsLoader(Context context, ImaSdkSettings imaSdkSettings, AdDisplayContainer adDisplayContainer) {
            return ImaSdkFactory.getInstance().createAdsLoader(context, imaSdkSettings, adDisplayContainer);
        }
    }

    private static final class AdInfo {
        public final int adGroupIndex;
        public final int adIndexInAdGroup;

        public AdInfo(int adGroupIndex, int adIndexInAdGroup) {
            this.adGroupIndex = adGroupIndex;
            this.adIndexInAdGroup = adIndexInAdGroup;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AdInfo adInfo = (AdInfo)o;
            if (this.adGroupIndex != adInfo.adGroupIndex) {
                return false;
            }
            return this.adIndexInAdGroup == adInfo.adIndexInAdGroup;
        }

        public int hashCode() {
            int result = this.adGroupIndex;
            result = 31 * result + this.adIndexInAdGroup;
            return result;
        }

        public String toString() {
            return "(" + this.adGroupIndex + ", " + this.adIndexInAdGroup + ')';
        }
    }

    private final class ComponentListener
    implements VideoAdPlayer,
    ContentProgressProvider,
    AdErrorEvent.AdErrorListener,
    AdsLoader.AdsLoadedListener,
    AdEvent.AdEventListener {
        private ComponentListener() {
        }

        public void onAdsManagerLoaded(AdsManagerLoadedEvent adsManagerLoadedEvent) {
            AdsManager adsManager = adsManagerLoadedEvent.getAdsManager();
            if (!Util.areEqual((Object)ImaAdsLoader.this.pendingAdRequestContext, (Object)adsManagerLoadedEvent.getUserRequestContext())) {
                adsManager.destroy();
                return;
            }
            ImaAdsLoader.this.pendingAdRequestContext = null;
            ImaAdsLoader.this.adsManager = adsManager;
            adsManager.addAdErrorListener((AdErrorEvent.AdErrorListener)this);
            adsManager.addAdEventListener((AdEvent.AdEventListener)this);
            if (ImaAdsLoader.this.adEventListener != null) {
                adsManager.addAdEventListener(ImaAdsLoader.this.adEventListener);
            }
            if (ImaAdsLoader.this.player != null) {
                try {
                    ImaAdsLoader.this.adPlaybackState = AdPlaybackStateFactory.fromCuePoints(adsManager.getAdCuePoints());
                    ImaAdsLoader.this.hasAdPlaybackState = true;
                    ImaAdsLoader.this.updateAdPlaybackState();
                }
                catch (RuntimeException e) {
                    ImaAdsLoader.this.maybeNotifyInternalError("onAdsManagerLoaded", e);
                }
            }
        }

        public void onAdEvent(AdEvent adEvent) {
            AdEvent.AdEventType adEventType = adEvent.getType();
            if (ImaAdsLoader.this.adsManager == null) {
                return;
            }
            try {
                ImaAdsLoader.this.handleAdEvent(adEvent);
            }
            catch (RuntimeException e) {
                ImaAdsLoader.this.maybeNotifyInternalError("onAdEvent", e);
            }
        }

        public void onAdError(AdErrorEvent adErrorEvent) {
            AdError error = adErrorEvent.getError();
            if (ImaAdsLoader.this.adsManager == null) {
                ImaAdsLoader.this.pendingAdRequestContext = null;
                ImaAdsLoader.this.adPlaybackState = AdPlaybackState.NONE;
                ImaAdsLoader.this.hasAdPlaybackState = true;
                ImaAdsLoader.this.updateAdPlaybackState();
            } else if (ImaAdsLoader.isAdGroupLoadError(error)) {
                try {
                    ImaAdsLoader.this.handleAdGroupLoadError((Exception)error);
                }
                catch (RuntimeException e) {
                    ImaAdsLoader.this.maybeNotifyInternalError("onAdError", e);
                }
            }
            if (ImaAdsLoader.this.pendingAdLoadError == null) {
                ImaAdsLoader.this.pendingAdLoadError = AdsMediaSource.AdLoadException.createForAllAds((Exception)error);
            }
            ImaAdsLoader.this.maybeNotifyPendingAdLoadError();
        }

        public VideoProgressUpdate getContentProgress() {
            long stuckElapsedRealtimeMs;
            VideoProgressUpdate videoProgressUpdate = ImaAdsLoader.this.getContentVideoProgressUpdate();
            if (ImaAdsLoader.this.waitingForPreloadElapsedRealtimeMs != -9223372036854775807L && (stuckElapsedRealtimeMs = SystemClock.elapsedRealtime() - ImaAdsLoader.this.waitingForPreloadElapsedRealtimeMs) >= 4000L) {
                ImaAdsLoader.this.waitingForPreloadElapsedRealtimeMs = -9223372036854775807L;
                ImaAdsLoader.this.handleAdGroupLoadError(new IOException("Ad preloading timed out"));
                ImaAdsLoader.this.maybeNotifyPendingAdLoadError();
            }
            return videoProgressUpdate;
        }

        public VideoProgressUpdate getAdProgress() {
            throw new IllegalStateException("Unexpected call to getAdProgress when using preloading");
        }

        public int getVolume() {
            return ImaAdsLoader.this.getPlayerVolumePercent();
        }

        public void loadAd(AdMediaInfo adMediaInfo, AdPodInfo adPodInfo) {
            try {
                if (ImaAdsLoader.this.adsManager == null) {
                    return;
                }
                int adGroupIndex = ImaAdsLoader.this.getAdGroupIndexForAdPod(adPodInfo);
                int adIndexInAdGroup = adPodInfo.getAdPosition() - 1;
                AdInfo adInfo = new AdInfo(adGroupIndex, adIndexInAdGroup);
                ImaAdsLoader.this.adInfoByAdMediaInfo.put(adMediaInfo, adInfo);
                if (ImaAdsLoader.this.adPlaybackState.isAdInErrorState(adGroupIndex, adIndexInAdGroup)) {
                    return;
                }
                AdPlaybackState.AdGroup adGroup = ((ImaAdsLoader)ImaAdsLoader.this).adPlaybackState.adGroups[adInfo.adGroupIndex];
                ImaAdsLoader.this.adPlaybackState = ImaAdsLoader.this.adPlaybackState.withAdCount(adInfo.adGroupIndex, Math.max(adPodInfo.getTotalAds(), adGroup.states.length));
                adGroup = ((ImaAdsLoader)ImaAdsLoader.this).adPlaybackState.adGroups[adInfo.adGroupIndex];
                for (int i = 0; i < adIndexInAdGroup; ++i) {
                    if (adGroup.states[i] != 0) continue;
                    ImaAdsLoader.this.adPlaybackState = ImaAdsLoader.this.adPlaybackState.withAdLoadError(adGroupIndex, i);
                }
                Uri adUri = Uri.parse((String)adMediaInfo.getUrl());
                ImaAdsLoader.this.adPlaybackState = ImaAdsLoader.this.adPlaybackState.withAdUri(adInfo.adGroupIndex, adInfo.adIndexInAdGroup, adUri);
                ImaAdsLoader.this.updateAdPlaybackState();
            }
            catch (RuntimeException e) {
                ImaAdsLoader.this.maybeNotifyInternalError("loadAd", e);
            }
        }

        public void addCallback(VideoAdPlayer.VideoAdPlayerCallback videoAdPlayerCallback) {
            ImaAdsLoader.this.adCallbacks.add(videoAdPlayerCallback);
        }

        public void removeCallback(VideoAdPlayer.VideoAdPlayerCallback videoAdPlayerCallback) {
            ImaAdsLoader.this.adCallbacks.remove(videoAdPlayerCallback);
        }

        public void playAd(AdMediaInfo adMediaInfo) {
            if (ImaAdsLoader.this.adsManager == null) {
                return;
            }
            if (ImaAdsLoader.this.imaAdState == 1) {
                Log.w((String)ImaAdsLoader.TAG, (String)"Unexpected playAd without stopAd");
            }
            try {
                if (ImaAdsLoader.this.imaAdState == 0) {
                    int i;
                    ImaAdsLoader.this.fakeContentProgressElapsedRealtimeMs = -9223372036854775807L;
                    ImaAdsLoader.this.fakeContentProgressOffsetMs = -9223372036854775807L;
                    ImaAdsLoader.this.imaAdState = 1;
                    ImaAdsLoader.this.imaAdMediaInfo = adMediaInfo;
                    ImaAdsLoader.this.imaAdInfo = (AdInfo)Assertions.checkNotNull(ImaAdsLoader.this.adInfoByAdMediaInfo.get(adMediaInfo));
                    for (i = 0; i < ImaAdsLoader.this.adCallbacks.size(); ++i) {
                        ((VideoAdPlayer.VideoAdPlayerCallback)ImaAdsLoader.this.adCallbacks.get(i)).onPlay(adMediaInfo);
                    }
                    if (ImaAdsLoader.this.pendingAdPrepareErrorAdInfo != null && ImaAdsLoader.this.pendingAdPrepareErrorAdInfo.equals(ImaAdsLoader.this.imaAdInfo)) {
                        ImaAdsLoader.this.pendingAdPrepareErrorAdInfo = null;
                        for (i = 0; i < ImaAdsLoader.this.adCallbacks.size(); ++i) {
                            ((VideoAdPlayer.VideoAdPlayerCallback)ImaAdsLoader.this.adCallbacks.get(i)).onError(adMediaInfo);
                        }
                    }
                    ImaAdsLoader.this.updateAdProgress();
                } else {
                    ImaAdsLoader.this.imaAdState = 1;
                    Assertions.checkState((boolean)adMediaInfo.equals(ImaAdsLoader.this.imaAdMediaInfo));
                    for (int i = 0; i < ImaAdsLoader.this.adCallbacks.size(); ++i) {
                        ((VideoAdPlayer.VideoAdPlayerCallback)ImaAdsLoader.this.adCallbacks.get(i)).onResume(adMediaInfo);
                    }
                }
                if (!((Player)Assertions.checkNotNull((Object)ImaAdsLoader.this.player)).getPlayWhenReady()) {
                    ((AdsManager)Assertions.checkNotNull((Object)ImaAdsLoader.this.adsManager)).pause();
                }
            }
            catch (RuntimeException e) {
                ImaAdsLoader.this.maybeNotifyInternalError("playAd", e);
            }
        }

        public void stopAd(AdMediaInfo adMediaInfo) {
            if (ImaAdsLoader.this.adsManager == null) {
                return;
            }
            if (ImaAdsLoader.this.imaAdState == 0) {
                AdInfo adInfo = (AdInfo)ImaAdsLoader.this.adInfoByAdMediaInfo.get(adMediaInfo);
                if (adInfo != null) {
                    ImaAdsLoader.this.adPlaybackState = ImaAdsLoader.this.adPlaybackState.withSkippedAd(adInfo.adGroupIndex, adInfo.adIndexInAdGroup);
                    ImaAdsLoader.this.updateAdPlaybackState();
                }
                return;
            }
            try {
                Assertions.checkNotNull((Object)ImaAdsLoader.this.player);
                ImaAdsLoader.this.stopAdInternal();
            }
            catch (RuntimeException e) {
                ImaAdsLoader.this.maybeNotifyInternalError("stopAd", e);
            }
        }

        public void pauseAd(AdMediaInfo adMediaInfo) {
            if (ImaAdsLoader.this.adsManager == null) {
                return;
            }
            if (ImaAdsLoader.this.imaAdState == 0) {
                return;
            }
            try {
                Assertions.checkState((boolean)adMediaInfo.equals(ImaAdsLoader.this.imaAdMediaInfo));
                ImaAdsLoader.this.imaAdState = 2;
                for (int i = 0; i < ImaAdsLoader.this.adCallbacks.size(); ++i) {
                    ((VideoAdPlayer.VideoAdPlayerCallback)ImaAdsLoader.this.adCallbacks.get(i)).onPause(adMediaInfo);
                }
            }
            catch (RuntimeException e) {
                ImaAdsLoader.this.maybeNotifyInternalError("pauseAd", e);
            }
        }

        public void release() {
        }
    }

    @VisibleForTesting
    static interface ImaFactory {
        public ImaSdkSettings createImaSdkSettings();

        public AdsRenderingSettings createAdsRenderingSettings();

        public AdDisplayContainer createAdDisplayContainer();

        public AdsRequest createAdsRequest();

        public com.google.ads.interactivemedia.v3.api.AdsLoader createAdsLoader(Context var1, ImaSdkSettings var2, AdDisplayContainer var3);
    }

    public static final class Builder {
        public static final long DEFAULT_AD_PRELOAD_TIMEOUT_MS = 10000L;
        private final Context context;
        @Nullable
        private ImaSdkSettings imaSdkSettings;
        @Nullable
        private AdEvent.AdEventListener adEventListener;
        @Nullable
        private Set<UiElement> adUiElements;
        private long adPreloadTimeoutMs;
        private int vastLoadTimeoutMs;
        private int mediaLoadTimeoutMs;
        private int mediaBitrate;
        private boolean focusSkipButtonWhenAvailable;
        private boolean playAdBeforeStartPosition;
        private ImaFactory imaFactory;

        public Builder(Context context) {
            this.context = (Context)Assertions.checkNotNull((Object)context);
            this.adPreloadTimeoutMs = 10000L;
            this.vastLoadTimeoutMs = -1;
            this.mediaLoadTimeoutMs = -1;
            this.mediaBitrate = -1;
            this.focusSkipButtonWhenAvailable = true;
            this.playAdBeforeStartPosition = true;
            this.imaFactory = new DefaultImaFactory();
        }

        public Builder setImaSdkSettings(ImaSdkSettings imaSdkSettings) {
            this.imaSdkSettings = (ImaSdkSettings)Assertions.checkNotNull((Object)imaSdkSettings);
            return this;
        }

        public Builder setAdEventListener(AdEvent.AdEventListener adEventListener) {
            this.adEventListener = (AdEvent.AdEventListener)Assertions.checkNotNull((Object)adEventListener);
            return this;
        }

        public Builder setAdUiElements(Set<UiElement> adUiElements) {
            this.adUiElements = new HashSet<UiElement>((Collection)Assertions.checkNotNull(adUiElements));
            return this;
        }

        public Builder setAdPreloadTimeoutMs(long adPreloadTimeoutMs) {
            Assertions.checkArgument((adPreloadTimeoutMs == -9223372036854775807L || adPreloadTimeoutMs > 0L ? 1 : 0) != 0);
            this.adPreloadTimeoutMs = adPreloadTimeoutMs;
            return this;
        }

        public Builder setVastLoadTimeoutMs(int vastLoadTimeoutMs) {
            Assertions.checkArgument((vastLoadTimeoutMs > 0 ? 1 : 0) != 0);
            this.vastLoadTimeoutMs = vastLoadTimeoutMs;
            return this;
        }

        public Builder setMediaLoadTimeoutMs(int mediaLoadTimeoutMs) {
            Assertions.checkArgument((mediaLoadTimeoutMs > 0 ? 1 : 0) != 0);
            this.mediaLoadTimeoutMs = mediaLoadTimeoutMs;
            return this;
        }

        public Builder setMaxMediaBitrate(int bitrate) {
            Assertions.checkArgument((bitrate > 0 ? 1 : 0) != 0);
            this.mediaBitrate = bitrate;
            return this;
        }

        public Builder setFocusSkipButtonWhenAvailable(boolean focusSkipButtonWhenAvailable) {
            this.focusSkipButtonWhenAvailable = focusSkipButtonWhenAvailable;
            return this;
        }

        public Builder setPlayAdBeforeStartPosition(boolean playAdBeforeStartPosition) {
            this.playAdBeforeStartPosition = playAdBeforeStartPosition;
            return this;
        }

        @VisibleForTesting
        Builder setImaFactory(ImaFactory imaFactory) {
            this.imaFactory = (ImaFactory)Assertions.checkNotNull((Object)imaFactory);
            return this;
        }

        public ImaAdsLoader buildForAdTag(Uri adTagUri) {
            return new ImaAdsLoader(this.context, adTagUri, this.imaSdkSettings, null, this.adPreloadTimeoutMs, this.vastLoadTimeoutMs, this.mediaLoadTimeoutMs, this.mediaBitrate, this.focusSkipButtonWhenAvailable, this.playAdBeforeStartPosition, this.adUiElements, this.adEventListener, this.imaFactory);
        }

        public ImaAdsLoader buildForAdsResponse(String adsResponse) {
            return new ImaAdsLoader(this.context, null, this.imaSdkSettings, adsResponse, this.adPreloadTimeoutMs, this.vastLoadTimeoutMs, this.mediaLoadTimeoutMs, this.mediaBitrate, this.focusSkipButtonWhenAvailable, this.playAdBeforeStartPosition, this.adUiElements, this.adEventListener, this.imaFactory);
        }
    }
}

