/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ext.ima;

import android.content.Context;
import android.net.Uri;
import android.os.Looper;
import android.os.SystemClock;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.ads.interactivemedia.v3.api.Ad;
import com.google.ads.interactivemedia.v3.api.AdDisplayContainer;
import com.google.ads.interactivemedia.v3.api.AdError;
import com.google.ads.interactivemedia.v3.api.AdErrorEvent;
import com.google.ads.interactivemedia.v3.api.AdEvent;
import com.google.ads.interactivemedia.v3.api.AdPodInfo;
import com.google.ads.interactivemedia.v3.api.AdsLoader;
import com.google.ads.interactivemedia.v3.api.AdsManager;
import com.google.ads.interactivemedia.v3.api.AdsManagerLoadedEvent;
import com.google.ads.interactivemedia.v3.api.AdsRenderingSettings;
import com.google.ads.interactivemedia.v3.api.AdsRequest;
import com.google.ads.interactivemedia.v3.api.CompanionAdSlot;
import com.google.ads.interactivemedia.v3.api.ImaSdkFactory;
import com.google.ads.interactivemedia.v3.api.ImaSdkSettings;
import com.google.ads.interactivemedia.v3.api.UiElement;
import com.google.ads.interactivemedia.v3.api.player.ContentProgressProvider;
import com.google.ads.interactivemedia.v3.api.player.VideoAdPlayer;
import com.google.ads.interactivemedia.v3.api.player.VideoProgressUpdate;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.ExoPlayerLibraryInfo;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.source.ads.AdPlaybackState;
import com.google.android.exoplayer2.source.ads.AdsLoader;
import com.google.android.exoplayer2.source.ads.AdsMediaSource;
import com.google.android.exoplayer2.trackselection.TrackSelectionArray;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ImaAdsLoader
implements Player.EventListener,
AdsLoader,
VideoAdPlayer,
ContentProgressProvider,
AdErrorEvent.AdErrorListener,
AdsLoader.AdsLoadedListener,
AdEvent.AdEventListener {
    private static final boolean DEBUG = false;
    private static final String TAG = "ImaAdsLoader";
    private static final boolean ENABLE_PRELOADING = true;
    private static final String IMA_SDK_SETTINGS_PLAYER_TYPE = "google/exo.ext.ima";
    private static final String IMA_SDK_SETTINGS_PLAYER_VERSION = "2.11.1";
    private static final long IMA_DURATION_UNSET = -1L;
    private static final long END_OF_CONTENT_POSITION_THRESHOLD_MS = 5000L;
    private static final long MAXIMUM_PRELOAD_DURATION_MS = 8000L;
    private static final int TIMEOUT_UNSET = -1;
    private static final int BITRATE_UNSET = -1;
    private static final int IMA_AD_STATE_NONE = 0;
    private static final int IMA_AD_STATE_PLAYING = 1;
    private static final int IMA_AD_STATE_PAUSED = 2;
    @Nullable
    private final Uri adTagUri;
    @Nullable
    private final String adsResponse;
    private final int vastLoadTimeoutMs;
    private final int mediaLoadTimeoutMs;
    private final boolean focusSkipButtonWhenAvailable;
    private final int mediaBitrate;
    @Nullable
    private final Set<UiElement> adUiElements;
    @Nullable
    private final AdEvent.AdEventListener adEventListener;
    private final ImaFactory imaFactory;
    private final Timeline.Period period;
    private final List<VideoAdPlayer.VideoAdPlayerCallback> adCallbacks;
    private final AdDisplayContainer adDisplayContainer;
    private final com.google.ads.interactivemedia.v3.api.AdsLoader adsLoader;
    private boolean wasSetPlayerCalled;
    @Nullable
    private Player nextPlayer;
    private Object pendingAdRequestContext;
    private List<String> supportedMimeTypes;
    @Nullable
    private AdsLoader.EventListener eventListener;
    @Nullable
    private Player player;
    private VideoProgressUpdate lastContentProgress;
    private VideoProgressUpdate lastAdProgress;
    private int lastVolumePercentage;
    private AdsManager adsManager;
    private boolean initializedAdsManager;
    private AdsMediaSource.AdLoadException pendingAdLoadError;
    private Timeline timeline;
    private long contentDurationMs;
    private int podIndexOffset;
    private AdPlaybackState adPlaybackState;
    private int expectedAdGroupIndex;
    private int adGroupIndex;
    private boolean imaPausedContent;
    private int imaAdState;
    private boolean sentContentComplete;
    private boolean playingAd;
    private int playingAdIndexInAdGroup;
    private boolean shouldNotifyAdPrepareError;
    private long fakeContentProgressElapsedRealtimeMs;
    private long fakeContentProgressOffsetMs;
    private long pendingContentPositionMs;
    private boolean sentPendingContentPositionMs;

    public ImaAdsLoader(Context context, Uri adTagUri) {
        this(context, adTagUri, null, null, -1, -1, -1, true, null, null, new DefaultImaFactory());
    }

    @Deprecated
    public ImaAdsLoader(Context context, Uri adTagUri, @Nullable ImaSdkSettings imaSdkSettings) {
        this(context, adTagUri, imaSdkSettings, null, -1, -1, -1, true, null, null, new DefaultImaFactory());
    }

    private ImaAdsLoader(Context context, @Nullable Uri adTagUri, @Nullable ImaSdkSettings imaSdkSettings, @Nullable String adsResponse, int vastLoadTimeoutMs, int mediaLoadTimeoutMs, int mediaBitrate, boolean focusSkipButtonWhenAvailable, @Nullable Set<UiElement> adUiElements, @Nullable AdEvent.AdEventListener adEventListener, ImaFactory imaFactory) {
        Assertions.checkArgument((adTagUri != null || adsResponse != null ? 1 : 0) != 0);
        this.adTagUri = adTagUri;
        this.adsResponse = adsResponse;
        this.vastLoadTimeoutMs = vastLoadTimeoutMs;
        this.mediaLoadTimeoutMs = mediaLoadTimeoutMs;
        this.mediaBitrate = mediaBitrate;
        this.focusSkipButtonWhenAvailable = focusSkipButtonWhenAvailable;
        this.adUiElements = adUiElements;
        this.adEventListener = adEventListener;
        this.imaFactory = imaFactory;
        if (imaSdkSettings == null) {
            imaSdkSettings = imaFactory.createImaSdkSettings();
        }
        imaSdkSettings.setPlayerType(IMA_SDK_SETTINGS_PLAYER_TYPE);
        imaSdkSettings.setPlayerVersion(IMA_SDK_SETTINGS_PLAYER_VERSION);
        this.period = new Timeline.Period();
        this.adCallbacks = new ArrayList<VideoAdPlayer.VideoAdPlayerCallback>(1);
        this.adDisplayContainer = imaFactory.createAdDisplayContainer();
        this.adDisplayContainer.setPlayer((VideoAdPlayer)this);
        this.adsLoader = imaFactory.createAdsLoader(context, imaSdkSettings, this.adDisplayContainer);
        this.adsLoader.addAdErrorListener((AdErrorEvent.AdErrorListener)this);
        this.adsLoader.addAdsLoadedListener((AdsLoader.AdsLoadedListener)this);
        this.fakeContentProgressElapsedRealtimeMs = -9223372036854775807L;
        this.fakeContentProgressOffsetMs = -9223372036854775807L;
        this.pendingContentPositionMs = -9223372036854775807L;
        this.adGroupIndex = -1;
        this.contentDurationMs = -9223372036854775807L;
        this.timeline = Timeline.EMPTY;
    }

    public com.google.ads.interactivemedia.v3.api.AdsLoader getAdsLoader() {
        return this.adsLoader;
    }

    public AdDisplayContainer getAdDisplayContainer() {
        return this.adDisplayContainer;
    }

    @Deprecated
    public void setCompanionSlots(Collection<CompanionAdSlot> companionSlots) {
        this.adDisplayContainer.setCompanionSlots(companionSlots);
    }

    public void requestAds(ViewGroup adViewGroup) {
        if (this.adPlaybackState != null || this.adsManager != null || this.pendingAdRequestContext != null) {
            return;
        }
        this.adDisplayContainer.setAdContainer(adViewGroup);
        this.pendingAdRequestContext = new Object();
        AdsRequest request = this.imaFactory.createAdsRequest();
        if (this.adTagUri != null) {
            request.setAdTagUrl(this.adTagUri.toString());
        } else {
            request.setAdsResponse(this.adsResponse);
        }
        if (this.vastLoadTimeoutMs != -1) {
            request.setVastLoadTimeout((float)this.vastLoadTimeoutMs);
        }
        request.setContentProgressProvider((ContentProgressProvider)this);
        request.setUserRequestContext(this.pendingAdRequestContext);
        this.adsLoader.requestAds(request);
    }

    public void setPlayer(@Nullable Player player) {
        Assertions.checkState((Looper.getMainLooper() == Looper.myLooper() ? 1 : 0) != 0);
        Assertions.checkState((player == null || player.getApplicationLooper() == Looper.getMainLooper() ? 1 : 0) != 0);
        this.nextPlayer = player;
        this.wasSetPlayerCalled = true;
    }

    public void setSupportedContentTypes(int ... contentTypes) {
        ArrayList<String> supportedMimeTypes = new ArrayList<String>();
        for (int contentType : contentTypes) {
            if (contentType == 0) {
                supportedMimeTypes.add("application/dash+xml");
                continue;
            }
            if (contentType == 2) {
                supportedMimeTypes.add("application/x-mpegURL");
                continue;
            }
            if (contentType == 3) {
                supportedMimeTypes.addAll(Arrays.asList("video/mp4", "video/webm", "video/3gpp", "audio/mp4", "audio/mpeg"));
                continue;
            }
            if (contentType != 1) continue;
        }
        this.supportedMimeTypes = Collections.unmodifiableList(supportedMimeTypes);
    }

    public void start(AdsLoader.EventListener eventListener, AdsLoader.AdViewProvider adViewProvider) {
        View[] adOverlayViews;
        Assertions.checkState((boolean)this.wasSetPlayerCalled, (Object)"Set player using adsLoader.setPlayer before preparing the player.");
        this.player = this.nextPlayer;
        if (this.player == null) {
            return;
        }
        this.eventListener = eventListener;
        this.lastVolumePercentage = 0;
        this.lastAdProgress = null;
        this.lastContentProgress = null;
        ViewGroup adViewGroup = adViewProvider.getAdViewGroup();
        this.adDisplayContainer.setAdContainer(adViewGroup);
        for (View view : adOverlayViews = adViewProvider.getAdOverlayViews()) {
            this.adDisplayContainer.registerVideoControlsOverlay(view);
        }
        this.player.addListener((Player.EventListener)this);
        this.maybeNotifyPendingAdLoadError();
        if (this.adPlaybackState != null) {
            eventListener.onAdPlaybackState(this.adPlaybackState);
            if (this.imaPausedContent && this.player.getPlayWhenReady()) {
                this.adsManager.resume();
            }
        } else if (this.adsManager != null) {
            this.adPlaybackState = new AdPlaybackState(ImaAdsLoader.getAdGroupTimesUs(this.adsManager.getAdCuePoints()));
            this.updateAdPlaybackState();
        } else {
            this.requestAds(adViewGroup);
        }
    }

    public void stop() {
        if (this.player == null) {
            return;
        }
        if (this.adsManager != null && this.imaPausedContent) {
            this.adPlaybackState = this.adPlaybackState.withAdResumePositionUs(this.playingAd ? C.msToUs((long)this.player.getCurrentPosition()) : 0L);
            this.adsManager.pause();
        }
        this.lastVolumePercentage = this.getVolume();
        this.lastAdProgress = this.getAdProgress();
        this.lastContentProgress = this.getContentProgress();
        this.adDisplayContainer.unregisterAllVideoControlsOverlays();
        this.player.removeListener((Player.EventListener)this);
        this.player = null;
        this.eventListener = null;
    }

    public void release() {
        this.pendingAdRequestContext = null;
        if (this.adsManager != null) {
            this.adsManager.removeAdErrorListener((AdErrorEvent.AdErrorListener)this);
            this.adsManager.removeAdEventListener((AdEvent.AdEventListener)this);
            if (this.adEventListener != null) {
                this.adsManager.removeAdEventListener(this.adEventListener);
            }
            this.adsManager.destroy();
            this.adsManager = null;
        }
        this.adsLoader.removeAdsLoadedListener((AdsLoader.AdsLoadedListener)this);
        this.adsLoader.removeAdErrorListener((AdErrorEvent.AdErrorListener)this);
        this.imaPausedContent = false;
        this.imaAdState = 0;
        this.pendingAdLoadError = null;
        this.adPlaybackState = AdPlaybackState.NONE;
        this.updateAdPlaybackState();
    }

    public void handlePrepareError(int adGroupIndex, int adIndexInAdGroup, IOException exception) {
        if (this.player == null) {
            return;
        }
        try {
            this.handleAdPrepareError(adGroupIndex, adIndexInAdGroup, exception);
        }
        catch (Exception e) {
            this.maybeNotifyInternalError("handlePrepareError", e);
        }
    }

    public void onAdsManagerLoaded(AdsManagerLoadedEvent adsManagerLoadedEvent) {
        AdsManager adsManager = adsManagerLoadedEvent.getAdsManager();
        if (!Util.areEqual((Object)this.pendingAdRequestContext, (Object)adsManagerLoadedEvent.getUserRequestContext())) {
            adsManager.destroy();
            return;
        }
        this.pendingAdRequestContext = null;
        this.adsManager = adsManager;
        adsManager.addAdErrorListener((AdErrorEvent.AdErrorListener)this);
        adsManager.addAdEventListener((AdEvent.AdEventListener)this);
        if (this.adEventListener != null) {
            adsManager.addAdEventListener(this.adEventListener);
        }
        if (this.player != null) {
            try {
                this.adPlaybackState = new AdPlaybackState(ImaAdsLoader.getAdGroupTimesUs(adsManager.getAdCuePoints()));
                this.updateAdPlaybackState();
            }
            catch (Exception e) {
                this.maybeNotifyInternalError("onAdsManagerLoaded", e);
            }
        }
    }

    public void onAdEvent(AdEvent adEvent) {
        AdEvent.AdEventType adEventType = adEvent.getType();
        if (this.adsManager == null) {
            Log.w((String)TAG, (String)("Ignoring AdEvent after release: " + adEvent));
            return;
        }
        try {
            this.handleAdEvent(adEvent);
        }
        catch (Exception e) {
            this.maybeNotifyInternalError("onAdEvent", e);
        }
    }

    public void onAdError(AdErrorEvent adErrorEvent) {
        AdError error = adErrorEvent.getError();
        if (this.adsManager == null) {
            this.pendingAdRequestContext = null;
            this.adPlaybackState = new AdPlaybackState(new long[0]);
            this.updateAdPlaybackState();
        } else if (ImaAdsLoader.isAdGroupLoadError(error)) {
            try {
                this.handleAdGroupLoadError((Exception)error);
            }
            catch (Exception e) {
                this.maybeNotifyInternalError("onAdError", e);
            }
        }
        if (this.pendingAdLoadError == null) {
            this.pendingAdLoadError = AdsMediaSource.AdLoadException.createForAllAds((Exception)error);
        }
        this.maybeNotifyPendingAdLoadError();
    }

    public VideoProgressUpdate getContentProgress() {
        long contentPositionMs;
        boolean hasContentDuration;
        if (this.player == null) {
            return this.lastContentProgress;
        }
        boolean bl = hasContentDuration = this.contentDurationMs != -9223372036854775807L;
        if (this.pendingContentPositionMs != -9223372036854775807L) {
            this.sentPendingContentPositionMs = true;
            contentPositionMs = this.pendingContentPositionMs;
            this.expectedAdGroupIndex = this.adPlaybackState.getAdGroupIndexForPositionUs(C.msToUs((long)contentPositionMs));
        } else if (this.fakeContentProgressElapsedRealtimeMs != -9223372036854775807L) {
            long elapsedSinceEndMs = SystemClock.elapsedRealtime() - this.fakeContentProgressElapsedRealtimeMs;
            contentPositionMs = this.fakeContentProgressOffsetMs + elapsedSinceEndMs;
            this.expectedAdGroupIndex = this.adPlaybackState.getAdGroupIndexForPositionUs(C.msToUs((long)contentPositionMs));
        } else if (this.imaAdState == 0 && !this.playingAd && hasContentDuration) {
            contentPositionMs = this.player.getCurrentPosition();
            int nextAdGroupIndex = this.adPlaybackState.getAdGroupIndexAfterPositionUs(C.msToUs((long)contentPositionMs), C.msToUs((long)this.contentDurationMs));
            if (nextAdGroupIndex != this.expectedAdGroupIndex && nextAdGroupIndex != -1) {
                long nextAdGroupTimeMs = C.usToMs((long)this.adPlaybackState.adGroupTimesUs[nextAdGroupIndex]);
                if (nextAdGroupTimeMs == Long.MIN_VALUE) {
                    nextAdGroupTimeMs = this.contentDurationMs;
                }
                if (nextAdGroupTimeMs - contentPositionMs < 8000L) {
                    this.expectedAdGroupIndex = nextAdGroupIndex;
                }
            }
        } else {
            return VideoProgressUpdate.VIDEO_TIME_NOT_READY;
        }
        long contentDurationMs = hasContentDuration ? this.contentDurationMs : -1L;
        return new VideoProgressUpdate(contentPositionMs, contentDurationMs);
    }

    public VideoProgressUpdate getAdProgress() {
        if (this.player == null) {
            return this.lastAdProgress;
        }
        if (this.imaAdState != 0 && this.playingAd) {
            long adDuration = this.player.getDuration();
            return adDuration == -9223372036854775807L ? VideoProgressUpdate.VIDEO_TIME_NOT_READY : new VideoProgressUpdate(this.player.getCurrentPosition(), adDuration);
        }
        return VideoProgressUpdate.VIDEO_TIME_NOT_READY;
    }

    public int getVolume() {
        if (this.player == null) {
            return this.lastVolumePercentage;
        }
        Player.AudioComponent audioComponent = this.player.getAudioComponent();
        if (audioComponent != null) {
            return (int)(audioComponent.getVolume() * 100.0f);
        }
        TrackSelectionArray trackSelections = this.player.getCurrentTrackSelections();
        for (int i = 0; i < this.player.getRendererCount() && i < trackSelections.length; ++i) {
            if (this.player.getRendererType(i) != 1 || trackSelections.get(i) == null) continue;
            return 100;
        }
        return 0;
    }

    public void loadAd(String adUriString) {
        try {
            int adIndexInAdGroup;
            if (this.adsManager == null) {
                Log.w((String)TAG, (String)"Ignoring loadAd after release");
                return;
            }
            if (this.adGroupIndex == -1) {
                Log.w((String)TAG, (String)("Unexpected loadAd without LOADED event; assuming ad group index is actually " + this.expectedAdGroupIndex));
                this.adGroupIndex = this.expectedAdGroupIndex;
                this.adsManager.start();
            }
            if ((adIndexInAdGroup = this.getAdIndexInAdGroupToLoad(this.adGroupIndex)) == -1) {
                Log.w((String)TAG, (String)"Unexpected loadAd in an ad group with no remaining unavailable ads");
                return;
            }
            this.adPlaybackState = this.adPlaybackState.withAdUri(this.adGroupIndex, adIndexInAdGroup, Uri.parse((String)adUriString));
            this.updateAdPlaybackState();
        }
        catch (Exception e) {
            this.maybeNotifyInternalError("loadAd", e);
        }
    }

    public void addCallback(VideoAdPlayer.VideoAdPlayerCallback videoAdPlayerCallback) {
        this.adCallbacks.add(videoAdPlayerCallback);
    }

    public void removeCallback(VideoAdPlayer.VideoAdPlayerCallback videoAdPlayerCallback) {
        this.adCallbacks.remove(videoAdPlayerCallback);
    }

    public void playAd() {
        if (this.adsManager == null) {
            Log.w((String)TAG, (String)"Ignoring playAd after release");
            return;
        }
        switch (this.imaAdState) {
            case 1: {
                Log.w((String)TAG, (String)"Unexpected playAd without stopAd");
                break;
            }
            case 0: {
                int i;
                this.fakeContentProgressElapsedRealtimeMs = -9223372036854775807L;
                this.fakeContentProgressOffsetMs = -9223372036854775807L;
                this.imaAdState = 1;
                for (i = 0; i < this.adCallbacks.size(); ++i) {
                    this.adCallbacks.get(i).onPlay();
                }
                if (!this.shouldNotifyAdPrepareError) break;
                this.shouldNotifyAdPrepareError = false;
                for (i = 0; i < this.adCallbacks.size(); ++i) {
                    this.adCallbacks.get(i).onError();
                }
                break;
            }
            case 2: {
                this.imaAdState = 1;
                for (int i = 0; i < this.adCallbacks.size(); ++i) {
                    this.adCallbacks.get(i).onResume();
                }
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (this.player == null) {
            Log.w((String)TAG, (String)"Unexpected playAd while detached");
        } else if (!this.player.getPlayWhenReady()) {
            this.adsManager.pause();
        }
    }

    public void stopAd() {
        if (this.adsManager == null) {
            Log.w((String)TAG, (String)"Ignoring stopAd after release");
            return;
        }
        if (this.player == null) {
            Log.w((String)TAG, (String)"Unexpected stopAd while detached");
        }
        if (this.imaAdState == 0) {
            Log.w((String)TAG, (String)"Unexpected stopAd");
            return;
        }
        try {
            this.stopAdInternal();
        }
        catch (Exception e) {
            this.maybeNotifyInternalError("stopAd", e);
        }
    }

    public void pauseAd() {
        if (this.imaAdState == 0) {
            return;
        }
        this.imaAdState = 2;
        for (int i = 0; i < this.adCallbacks.size(); ++i) {
            this.adCallbacks.get(i).onPause();
        }
    }

    public void resumeAd() {
        this.maybeNotifyInternalError("resumeAd", new IllegalStateException("Unexpected call to resumeAd"));
    }

    public void onTimelineChanged(Timeline timeline, int reason) {
        if (timeline.isEmpty()) {
            return;
        }
        Assertions.checkArgument((timeline.getPeriodCount() == 1 ? 1 : 0) != 0);
        this.timeline = timeline;
        long contentDurationUs = timeline.getPeriod((int)0, (Timeline.Period)this.period).durationUs;
        this.contentDurationMs = C.usToMs((long)contentDurationUs);
        if (contentDurationUs != -9223372036854775807L) {
            this.adPlaybackState = this.adPlaybackState.withContentDurationUs(contentDurationUs);
        }
        if (!this.initializedAdsManager && this.adsManager != null) {
            this.initializedAdsManager = true;
            this.initializeAdsManager();
        }
        this.onPositionDiscontinuity(4);
    }

    public void onPlayerStateChanged(boolean playWhenReady, int playbackState) {
        if (this.adsManager == null) {
            return;
        }
        if (this.imaAdState == 1 && !playWhenReady) {
            this.adsManager.pause();
            return;
        }
        if (this.imaAdState == 2 && playWhenReady) {
            this.adsManager.resume();
            return;
        }
        if (this.imaAdState == 0 && playbackState == 2 && playWhenReady) {
            this.checkForContentComplete();
        } else if (this.imaAdState != 0 && playbackState == 4) {
            for (int i = 0; i < this.adCallbacks.size(); ++i) {
                this.adCallbacks.get(i).onEnded();
            }
        }
    }

    public void onPlayerError(ExoPlaybackException error) {
        if (this.imaAdState != 0) {
            for (int i = 0; i < this.adCallbacks.size(); ++i) {
                this.adCallbacks.get(i).onError();
            }
        }
    }

    public void onPositionDiscontinuity(int reason) {
        if (this.adsManager == null) {
            return;
        }
        if (!this.playingAd && !this.player.isPlayingAd()) {
            this.checkForContentComplete();
            if (this.sentContentComplete) {
                for (int i = 0; i < this.adPlaybackState.adGroupCount; ++i) {
                    if (this.adPlaybackState.adGroupTimesUs[i] == Long.MIN_VALUE) continue;
                    this.adPlaybackState = this.adPlaybackState.withSkippedAdGroup(i);
                }
                this.updateAdPlaybackState();
            } else if (!this.timeline.isEmpty()) {
                long positionMs = this.player.getCurrentPosition();
                this.timeline.getPeriod(0, this.period);
                int newAdGroupIndex = this.period.getAdGroupIndexForPositionUs(C.msToUs((long)positionMs));
                if (newAdGroupIndex != -1) {
                    this.sentPendingContentPositionMs = false;
                    this.pendingContentPositionMs = positionMs;
                    if (newAdGroupIndex != this.adGroupIndex) {
                        this.shouldNotifyAdPrepareError = false;
                    }
                }
            }
        }
        this.updateImaStateForPlayerState();
    }

    private void initializeAdsManager() {
        AdsRenderingSettings adsRenderingSettings = this.imaFactory.createAdsRenderingSettings();
        adsRenderingSettings.setEnablePreloading(true);
        adsRenderingSettings.setMimeTypes(this.supportedMimeTypes);
        if (this.mediaLoadTimeoutMs != -1) {
            adsRenderingSettings.setLoadVideoTimeout(this.mediaLoadTimeoutMs);
        }
        if (this.mediaBitrate != -1) {
            adsRenderingSettings.setBitrateKbps(this.mediaBitrate / 1000);
        }
        adsRenderingSettings.setFocusSkipButtonWhenAvailable(this.focusSkipButtonWhenAvailable);
        if (this.adUiElements != null) {
            adsRenderingSettings.setUiElements(this.adUiElements);
        }
        long[] adGroupTimesUs = ImaAdsLoader.getAdGroupTimesUs(this.adsManager.getAdCuePoints());
        long contentPositionMs = this.player.getContentPosition();
        int adGroupIndexForPosition = this.adPlaybackState.getAdGroupIndexForPositionUs(C.msToUs((long)contentPositionMs));
        if (adGroupIndexForPosition > 0 && adGroupIndexForPosition != -1) {
            for (int i = 0; i < adGroupIndexForPosition; ++i) {
                this.adPlaybackState = this.adPlaybackState.withSkippedAdGroup(i);
            }
            long adGroupForPositionTimeUs = adGroupTimesUs[adGroupIndexForPosition];
            long adGroupBeforeTimeUs = adGroupTimesUs[adGroupIndexForPosition - 1];
            double midpointTimeUs = (double)(adGroupForPositionTimeUs + adGroupBeforeTimeUs) / 2.0;
            adsRenderingSettings.setPlayAdsAfterTime(midpointTimeUs / 1000000.0);
        }
        this.podIndexOffset = adGroupIndexForPosition == 0 && adGroupTimesUs[0] == 0L ? 0 : (adGroupIndexForPosition == -1 ? -1 : adGroupIndexForPosition - 1);
        if (adGroupIndexForPosition != -1 && ImaAdsLoader.hasMidrollAdGroups(adGroupTimesUs)) {
            this.pendingContentPositionMs = contentPositionMs;
        }
        this.adsManager.init(adsRenderingSettings);
        this.updateAdPlaybackState();
    }

    private void handleAdEvent(AdEvent adEvent) {
        Ad ad = adEvent.getAd();
        switch (adEvent.getType()) {
            case LOADED: {
                AdPodInfo adPodInfo = ad.getAdPodInfo();
                int podIndex = adPodInfo.getPodIndex();
                this.adGroupIndex = podIndex == -1 ? this.adPlaybackState.adGroupCount - 1 : podIndex + this.podIndexOffset;
                int adPosition = adPodInfo.getAdPosition();
                int adCount = adPodInfo.getTotalAds();
                this.adsManager.start();
                int oldAdCount = this.adPlaybackState.adGroups[this.adGroupIndex].count;
                if (adCount != oldAdCount) {
                    if (oldAdCount == -1) {
                        this.adPlaybackState = this.adPlaybackState.withAdCount(this.adGroupIndex, adCount);
                        this.updateAdPlaybackState();
                    } else {
                        Log.w((String)TAG, (String)("Unexpected ad count in LOADED, " + adCount + ", expected " + oldAdCount));
                    }
                }
                if (this.adGroupIndex == this.expectedAdGroupIndex) break;
                Log.w((String)TAG, (String)("Expected ad group index " + this.expectedAdGroupIndex + ", actual ad group index " + this.adGroupIndex));
                this.expectedAdGroupIndex = this.adGroupIndex;
                break;
            }
            case CONTENT_PAUSE_REQUESTED: {
                this.imaPausedContent = true;
                this.pauseContentInternal();
                break;
            }
            case TAPPED: {
                if (this.eventListener == null) break;
                this.eventListener.onAdTapped();
                break;
            }
            case CLICKED: {
                if (this.eventListener == null) break;
                this.eventListener.onAdClicked();
                break;
            }
            case CONTENT_RESUME_REQUESTED: {
                this.imaPausedContent = false;
                this.resumeContentInternal();
                break;
            }
            case LOG: {
                Map adData = adEvent.getAdData();
                String message = "AdEvent: " + adData;
                Log.i((String)TAG, (String)message);
                if (!"adLoadError".equals(adData.get("type"))) break;
                this.handleAdGroupLoadError(new IOException(message));
                break;
            }
        }
    }

    private void updateImaStateForPlayerState() {
        boolean adFinished;
        boolean wasPlayingAd = this.playingAd;
        int oldPlayingAdIndexInAdGroup = this.playingAdIndexInAdGroup;
        this.playingAd = this.player.isPlayingAd();
        this.playingAdIndexInAdGroup = this.playingAd ? this.player.getCurrentAdIndexInAdGroup() : -1;
        boolean bl = adFinished = wasPlayingAd && this.playingAdIndexInAdGroup != oldPlayingAdIndexInAdGroup;
        if (adFinished) {
            for (int i = 0; i < this.adCallbacks.size(); ++i) {
                this.adCallbacks.get(i).onEnded();
            }
        }
        if (!this.sentContentComplete && !wasPlayingAd && this.playingAd && this.imaAdState == 0) {
            int adGroupIndex = this.player.getCurrentAdGroupIndex();
            this.fakeContentProgressElapsedRealtimeMs = SystemClock.elapsedRealtime();
            this.fakeContentProgressOffsetMs = C.usToMs((long)this.adPlaybackState.adGroupTimesUs[adGroupIndex]);
            if (this.fakeContentProgressOffsetMs == Long.MIN_VALUE) {
                this.fakeContentProgressOffsetMs = this.contentDurationMs;
            }
        }
    }

    private void resumeContentInternal() {
        if (this.imaAdState != 0) {
            this.imaAdState = 0;
        }
        if (this.adGroupIndex != -1) {
            this.adPlaybackState = this.adPlaybackState.withSkippedAdGroup(this.adGroupIndex);
            this.adGroupIndex = -1;
            this.updateAdPlaybackState();
        }
    }

    private void pauseContentInternal() {
        this.imaAdState = 0;
        if (this.sentPendingContentPositionMs) {
            this.pendingContentPositionMs = -9223372036854775807L;
            this.sentPendingContentPositionMs = false;
        }
    }

    private void stopAdInternal() {
        this.imaAdState = 0;
        int adIndexInAdGroup = this.adPlaybackState.adGroups[this.adGroupIndex].getFirstAdIndexToPlay();
        this.adPlaybackState = this.adPlaybackState.withPlayedAd(this.adGroupIndex, adIndexInAdGroup).withAdResumePositionUs(0L);
        this.updateAdPlaybackState();
        if (!this.playingAd) {
            this.adGroupIndex = -1;
        }
    }

    private void handleAdGroupLoadError(Exception error) {
        int adGroupIndex;
        int n = adGroupIndex = this.adGroupIndex == -1 ? this.expectedAdGroupIndex : this.adGroupIndex;
        if (adGroupIndex == -1) {
            return;
        }
        AdPlaybackState.AdGroup adGroup = this.adPlaybackState.adGroups[adGroupIndex];
        if (adGroup.count == -1) {
            this.adPlaybackState = this.adPlaybackState.withAdCount(adGroupIndex, Math.max(1, adGroup.states.length));
            adGroup = this.adPlaybackState.adGroups[adGroupIndex];
        }
        for (int i = 0; i < adGroup.count; ++i) {
            if (adGroup.states[i] != 0) continue;
            this.adPlaybackState = this.adPlaybackState.withAdLoadError(adGroupIndex, i);
        }
        this.updateAdPlaybackState();
        if (this.pendingAdLoadError == null) {
            this.pendingAdLoadError = AdsMediaSource.AdLoadException.createForAdGroup((Exception)error, (int)adGroupIndex);
        }
        this.pendingContentPositionMs = -9223372036854775807L;
        this.fakeContentProgressElapsedRealtimeMs = -9223372036854775807L;
    }

    private void handleAdPrepareError(int adGroupIndex, int adIndexInAdGroup, Exception exception) {
        if (this.adsManager == null) {
            Log.w((String)TAG, (String)"Ignoring ad prepare error after release");
            return;
        }
        if (this.imaAdState == 0) {
            this.fakeContentProgressElapsedRealtimeMs = SystemClock.elapsedRealtime();
            this.fakeContentProgressOffsetMs = C.usToMs((long)this.adPlaybackState.adGroupTimesUs[adGroupIndex]);
            if (this.fakeContentProgressOffsetMs == Long.MIN_VALUE) {
                this.fakeContentProgressOffsetMs = this.contentDurationMs;
            }
            this.shouldNotifyAdPrepareError = true;
        } else {
            int i;
            if (adIndexInAdGroup > this.playingAdIndexInAdGroup) {
                for (i = 0; i < this.adCallbacks.size(); ++i) {
                    this.adCallbacks.get(i).onEnded();
                }
            }
            this.playingAdIndexInAdGroup = this.adPlaybackState.adGroups[adGroupIndex].getFirstAdIndexToPlay();
            for (i = 0; i < this.adCallbacks.size(); ++i) {
                this.adCallbacks.get(i).onError();
            }
        }
        this.adPlaybackState = this.adPlaybackState.withAdLoadError(adGroupIndex, adIndexInAdGroup);
        this.updateAdPlaybackState();
    }

    private void checkForContentComplete() {
        if (this.contentDurationMs != -9223372036854775807L && this.pendingContentPositionMs == -9223372036854775807L && this.player.getContentPosition() + 5000L >= this.contentDurationMs && !this.sentContentComplete) {
            this.adsLoader.contentComplete();
            this.sentContentComplete = true;
            this.expectedAdGroupIndex = this.adPlaybackState.getAdGroupIndexForPositionUs(C.msToUs((long)this.contentDurationMs));
        }
    }

    private void updateAdPlaybackState() {
        if (this.eventListener != null) {
            this.eventListener.onAdPlaybackState(this.adPlaybackState);
        }
    }

    private int getAdIndexInAdGroupToLoad(int adGroupIndex) {
        int adIndexInAdGroup;
        int[] states = this.adPlaybackState.adGroups[adGroupIndex].states;
        for (adIndexInAdGroup = 0; adIndexInAdGroup < states.length && states[adIndexInAdGroup] != 0; ++adIndexInAdGroup) {
        }
        return adIndexInAdGroup == states.length ? -1 : adIndexInAdGroup;
    }

    private void maybeNotifyPendingAdLoadError() {
        if (this.pendingAdLoadError != null && this.eventListener != null) {
            this.eventListener.onAdLoadError(this.pendingAdLoadError, new DataSpec(this.adTagUri));
            this.pendingAdLoadError = null;
        }
    }

    private void maybeNotifyInternalError(String name, Exception cause) {
        String message = "Internal error in " + name;
        Log.e((String)TAG, (String)message, (Throwable)cause);
        if (this.adPlaybackState == null) {
            this.adPlaybackState = AdPlaybackState.NONE;
        } else {
            for (int i = 0; i < this.adPlaybackState.adGroupCount; ++i) {
                this.adPlaybackState = this.adPlaybackState.withSkippedAdGroup(i);
            }
        }
        this.updateAdPlaybackState();
        if (this.eventListener != null) {
            this.eventListener.onAdLoadError(AdsMediaSource.AdLoadException.createForUnexpected((RuntimeException)new RuntimeException(message, cause)), new DataSpec(this.adTagUri));
        }
    }

    private static long[] getAdGroupTimesUs(List<Float> cuePoints) {
        if (cuePoints.isEmpty()) {
            return new long[]{0L};
        }
        int count = cuePoints.size();
        long[] adGroupTimesUs = new long[count];
        int adGroupIndex = 0;
        for (int i = 0; i < count; ++i) {
            double cuePoint = cuePoints.get(i).floatValue();
            if (cuePoint == -1.0) {
                adGroupTimesUs[count - 1] = Long.MIN_VALUE;
                continue;
            }
            adGroupTimesUs[adGroupIndex++] = (long)(1000000.0 * cuePoint);
        }
        Arrays.sort(adGroupTimesUs, 0, adGroupIndex);
        return adGroupTimesUs;
    }

    private static boolean isAdGroupLoadError(AdError adError) {
        return adError.getErrorCode() == AdError.AdErrorCode.VAST_LINEAR_ASSET_MISMATCH || adError.getErrorCode() == AdError.AdErrorCode.UNKNOWN_ERROR;
    }

    private static boolean hasMidrollAdGroups(long[] adGroupTimesUs) {
        int count = adGroupTimesUs.length;
        if (count == 1) {
            return adGroupTimesUs[0] != 0L && adGroupTimesUs[0] != Long.MIN_VALUE;
        }
        if (count == 2) {
            return adGroupTimesUs[0] != 0L || adGroupTimesUs[1] != Long.MIN_VALUE;
        }
        return true;
    }

    static {
        ExoPlayerLibraryInfo.registerModule((String)"goog.exo.ima");
    }

    private static final class DefaultImaFactory
    implements ImaFactory {
        private DefaultImaFactory() {
        }

        @Override
        public ImaSdkSettings createImaSdkSettings() {
            return ImaSdkFactory.getInstance().createImaSdkSettings();
        }

        @Override
        public AdsRenderingSettings createAdsRenderingSettings() {
            return ImaSdkFactory.getInstance().createAdsRenderingSettings();
        }

        @Override
        public AdDisplayContainer createAdDisplayContainer() {
            return ImaSdkFactory.getInstance().createAdDisplayContainer();
        }

        @Override
        public AdsRequest createAdsRequest() {
            return ImaSdkFactory.getInstance().createAdsRequest();
        }

        @Override
        public com.google.ads.interactivemedia.v3.api.AdsLoader createAdsLoader(Context context, ImaSdkSettings imaSdkSettings, AdDisplayContainer adDisplayContainer) {
            return ImaSdkFactory.getInstance().createAdsLoader(context, imaSdkSettings, adDisplayContainer);
        }
    }

    @VisibleForTesting
    static interface ImaFactory {
        public ImaSdkSettings createImaSdkSettings();

        public AdsRenderingSettings createAdsRenderingSettings();

        public AdDisplayContainer createAdDisplayContainer();

        public AdsRequest createAdsRequest();

        public com.google.ads.interactivemedia.v3.api.AdsLoader createAdsLoader(Context var1, ImaSdkSettings var2, AdDisplayContainer var3);
    }

    public static final class Builder {
        private final Context context;
        @Nullable
        private ImaSdkSettings imaSdkSettings;
        @Nullable
        private AdEvent.AdEventListener adEventListener;
        @Nullable
        private Set<UiElement> adUiElements;
        private int vastLoadTimeoutMs;
        private int mediaLoadTimeoutMs;
        private int mediaBitrate;
        private boolean focusSkipButtonWhenAvailable;
        private ImaFactory imaFactory;

        public Builder(Context context) {
            this.context = (Context)Assertions.checkNotNull((Object)context);
            this.vastLoadTimeoutMs = -1;
            this.mediaLoadTimeoutMs = -1;
            this.mediaBitrate = -1;
            this.focusSkipButtonWhenAvailable = true;
            this.imaFactory = new DefaultImaFactory();
        }

        public Builder setImaSdkSettings(ImaSdkSettings imaSdkSettings) {
            this.imaSdkSettings = (ImaSdkSettings)Assertions.checkNotNull((Object)imaSdkSettings);
            return this;
        }

        public Builder setAdEventListener(AdEvent.AdEventListener adEventListener) {
            this.adEventListener = (AdEvent.AdEventListener)Assertions.checkNotNull((Object)adEventListener);
            return this;
        }

        public Builder setAdUiElements(Set<UiElement> adUiElements) {
            this.adUiElements = new HashSet<UiElement>((Collection)Assertions.checkNotNull(adUiElements));
            return this;
        }

        public Builder setVastLoadTimeoutMs(int vastLoadTimeoutMs) {
            Assertions.checkArgument((vastLoadTimeoutMs > 0 ? 1 : 0) != 0);
            this.vastLoadTimeoutMs = vastLoadTimeoutMs;
            return this;
        }

        public Builder setMediaLoadTimeoutMs(int mediaLoadTimeoutMs) {
            Assertions.checkArgument((mediaLoadTimeoutMs > 0 ? 1 : 0) != 0);
            this.mediaLoadTimeoutMs = mediaLoadTimeoutMs;
            return this;
        }

        public Builder setMaxMediaBitrate(int bitrate) {
            Assertions.checkArgument((bitrate > 0 ? 1 : 0) != 0);
            this.mediaBitrate = bitrate;
            return this;
        }

        public Builder setFocusSkipButtonWhenAvailable(boolean focusSkipButtonWhenAvailable) {
            this.focusSkipButtonWhenAvailable = focusSkipButtonWhenAvailable;
            return this;
        }

        @VisibleForTesting
        Builder setImaFactory(ImaFactory imaFactory) {
            this.imaFactory = (ImaFactory)Assertions.checkNotNull((Object)imaFactory);
            return this;
        }

        public ImaAdsLoader buildForAdTag(Uri adTagUri) {
            return new ImaAdsLoader(this.context, adTagUri, this.imaSdkSettings, null, this.vastLoadTimeoutMs, this.mediaLoadTimeoutMs, this.mediaBitrate, this.focusSkipButtonWhenAvailable, this.adUiElements, this.adEventListener, this.imaFactory);
        }

        public ImaAdsLoader buildForAdsResponse(String adsResponse) {
            return new ImaAdsLoader(this.context, null, this.imaSdkSettings, adsResponse, this.vastLoadTimeoutMs, this.mediaLoadTimeoutMs, this.mediaBitrate, this.focusSkipButtonWhenAvailable, this.adUiElements, this.adEventListener, this.imaFactory);
        }
    }
}

