/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.smoothstreaming.manifest;

import android.net.Uri;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Pair;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.drm.DrmInitData;
import com.google.android.exoplayer2.extractor.mp4.PsshAtomUtil;
import com.google.android.exoplayer2.source.smoothstreaming.manifest.SsManifest;
import com.google.android.exoplayer2.upstream.ParsingLoadable;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.CodecSpecificDataUtil;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class SsManifestParser
implements ParsingLoadable.Parser<SsManifest> {
    private final XmlPullParserFactory xmlParserFactory;

    public SsManifestParser() {
        try {
            this.xmlParserFactory = XmlPullParserFactory.newInstance();
        }
        catch (XmlPullParserException e) {
            throw new RuntimeException("Couldn't create XmlPullParserFactory instance", e);
        }
    }

    public SsManifest parse(Uri uri, InputStream inputStream) throws IOException {
        try {
            XmlPullParser xmlParser = this.xmlParserFactory.newPullParser();
            xmlParser.setInput(inputStream, null);
            SmoothStreamingMediaParser smoothStreamingMediaParser = new SmoothStreamingMediaParser(null, uri.toString());
            return (SsManifest)smoothStreamingMediaParser.parse(xmlParser);
        }
        catch (XmlPullParserException e) {
            throw new ParserException((Throwable)e);
        }
    }

    private static class QualityLevelParser
    extends ElementParser {
        public static final String TAG = "QualityLevel";
        private static final String KEY_INDEX = "Index";
        private static final String KEY_BITRATE = "Bitrate";
        private static final String KEY_CODEC_PRIVATE_DATA = "CodecPrivateData";
        private static final String KEY_SAMPLING_RATE = "SamplingRate";
        private static final String KEY_CHANNELS = "Channels";
        private static final String KEY_FOUR_CC = "FourCC";
        private static final String KEY_TYPE = "Type";
        private static final String KEY_LANGUAGE = "Language";
        private static final String KEY_NAME = "Name";
        private static final String KEY_MAX_WIDTH = "MaxWidth";
        private static final String KEY_MAX_HEIGHT = "MaxHeight";
        private Format format;

        public QualityLevelParser(ElementParser parent, String baseUri) {
            super(parent, baseUri, TAG);
        }

        @Override
        public void parseStartTag(XmlPullParser parser) throws ParserException {
            int type = (Integer)this.getNormalizedAttribute(KEY_TYPE);
            String id = parser.getAttributeValue(null, KEY_INDEX);
            String name = (String)this.getNormalizedAttribute(KEY_NAME);
            int bitrate = this.parseRequiredInt(parser, KEY_BITRATE);
            String sampleMimeType = QualityLevelParser.fourCCToMimeType(this.parseRequiredString(parser, KEY_FOUR_CC));
            if (type == 2) {
                int width = this.parseRequiredInt(parser, KEY_MAX_WIDTH);
                int height = this.parseRequiredInt(parser, KEY_MAX_HEIGHT);
                List<byte[]> codecSpecificData = QualityLevelParser.buildCodecSpecificData(parser.getAttributeValue(null, KEY_CODEC_PRIVATE_DATA));
                this.format = Format.createVideoContainerFormat((String)id, (String)name, (String)"video/mp4", (String)sampleMimeType, null, (int)bitrate, (int)width, (int)height, (float)-1.0f, codecSpecificData, (int)0);
            } else if (type == 1) {
                sampleMimeType = sampleMimeType == null ? "audio/mp4a-latm" : sampleMimeType;
                int channels = this.parseRequiredInt(parser, KEY_CHANNELS);
                int samplingRate = this.parseRequiredInt(parser, KEY_SAMPLING_RATE);
                List<byte[]> codecSpecificData = QualityLevelParser.buildCodecSpecificData(parser.getAttributeValue(null, KEY_CODEC_PRIVATE_DATA));
                if (codecSpecificData.isEmpty() && "audio/mp4a-latm".equals(sampleMimeType)) {
                    codecSpecificData = Collections.singletonList(CodecSpecificDataUtil.buildAacLcAudioSpecificConfig((int)samplingRate, (int)channels));
                }
                String language = (String)this.getNormalizedAttribute(KEY_LANGUAGE);
                this.format = Format.createAudioContainerFormat((String)id, (String)name, (String)"audio/mp4", (String)sampleMimeType, null, (int)bitrate, (int)channels, (int)samplingRate, codecSpecificData, (int)0, (String)language);
            } else if (type == 3) {
                String language = (String)this.getNormalizedAttribute(KEY_LANGUAGE);
                this.format = Format.createTextContainerFormat((String)id, (String)name, (String)"application/mp4", (String)sampleMimeType, null, (int)bitrate, (int)0, (String)language);
            } else {
                this.format = Format.createContainerFormat((String)id, (String)name, (String)"application/mp4", (String)sampleMimeType, null, (int)bitrate, (int)0, null);
            }
        }

        @Override
        public Object build() {
            return this.format;
        }

        private static List<byte[]> buildCodecSpecificData(String codecSpecificDataString) {
            ArrayList<byte[]> csd = new ArrayList<byte[]>();
            if (!TextUtils.isEmpty((CharSequence)codecSpecificDataString)) {
                byte[] codecPrivateData = Util.getBytesFromHexString((String)codecSpecificDataString);
                byte[][] split = CodecSpecificDataUtil.splitNalUnits((byte[])codecPrivateData);
                if (split == null) {
                    csd.add(codecPrivateData);
                } else {
                    Collections.addAll(csd, split);
                }
            }
            return csd;
        }

        private static String fourCCToMimeType(String fourCC) {
            if (fourCC.equalsIgnoreCase("H264") || fourCC.equalsIgnoreCase("X264") || fourCC.equalsIgnoreCase("AVC1") || fourCC.equalsIgnoreCase("DAVC")) {
                return "video/avc";
            }
            if (fourCC.equalsIgnoreCase("AAC") || fourCC.equalsIgnoreCase("AACL") || fourCC.equalsIgnoreCase("AACH") || fourCC.equalsIgnoreCase("AACP")) {
                return "audio/mp4a-latm";
            }
            if (fourCC.equalsIgnoreCase("TTML") || fourCC.equalsIgnoreCase("DFXP")) {
                return "application/ttml+xml";
            }
            if (fourCC.equalsIgnoreCase("ac-3") || fourCC.equalsIgnoreCase("dac3")) {
                return "audio/ac3";
            }
            if (fourCC.equalsIgnoreCase("ec-3") || fourCC.equalsIgnoreCase("dec3")) {
                return "audio/eac3";
            }
            if (fourCC.equalsIgnoreCase("dtsc")) {
                return "audio/vnd.dts";
            }
            if (fourCC.equalsIgnoreCase("dtsh") || fourCC.equalsIgnoreCase("dtsl")) {
                return "audio/vnd.dts.hd";
            }
            if (fourCC.equalsIgnoreCase("dtse")) {
                return "audio/vnd.dts.hd;profile=lbr";
            }
            if (fourCC.equalsIgnoreCase("opus")) {
                return "audio/opus";
            }
            return null;
        }
    }

    private static class StreamIndexParser
    extends ElementParser {
        public static final String TAG = "StreamIndex";
        private static final String TAG_STREAM_FRAGMENT = "c";
        private static final String KEY_TYPE = "Type";
        private static final String KEY_TYPE_AUDIO = "audio";
        private static final String KEY_TYPE_VIDEO = "video";
        private static final String KEY_TYPE_TEXT = "text";
        private static final String KEY_SUB_TYPE = "Subtype";
        private static final String KEY_NAME = "Name";
        private static final String KEY_URL = "Url";
        private static final String KEY_MAX_WIDTH = "MaxWidth";
        private static final String KEY_MAX_HEIGHT = "MaxHeight";
        private static final String KEY_DISPLAY_WIDTH = "DisplayWidth";
        private static final String KEY_DISPLAY_HEIGHT = "DisplayHeight";
        private static final String KEY_LANGUAGE = "Language";
        private static final String KEY_TIME_SCALE = "TimeScale";
        private static final String KEY_FRAGMENT_DURATION = "d";
        private static final String KEY_FRAGMENT_START_TIME = "t";
        private static final String KEY_FRAGMENT_REPEAT_COUNT = "r";
        private final String baseUri;
        private final List<Format> formats;
        private int type;
        private String subType;
        private long timescale;
        private String name;
        private String url;
        private int maxWidth;
        private int maxHeight;
        private int displayWidth;
        private int displayHeight;
        private String language;
        private ArrayList<Long> startTimes;
        private long lastChunkDuration;

        public StreamIndexParser(ElementParser parent, String baseUri) {
            super(parent, baseUri, TAG);
            this.baseUri = baseUri;
            this.formats = new LinkedList<Format>();
        }

        @Override
        public boolean handleChildInline(String tag) {
            return TAG_STREAM_FRAGMENT.equals(tag);
        }

        @Override
        public void parseStartTag(XmlPullParser parser) throws ParserException {
            if (TAG_STREAM_FRAGMENT.equals(parser.getName())) {
                this.parseStreamFragmentStartTag(parser);
            } else {
                this.parseStreamElementStartTag(parser);
            }
        }

        private void parseStreamFragmentStartTag(XmlPullParser parser) throws ParserException {
            int chunkIndex = this.startTimes.size();
            long startTime = this.parseLong(parser, KEY_FRAGMENT_START_TIME, -9223372036854775807L);
            if (startTime == -9223372036854775807L) {
                if (chunkIndex == 0) {
                    startTime = 0L;
                } else if (this.lastChunkDuration != -1L) {
                    startTime = this.startTimes.get(chunkIndex - 1) + this.lastChunkDuration;
                } else {
                    throw new ParserException("Unable to infer start time");
                }
            }
            ++chunkIndex;
            this.startTimes.add(startTime);
            this.lastChunkDuration = this.parseLong(parser, KEY_FRAGMENT_DURATION, -9223372036854775807L);
            long repeatCount = this.parseLong(parser, KEY_FRAGMENT_REPEAT_COUNT, 1L);
            if (repeatCount > 1L && this.lastChunkDuration == -9223372036854775807L) {
                throw new ParserException("Repeated chunk with unspecified duration");
            }
            int i = 1;
            while ((long)i < repeatCount) {
                ++chunkIndex;
                this.startTimes.add(startTime + this.lastChunkDuration * (long)i);
                ++i;
            }
        }

        private void parseStreamElementStartTag(XmlPullParser parser) throws ParserException {
            this.type = this.parseType(parser);
            this.putNormalizedAttribute(KEY_TYPE, this.type);
            this.subType = this.type == 3 ? this.parseRequiredString(parser, KEY_SUB_TYPE) : parser.getAttributeValue(null, KEY_SUB_TYPE);
            this.name = parser.getAttributeValue(null, KEY_NAME);
            this.url = this.parseRequiredString(parser, KEY_URL);
            this.maxWidth = this.parseInt(parser, KEY_MAX_WIDTH, -1);
            this.maxHeight = this.parseInt(parser, KEY_MAX_HEIGHT, -1);
            this.displayWidth = this.parseInt(parser, KEY_DISPLAY_WIDTH, -1);
            this.displayHeight = this.parseInt(parser, KEY_DISPLAY_HEIGHT, -1);
            this.language = parser.getAttributeValue(null, KEY_LANGUAGE);
            this.putNormalizedAttribute(KEY_LANGUAGE, this.language);
            this.timescale = this.parseInt(parser, KEY_TIME_SCALE, -1);
            if (this.timescale == -1L) {
                this.timescale = (Long)this.getNormalizedAttribute(KEY_TIME_SCALE);
            }
            this.startTimes = new ArrayList();
        }

        private int parseType(XmlPullParser parser) throws ParserException {
            String value = parser.getAttributeValue(null, KEY_TYPE);
            if (value != null) {
                if (KEY_TYPE_AUDIO.equalsIgnoreCase(value)) {
                    return 1;
                }
                if (KEY_TYPE_VIDEO.equalsIgnoreCase(value)) {
                    return 2;
                }
                if (KEY_TYPE_TEXT.equalsIgnoreCase(value)) {
                    return 3;
                }
                throw new ParserException("Invalid key value[" + value + "]");
            }
            throw new MissingFieldException(KEY_TYPE);
        }

        @Override
        public void addChild(Object child) {
            if (child instanceof Format) {
                this.formats.add((Format)child);
            }
        }

        @Override
        public Object build() {
            Format[] formatArray = new Format[this.formats.size()];
            this.formats.toArray(formatArray);
            return new SsManifest.StreamElement(this.baseUri, this.url, this.type, this.subType, this.timescale, this.name, this.maxWidth, this.maxHeight, this.displayWidth, this.displayHeight, this.language, formatArray, this.startTimes, this.lastChunkDuration);
        }
    }

    private static class ProtectionParser
    extends ElementParser {
        public static final String TAG = "Protection";
        public static final String TAG_PROTECTION_HEADER = "ProtectionHeader";
        public static final String KEY_SYSTEM_ID = "SystemID";
        private boolean inProtectionHeader;
        private UUID uuid;
        private byte[] initData;

        public ProtectionParser(ElementParser parent, String baseUri) {
            super(parent, baseUri, TAG);
        }

        @Override
        public boolean handleChildInline(String tag) {
            return TAG_PROTECTION_HEADER.equals(tag);
        }

        @Override
        public void parseStartTag(XmlPullParser parser) {
            if (TAG_PROTECTION_HEADER.equals(parser.getName())) {
                this.inProtectionHeader = true;
                String uuidString = parser.getAttributeValue(null, KEY_SYSTEM_ID);
                uuidString = ProtectionParser.stripCurlyBraces(uuidString);
                this.uuid = UUID.fromString(uuidString);
            }
        }

        @Override
        public void parseText(XmlPullParser parser) {
            if (this.inProtectionHeader) {
                this.initData = Base64.decode((String)parser.getText(), (int)0);
            }
        }

        @Override
        public void parseEndTag(XmlPullParser parser) {
            if (TAG_PROTECTION_HEADER.equals(parser.getName())) {
                this.inProtectionHeader = false;
            }
        }

        @Override
        public Object build() {
            return new SsManifest.ProtectionElement(this.uuid, PsshAtomUtil.buildPsshAtom((UUID)this.uuid, (byte[])this.initData));
        }

        private static String stripCurlyBraces(String uuidString) {
            if (uuidString.charAt(0) == '{' && uuidString.charAt(uuidString.length() - 1) == '}') {
                uuidString = uuidString.substring(1, uuidString.length() - 1);
            }
            return uuidString;
        }
    }

    private static class SmoothStreamingMediaParser
    extends ElementParser {
        public static final String TAG = "SmoothStreamingMedia";
        private static final String KEY_MAJOR_VERSION = "MajorVersion";
        private static final String KEY_MINOR_VERSION = "MinorVersion";
        private static final String KEY_TIME_SCALE = "TimeScale";
        private static final String KEY_DVR_WINDOW_LENGTH = "DVRWindowLength";
        private static final String KEY_DURATION = "Duration";
        private static final String KEY_LOOKAHEAD_COUNT = "LookaheadCount";
        private static final String KEY_IS_LIVE = "IsLive";
        private final List<SsManifest.StreamElement> streamElements = new LinkedList<SsManifest.StreamElement>();
        private int majorVersion;
        private int minorVersion;
        private long timescale;
        private long duration;
        private long dvrWindowLength;
        private int lookAheadCount = -1;
        private boolean isLive;
        private SsManifest.ProtectionElement protectionElement = null;

        public SmoothStreamingMediaParser(ElementParser parent, String baseUri) {
            super(parent, baseUri, TAG);
        }

        @Override
        public void parseStartTag(XmlPullParser parser) throws ParserException {
            this.majorVersion = this.parseRequiredInt(parser, KEY_MAJOR_VERSION);
            this.minorVersion = this.parseRequiredInt(parser, KEY_MINOR_VERSION);
            this.timescale = this.parseLong(parser, KEY_TIME_SCALE, 10000000L);
            this.duration = this.parseRequiredLong(parser, KEY_DURATION);
            this.dvrWindowLength = this.parseLong(parser, KEY_DVR_WINDOW_LENGTH, 0L);
            this.lookAheadCount = this.parseInt(parser, KEY_LOOKAHEAD_COUNT, -1);
            this.isLive = this.parseBoolean(parser, KEY_IS_LIVE, false);
            this.putNormalizedAttribute(KEY_TIME_SCALE, this.timescale);
        }

        @Override
        public void addChild(Object child) {
            if (child instanceof SsManifest.StreamElement) {
                this.streamElements.add((SsManifest.StreamElement)child);
            } else if (child instanceof SsManifest.ProtectionElement) {
                Assertions.checkState((this.protectionElement == null ? 1 : 0) != 0);
                this.protectionElement = (SsManifest.ProtectionElement)child;
            }
        }

        @Override
        public Object build() {
            SsManifest.StreamElement[] streamElementArray = new SsManifest.StreamElement[this.streamElements.size()];
            this.streamElements.toArray(streamElementArray);
            if (this.protectionElement != null) {
                DrmInitData drmInitData = new DrmInitData(new DrmInitData.SchemeData[]{new DrmInitData.SchemeData(this.protectionElement.uuid, "video/mp4", this.protectionElement.data)});
                for (SsManifest.StreamElement streamElement : streamElementArray) {
                    for (int i = 0; i < streamElement.formats.length; ++i) {
                        streamElement.formats[i] = streamElement.formats[i].copyWithDrmInitData(drmInitData);
                    }
                }
            }
            return new SsManifest(this.majorVersion, this.minorVersion, this.timescale, this.duration, this.dvrWindowLength, this.lookAheadCount, this.isLive, this.protectionElement, streamElementArray);
        }
    }

    private static abstract class ElementParser {
        private final String baseUri;
        private final String tag;
        private final ElementParser parent;
        private final List<Pair<String, Object>> normalizedAttributes;

        public ElementParser(ElementParser parent, String baseUri, String tag) {
            this.parent = parent;
            this.baseUri = baseUri;
            this.tag = tag;
            this.normalizedAttributes = new LinkedList<Pair<String, Object>>();
        }

        public final Object parse(XmlPullParser xmlParser) throws XmlPullParserException, IOException {
            boolean foundStartTag = false;
            int skippingElementDepth = 0;
            while (true) {
                int eventType = xmlParser.getEventType();
                switch (eventType) {
                    case 2: {
                        String tagName = xmlParser.getName();
                        if (this.tag.equals(tagName)) {
                            foundStartTag = true;
                            this.parseStartTag(xmlParser);
                            break;
                        }
                        if (!foundStartTag) break;
                        if (skippingElementDepth > 0) {
                            ++skippingElementDepth;
                            break;
                        }
                        if (this.handleChildInline(tagName)) {
                            this.parseStartTag(xmlParser);
                            break;
                        }
                        ElementParser childElementParser = this.newChildParser(this, tagName, this.baseUri);
                        if (childElementParser == null) {
                            skippingElementDepth = 1;
                            break;
                        }
                        this.addChild(childElementParser.parse(xmlParser));
                        break;
                    }
                    case 4: {
                        if (!foundStartTag || skippingElementDepth != 0) break;
                        this.parseText(xmlParser);
                        break;
                    }
                    case 3: {
                        if (!foundStartTag) break;
                        if (skippingElementDepth > 0) {
                            --skippingElementDepth;
                            break;
                        }
                        String tagName = xmlParser.getName();
                        this.parseEndTag(xmlParser);
                        if (this.handleChildInline(tagName)) break;
                        return this.build();
                    }
                    case 1: {
                        return null;
                    }
                }
                xmlParser.next();
            }
        }

        private ElementParser newChildParser(ElementParser parent, String name, String baseUri) {
            if ("QualityLevel".equals(name)) {
                return new QualityLevelParser(parent, baseUri);
            }
            if ("Protection".equals(name)) {
                return new ProtectionParser(parent, baseUri);
            }
            if ("StreamIndex".equals(name)) {
                return new StreamIndexParser(parent, baseUri);
            }
            return null;
        }

        protected final void putNormalizedAttribute(String key, Object value) {
            this.normalizedAttributes.add((Pair<String, Object>)Pair.create((Object)key, (Object)value));
        }

        protected final Object getNormalizedAttribute(String key) {
            for (int i = 0; i < this.normalizedAttributes.size(); ++i) {
                Pair<String, Object> pair = this.normalizedAttributes.get(i);
                if (!((String)pair.first).equals(key)) continue;
                return pair.second;
            }
            return this.parent == null ? null : this.parent.getNormalizedAttribute(key);
        }

        protected boolean handleChildInline(String tagName) {
            return false;
        }

        protected void parseStartTag(XmlPullParser xmlParser) throws ParserException {
        }

        protected void parseText(XmlPullParser xmlParser) {
        }

        protected void parseEndTag(XmlPullParser xmlParser) {
        }

        protected void addChild(Object parsedChild) {
        }

        protected abstract Object build();

        protected final String parseRequiredString(XmlPullParser parser, String key) throws MissingFieldException {
            String value = parser.getAttributeValue(null, key);
            if (value != null) {
                return value;
            }
            throw new MissingFieldException(key);
        }

        protected final int parseInt(XmlPullParser parser, String key, int defaultValue) throws ParserException {
            String value = parser.getAttributeValue(null, key);
            if (value != null) {
                try {
                    return Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    throw new ParserException((Throwable)e);
                }
            }
            return defaultValue;
        }

        protected final int parseRequiredInt(XmlPullParser parser, String key) throws ParserException {
            String value = parser.getAttributeValue(null, key);
            if (value != null) {
                try {
                    return Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    throw new ParserException((Throwable)e);
                }
            }
            throw new MissingFieldException(key);
        }

        protected final long parseLong(XmlPullParser parser, String key, long defaultValue) throws ParserException {
            String value = parser.getAttributeValue(null, key);
            if (value != null) {
                try {
                    return Long.parseLong(value);
                }
                catch (NumberFormatException e) {
                    throw new ParserException((Throwable)e);
                }
            }
            return defaultValue;
        }

        protected final long parseRequiredLong(XmlPullParser parser, String key) throws ParserException {
            String value = parser.getAttributeValue(null, key);
            if (value != null) {
                try {
                    return Long.parseLong(value);
                }
                catch (NumberFormatException e) {
                    throw new ParserException((Throwable)e);
                }
            }
            throw new MissingFieldException(key);
        }

        protected final boolean parseBoolean(XmlPullParser parser, String key, boolean defaultValue) {
            String value = parser.getAttributeValue(null, key);
            if (value != null) {
                return Boolean.parseBoolean(value);
            }
            return defaultValue;
        }
    }

    public static class MissingFieldException
    extends ParserException {
        public MissingFieldException(String fieldName) {
            super("Missing required field: " + fieldName);
        }
    }
}

