/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.smoothstreaming;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.SeekParameters;
import com.google.android.exoplayer2.drm.DrmSessionManager;
import com.google.android.exoplayer2.offline.StreamKey;
import com.google.android.exoplayer2.source.CompositeSequenceableLoaderFactory;
import com.google.android.exoplayer2.source.MediaPeriod;
import com.google.android.exoplayer2.source.MediaSourceEventListener;
import com.google.android.exoplayer2.source.SampleStream;
import com.google.android.exoplayer2.source.SequenceableLoader;
import com.google.android.exoplayer2.source.TrackGroup;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.source.chunk.ChunkSampleStream;
import com.google.android.exoplayer2.source.chunk.ChunkSource;
import com.google.android.exoplayer2.source.smoothstreaming.SsChunkSource;
import com.google.android.exoplayer2.source.smoothstreaming.manifest.SsManifest;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.upstream.Allocator;
import com.google.android.exoplayer2.upstream.LoadErrorHandlingPolicy;
import com.google.android.exoplayer2.upstream.LoaderErrorThrower;
import com.google.android.exoplayer2.upstream.TransferListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.compatqual.NullableType;

final class SsMediaPeriod
implements MediaPeriod,
SequenceableLoader.Callback<ChunkSampleStream<SsChunkSource>> {
    private final SsChunkSource.Factory chunkSourceFactory;
    @Nullable
    private final TransferListener transferListener;
    private final LoaderErrorThrower manifestLoaderErrorThrower;
    private final DrmSessionManager<?> drmSessionManager;
    private final LoadErrorHandlingPolicy loadErrorHandlingPolicy;
    private final MediaSourceEventListener.EventDispatcher eventDispatcher;
    private final Allocator allocator;
    private final TrackGroupArray trackGroups;
    private final CompositeSequenceableLoaderFactory compositeSequenceableLoaderFactory;
    @Nullable
    private MediaPeriod.Callback callback;
    private SsManifest manifest;
    private ChunkSampleStream<SsChunkSource>[] sampleStreams;
    private SequenceableLoader compositeSequenceableLoader;
    private boolean notifiedReadingStarted;

    public SsMediaPeriod(SsManifest manifest, SsChunkSource.Factory chunkSourceFactory, @Nullable TransferListener transferListener, CompositeSequenceableLoaderFactory compositeSequenceableLoaderFactory, DrmSessionManager<?> drmSessionManager, LoadErrorHandlingPolicy loadErrorHandlingPolicy, MediaSourceEventListener.EventDispatcher eventDispatcher, LoaderErrorThrower manifestLoaderErrorThrower, Allocator allocator) {
        this.manifest = manifest;
        this.chunkSourceFactory = chunkSourceFactory;
        this.transferListener = transferListener;
        this.manifestLoaderErrorThrower = manifestLoaderErrorThrower;
        this.drmSessionManager = drmSessionManager;
        this.loadErrorHandlingPolicy = loadErrorHandlingPolicy;
        this.eventDispatcher = eventDispatcher;
        this.allocator = allocator;
        this.compositeSequenceableLoaderFactory = compositeSequenceableLoaderFactory;
        this.trackGroups = SsMediaPeriod.buildTrackGroups(manifest, drmSessionManager);
        this.sampleStreams = SsMediaPeriod.newSampleStreamArray(0);
        this.compositeSequenceableLoader = compositeSequenceableLoaderFactory.createCompositeSequenceableLoader(this.sampleStreams);
        eventDispatcher.mediaPeriodCreated();
    }

    public void updateManifest(SsManifest manifest) {
        this.manifest = manifest;
        for (ChunkSampleStream<SsChunkSource> sampleStream : this.sampleStreams) {
            ((SsChunkSource)sampleStream.getChunkSource()).updateManifest(manifest);
        }
        this.callback.onContinueLoadingRequested((SequenceableLoader)this);
    }

    public void release() {
        for (ChunkSampleStream<SsChunkSource> sampleStream : this.sampleStreams) {
            sampleStream.release();
        }
        this.callback = null;
        this.eventDispatcher.mediaPeriodReleased();
    }

    public void prepare(MediaPeriod.Callback callback, long positionUs) {
        this.callback = callback;
        callback.onPrepared((MediaPeriod)this);
    }

    public void maybeThrowPrepareError() throws IOException {
        this.manifestLoaderErrorThrower.maybeThrowError();
    }

    public TrackGroupArray getTrackGroups() {
        return this.trackGroups;
    }

    public long selectTracks(@NullableType TrackSelection[] selections, boolean[] mayRetainStreamFlags, @NullableType SampleStream[] streams, boolean[] streamResetFlags, long positionUs) {
        ArrayList<ChunkSampleStream<SsChunkSource>> sampleStreamsList = new ArrayList<ChunkSampleStream<SsChunkSource>>();
        for (int i = 0; i < selections.length; ++i) {
            ChunkSampleStream<SsChunkSource> stream;
            if (streams[i] != null) {
                stream = (ChunkSampleStream<SsChunkSource>)streams[i];
                if (selections[i] == null || !mayRetainStreamFlags[i]) {
                    stream.release();
                    streams[i] = null;
                } else {
                    ((SsChunkSource)stream.getChunkSource()).updateTrackSelection(selections[i]);
                    sampleStreamsList.add(stream);
                }
            }
            if (streams[i] != null || selections[i] == null) continue;
            stream = this.buildSampleStream(selections[i], positionUs);
            sampleStreamsList.add(stream);
            streams[i] = stream;
            streamResetFlags[i] = true;
        }
        this.sampleStreams = SsMediaPeriod.newSampleStreamArray(sampleStreamsList.size());
        sampleStreamsList.toArray(this.sampleStreams);
        this.compositeSequenceableLoader = this.compositeSequenceableLoaderFactory.createCompositeSequenceableLoader(this.sampleStreams);
        return positionUs;
    }

    public List<StreamKey> getStreamKeys(List<TrackSelection> trackSelections) {
        ArrayList<StreamKey> streamKeys = new ArrayList<StreamKey>();
        for (int selectionIndex = 0; selectionIndex < trackSelections.size(); ++selectionIndex) {
            TrackSelection trackSelection = trackSelections.get(selectionIndex);
            int streamElementIndex = this.trackGroups.indexOf(trackSelection.getTrackGroup());
            for (int i = 0; i < trackSelection.length(); ++i) {
                streamKeys.add(new StreamKey(streamElementIndex, trackSelection.getIndexInTrackGroup(i)));
            }
        }
        return streamKeys;
    }

    public void discardBuffer(long positionUs, boolean toKeyframe) {
        for (ChunkSampleStream<SsChunkSource> sampleStream : this.sampleStreams) {
            sampleStream.discardBuffer(positionUs, toKeyframe);
        }
    }

    public void reevaluateBuffer(long positionUs) {
        this.compositeSequenceableLoader.reevaluateBuffer(positionUs);
    }

    public boolean continueLoading(long positionUs) {
        return this.compositeSequenceableLoader.continueLoading(positionUs);
    }

    public boolean isLoading() {
        return this.compositeSequenceableLoader.isLoading();
    }

    public long getNextLoadPositionUs() {
        return this.compositeSequenceableLoader.getNextLoadPositionUs();
    }

    public long readDiscontinuity() {
        if (!this.notifiedReadingStarted) {
            this.eventDispatcher.readingStarted();
            this.notifiedReadingStarted = true;
        }
        return -9223372036854775807L;
    }

    public long getBufferedPositionUs() {
        return this.compositeSequenceableLoader.getBufferedPositionUs();
    }

    public long seekToUs(long positionUs) {
        for (ChunkSampleStream<SsChunkSource> sampleStream : this.sampleStreams) {
            sampleStream.seekToUs(positionUs);
        }
        return positionUs;
    }

    public long getAdjustedSeekPositionUs(long positionUs, SeekParameters seekParameters) {
        for (ChunkSampleStream<SsChunkSource> sampleStream : this.sampleStreams) {
            if (sampleStream.primaryTrackType != 2) continue;
            return sampleStream.getAdjustedSeekPositionUs(positionUs, seekParameters);
        }
        return positionUs;
    }

    public void onContinueLoadingRequested(ChunkSampleStream<SsChunkSource> sampleStream) {
        this.callback.onContinueLoadingRequested((SequenceableLoader)this);
    }

    private ChunkSampleStream<SsChunkSource> buildSampleStream(TrackSelection selection, long positionUs) {
        int streamElementIndex = this.trackGroups.indexOf(selection.getTrackGroup());
        SsChunkSource chunkSource = this.chunkSourceFactory.createChunkSource(this.manifestLoaderErrorThrower, this.manifest, streamElementIndex, selection, this.transferListener);
        return new ChunkSampleStream(this.manifest.streamElements[streamElementIndex].type, null, null, (ChunkSource)chunkSource, (SequenceableLoader.Callback)this, this.allocator, positionUs, this.drmSessionManager, this.loadErrorHandlingPolicy, this.eventDispatcher);
    }

    private static TrackGroupArray buildTrackGroups(SsManifest manifest, DrmSessionManager<?> drmSessionManager) {
        TrackGroup[] trackGroups = new TrackGroup[manifest.streamElements.length];
        for (int i = 0; i < manifest.streamElements.length; ++i) {
            Format[] manifestFormats = manifest.streamElements[i].formats;
            Format[] exposedFormats = new Format[manifestFormats.length];
            for (int j = 0; j < manifestFormats.length; ++j) {
                Format manifestFormat = manifestFormats[j];
                exposedFormats[j] = manifestFormat.drmInitData != null ? manifestFormat.copyWithExoMediaCryptoType(drmSessionManager.getExoMediaCryptoType(manifestFormat.drmInitData)) : manifestFormat;
            }
            trackGroups[i] = new TrackGroup(exposedFormats);
        }
        return new TrackGroupArray(trackGroups);
    }

    private static ChunkSampleStream<SsChunkSource>[] newSampleStreamArray(int length) {
        return new ChunkSampleStream[length];
    }
}

