/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.hls.playlist;

import android.support.annotation.NonNull;
import com.google.android.exoplayer2.source.hls.playlist.HlsPlaylist;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collections;
import java.util.List;

public final class HlsMediaPlaylist
extends HlsPlaylist {
    public static final int PLAYLIST_TYPE_UNKNOWN = 0;
    public static final int PLAYLIST_TYPE_VOD = 1;
    public static final int PLAYLIST_TYPE_EVENT = 2;
    public final int playlistType;
    public final long startOffsetUs;
    public final long startTimeUs;
    public final boolean hasDiscontinuitySequence;
    public final int discontinuitySequence;
    public final int mediaSequence;
    public final int version;
    public final long targetDurationUs;
    public final boolean hasIndependentSegmentsTag;
    public final boolean hasEndTag;
    public final boolean hasProgramDateTime;
    public final Segment initializationSegment;
    public final List<Segment> segments;
    public final long durationUs;

    public HlsMediaPlaylist(int playlistType, String baseUri, List<String> tags, long startOffsetUs, long startTimeUs, boolean hasDiscontinuitySequence, int discontinuitySequence, int mediaSequence, int version, long targetDurationUs, boolean hasIndependentSegmentsTag, boolean hasEndTag, boolean hasProgramDateTime, Segment initializationSegment, List<Segment> segments) {
        super(baseUri, tags);
        this.playlistType = playlistType;
        this.startTimeUs = startTimeUs;
        this.hasDiscontinuitySequence = hasDiscontinuitySequence;
        this.discontinuitySequence = discontinuitySequence;
        this.mediaSequence = mediaSequence;
        this.version = version;
        this.targetDurationUs = targetDurationUs;
        this.hasIndependentSegmentsTag = hasIndependentSegmentsTag;
        this.hasEndTag = hasEndTag;
        this.hasProgramDateTime = hasProgramDateTime;
        this.initializationSegment = initializationSegment;
        this.segments = Collections.unmodifiableList(segments);
        if (!segments.isEmpty()) {
            Segment last = segments.get(segments.size() - 1);
            this.durationUs = last.relativeStartTimeUs + last.durationUs;
        } else {
            this.durationUs = 0L;
        }
        this.startOffsetUs = startOffsetUs == -9223372036854775807L ? -9223372036854775807L : (startOffsetUs >= 0L ? startOffsetUs : this.durationUs + startOffsetUs);
    }

    public boolean isNewerThan(HlsMediaPlaylist other) {
        int otherSegmentCount;
        if (other == null || this.mediaSequence > other.mediaSequence) {
            return true;
        }
        if (this.mediaSequence < other.mediaSequence) {
            return false;
        }
        int segmentCount = this.segments.size();
        return segmentCount > (otherSegmentCount = other.segments.size()) || segmentCount == otherSegmentCount && this.hasEndTag && !other.hasEndTag;
    }

    public long getEndTimeUs() {
        return this.startTimeUs + this.durationUs;
    }

    public HlsMediaPlaylist copyWith(long startTimeUs, int discontinuitySequence) {
        return new HlsMediaPlaylist(this.playlistType, this.baseUri, this.tags, this.startOffsetUs, startTimeUs, true, discontinuitySequence, this.mediaSequence, this.version, this.targetDurationUs, this.hasIndependentSegmentsTag, this.hasEndTag, this.hasProgramDateTime, this.initializationSegment, this.segments);
    }

    public HlsMediaPlaylist copyWithEndTag() {
        if (this.hasEndTag) {
            return this;
        }
        return new HlsMediaPlaylist(this.playlistType, this.baseUri, this.tags, this.startOffsetUs, this.startTimeUs, this.hasDiscontinuitySequence, this.discontinuitySequence, this.mediaSequence, this.version, this.targetDurationUs, this.hasIndependentSegmentsTag, true, this.hasProgramDateTime, this.initializationSegment, this.segments);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PlaylistType {
    }

    public static final class Segment
    implements Comparable<Long> {
        public final String url;
        public final long durationUs;
        public final int relativeDiscontinuitySequence;
        public final long relativeStartTimeUs;
        public final boolean isEncrypted;
        public final String encryptionKeyUri;
        public final String encryptionIV;
        public final long byterangeOffset;
        public final long byterangeLength;

        public Segment(String uri, long byterangeOffset, long byterangeLength) {
            this(uri, 0L, -1, -9223372036854775807L, false, null, null, byterangeOffset, byterangeLength);
        }

        public Segment(String url, long durationUs, int relativeDiscontinuitySequence, long relativeStartTimeUs, boolean isEncrypted, String encryptionKeyUri, String encryptionIV, long byterangeOffset, long byterangeLength) {
            this.url = url;
            this.durationUs = durationUs;
            this.relativeDiscontinuitySequence = relativeDiscontinuitySequence;
            this.relativeStartTimeUs = relativeStartTimeUs;
            this.isEncrypted = isEncrypted;
            this.encryptionKeyUri = encryptionKeyUri;
            this.encryptionIV = encryptionIV;
            this.byterangeOffset = byterangeOffset;
            this.byterangeLength = byterangeLength;
        }

        @Override
        public int compareTo(@NonNull Long relativeStartTimeUs) {
            return this.relativeStartTimeUs > relativeStartTimeUs ? 1 : (this.relativeStartTimeUs < relativeStartTimeUs ? -1 : 0);
        }
    }
}

