/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.hls;

import android.text.TextUtils;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.extractor.Extractor;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.PositionHolder;
import com.google.android.exoplayer2.extractor.SeekMap;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.text.SubtitleDecoderException;
import com.google.android.exoplayer2.text.webvtt.WebvttParserUtil;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.TimestampAdjuster;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class WebvttExtractor
implements Extractor {
    private static final Pattern LOCAL_TIMESTAMP = Pattern.compile("LOCAL:([^,]+)");
    private static final Pattern MEDIA_TIMESTAMP = Pattern.compile("MPEGTS:(\\d+)");
    private final String language;
    private final TimestampAdjuster timestampAdjuster;
    private final ParsableByteArray sampleDataWrapper;
    private ExtractorOutput output;
    private byte[] sampleData;
    private int sampleSize;

    public WebvttExtractor(String language, TimestampAdjuster timestampAdjuster) {
        this.language = language;
        this.timestampAdjuster = timestampAdjuster;
        this.sampleDataWrapper = new ParsableByteArray();
        this.sampleData = new byte[1024];
    }

    public boolean sniff(ExtractorInput input) throws IOException, InterruptedException {
        throw new IllegalStateException();
    }

    public void init(ExtractorOutput output) {
        this.output = output;
        output.seekMap((SeekMap)new SeekMap.Unseekable(-9223372036854775807L));
    }

    public void seek(long position, long timeUs) {
        throw new IllegalStateException();
    }

    public void release() {
    }

    public int read(ExtractorInput input, PositionHolder seekPosition) throws IOException, InterruptedException {
        int bytesRead;
        int currentFileSize = (int)input.getLength();
        if (this.sampleSize == this.sampleData.length) {
            this.sampleData = Arrays.copyOf(this.sampleData, (currentFileSize != -1 ? currentFileSize : this.sampleData.length) * 3 / 2);
        }
        if ((bytesRead = input.read(this.sampleData, this.sampleSize, this.sampleData.length - this.sampleSize)) != -1) {
            this.sampleSize += bytesRead;
            if (currentFileSize == -1 || this.sampleSize != currentFileSize) {
                return 0;
            }
        }
        this.processSample();
        return -1;
    }

    private void processSample() throws ParserException {
        String line;
        ParsableByteArray webvttData = new ParsableByteArray(this.sampleData);
        try {
            WebvttParserUtil.validateWebvttHeaderLine((ParsableByteArray)webvttData);
        }
        catch (SubtitleDecoderException e) {
            throw new ParserException((Throwable)e);
        }
        long vttTimestampUs = 0L;
        long tsTimestampUs = 0L;
        while (!TextUtils.isEmpty((CharSequence)(line = webvttData.readLine()))) {
            if (!line.startsWith("X-TIMESTAMP-MAP")) continue;
            Matcher localTimestampMatcher = LOCAL_TIMESTAMP.matcher(line);
            if (!localTimestampMatcher.find()) {
                throw new ParserException("X-TIMESTAMP-MAP doesn't contain local timestamp: " + line);
            }
            Matcher mediaTimestampMatcher = MEDIA_TIMESTAMP.matcher(line);
            if (!mediaTimestampMatcher.find()) {
                throw new ParserException("X-TIMESTAMP-MAP doesn't contain media timestamp: " + line);
            }
            vttTimestampUs = WebvttParserUtil.parseTimestampUs((String)localTimestampMatcher.group(1));
            tsTimestampUs = TimestampAdjuster.ptsToUs((long)Long.parseLong(mediaTimestampMatcher.group(1)));
        }
        Matcher cueHeaderMatcher = WebvttParserUtil.findNextCueHeader((ParsableByteArray)webvttData);
        if (cueHeaderMatcher == null) {
            this.buildTrackOutput(0L);
            return;
        }
        long firstCueTimeUs = WebvttParserUtil.parseTimestampUs((String)cueHeaderMatcher.group(1));
        long sampleTimeUs = this.timestampAdjuster.adjustSampleTimestamp(firstCueTimeUs + tsTimestampUs - vttTimestampUs);
        long subsampleOffsetUs = sampleTimeUs - firstCueTimeUs;
        TrackOutput trackOutput = this.buildTrackOutput(subsampleOffsetUs);
        this.sampleDataWrapper.reset(this.sampleData, this.sampleSize);
        trackOutput.sampleData(this.sampleDataWrapper, this.sampleSize);
        trackOutput.sampleMetadata(sampleTimeUs, 1, this.sampleSize, 0, null);
    }

    private TrackOutput buildTrackOutput(long subsampleOffsetUs) {
        TrackOutput trackOutput = this.output.track(0, 3);
        trackOutput.format(Format.createTextSampleFormat(null, (String)"text/vtt", null, (int)-1, (int)0, (String)this.language, null, (long)subsampleOffsetUs));
        this.output.endTracks();
        return trackOutput;
    }
}

