/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.hls;

import android.os.Handler;
import android.text.TextUtils;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.source.AdaptiveMediaSourceEventListener;
import com.google.android.exoplayer2.source.CompositeSequenceableLoader;
import com.google.android.exoplayer2.source.MediaPeriod;
import com.google.android.exoplayer2.source.SampleStream;
import com.google.android.exoplayer2.source.SequenceableLoader;
import com.google.android.exoplayer2.source.TrackGroup;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.source.hls.HlsChunkSource;
import com.google.android.exoplayer2.source.hls.HlsDataSourceFactory;
import com.google.android.exoplayer2.source.hls.HlsSampleStreamWrapper;
import com.google.android.exoplayer2.source.hls.TimestampAdjusterProvider;
import com.google.android.exoplayer2.source.hls.playlist.HlsMasterPlaylist;
import com.google.android.exoplayer2.source.hls.playlist.HlsPlaylistTracker;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.upstream.Allocator;
import com.google.android.exoplayer2.util.Assertions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;

public final class HlsMediaPeriod
implements MediaPeriod,
HlsSampleStreamWrapper.Callback,
HlsPlaylistTracker.PlaylistEventListener {
    private final HlsPlaylistTracker playlistTracker;
    private final HlsDataSourceFactory dataSourceFactory;
    private final int minLoadableRetryCount;
    private final AdaptiveMediaSourceEventListener.EventDispatcher eventDispatcher;
    private final Allocator allocator;
    private final IdentityHashMap<SampleStream, Integer> streamWrapperIndices;
    private final TimestampAdjusterProvider timestampAdjusterProvider;
    private final Handler continueLoadingHandler;
    private MediaPeriod.Callback callback;
    private int pendingPrepareCount;
    private TrackGroupArray trackGroups;
    private HlsSampleStreamWrapper[] sampleStreamWrappers;
    private HlsSampleStreamWrapper[] enabledSampleStreamWrappers;
    private CompositeSequenceableLoader sequenceableLoader;

    public HlsMediaPeriod(HlsPlaylistTracker playlistTracker, HlsDataSourceFactory dataSourceFactory, int minLoadableRetryCount, AdaptiveMediaSourceEventListener.EventDispatcher eventDispatcher, Allocator allocator) {
        this.playlistTracker = playlistTracker;
        this.dataSourceFactory = dataSourceFactory;
        this.minLoadableRetryCount = minLoadableRetryCount;
        this.eventDispatcher = eventDispatcher;
        this.allocator = allocator;
        this.streamWrapperIndices = new IdentityHashMap();
        this.timestampAdjusterProvider = new TimestampAdjusterProvider();
        this.continueLoadingHandler = new Handler();
        this.sampleStreamWrappers = new HlsSampleStreamWrapper[0];
        this.enabledSampleStreamWrappers = new HlsSampleStreamWrapper[0];
    }

    public void release() {
        this.playlistTracker.removeListener(this);
        this.continueLoadingHandler.removeCallbacksAndMessages(null);
        for (HlsSampleStreamWrapper sampleStreamWrapper : this.sampleStreamWrappers) {
            sampleStreamWrapper.release();
        }
    }

    public void prepare(MediaPeriod.Callback callback, long positionUs) {
        this.callback = callback;
        this.playlistTracker.addListener(this);
        this.buildAndPrepareSampleStreamWrappers(positionUs);
    }

    public void maybeThrowPrepareError() throws IOException {
        for (HlsSampleStreamWrapper sampleStreamWrapper : this.sampleStreamWrappers) {
            sampleStreamWrapper.maybeThrowPrepareError();
        }
    }

    public TrackGroupArray getTrackGroups() {
        return this.trackGroups;
    }

    public long selectTracks(TrackSelection[] selections, boolean[] mayRetainStreamFlags, SampleStream[] streams, boolean[] streamResetFlags, long positionUs) {
        int[] streamChildIndices = new int[selections.length];
        int[] selectionChildIndices = new int[selections.length];
        block0: for (int i = 0; i < selections.length; ++i) {
            streamChildIndices[i] = streams[i] == null ? -1 : this.streamWrapperIndices.get(streams[i]);
            selectionChildIndices[i] = -1;
            if (selections[i] == null) continue;
            TrackGroup trackGroup = selections[i].getTrackGroup();
            for (int j = 0; j < this.sampleStreamWrappers.length; ++j) {
                if (this.sampleStreamWrappers[j].getTrackGroups().indexOf(trackGroup) == -1) continue;
                selectionChildIndices[i] = j;
                continue block0;
            }
        }
        boolean forceReset = false;
        this.streamWrapperIndices.clear();
        SampleStream[] newStreams = new SampleStream[selections.length];
        SampleStream[] childStreams = new SampleStream[selections.length];
        TrackSelection[] childSelections = new TrackSelection[selections.length];
        int newEnabledSampleStreamWrapperCount = 0;
        HlsSampleStreamWrapper[] newEnabledSampleStreamWrappers = new HlsSampleStreamWrapper[this.sampleStreamWrappers.length];
        for (int i = 0; i < this.sampleStreamWrappers.length; ++i) {
            for (int j = 0; j < selections.length; ++j) {
                childStreams[j] = streamChildIndices[j] == i ? streams[j] : null;
                childSelections[j] = selectionChildIndices[j] == i ? selections[j] : null;
            }
            HlsSampleStreamWrapper sampleStreamWrapper = this.sampleStreamWrappers[i];
            boolean wasReset = sampleStreamWrapper.selectTracks(childSelections, mayRetainStreamFlags, childStreams, streamResetFlags, positionUs, forceReset);
            boolean wrapperEnabled = false;
            for (int j = 0; j < selections.length; ++j) {
                if (selectionChildIndices[j] == i) {
                    Assertions.checkState((childStreams[j] != null ? 1 : 0) != 0);
                    newStreams[j] = childStreams[j];
                    wrapperEnabled = true;
                    this.streamWrapperIndices.put(childStreams[j], i);
                    continue;
                }
                if (streamChildIndices[j] != i) continue;
                Assertions.checkState((childStreams[j] == null ? 1 : 0) != 0);
            }
            if (!wrapperEnabled) continue;
            newEnabledSampleStreamWrappers[newEnabledSampleStreamWrapperCount] = sampleStreamWrapper;
            if (newEnabledSampleStreamWrapperCount++ == 0) {
                sampleStreamWrapper.setIsTimestampMaster(true);
                if (!wasReset && this.enabledSampleStreamWrappers.length != 0 && sampleStreamWrapper == this.enabledSampleStreamWrappers[0]) continue;
                this.timestampAdjusterProvider.reset();
                forceReset = true;
                continue;
            }
            sampleStreamWrapper.setIsTimestampMaster(false);
        }
        System.arraycopy(newStreams, 0, streams, 0, newStreams.length);
        this.enabledSampleStreamWrappers = Arrays.copyOf(newEnabledSampleStreamWrappers, newEnabledSampleStreamWrapperCount);
        this.sequenceableLoader = new CompositeSequenceableLoader((SequenceableLoader[])this.enabledSampleStreamWrappers);
        return positionUs;
    }

    public void discardBuffer(long positionUs) {
        for (HlsSampleStreamWrapper sampleStreamWrapper : this.enabledSampleStreamWrappers) {
            sampleStreamWrapper.discardBuffer(positionUs);
        }
    }

    public boolean continueLoading(long positionUs) {
        return this.sequenceableLoader.continueLoading(positionUs);
    }

    public long getNextLoadPositionUs() {
        return this.sequenceableLoader.getNextLoadPositionUs();
    }

    public long readDiscontinuity() {
        return -9223372036854775807L;
    }

    public long getBufferedPositionUs() {
        return this.sequenceableLoader.getBufferedPositionUs();
    }

    public long seekToUs(long positionUs) {
        if (this.enabledSampleStreamWrappers.length > 0) {
            boolean forceReset = this.enabledSampleStreamWrappers[0].seekToUs(positionUs, false);
            for (int i = 1; i < this.enabledSampleStreamWrappers.length; ++i) {
                this.enabledSampleStreamWrappers[i].seekToUs(positionUs, forceReset);
            }
            if (forceReset) {
                this.timestampAdjusterProvider.reset();
            }
        }
        return positionUs;
    }

    @Override
    public void onPrepared() {
        if (--this.pendingPrepareCount > 0) {
            return;
        }
        int totalTrackGroupCount = 0;
        for (HlsSampleStreamWrapper sampleStreamWrapper : this.sampleStreamWrappers) {
            totalTrackGroupCount += sampleStreamWrapper.getTrackGroups().length;
        }
        TrackGroup[] trackGroupArray = new TrackGroup[totalTrackGroupCount];
        int trackGroupIndex = 0;
        for (HlsSampleStreamWrapper sampleStreamWrapper : this.sampleStreamWrappers) {
            int wrapperTrackGroupCount = sampleStreamWrapper.getTrackGroups().length;
            for (int j = 0; j < wrapperTrackGroupCount; ++j) {
                trackGroupArray[trackGroupIndex++] = sampleStreamWrapper.getTrackGroups().get(j);
            }
        }
        this.trackGroups = new TrackGroupArray(trackGroupArray);
        this.callback.onPrepared((MediaPeriod)this);
    }

    @Override
    public void onPlaylistRefreshRequired(HlsMasterPlaylist.HlsUrl url) {
        this.playlistTracker.refreshPlaylist(url);
    }

    public void onContinueLoadingRequested(HlsSampleStreamWrapper sampleStreamWrapper) {
        if (this.trackGroups == null) {
            return;
        }
        this.callback.onContinueLoadingRequested((SequenceableLoader)this);
    }

    @Override
    public void onPlaylistChanged() {
        this.continuePreparingOrLoading();
    }

    @Override
    public void onPlaylistBlacklisted(HlsMasterPlaylist.HlsUrl url, long blacklistMs) {
        for (HlsSampleStreamWrapper streamWrapper : this.sampleStreamWrappers) {
            streamWrapper.onPlaylistBlacklisted(url, blacklistMs);
        }
        this.continuePreparingOrLoading();
    }

    private void buildAndPrepareSampleStreamWrappers(long positionUs) {
        int i;
        HlsMasterPlaylist masterPlaylist = this.playlistTracker.getMasterPlaylist();
        ArrayList<HlsMasterPlaylist.HlsUrl> selectedVariants = new ArrayList<HlsMasterPlaylist.HlsUrl>(masterPlaylist.variants);
        ArrayList<HlsMasterPlaylist.HlsUrl> definiteVideoVariants = new ArrayList<HlsMasterPlaylist.HlsUrl>();
        ArrayList<HlsMasterPlaylist.HlsUrl> definiteAudioOnlyVariants = new ArrayList<HlsMasterPlaylist.HlsUrl>();
        for (int i2 = 0; i2 < selectedVariants.size(); ++i2) {
            HlsMasterPlaylist.HlsUrl variant = (HlsMasterPlaylist.HlsUrl)selectedVariants.get(i2);
            if (variant.format.height > 0 || HlsMediaPeriod.variantHasExplicitCodecWithPrefix(variant, "avc")) {
                definiteVideoVariants.add(variant);
                continue;
            }
            if (!HlsMediaPeriod.variantHasExplicitCodecWithPrefix(variant, "mp4a")) continue;
            definiteAudioOnlyVariants.add(variant);
        }
        if (!definiteVideoVariants.isEmpty()) {
            selectedVariants = definiteVideoVariants;
        } else if (definiteAudioOnlyVariants.size() < selectedVariants.size()) {
            selectedVariants.removeAll(definiteAudioOnlyVariants);
        }
        List<HlsMasterPlaylist.HlsUrl> audioRenditions = masterPlaylist.audios;
        List<HlsMasterPlaylist.HlsUrl> subtitleRenditions = masterPlaylist.subtitles;
        this.sampleStreamWrappers = new HlsSampleStreamWrapper[1 + audioRenditions.size() + subtitleRenditions.size()];
        int currentWrapperIndex = 0;
        this.pendingPrepareCount = this.sampleStreamWrappers.length;
        Assertions.checkArgument((!selectedVariants.isEmpty() ? 1 : 0) != 0);
        HlsMasterPlaylist.HlsUrl[] variants = new HlsMasterPlaylist.HlsUrl[selectedVariants.size()];
        selectedVariants.toArray(variants);
        HlsSampleStreamWrapper sampleStreamWrapper = this.buildSampleStreamWrapper(0, variants, masterPlaylist.muxedAudioFormat, masterPlaylist.muxedCaptionFormats, positionUs);
        this.sampleStreamWrappers[currentWrapperIndex++] = sampleStreamWrapper;
        sampleStreamWrapper.setIsTimestampMaster(true);
        sampleStreamWrapper.continuePreparing();
        for (i = 0; i < audioRenditions.size(); ++i) {
            sampleStreamWrapper = this.buildSampleStreamWrapper(1, new HlsMasterPlaylist.HlsUrl[]{audioRenditions.get(i)}, null, Collections.emptyList(), positionUs);
            this.sampleStreamWrappers[currentWrapperIndex++] = sampleStreamWrapper;
            sampleStreamWrapper.continuePreparing();
        }
        for (i = 0; i < subtitleRenditions.size(); ++i) {
            HlsMasterPlaylist.HlsUrl url = subtitleRenditions.get(i);
            sampleStreamWrapper = this.buildSampleStreamWrapper(3, new HlsMasterPlaylist.HlsUrl[]{url}, null, Collections.emptyList(), positionUs);
            sampleStreamWrapper.prepareSingleTrack(url.format);
            this.sampleStreamWrappers[currentWrapperIndex++] = sampleStreamWrapper;
        }
        this.enabledSampleStreamWrappers = this.sampleStreamWrappers;
    }

    private HlsSampleStreamWrapper buildSampleStreamWrapper(int trackType, HlsMasterPlaylist.HlsUrl[] variants, Format muxedAudioFormat, List<Format> muxedCaptionFormats, long positionUs) {
        HlsChunkSource defaultChunkSource = new HlsChunkSource(this.playlistTracker, variants, this.dataSourceFactory, this.timestampAdjusterProvider, muxedCaptionFormats);
        return new HlsSampleStreamWrapper(trackType, this, defaultChunkSource, this.allocator, positionUs, muxedAudioFormat, this.minLoadableRetryCount, this.eventDispatcher);
    }

    private void continuePreparingOrLoading() {
        if (this.trackGroups != null) {
            this.callback.onContinueLoadingRequested((SequenceableLoader)this);
        } else {
            for (HlsSampleStreamWrapper wrapper : this.sampleStreamWrappers) {
                wrapper.continuePreparing();
            }
        }
    }

    private static boolean variantHasExplicitCodecWithPrefix(HlsMasterPlaylist.HlsUrl variant, String prefix) {
        String[] codecArray;
        String codecs = variant.format.codecs;
        if (TextUtils.isEmpty((CharSequence)codecs)) {
            return false;
        }
        for (String codec : codecArray = codecs.split("(\\s*,\\s*)|(\\s*$)")) {
            if (!codec.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }
}

