/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.hls;

import android.text.TextUtils;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.extractor.DefaultExtractorInput;
import com.google.android.exoplayer2.extractor.Extractor;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.mp3.Mp3Extractor;
import com.google.android.exoplayer2.extractor.mp4.FragmentedMp4Extractor;
import com.google.android.exoplayer2.extractor.ts.Ac3Extractor;
import com.google.android.exoplayer2.extractor.ts.AdtsExtractor;
import com.google.android.exoplayer2.extractor.ts.DefaultTsPayloadReaderFactory;
import com.google.android.exoplayer2.extractor.ts.TsExtractor;
import com.google.android.exoplayer2.extractor.ts.TsPayloadReader;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.metadata.id3.Id3Decoder;
import com.google.android.exoplayer2.metadata.id3.PrivFrame;
import com.google.android.exoplayer2.source.chunk.MediaChunk;
import com.google.android.exoplayer2.source.hls.Aes128DataSource;
import com.google.android.exoplayer2.source.hls.HlsSampleStreamWrapper;
import com.google.android.exoplayer2.source.hls.WebvttExtractor;
import com.google.android.exoplayer2.source.hls.playlist.HlsMasterPlaylist;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.TimestampAdjuster;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

final class HlsMediaChunk
extends MediaChunk {
    private static final AtomicInteger UID_SOURCE = new AtomicInteger();
    private static final String PRIV_TIMESTAMP_FRAME_OWNER = "com.apple.streaming.transportStreamTimestamp";
    private static final String AAC_FILE_EXTENSION = ".aac";
    private static final String AC3_FILE_EXTENSION = ".ac3";
    private static final String EC3_FILE_EXTENSION = ".ec3";
    private static final String MP3_FILE_EXTENSION = ".mp3";
    private static final String MP4_FILE_EXTENSION = ".mp4";
    private static final String M4_FILE_EXTENSION_PREFIX = ".m4";
    private static final String VTT_FILE_EXTENSION = ".vtt";
    private static final String WEBVTT_FILE_EXTENSION = ".webvtt";
    public final int uid;
    public final int discontinuitySequenceNumber;
    public final HlsMasterPlaylist.HlsUrl hlsUrl;
    private final DataSource initDataSource;
    private final DataSpec initDataSpec;
    private final boolean isEncrypted;
    private final boolean isMasterTimestampSource;
    private final TimestampAdjuster timestampAdjuster;
    private final String lastPathSegment;
    private final Extractor previousExtractor;
    private final boolean shouldSpliceIn;
    private final boolean needNewExtractor;
    private final List<Format> muxedCaptionFormats;
    private final boolean isPackedAudio;
    private final Id3Decoder id3Decoder;
    private final ParsableByteArray id3Data;
    private Extractor extractor;
    private int initSegmentBytesLoaded;
    private int bytesLoaded;
    private boolean initLoadCompleted;
    private HlsSampleStreamWrapper extractorOutput;
    private volatile boolean loadCanceled;
    private volatile boolean loadCompleted;

    public HlsMediaChunk(DataSource dataSource, DataSpec dataSpec, DataSpec initDataSpec, HlsMasterPlaylist.HlsUrl hlsUrl, List<Format> muxedCaptionFormats, int trackSelectionReason, Object trackSelectionData, long startTimeUs, long endTimeUs, int chunkIndex, int discontinuitySequenceNumber, boolean isMasterTimestampSource, TimestampAdjuster timestampAdjuster, HlsMediaChunk previousChunk, byte[] encryptionKey, byte[] encryptionIv) {
        super(HlsMediaChunk.buildDataSource(dataSource, encryptionKey, encryptionIv), dataSpec, hlsUrl.format, trackSelectionReason, trackSelectionData, startTimeUs, endTimeUs, chunkIndex);
        this.discontinuitySequenceNumber = discontinuitySequenceNumber;
        this.initDataSpec = initDataSpec;
        this.hlsUrl = hlsUrl;
        this.muxedCaptionFormats = muxedCaptionFormats;
        this.isMasterTimestampSource = isMasterTimestampSource;
        this.timestampAdjuster = timestampAdjuster;
        this.isEncrypted = this.dataSource instanceof Aes128DataSource;
        this.lastPathSegment = dataSpec.uri.getLastPathSegment();
        boolean bl = this.isPackedAudio = this.lastPathSegment.endsWith(AAC_FILE_EXTENSION) || this.lastPathSegment.endsWith(AC3_FILE_EXTENSION) || this.lastPathSegment.endsWith(EC3_FILE_EXTENSION) || this.lastPathSegment.endsWith(MP3_FILE_EXTENSION);
        if (previousChunk != null) {
            this.id3Decoder = previousChunk.id3Decoder;
            this.id3Data = previousChunk.id3Data;
            this.previousExtractor = previousChunk.extractor;
            this.shouldSpliceIn = previousChunk.hlsUrl != hlsUrl;
            this.needNewExtractor = previousChunk.discontinuitySequenceNumber != discontinuitySequenceNumber || this.shouldSpliceIn;
        } else {
            this.id3Decoder = this.isPackedAudio ? new Id3Decoder() : null;
            this.id3Data = this.isPackedAudio ? new ParsableByteArray(10) : null;
            this.previousExtractor = null;
            this.shouldSpliceIn = false;
            this.needNewExtractor = true;
        }
        this.initDataSource = dataSource;
        this.uid = UID_SOURCE.getAndIncrement();
    }

    public void init(HlsSampleStreamWrapper output) {
        this.extractorOutput = output;
        output.init(this.uid, this.shouldSpliceIn);
    }

    public boolean isLoadCompleted() {
        return this.loadCompleted;
    }

    public long bytesLoaded() {
        return this.bytesLoaded;
    }

    public void cancelLoad() {
        this.loadCanceled = true;
    }

    public boolean isLoadCanceled() {
        return this.loadCanceled;
    }

    public void load() throws IOException, InterruptedException {
        if (this.extractor == null && !this.isPackedAudio) {
            this.extractor = this.createExtractor();
        }
        this.maybeLoadInitData();
        if (!this.loadCanceled) {
            this.loadMedia();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeLoadInitData() throws IOException, InterruptedException {
        if (this.previousExtractor == this.extractor || this.initLoadCompleted || this.initDataSpec == null) {
            return;
        }
        DataSpec initSegmentDataSpec = this.initDataSpec.subrange((long)this.initSegmentBytesLoaded);
        try {
            DefaultExtractorInput input = new DefaultExtractorInput(this.initDataSource, initSegmentDataSpec.absoluteStreamPosition, this.initDataSource.open(initSegmentDataSpec));
            try {
                int result = 0;
                while (result == 0 && !this.loadCanceled) {
                    result = this.extractor.read((ExtractorInput)input, null);
                }
            }
            finally {
                this.initSegmentBytesLoaded = (int)(input.getPosition() - this.initDataSpec.absoluteStreamPosition);
            }
        }
        finally {
            Util.closeQuietly((DataSource)this.dataSource);
        }
        this.initLoadCompleted = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMedia() throws IOException, InterruptedException {
        boolean skipLoadedBytes;
        DataSpec loadDataSpec;
        if (this.isEncrypted) {
            loadDataSpec = this.dataSpec;
            skipLoadedBytes = this.bytesLoaded != 0;
        } else {
            loadDataSpec = this.dataSpec.subrange((long)this.bytesLoaded);
            skipLoadedBytes = false;
        }
        if (!this.isMasterTimestampSource) {
            this.timestampAdjuster.waitUntilInitialized();
        } else if (this.timestampAdjuster.getFirstSampleTimestampUs() == Long.MAX_VALUE) {
            this.timestampAdjuster.setFirstSampleTimestampUs(this.startTimeUs);
        }
        try {
            DefaultExtractorInput input = new DefaultExtractorInput(this.dataSource, loadDataSpec.absoluteStreamPosition, this.dataSource.open(loadDataSpec));
            if (this.extractor == null) {
                long id3Timestamp = this.peekId3PrivTimestamp((ExtractorInput)input);
                this.extractor = this.buildPackedAudioExtractor(id3Timestamp != -9223372036854775807L ? this.timestampAdjuster.adjustTsTimestamp(id3Timestamp) : this.startTimeUs);
            }
            if (skipLoadedBytes) {
                input.skipFully(this.bytesLoaded);
            }
            try {
                int result = 0;
                while (result == 0 && !this.loadCanceled) {
                    result = this.extractor.read((ExtractorInput)input, null);
                }
            }
            finally {
                this.bytesLoaded = (int)(input.getPosition() - this.dataSpec.absoluteStreamPosition);
            }
        }
        finally {
            Util.closeQuietly((DataSource)this.dataSource);
        }
        this.loadCompleted = true;
    }

    private long peekId3PrivTimestamp(ExtractorInput input) throws IOException, InterruptedException {
        input.resetPeekPosition();
        if (!input.peekFully(this.id3Data.data, 0, 10, true)) {
            return -9223372036854775807L;
        }
        this.id3Data.reset(10);
        int id = this.id3Data.readUnsignedInt24();
        if (id != Id3Decoder.ID3_TAG) {
            return -9223372036854775807L;
        }
        this.id3Data.skipBytes(3);
        int id3Size = this.id3Data.readSynchSafeInt();
        int requiredCapacity = id3Size + 10;
        if (requiredCapacity > this.id3Data.capacity()) {
            byte[] data = this.id3Data.data;
            this.id3Data.reset(requiredCapacity);
            System.arraycopy(data, 0, this.id3Data.data, 0, 10);
        }
        if (!input.peekFully(this.id3Data.data, 10, id3Size, true)) {
            return -9223372036854775807L;
        }
        Metadata metadata = this.id3Decoder.decode(this.id3Data.data, id3Size);
        if (metadata == null) {
            return -9223372036854775807L;
        }
        int metadataLength = metadata.length();
        for (int i = 0; i < metadataLength; ++i) {
            Metadata.Entry frame = metadata.get(i);
            if (!(frame instanceof PrivFrame)) continue;
            PrivFrame privFrame = (PrivFrame)frame;
            if (!PRIV_TIMESTAMP_FRAME_OWNER.equals(privFrame.owner)) continue;
            System.arraycopy(privFrame.privateData, 0, this.id3Data.data, 0, 8);
            this.id3Data.reset(8);
            return this.id3Data.readLong();
        }
        return -9223372036854775807L;
    }

    private static DataSource buildDataSource(DataSource dataSource, byte[] encryptionKey, byte[] encryptionIv) {
        if (encryptionKey == null || encryptionIv == null) {
            return dataSource;
        }
        return new Aes128DataSource(dataSource, encryptionKey, encryptionIv);
    }

    private Extractor createExtractor() {
        WebvttExtractor extractor;
        boolean usingNewExtractor = true;
        if ("text/vtt".equals(this.hlsUrl.format.sampleMimeType) || this.lastPathSegment.endsWith(WEBVTT_FILE_EXTENSION) || this.lastPathSegment.endsWith(VTT_FILE_EXTENSION)) {
            extractor = new WebvttExtractor(this.trackFormat.language, this.timestampAdjuster);
        } else if (!this.needNewExtractor) {
            usingNewExtractor = false;
            extractor = this.previousExtractor;
        } else if (this.lastPathSegment.endsWith(MP4_FILE_EXTENSION) || this.lastPathSegment.startsWith(M4_FILE_EXTENSION_PREFIX, this.lastPathSegment.length() - 4)) {
            extractor = new FragmentedMp4Extractor(0, this.timestampAdjuster);
        } else {
            int esReaderFactoryFlags = 16;
            List<Object> closedCaptionFormats = this.muxedCaptionFormats;
            if (closedCaptionFormats != null) {
                esReaderFactoryFlags |= 0x20;
            } else {
                closedCaptionFormats = Collections.emptyList();
            }
            String codecs = this.trackFormat.codecs;
            if (!TextUtils.isEmpty((CharSequence)codecs)) {
                if (!"audio/mp4a-latm".equals(MimeTypes.getAudioMediaMimeType((String)codecs))) {
                    esReaderFactoryFlags |= 2;
                }
                if (!"video/avc".equals(MimeTypes.getVideoMediaMimeType((String)codecs))) {
                    esReaderFactoryFlags |= 4;
                }
            }
            extractor = new TsExtractor(2, this.timestampAdjuster, (TsPayloadReader.Factory)new DefaultTsPayloadReaderFactory(esReaderFactoryFlags, closedCaptionFormats));
        }
        if (usingNewExtractor) {
            extractor.init(this.extractorOutput);
        }
        return extractor;
    }

    private Extractor buildPackedAudioExtractor(long startTimeUs) {
        AdtsExtractor extractor;
        if (this.lastPathSegment.endsWith(AAC_FILE_EXTENSION)) {
            extractor = new AdtsExtractor(startTimeUs);
        } else if (this.lastPathSegment.endsWith(AC3_FILE_EXTENSION) || this.lastPathSegment.endsWith(EC3_FILE_EXTENSION)) {
            extractor = new Ac3Extractor(startTimeUs);
        } else if (this.lastPathSegment.endsWith(MP3_FILE_EXTENSION)) {
            extractor = new Mp3Extractor(0, startTimeUs);
        } else {
            throw new IllegalArgumentException("Unknown extension for audio file: " + this.lastPathSegment);
        }
        extractor.init((ExtractorOutput)this.extractorOutput);
        return extractor;
    }
}

